ORCA/M Asm65816 2.1.0

0001 0000              **********************************************************************
0002 0000              *
0003 0000              *                   Window Manager Version 3.0
0004 0000              *
0005 0000              *          Copyright Apple Computer, Inc. 1986-1990
0006 0000              *          All rights reserved
0007 0000              *          Written by Dan Oliver
0008 0000              *
0009 0000              * Change History
0010 0000              *
0011 0000              * 08/20/87          Dan
0012 0000              *
0013 0000              * Start ROMing.
0014 0000              *
0015 0000              * 26 Jun 88         Harry Yee
0016 0000              *
0017 0000              * Converted to MAX
0018 0000              *
0019 0000              * 27 Jan 88         Steven Glass
0020 0000              *
0021 0000              * Removed Pop routines and used shared routines in WCM library.
0022 0000              * Used shared PushDPage routine in WCM library.
0023 0000              * Changed name of SetOrigin to SetTheOrigin to avoid naming conflict with 
0024 0000              *   QuickDraw.
0025 0000              *
0026 0000              * 29 Jun 88         Steven Glass
0027 0000              *
0028 0000              * Made WindDragRect public so that we can have control manager
0029 0000              * link to it in ROM.  (CtlStartup was getting address and patching
0030 0000              * call table.  This does not work in ROM so we must have right value
0031 0000              * in place to start with.)
0032 0000              *
0033 0000              * 14 JUL 88         Dan Oliver
0034 0000              *
0035 0000              * Changed TaskScroll routine so that it would not pass a negative X origin to new_origin.  The
0036 0000              * problem seems to be that a window's origin may not match the scroll bar values when the origin
0037 0000              * is being masked to a grid.  This is OK as long as the move deltas (as in this case) don't get
0038 0000              * out of range.  The top end of the range is checked in new_origin, the bottom is now checked in
0039 0000              * TaskScroll.
0040 0000              *
0041 0000              * 23 Jul 88         Steven Glass
0042 0000              *
0043 0000              * Changed CheckUpdate, TrackGoAway and TrackZoom so that when they
0044 0000              * return TRUE, all the bits in the returned word are set.  A problem has
0045 0000              * occured for developers using high level languages:  The language test
0046 0000              * for TRUE was not always working.  Pascal looks in bit 0, C looks in 
0047 0000              * bit 15.  By setting all the bits, it might work.
0048 0000              *
0049 0000              * 10 Aug 88         Dan Oliver
0050 0000              *
0051 0000              * Free allocated data area on shutdown.
0052 0000              *
0053 0000              * 20 Oct 88         Dan O.
0054 0000              *
0055 0000              * Added CompileString to function table.
0056 0000              * Added Window Manager error code equates.
0057 0000              *
0058 0000              * 21 Oct 88         Dan O.
0059 0000              *
0060 0000              * Changed airport & calc_vis routines to limit the window that have their visRgn recomputed
0061 0000              * when a window is brought to the top.  Now visRgns for windows behind the window being brought
0062 0000              * foreward are not recomputed.
0063 0000              *
0064 0000              * DragRect changed to draw 4 lines rather than 1 RECT.  This keeps the cursor from blinking off
0065 0000              * and on in some cases.
0066 0000              *
0067 0000              *
0068 0000              * 24 Oct 88         Dan O.
0069 0000              *
0070 0000              * Window Manager nows looks for DeskMessage (defined in Message Center documentation) to determine
0071 0000              * what to draw for the desktop.  The Window Manager does not look for the message each time, rather
0072 0000              * it is set by a Desktop call.
0073 0000              *
0074 0000              * Added an operation number FindDeskPatt (8) added to Desktop call.  No additional parameter 
0075 0000              * passed and no parameter returned.  This operation makes the Window Manager check the Message
0076 0000              * Center for a DeskMessage it can use to draw the desktop image.  If a message is found it will
0077 0000              * be used when drawing the desktop in the future.  This call will not redraw the desktop.
0078 0000              *
0079 0000              * WindStartup and WindNewRes make the above call to Desktop to log in any new desktop patterns.
0080 0000              *
0081 0000              *
0082 0000              * 10/28/88          Dan O.
0083 0000              *
0084 0000              * Added NewWindow2 call.
0085 0000              * Window Manager can now handle titles as handles.  If high bit set in title pointer it's a handle.
0086 0000              * Remove break from PaintDesk.
0087 0000              *
0088 0000              * 07 Dec 88         Steven Glass
0089 0000              *
0090 0000              * Added check to DeskTop and RefreshDesktop to see if the window
0091 0000              * manager is active.  These calls are special since they are
0092 0000              * made by the menu manager.  In the past, the menu manager could
0093 0000              * be used without the window manager.  When this occured, the window
0094 0000              * manager was not loaded and these calls generated dispatcher
0095 0000              * errors.  The check just added simulates dispatcher errors
0096 0000              * to keep the menu manager from crashing.
0097 0000              *
0098 0000              * 14 Dec 88         Mensch
0099 0000              *
0100 0000              * Modified NewWindw2 call so that it would conform to new toolbox verb/reference
0101 0000              * conventions. This required the addition of an extra parameter to be passed to
0102 0000              * the NewWindow2 call as well as a new parameter for the window template itself.
0103 0000              * NewWindow2 will now accept a pointer/handle/or resourceID as input for the template
0104 0000              * specifier.  In addition, the title, colortable, and control list fields can now also
0105 0000              * take pointers and handles.
0106 0000              *
0107 0000              * 1 Jan 89          Mensch
0108 0000              *
0109 0000              * Changed DragWindow so that it does not call ReadMouse.  This was done to allow
0110 0000              * journaling of clicks in a window's title bar.
0111 0000              *
0112 0000              * 9 Jan 89          Konstantin
0113 0000              *
0114 0000              * Added ErrorWindow call.
0115 0000              *
0116 0000              *
0117 0000              * 2 Mar 89          Dave Good
0118 0000              *
0119 0000              * Rewrote SelectWindow to not use the airport routine unless either the
0120 0000              * window that was selected or the previous topmost window was invisible.
0121 0000              * Also changed DragWindow to not call MoveWindow unless it was actually
0122 0000              * moved.
0123 0000              *
0124 0000              * 28 Mar 89         Steven Glass
0125 0000              *
0126 0000              * Removed some unimportant commented out lines left over from APW.
0127 0000              *
0128 0000              *
0129 0000              * 09 Apr 89         Steven Glass
0130 0000              *
0131 0000              * Changed CkButton where it sees if mouse is really down while we are waiting
0132 0000              * it to come up.  It was possible for MouseUp event to be left in the queue.
0133 0000              *
0134 0000              *
0135 0000              * 19 Apr 89         David Good
0136 0000              *
0137 0000              * Fixed bug in SelectWindow
0138 0000              *
0139 0000              *
0140 0000              * 26 Apr 89         David Good
0141 0000              *
0142 0000              * Fixed bug in EraseWindow (called by CloseWindow). If the WindGlobal
0143 0000              * flag said to NOT change the hilighting on windows, CloseWindow used to
0144 0000              * skip drawing. Now it just skips the hilighting, but it still draws the
0145 0000              * frame.
0146 0000              *
0147 0000              * 5/10/89           Mensch
0148 0000              * Fixed bug in GetFrameColor, it was not dereferencing the handle if the
0149 0000              * frame color table is stored in a handle.
0150 0000              *
0151 0000              * 5/11/89           Mensch
0152 0000              * Patched GetWRefCon so that it would not trash window manager temp storage.
0153 0000              * This was do in order to make List Plus still compatible.
0154 0000              *
0155 0000              **********************************************************************
0156 0000                       Blanks off 
0157 0000                       String asis 
0158 0000
0159 0000                       include 'all.macros' 
0160 0000
0161 0000                       include 'e16.control' 
0162 0000                       include 'WindMgrEquates.asm' 
0163 0000                       include '::ToolPatch:ToolPatchEquates.asm' 
0164 0000
0165 0000                       include 'e16.event' 
0166 0000
0167 0000              ;-----------------------------------------------
0168 0000              ;
0169 0000              ;   Imported addresses
0170 0000              ;
0171 0000              ;-----------------------------------------------
0172 0000
0173 0000                       IMPORT Add
0174 0000                       IMPORT AlertWindow
0175 0000                       IMPORT Ask
0176 0000                       IMPORT Check
0177 0000                       IMPORT Clear
0178 0000                       IMPORT ClipRgn
0179 0000                       IMPORT Clobbered
0180 0000                       IMPORT Clone
0181 0000                       IMPORT Close
0182 0000                       IMPORT colorWhite
0183 0000                       IMPORT Compute
0184 0000                       IMPORT Convert
0185 0000                       IMPORT Deallocate
0186 0000                       IMPORT Draw
0187 0000                       IMPORT Empty
0188 0000                       IMPORT Entry
0189 0000                       IMPORT ErrorWindow
0190 0000                       IMPORT Expand
0191 0000                       IMPORT Find
0192 0000                       IMPORT Free
0193 0000                       IMPORT Get
0194 0000                       IMPORT Intersection
0195 0000                       IMPORT Is
0196 0000                       IMPORT Make
0197 0000                       IMPORT Offset
0198 0000                       IMPORT Reset
0199 0000                       IMPORT Restore
0200 0000                       IMPORT Return
0201 0000                       IMPORT Save
0202 0000                       IMPORT Set
0203 0000                       IMPORT Shutdown
0204 0000                       IMPORT Subtract
0205 0000                       IMPORT Switch
0206 0000                       IMPORT TaskMaster
0207 0000                       IMPORT Tell
0208 0000                       IMPORT Window
0209 0000                       IMPORT alertDefProc
0210 0000                       IMPORT clip
0211 0000                       IMPORT docDefProc
0212 0000                       IMPORT makePattern
0213 0000
0214 0000              ;-----------------------------------------------
0215 0000              ;
0216 0000              ;   Forward addresses and entries
0217 0000              ;
0218 0000              ;-----------------------------------------------
0219 0000
0220 0000                       ENTRY BeginUpdate
0221 0000                       ENTRY BringToFront
0222 0000                       ENTRY CheckUpdate
0223 0000                       ENTRY CloseWindow
0224 0000                       ENTRY Desktop
0225 0000                       ENTRY DragWindow
0226 0000                       ENTRY DrawInfoBar
0227 0000                       ENTRY ENDFPT
0228 0000                       ENTRY EndFrameDrawing
0229 0000                       ENTRY EndInfoDrawing
0230 0000                       ENTRY EndUpdate
0231 0000                       ENTRY FindWindow
0232 0000                       ENTRY FrontWindow
0233 0000                       ENTRY GetCDraw
0234 0000                       ENTRY GetCOrigin
0235 0000                       ENTRY GetContRgn
0236 0000                       ENTRY GetDataSize
0237 0000                       ENTRY GetDefProc
0238 0000                       ENTRY GetDragRect
0239 0000                       ENTRY GetFirstWindow
0240 0000                       ENTRY GetFrameColor
0241 0000                       ENTRY GetInfoDraw
0242 0000                       ENTRY GetInfoRefCon
0243 0000                       ENTRY GetMaxGrow
0244 0000                       ENTRY GetNextWindow
0245 0000                       ENTRY GetPage
0246 0000                       ENTRY GetRectInfo
0247 0000                       ENTRY GetScroll
0248 0000                       ENTRY GetStructRgn
0249 0000                       ENTRY GetSysWFlag
0250 0000                       ENTRY GetUpdateRgn
0251 0000                       ENTRY GetWControls
0252 0000                       ENTRY GetWFrame
0253 0000                       ENTRY GetWKind
0254 0000                       ENTRY GetWMgrPort
0255 0000                       ENTRY GetWRefCon
0256 0000                       ENTRY GetWTitle
0257 0000                       ENTRY GetWindowMgrGlobals
0258 0000                       ENTRY GetZoomRect
0259 0000                       ENTRY GrowWindow
0260 0000                       ENTRY HideWindow
0261 0000                       ENTRY HiliteWindow
0262 0000                       ENTRY InvalRect
0263 0000                       ENTRY InvalRgn
0264 0000                       ENTRY MoveWindow
0265 0000                       ENTRY NewWindow
0266 0000                       ENTRY PaintDesk
0267 0000                       ENTRY PaintOne
0268 0000                       ENTRY PinRect
0269 0000                       ENTRY Refresh
0270 0000                       ENTRY Reserved
0271 0000                       ENTRY ResizeWindow
0272 0000                       ENTRY SelectWindow
0273 0000                       ENTRY SendBehind
0274 0000                       ENTRY SetCDraw
0275 0000                       ENTRY SetCOrigin
0276 0000                       ENTRY SetCOrigin2
0277 0000                       ENTRY SetDataSize
0278 0000                       ENTRY SetDefProc
0279 0000                       ENTRY SetFrameColor
0280 0000                       ENTRY SetInfoDraw
0281 0000                       ENTRY SetInfoRefCon
0282 0000                       ENTRY SetMaxGrow
0283 0000                       ENTRY SetOrgnMask
0284 0000                       ENTRY SetPage
0285 0000                       ENTRY SetScroll
0286 0000                       ENTRY SetSysWindow
0287 0000                       ENTRY SetWFrame
0288 0000                       ENTRY SetWMgrIcons
0289 0000                       ENTRY SetWRefCon
0290 0000                       ENTRY SetWTitle
0291 0000                       ENTRY SetZoomRect
0292 0000                       ENTRY ShowHide
0293 0000                       ENTRY ShowWindow
0294 0000                       ENTRY SizeWindow
0295 0000                       ENTRY StartDrawing
0296 0000                       ENTRY StartFrameDrawing
0297 0000                       ENTRY StartInfoDraw
0298 0000                       ENTRY SubStructLoop
0299 0000                       ENTRY TrackGoAway
0300 0000                       ENTRY TrackZoom
0301 0000                       ENTRY ValidRect
0302 0000                       ENTRY ValidRgn
0303 0000                       ENTRY WNewRes
0304 0000                       ENTRY WindBootInit
0305 0000                       ENTRY WindDragRect
0306 0000                       ENTRY WindReset
0307 0000                       ENTRY WindShutDown
0308 0000                       ENTRY WindStartup
0309 0000                       ENTRY WindStatus
0310 0000                       ENTRY WindVersion
0311 0000                       ENTRY WindowGlobal
0312 0000                       ENTRY ZoomWindow
0313 0000                       ENTRY activate
0314 0000                       ENTRY addframe
0315 0000                       ENTRY airport
0316 0000                       ENTRY alloc_rgn
0317 0000                       ENTRY allocate
0318 0000                       ENTRY calc_vis
0319 0000                       ENTRY callDrag
0320 0000                       ENTRY callProc
0321 0000                       ENTRY callProc2
0322 0000                       ENTRY clipabove
0323 0000                       ENTRY closeWMgrport
0324 0000                       ENTRY deactivate
0325 0000                       ENTRY def_color
0326 0000                       ENTRY deskBounds
0327 0000                       ENTRY dispatch
0328 0000                       ENTRY dispatch2
0329 0000                       ENTRY drawframe
0330 0000                       ENTRY erasewind
0331 0000                       ENTRY RealFastExit
0332 0000                       ENTRY find_top
0333 0000                       ENTRY findloc
0334 0000                       ENTRY finiupdate
0335 0000                       ENTRY fixworkptr
0336 0000                       ENTRY fullport
0337 0000                       ENTRY getWMgrCtls
0338 0000                       ENTRY get_long
0339 0000                       ENTRY get_port
0340 0000                       ENTRY get_portp2
0341 0000                       ENTRY get_portptr
0342 0000                       ENTRY get_wptr
0343 0000                       ENTRY getbounds
0344 0000                       ENTRY getbounds1
0345 0000                       ENTRY getbounds3
0346 0000                       ENTRY getcontwh
0347 0000                       ENTRY getpre
0348 0000                       ENTRY getwgrect
0349 0000                       ENTRY hilite
0350 0000                       ENTRY initres
0351 0000                       ENTRY intolist
0352 0000                       ENTRY longCall
0353 0000                       ENTRY moveWMgrOnWind
0354 0000                       ENTRY moveWmgrBack
0355 0000                       ENTRY new_size
0356 0000                       ENTRY openWMgrport
0357 0000                       ENTRY outoflist
0358 0000                       ENTRY paintonedown
0359 0000                       ENTRY pos_wind
0360 0000                       ENTRY pullparam
0361 0000                       ENTRY pushGP_Bounds
0362 0000                       ENTRY pushGray
0363 0000                       ENTRY pushWlong
0364 0000                       ENTRY pushandle
0365 0000                       ENTRY pushblitdes
0366 0000                       ENTRY pushblitsrc
0367 0000                       ENTRY pushcallProcList
0368 0000                       ENTRY pushclip
0369 0000                       ENTRY pushdrag_bound
0370 0000                       ENTRY pushfontHandle
0371 0000                       ENTRY pushparam
0372 0000                       ENTRY pushport
0373 0000                       ENTRY pushptr
0374 0000                       ENTRY pushrect
0375 0000                       ENTRY pushrgn2
0376 0000                       ENTRY pushrgnptr
0377 0000                       ENTRY pushscInfo
0378 0000                       ENTRY pushscreen
0379 0000                       ENTRY pushscrn2scrn
0380 0000                       ENTRY pushslop_bound
0381 0000                       ENTRY pushwork
0382 0000                       ENTRY pushwrect
0383 0000                       ENTRY pushyrat
0384 0000                       ENTRY restore_port
0385 0000                       ENTRY save_port
0386 0000                       ENTRY setCallProc
0387 0000                       ENTRY setTheOrigin
0388 0000                       ENTRY setWAP
0389 0000                       ENTRY setup
0390 0000                       ENTRY setwmgrport
0391 0000                       ENTRY sizeguts
0392 0000                       ENTRY startupdate
0393 0000                       ENTRY testVis
0394 0000                       ENTRY test_pt
0395 0000                       ENTRY testclip
0396 0000                       ENTRY tofront
0397 0000                       ENTRY trackbox
0398 0000                       ENTRY unhilite
0399 0000                       ENTRY wind320
0400 0000                       ENTRY wind640
0401 0000                       ENTRY wrect2rect
0402 0000                       ENTRY zeroOrigin
0403 0000                       ENTRY disposeRgnPtr
0404 0000                       ENTRY drawEntireFrame
0405 0000                       ENTRY offsetToLocal
0406 0000                       ENTRY offsetToGlobal
0407 0000
0408 0000                       import pop0bytes
0409 0000                       import pop2bytes
0410 0000                       import pop4bytes
0411 0000                       import Epop4bytes
0412 0000                       import pop6bytes
0413 0000                       import pop8bytes
0414 0000                       import pop10bytes
0415 0000                       import pop12bytes
0416 0000                       import pop16bytes
0417 0000                       import pop18bytes
0418 0000                       import pop26bytes
0419 0000                       import pop28bytes
0420 0000                       import pop32bytes
0421 0000
0422 0000                       import pushDpage
0423 0000
0424 0000              ;=================================================
0425 0000              ;          Window Manager Function Table
0426 0000              ;=================================================
0427 0000
0428 0000              WindowCallTable PROC EXPORT
0429 0000                       import TaskMasterContent
0430 0000                       import TaskMasterKey
0431 0000                       import TaskMasterDA
0432 0000                       import CompileString
0433 0000                       import NewWindow2
0434 0000                       import UpdateWindow
0435 0000
0436 0000                       EXPORT FPT
0437 0000 63 00        FPT      DC W:(ENDFPT-FPT)/4
0438 0002 00 00                 DC W:0
0439 0004 F3 21 FD 00           DC L:WindBootInit-1            ;$010E
0440 0008 8B 01 FD 00           DC L:WindStartup-1             ;$020E
0441 000C 8B 03 FD 00           DC L:WindShutDown-1            ;$030E
0442 0010 C7 04 FD 00           DC L:WindVersion-1             ;$040E
0443 0014 84 03 FD 00           DC L:WindReset-1               ;$050E
0444 0018 79 03 FD 00           DC L:WindStatus-1              ;$060E
0445 001C F3 21 FD 00           DC L:Reserved-1                ;$070E
0446 0020 F3 21 FD 00           DC L:Reserved-1                ;$080E
0447 0024 00 12 FD 00           DC L:NewWindow-1               ;$090E
0448 0028 11 04 FD 00           DC L:CheckUpdate-1             ;$0A0E
0449 002C FE 13 FD 00           DC L:CloseWindow-1             ;$0B0E
0450 0030 23 09 FD 00           DC L:Desktop-1                 ;$0C0E
0451 0034 D7 10 FD 00           DC L:SetWTitle-1               ;$0D0E
0452 0038 69 11 FD 00           DC L:GetWTitle-1               ;$0E0E
0453 003C DF 10 FD 00           DC L:SetFrameColor-1           ;$0F0E
0454 0040 71 11 FD 00           DC L:GetFrameColor-1           ;$100E
0455 0044 D7 1A FD 00           DC L:SelectWindow-1            ;$110E
0456 0048 13 1E FD 00           DC L:HideWindow-1              ;$120E
0457 004C BA 1D FD 00           DC L:ShowWindow-1              ;$130E
0458 0050 77 1C FD 00           DC L:SendBehind-1              ;$140E
0459 0054 DC 04 FD 00           DC L:FrontWindow-1             ;$150E
0460 0058 7F 10 FD 00           DC L:SetInfoDraw-1             ;$160E
0461 005C 55 19 FD 00           DC L:FindWindow-1              ;$170E
0462 0060 45 1A FD 00           DC L:TrackGoAway-1             ;$180E
0463 0064 B2 0B FD 00           DC L:MoveWindow-1              ;$190E
0464 0068 37 0A FD 00           DC L:DragWindow-1              ;$1A0E
0465 006C FF 17 FD 00           DC L:GrowWindow-1              ;$1B0E
0466 0070 49 16 FD 00           DC L:SizeWindow-1              ;$1C0E
0467 0074 83 26 FD 00           DC L:TaskMaster-1              ;$1D0E
0468 0078 1F 06 FD 00           DC L:BeginUpdate-1             ;$1E0E
0469 007C 68 06 FD 00           DC L:EndUpdate-1               ;$1F0E
0470 0080 CF 04 FD 00           DC L:GetWMgrPort-1             ;$200E
0471 0084 02 19 FD 00           DC L:PinRect-1                 ;$210E
0472 0088 52 1F FD 00           DC L:HiliteWindow-1            ;$220E
0473 008C 53 1E FD 00           DC L:ShowHide-1                ;$230E
0474 0090 CF 1A FD 00           DC L:BringToFront-1            ;$240E
0475 0094 2C 02 FD 00           DC L:WNewRes-1                 ;$250E
0476 0098 3D 1A FD 00           DC L:TrackZoom-1               ;$260E
0477 009C 48 19 FD 00           DC L:ZoomWindow-1              ;$270E
0478 00A0 C6 0F FD 00           DC L:SetWRefCon-1              ;$280E
0479 00A4 E6 0F FD 00           DC L:GetWRefCon-1              ;$290E
0480 00A8 28 10 FD 00           DC L:GetNextWindow-1           ;$2A0E
0481 00AC 41 10 FD 00           DC L:GetWKind-1                ;$2B0E
0482 00B0 02 10 FD 00           DC L:GetWFrame-1               ;$2C0E
0483 00B4 12 11 FD 00           DC L:SetWFrame-1               ;$2D0E
0484 00B8 10 10 FD 00           DC L:GetStructRgn-1            ;$2E0E
0485 00BC 18 10 FD 00           DC L:GetContRgn-1              ;$2F0E
0486 00C0 20 10 FD 00           DC L:GetUpdateRgn-1            ;$300E
0487 00C4 D6 0F FD 00           DC L:GetDefProc-1              ;$310E
0488 00C8 CE 0F FD 00           DC L:SetDefProc-1              ;$320E
0489 00CC DE 0F FD 00           DC L:GetWControls-1            ;$330E
0490 00D0 52 10 FD 00           DC L:SetOrgnMask-1             ;$340E
0491 00D4 41 11 FD 00           DC L:GetInfoRefCon-1           ;$350E
0492 00D8 77 10 FD 00           DC L:SetInfoRefCon-1           ;$360E
0493 00DC 61 11 FD 00           DC L:GetZoomRect-1             ;$370E
0494 00E0 CA 10 FD 00           DC L:SetZoomRect-1             ;$380E
0495 00E4 68 04 FD 00           DC L:Refresh-1                 ;$390E
0496 00E8 93 05 FD 00           DC L:InvalRect-1               ;$3A0E
0497 00EC 7E 05 FD 00           DC L:InvalRgn-1                ;$3B0E
0498 00F0 8E 05 FD 00           DC L:ValidRect-1               ;$3C0E
0499 00F4 79 05 FD 00           DC L:ValidRgn-1                ;$3D0E
0500 00F8 51 11 FD 00           DC L:GetCOrigin-1              ;$3E0E
0501 00FC A3 10 FD 00           DC L:SetCOrigin-1              ;$3F0E
0502 0100 59 11 FD 00           DC L:GetDataSize-1             ;$400E
0503 0104 C2 10 FD 00           DC L:SetDataSize-1             ;$410E
0504 0108 1F 11 FD 00           DC L:GetMaxGrow-1              ;$420E
0505 010C 5F 10 FD 00           DC L:SetMaxGrow-1              ;$430E
0506 0110 31 11 FD 00           DC L:GetScroll-1               ;$440E
0507 0114 67 10 FD 00           DC L:SetScroll-1               ;$450E
0508 0118 39 11 FD 00           DC L:GetPage-1                 ;$460E
0509 011C 6F 10 FD 00           DC L:SetPage-1                 ;$470E
0510 0120 FA 0F FD 00           DC L:GetCDraw-1                ;$480E
0511 0124 B2 0F FD 00           DC L:SetCDraw-1                ;$490E
0512 0128 49 11 FD 00           DC L:GetInfoDraw-1             ;$4A0E
0513 012C A1 0F FD 00           DC L:SetSysWindow-1            ;$4B0E
0514 0130 41 10 FD 00           DC L:GetSysWFlag-1             ;$4C0E
0515 0134 12 06 FD 00           DC L:StartDrawing-1            ;$4D0E
0516 0138 09 05 FD 00           DC L:SetWMgrIcons-1            ;$4E0E
0517 013C 95 11 FD 00           DC L:GetRectInfo-1             ;$4F0E
0518 0140 AF 11 FD 00           DC L:StartInfoDraw-1           ;$500E
0519 0144 B8 11 FD 00           DC L:EndInfoDrawing-1          ;$510E
0520 0148 EA 04 FD 00           DC L:GetFirstWindow-1          ;$520E added to version $8104
0521 014C F5 0C FD 00           DC L:WindDragRect-1            ;$530E
0522 0150 E6 0C FD 00           DC L:GetDragRect-1             ;$540E not public.
0523 0154 A2 11 FD 00           DC L:DrawInfoBar-1             ;$550E
0524 0158 86 0F FD 00           DC L:WindowGlobal-1            ;$560E added 02/19/87
0525 015C 87 10 FD 00           DC L:SetCOrigin2-1             ;$570E added 04/07/87
0526 0160 2C 05 FD 00           DC L:GetWindowMgrGlobals-1     ;$580E added 03/08/88
0527 0164 7F 2D FD 00           DC L:AlertWindow-1             ;$590E added 11/03/87
0528 0168 3E 05 FD 00           DC L:StartFrameDrawing-1       ;$5A0E added 03/15/88
0529 016C 69 05 FD 00           DC L:EndFrameDrawing-1         ;$5B0E added 03/15/88
0530 0170 99 16 FD 00           DC L:ResizeWindow-1            ;$5C0E added 03/15/88
0531 0174
0532 0174 BE 28 FD 00           DC L:TaskMasterContent-1       ;$5D0E added 22 Sep 88  SEG
0533 0178 EC 29 FD 00           DC L:TaskMasterKey-1           ;$5E0E added 28 Sep 88  SEG
0534 017C C8 2A FD 00           DC L:TaskMasterDA-1            ;$5F0E added 02 Oct 88  SEG
0535 0180 41 39 FD 00           DC L:CompileString-1           ;$600E added 10/20/88 Dan O.
0536 0184 5B 23 FD 00           DC L:NewWindow2-1              ;$610E added 10/26/88 Dan O.
0537 0188 5D 38 FD 00           DC L:ErrorWindow-1             ;$620E added 1/9/89 Konstantin
0538 018C
0539 018C                       EXPORT ENDFPT
0540 018C              ENDFPT    
0541 018C                       ENDP 
0542 018C
0543 018C
0544 018C                       EndP 
0545 018C
0546 018C              ;=========================================
0547 018C              ;        Initialize Window Manager
0548 018C              ;=========================================
0549 018C              ;
0550 018C              ;  IN:     PUSH:WORD - ID to use.
0551 018C              ;
0552 018C              ; OUT:     Nothing.
0553 018C              ;
0554 018C              WindStartup PROC 
0555 018C                       import SelfMod1Low,SelfMod1High,SelfMod2Low,SelfMod2High
0556 018C                       import DiskSwap640Hndl,DiskSwap320Hndl
0557 018C
0558 018C              newID    equ   9
0559 018C
0560 018C 22 64 00 E1           jsl   IncBusyFlg
0561 0190
0562 0190 0B                    phd                            Save current zero page.
0563 0191
0564 0191 AA                    tax                            Am I already initialized?
0565 0192 F0 04                 beq   ok1
0566 0194 8B                    phb   
0567 0195 4C AB 8F              jmp   pop2bytes
0568 0198              ok1       
0569 0198
0570 0198              ;
0571 0198              ; --- Get zero page to use from Event Manager and use it from now on -----
0572 0198              ;
0573 0198 48                    pha                            Space for returned zero page.
0574 0199 A2 06 09 22           _DoWindows                     Ask Event Manager for zero page.
0575 01A0 2B                    pld                            Switch to returned zero page.
0576 01A1              ;
0577 01A1 7B                    tdc                            Pass direct page pointer to WAP.
0578 01A2 20 01 04              jsr   setWAP
0579 01A5              ;
0580 01A5              ;
0581 01A5              ; --- Clear my half of my direct page -----------------------
0582 01A5              ;
0583 01A5 A2 7E 00              ldx   #$7E
0584 01A8 74 80        clearzp  stz   <$80,x
0585 01AA CA                    dex   
0586 01AB 10 FB                 bpl   clearzp
0587 01AD              ;
0588 01AD              ;
0589 01AD              ; --- Allocate a data area block -----------------------------
0590 01AD              ;
0591 01AD A3 09                 lda   newID,s                  My memory ID.
0592 01AF 85 DC                 sta   <MyID
0593 01B1              ;
0594 01B1 A9 F2 01              lda   #RAMSIZE                 Size of data area needed.
0595 01B4 20 C5 21              jsr   allocate
0596 01B7 85 DE                 sta   <work                    Handle of data area.
0597 01B9 86 E0                 stx   <work+2
0598 01BB A7 DE                 lda   [<work]                  Dereference handle.
0599 01BD 85 D8                 sta   <data                    Store pointer to data area.
0600 01BF A0 02 00              ldy   #2
0601 01C2 B7 DE                 lda   [<work],y
0602 01C4 85 DA                 sta   <data+2
0603 01C6              ;
0604 01C6              ;
0605 01C6              ; --- Initialize data area --------------------------------
0606 01C6              ;
0607 01C6 A9 00 00              lda   #0
0608 01C9 A0 F0 01              ldy   #RAMSIZE-2
0609 01CC 97 D8        lop1     sta   [<data],y
0610 01CE 88                    dey   
0611 01CF 88                    dey   
0612 01D0 10 FA                 bpl   lop1
0613 01D2              ;
0614 01D2 20 55 21              jsr   pushscInfo
0615 01D5 A0 38 00              ldy   #scrn2scrn+PP_SrcInfo
0616 01D8 20 22 02              jsr   getPointer
0617 01DB              ;
0618 01DB 20 55 21              jsr   pushscInfo
0619 01DE A0 3C 00              ldy   #scrn2scrn+PP_DesInfo
0620 01E1 20 22 02              jsr   getPointer
0621 01E4              ;
0622 01E4 20 2D 21              jsr   pushblitsrc
0623 01E7 A0 40 00              ldy   #scrn2scrn+PP_SrcRect
0624 01EA 20 22 02              jsr   getPointer
0625 01ED              ;
0626 01ED 20 28 21              jsr   pushblitdes
0627 01F0 A0 44 00              ldy   #scrn2scrn+PP_DesRect
0628 01F3 20 22 02              jsr   getPointer
0629 01F6              ;
0630 01F6              ;
0631 01F6              ; --- Initialize Manager's variables ----------------------
0632 01F6              ;
0633 01F6 A0 0A 00              ldy   #defwindclr              Set current window color table pointer
0634 01F9 A9 7C 22              lda   #def_color               to the default.
0635 01FC 97 D8                 sta   [<data],y
0636 01FE A9 FD 00              lda   #def_color>>16
0637 0201 C8                    iny   
0638 0202 C8                    iny   
0639 0203 97 D8                 sta   [<data],y
0640 0205              ;
0641 0205 A9 52 43              lda   #docDefProc              Stuff address of doc window defProc in
0642 0208 A0 40 01              ldy   #wmgr_wind+wDefProc      window manager's dummy window record
0643 020B 97 D8                 sta   [<data],y                cause Word Perfect uses it as a window.
0644 020D A9 FD 00              lda   #docDefProc>>16
0645 0210 C8                    iny   
0646 0211 C8                    iny   
0647 0212 97 D8                 sta   [<data],y
0648 0214              ;
0649 0214 20 AD 21              jsr   alloc_rgn                Allocate a region for the desktop.
0650 0217 85 C0                 sta   <GrayRgn
0651 0219 86 C2                 stx   <GrayRgn+2
0652 021B              ;
0653 021B 20 85 02              jsr   initres                  Do additional initialization for mode.
0654 021E              ;
0655 021E 8B                    phb   
0656 021F 4C AB 8F              jmp   pop2bytes
0657 0222
0658 0222
0659 0222              ;
0660 0222              ;
0661 0222              ; = = = = = = = = = = = = = = = = = = = = = =
0662 0222              ;          Common code.
0663 0222              ; = = = = = = = = = = = = = = = = = = = = = =
0664 0222              ;
0665 0222              ;   IN:    y = offset into data area to store LONG value.
0666 0222              ;          LONG value on stack.
0667 0222              ;
0668 0222              ;  OUT:    LONG value removed from stack and stored in data area.
0669 0222              ;
0670 0222              getPointer                              ; 
0671 0222              ;
0672 0222 FA                    plx   
0673 0223              ;
0674 0223 68                    pla   
0675 0224 97 D8                 sta   [<data],y
0676 0226 C8                    iny   
0677 0227 C8                    iny   
0678 0228 68                    pla   
0679 0229 97 D8                 sta   [<data],y
0680 022B              ;
0681 022B DA                    phx   
0682 022C 60                    rts   
0683 022D              ;
0684 022D                       ENDP 
0685 022D              ;
0686 022D              ;
0687 022D              ;=====================================================
0688 022D              ;        Set up in current Screen Resolution.
0689 022D              ;=====================================================
0690 022D              ;
0691 022D              ;   IN:    Nothing.
0692 022D              ;  OUT:    Nothing.
0693 022D              ;
0694 022D              WNewRes  PROC 
0695 022D              ;
0696 022D              ;
0697 022D              ;
0698 022D 20 CA 21              jsr   setup
0699 0230              ;
0700 0230 20 48 20              jsr   save_port
0701 0233              ;
0702 0233 20 0E 21              jsr   closeWMgrport            Close Window Manager's current port.
0703 0236              ;
0704 0236 20 85 02              jsr   initres                  Make needed initialization.
0705 0239              ;
0706 0239              ;
0707 0239              ; --- Reinitialize bounds of all window ports --------------------
0708 0239              ;
0709 0239 A5 8E                 lda   <topwind
0710 023B A6 90                 ldx   <topwind+2
0711 023D 80 34                 bra   enter1
0712 023F              ;
0713 023F A0 62 00     lop1     ldy   #scInfo+PortSCB
0714 0242 B7 D8                 lda   [<data],y                Get current SCB byte.
0715 0244 A0 04 00              ldy   #wport+GP_PortInfo+PortSCB
0716 0247 97 A6                 sta   [<wind],y                Set proper SCB byte.
0717 0249              ;
0718 0249 29 80 00              and   #$0080                   Get mode flag.
0719 024C 08                    php   
0720 024D A9 40 01              lda   #320                     Max port width for 320 mode.
0721 0250 28                    plp   
0722 0251 F0 01                 beq   ok1                      320 or 640 mode?
0723 0253 0A                    asl   a                        Double width for 640 mode.
0724 0254 A0 0E 00     ok1      ldy   #wport+GP_PortInfo+PBounds+x1
0725 0257 18                    clc   
0726 0258 77 A6                 adc   [<wind],y
0727 025A A0 12 00              ldy   #wport+GP_PortInfo+PBounds+x2
0728 025D 97 A6                 sta   [<wind],y
0729 025F              ;
0730 025F 20 A8 1F              jsr   moveWMgrOnWind           Move Window Manager's port on window.
0731 0262 A2 02 00              ldx   #wCalcRgns
0732 0265 20 19 20              jsr   dispatch                 Trash 'rect' and 'wrect'.
0733 0268 20 F8 1F              jsr   moveWmgrBack             Move Window Manager's port back.
0734 026B              ;
0735 026B A0 02 00              ldy   #2                       Next window.
0736 026E B7 A6                 lda   [<wind],y
0737 0270 AA                    tax   
0738 0271 A7 A6                 lda   [<wind]
0739 0273              ;
0740 0273 85 A6        enter1   sta   <wind
0741 0275 86 A8                 stx   <wind+2
0742 0277 05 A8                 ora   <wind+2                  Any more windows?
0743 0279 D0 C4                 bne   lop1
0744 027B              ;
0745 027B 20 17 08              jsr   calc_vis
0746 027E 20 60 20              jsr   restore_port
0747 0281              ;
0748 0281 8B           exit     phb   
0749 0282 4C A3 8F              jmp   pop0bytes
0750 0285                       ENDP 
0751 0285              ;
0752 0285              ;
0753 0285              ;===========================================
0754 0285              ;        Initialize for resolution.
0755 0285              ;===========================================
0756 0285              ;
0757 0285              initres  PROC 
0758 0285              ;
0759 0285                       IMPORT pushLocInfo1
0760 0285              ;
0761 0285              ;
0762 0285              ; --- Open Window Manager's port -------------------------
0763 0285              ;
0764 0285 20 48 20              jsr   save_port                Save current port.
0765 0288              ;
0766 0288 20 09 21              jsr   openWMgrport             Open Window Manager's port.
0767 028B              ;
0768 028B 20 55 21              jsr   pushscInfo               Pass address of scInfo.
0769 028E A2 04 1E 22           _GetPortLoc                    Get the parameters of the screen.
0770 0295              ;
0771 0295 20 5A 21              jsr   pushLocInfo1             Pass address of locInfo1.
0772 0298 A2 04 1E 22           _GetPortLoc                    Get the parameters of the screen.
0773 029F              ;
0774 029F              ;
0775 029F              ; --- Initialize my variables for mode ------------------
0776 029F              ;
0777 029F A0 61 00              ldy   #scInfo-1
0778 02A2 B7 D8                 lda   [<data],y
0779 02A4 29 00 80              and   #$8000
0780 02A7 A0 12 00              ldy   #screenMode
0781 02AA 97 D8                 sta   [<data],y
0782 02AC A8                    tay   
0783 02AD D0 0B                 bne   do640
0784 02AF              ;
0785 02AF              ;
0786 02AF              ; ------ Initialize for 320 mode -------------------------
0787 02AF              ;
0788 02AF A2 01 00              ldx   #1                       Thickness of vertical lines.
0789 02B2 A9 FE 22              lda   #wind320                 320 icon font.
0790 02B5 A0 B0 00              ldy   #P_SOLID+$B0             Default desktop pattern.
0791 02B8 80 09                 bra   store1
0792 02BA              ;
0793 02BA              ;
0794 02BA              ; ------ Initialize for 640 mode --------------------------
0795 02BA              ;
0796 02BA A2 02 00     do640    ldx   #2                       Thickness of vertical lines.
0797 02BD A9 8E 22              lda   #wind640                 640 icon font.
0798 02C0 A0 D0 00              ldy   #P_SOLID+$D0             Default desktop pattern.
0799 02C3
0800 02C3
0801 02C3 84 92        store1   sty   <deskpatt                Initialize desktop pattern.
0802 02C5 A0 00 40              ldy   #$4000
0803 02C8 84 94                 sty   <deskpatt+2
0804 02CA
0805 02CA A0 A4 01              ldy   #fontHandle              Initialize font handle.
0806 02CD 97 D8                 sta   [<data],y                Put address of font into dummy handle.
0807 02CF A9 FD 00              lda   #wind320>>16
0808 02D2 C8                    iny   
0809 02D3 C8                    iny   
0810 02D4 97 D8                 sta   [<data],y
0811 02D6
0812 02D6 A0 00 00              ldy   #lineW                   Initialize thickness of vertical lines.
0813 02D9 8A                    txa   
0814 02DA 97 D8                 sta   [<data],y
0815 02DC
0816 02DC 20 4B 21              jsr   pushfontHandle           Push pointer to fontHandle.
0817 02DF 68                    pla   
0818 02E0 A0 0E 00              ldy   #windIconFont
0819 02E3 97 D8                 sta   [<data],y                Store the icon font handle.
0820 02E5 68                    pla   
0821 02E6 C8                    iny   
0822 02E7 C8                    iny   
0823 02E8 97 D8                 sta   [<data],y
0824 02EA
0825 02EA
0826 02EA D4 C2                 pei   <GrayRgn+2               Pass handle of region.
0827 02EC D4 C0                 pei   <GrayRgn
0828 02EE 20 46 21              jsr   pushscreen               Pass pointer to screen bounds.
0829 02F1 A2 04 6C 22           _RectRgn                       Make desktop region the entire screen.
0830 02F8              ;
0831 02F8              ;
0832 02F8              ; --- Initialize global widths and heights ------------------
0833 02F8              ;
0834 02F8              ; ------- Height of window's title bar ----------------------
0835 02F8              ;
0836 02F8 20 6B 21              jsr   pushwork                 Push address of work.
0837 02FB A2 04 96 22           _GetFontInfo 
0838 0302
0839 0302 A5 DE                 lda   <work                    Font's ascent,
0840 0304 18                    clc   
0841 0305 69 03 00              adc   #3                       Pad the top.
0842 0308 A0 04 00              ldy   #titleYPos
0843 030B 97 D8                 sta   [<data],y                Y position to print title in title bar.
0844 030D 18                    clc   
0845 030E 65 E0                 adc   <work+2                  plus decent is the height.
0846 0310 69 02 00              adc   #2                       Pad bottom.
0847 0313 A0 02 00              ldy   #titleHeight
0848 0316 97 D8                 sta   [<data],y                That's the height of title bars.
0849 0318              ;
0850 0318              ; --- Compute width and height of close and zoom box --------------
0851 0318              ;
0852 0318 48                    pha   
0853 0319 48                    pha   
0854 031A A2 04 D1 22           _GetFontID 
0855 0321 48                    pha                            Space for current font.
0856 0322 48                    pha   
0857 0323 A2 04 95 22           _GetFont                       Get handle of current font.
0858 032A
0859 032A A0 10 00              ldy   #windIconFont+2          Pass handle of icon font.
0860 032D B7 D8                 lda   [<data],y
0861 032F 48                    pha   
0862 0330 88                    dey   
0863 0331 88                    dey   
0864 0332 B7 D8                 lda   [<data],y
0865 0334 48                    pha   
0866 0335 A2 04 94 22           _SetFont                       Switch to window icon font.
0867 033C
0868 033C F4 00 00              pea   0                        Close box character.
0869 033F 20 7A 21              jsr   pushrect                 Place to store bounds.
0870 0342 A2 04 AC 22           _CharBounds 
0871 0349
0872 0349 A5 9A                 lda   <rect+y2                 Compute height of close box icon.
0873 034B 38                    sec   
0874 034C E5 96                 sbc   <rect+y1
0875 034E A0 06 00              ldy   #closeHeight
0876 0351 97 D8                 sta   [<data],y                Keep height of close box (and zoom).
0877 0353
0878 0353 A5 9C                 lda   <rect+x2                 Compute width of close box icon.
0879 0355 38                    sec   
0880 0356 E5 98                 sbc   <rect+x1
0881 0358 A0 08 00              ldy   #closeWidth
0882 035B 97 D8                 sta   [<data],y                Keep width of close box (and zoom).
0883 035D
0884 035D A2 04 94 22           _SetFont                       Restore original font.
0885 0364 A2 04 D0 22           _SetFontID 
0886 036B
0887 036B F4 08 00              pea   8                        Check if there is another desktop pattern.
0888 036E 48                    pha   
0889 036F 48                    pha   
0890 0370 A2 0E 0C 22           _Desktop 
0891 0377
0892 0377 82 E6 1C              brl   restore_port             Restore original port.
0893 037A                       ENDP 
0894 037A
0895 037A
0896 037A              ;=================================================
0897 037A              ;          Return status of Window Manager.
0898 037A              ;=================================================
0899 037A              ;
0900 037A              ;   IN:    None.
0901 037A              ;
0902 037A              ;  OUT:    WORD - 1 if active, 0 if not active.
0903 037A              ;
0904 037A              WindStatus PROC 
0905 037A
0906 037A AA                    tax   
0907 037B F0 03                 beq   store
0908 037D A9 12 00              lda   #$0012                   Dan O. version number.
0909 0380
0910 0380              store     
0911 0380 83 07                 sta   7,s                      Return status.
0912 0382 82 6F 1E              brl   RealFastExit
0913 0385
0914 0385                       ENDP 
0915 0385
0916 0385
0917 0385              ;=========================================
0918 0385              ;          Shut down Window Manager.
0919 0385              ;=========================================
0920 0385              ;
0921 0385              ;   IN:  None.
0922 0385              ;
0923 0385              ;  OUT:  None.
0924 0385              ;
0925 0385              WindReset PROC 
0926 0385
0927 0385 22 64 00 E1           jsl   IncBusyFlg
0928 0389
0929 0389 0B                    phd   
0930 038A 80 63                 bra   quicky
0931 038C
0932 038C                       ENTRY WindShutDown
0933 038C              WindShutDown  
0934 038C C9 00 00              cmp   #0                       See if we are active
0935 038F D0 02                 bne   @continue                if a-reg is zero, we are not active!
0936 0391
0937 0391 18                    clc   
0938 0392 6B                    rtl   
0939 0393
0940 0393              @continue  
0941 0393
0942 0393 22 64 00 E1           jsl   IncBusyFlg
0943 0397
0944 0397 0B                    phd   
0945 0398 5B                    tcd   
0946 0399              ;
0947 0399              ; --- Close every window, in every way -------------------------
0948 0399              ;
0949 0399 80 18                 bra   enter1
0950 039B A5 8E        lop1     lda   <topwind
0951 039D 20 08 22              jsr   get_portp2
0952 03A0
0953 03A0
0954 03A0 DA                    phx                            ; push window pointer for closewindow
0955 03A1 48                    pha   
0956 03A2
0957 03A2 A0 D2 00              ldy   #wFrame
0958 03A5 B7 8E                 lda   [<topwind],y
0959 03A7 29 DF FF              and   #$FFFF-f_Vis
0960 03AA 97 8E                 sta   [<topwind],y
0961 03AC
0962 03AC A2 0E 0B 22           _CloseWindow 
0963 03B3              ;
0964 03B3 A5 90        enter1   lda   <topwind+2
0965 03B5 AA                    tax   
0966 03B6 05 8E                 ora   <topwind
0967 03B8 D0 E1                 bne   lop1
0968 03BA
0969 03BA              ;
0970 03BA              ;
0971 03BA              ; --- refresh the desktop ----------------------------------
0972 03BA              ;
0973 03BA F4 FD 00 F4           PushLong #ScreenRect 
0974 03C0 A2 0E 39 22           _RefreshDeskTop 
0975 03C7
0976 03C7              ;
0977 03C7              ;
0978 03C7              ; --- Free desktop region ----------------------------------
0979 03C7              ;
0980 03C7 20 87 21              jsr   pushGray
0981 03CA A2 04 68 22           _DisposeRgn 
0982 03D1              ;
0983 03D1              ;
0984 03D1              ; --- Close the Window Manager's port ----------------------
0985 03D1              ;
0986 03D1 20 0E 21              jsr   closeWMgrport            Close Window Manager's port.
0987 03D4              ;
0988 03D4 A2 10 05 22           _CtlReset                      Shutdown the Control Manager.
0989 03DB              ;
0990 03DB              ;
0991 03DB              ; --- Free allocated data area.
0992 03DB              ;
0993 03DB 48                    pha   
0994 03DC 48                    pha   
0995 03DD D4 DA                 pei   <data+2                  Find handle of data area.
0996 03DF D4 D8                 pei   <data
0997 03E1 A2 02 1A 22           _FindHandle 
0998 03E8 A2 02 10 22           _DisposeHandle 
0999 03EF              ;
1000 03EF              ;
1001 03EF              ; --- Set my Tool Locator variable to zero ------------------
1002 03EF              ;
1003 03EF A9 00 00     quicky   lda   #0                       Clear WAP.
1004 03F2 20 01 04              jsr   setWAP
1005 03F5              ;
1006 03F5 8B                    phb   
1007 03F6 4C A3 8F              jmp   pop0bytes                All done.
1008 03F9
1009 03F9
1010 03F9 00 00 00 00  ScreenRect DC W:0,0,200,640
1011 0401
1012 0401                       ENDP 
1013 0401              ;
1014 0401              ;
1015 0401              ;===============================
1016 0401              ;          Call SetWAP.
1017 0401              ;===============================
1018 0401              ;
1019 0401              ;   IN:    a = value to pass to WAP.
1020 0401              ;
1021 0401              setWAP   PROC 
1022 0401              ;
1023 0401                                                      ;using equates
1024 0401              ;
1025 0401              ;
1026 0401 A2 00 00              ldx   #0
1027 0404 DA                    phx   
1028 0405 F4 0E 00              pea   WindToolNum              Pass Window Manager tool number.
1029 0408 DA                    phx   
1030 0409 48                    pha   
1031 040A A2 01 0D 22           _SetWAP                        Tell Tool Locator about it.
1032 0411 60                    rts   
1033 0412                       ENDP 
1034 0412              ;
1035 0412              ;
1036 0412              ;=========================================
1037 0412              ;        Stuff any update messages
1038 0412              ;        into event record.
1039 0412              ;=========================================
1040 0412              ;
1041 0412              ;   IN:  PUSH:LONG - pointer to event record.
1042 0412              ;
1043 0412              ;  OUT:  WORD - 1 if update event passed, 0 if no update event found.
1044 0412              ;
1045 0412              CheckUpdate PROC 
1046 0412              ;
1047 0412                                                      ;using equates
1048 0412              ;
1049 0412              eventRec equ   9
1050 0412              RetFlag  equ   eventRec+4
1051 0412              ;
1052 0412              ;
1053 0412 22 64 00 E1           jsl   IncBusyFlg
1054 0416
1055 0416 0B                    phd                            Save orginal zero page.
1056 0417 5B                    tcd                            Switch to my zero page.
1057 0418              ;
1058 0418 A3 09                 lda   eventRec,s               Move event pointer into 'workptr'.
1059 041A 85 AE                 sta   <workptr
1060 041C A3 0B                 lda   eventRec+2,s
1061 041E 85 B0                 sta   <workptr+2
1062 0420              ;
1063 0420              ;
1064 0420              ; --- Search window list for windows with valid update regions ----------
1065 0420              ;
1066 0420 A5 8E                 lda   <topwind                 Start with the top most window.
1067 0422 A6 90                 ldx   <topwind+2
1068 0424 86 A8        lop      stx   <wind+2
1069 0426 85 A6                 sta   <wind
1070 0428 05 A8                 ora   <wind+2
1071 042A F0 37                 beq   exit                     Any more windows?
1072 042C              ;
1073 042C              ; ------- Is the window even visible? ---------------------------
1074 042C              ;
1075 042C 20 48 22              jsr   testVis                  Test the window's F_VIS flag.
1076 042F F0 28                 beq   nextwind                 Only check visible windows.
1077 0431              ;
1078 0431              ; ------- Check if window's update region is empty -----------------
1079 0431              ;
1080 0431 48                    pha                            Space for result.
1081 0432 A0 C8 00              ldy   #wupdateRgn+2
1082 0435 20 F9 21              jsr   pushandle                Push window's update region handle.
1083 0438 A2 04 78 22           _EmptyRgn                      Check if region is empty.
1084 043F 68                    pla   
1085 0440 D0 17                 bne   nextwind                 Empty?
1086 0442              ;
1087 0442              ; ------- Pass update information in event record -------------------
1088 0442              ;
1089 0442 A9 06 00              lda   #6                       Set event code.
1090 0445 87 AE                 sta   [<workptr]
1091 0447              ;
1092 0447 20 04 22              jsr   get_portptr              Compute pointer to window's port.
1093 044A              ;
1094 044A A0 02 00              ldy   #message                 Return pointer to window
1095 044D 97 AE                 sta   [<workptr],y
1096 044F C8                    iny   
1097 0450 C8                    iny   
1098 0451 8A                    txa   
1099 0452 97 AE                 sta   [<workptr],y
1100 0454 A9 FF FF              lda   #TRUE                    Update flag.
1101 0457 80 0A                 bra   exit                     That's it.
1102 0459              ;
1103 0459 A0 02 00     nextwind ldy   #2                       Next window in list.
1104 045C B7 A6                 lda   [<wind],y
1105 045E AA                    tax   
1106 045F A7 A6                 lda   [<wind]
1107 0461 80 C1                 bra   lop
1108 0463              ;
1109 0463              ;
1110 0463 83 0D        exit     sta   RetFlag,s                0 = no update, not 0 = update.
1111 0465 8B                    phb   
1112 0466 4C B3 8F              jmp   pop4bytes
1113 0469                       ENDP 
1114 0469              ;
1115 0469              ;
1116 0469              ;========================================
1117 0469              ;          Redraw entire desktop.
1118 0469              ;========================================
1119 0469              ;
1120 0469              ;   IN:    PUSH:LONG - pointer to RECT, or zero for whole screen.
1121 0469              ;  OUT:    None.
1122 0469              ;
1123 0469              Refresh  PROC 
1124 0469              ;
1125 0469              ;
1126 0469              ;
1127 0469              badRect  equ   9
1128 0469              ;
1129 0469              ;
1130 0469 AA                    tax   
1131 046A D0 05                 bne   @Continue
1132 046C A9 02 00              lda   #2
1133 046F 38                    sec   
1134 0470 6B                    rtl   
1135 0471              @Continue  
1136 0471
1137 0471 22 64 00 E1           jsl   IncBusyFlg
1138 0475
1139 0475 0B                    phd                            Save zero page.
1140 0476 5B                    tcd                            Switch to my zero page.
1141 0477              ;
1142 0477              ;
1143 0477              ; --- Check if caller wants whole screen -------------------------------
1144 0477              ;
1145 0477 A3 0B                 lda   badRect+2,s
1146 0479 A8                    tay   
1147 047A A3 09                 lda   badRect,s
1148 047C AA                    tax   
1149 047D D0 08                 bne   skip1
1150 047F 98                    tya   
1151 0480 D0 05                 bne   skip1                    Use default whole screen RECT?
1152 0482              ;
1153 0482 20 41 21              jsr   pushGP_Bounds            Push pointer to my port's bounds.
1154 0485 FA                    plx   
1155 0486 7A                    ply   
1156 0487              ;
1157 0487              ;
1158 0487              ; --- Redraw the clobbered area ----------------------------------------
1159 0487              ;
1160 0487 84 E0        skip1    sty   <work+2                  Save address of RECT to redraw.
1161 0489 86 DE                 stx   <work
1162 048B              ;
1163 048B 20 AD 21              jsr   alloc_rgn                Allocate a temp work region, 'rgnptr'.
1164 048E              ;
1165 048E 20 80 21              jsr   pushrgnptr               Pass address of clobbered region.
1166 0491 D4 E0                 pei   <work+2                  Pass address of clobbered RECT.
1167 0493 D4 DE                 pei   <work
1168 0495 A2 04 6C 22           _RectRgn                       Set clobbered region to clobbered RECT.
1169 049C              ;
1170 049C 20 3A 20              jsr   setwmgrport
1171 049F 20 C4 08              jsr   fullport
1172 04A2              ;
1173 04A2 D4 C2                 pei   <GrayRgn+2               Desktop,
1174 04A4 D4 C0                 pei   <GrayRgn
1175 04A6 20 80 21              jsr   pushrgnptr               AND clobbered region.
1176 04A9 20 80 21              jsr   pushrgnptr
1177 04AC A2 04 71 22           _SectRgn                       rgnptr = rgnptr AND GrayRgn.
1178 04B3              ;
1179 04B3 A5 8E                 lda   <topwind                 Draw every window.
1180 04B5 85 A6                 sta   <wind
1181 04B7 A5 90                 lda   <topwind+2
1182 04B9 85 A8                 sta   <wind+2
1183 04BB 20 B5 06              jsr   paintonedown
1184 04BE              ;
1185 04BE 20 78 26              jsr   disposeRgnPtr            Free temp work region.
1186 04C1              ;
1187 04C1 20 60 20              jsr   restore_port             Restore original port.
1188 04C4              ;
1189 04C4 8B                    phb   
1190 04C5 4C B3 8F              jmp   pop4bytes                Restore zero page.
1191 04C8                       ENDP 
1192 04C8              ;
1193 04C8              ;
1194 04C8              ;======================================================
1195 04C8              ;        Return Window Manager's Version Number
1196 04C8              ;======================================================
1197 04C8              ;  IN:   Nothing
1198 04C8              ; OUT:   WORD - version number.
1199 04C8              ;
1200 04C8              WindVersion PROC 
1201 04C8 A9 00 03              lda   #$0300
1202 04CB 83 07                 sta   7,s
1203 04CD 82 24 1D              brl   RealFastExit
1204 04D0
1205 04D0                       ENDP 
1206 04D0
1207 04D0              ;======================================================
1208 04D0              ;        Return pointer to Window Manager's port.
1209 04D0              ;======================================================
1210 04D0              ;  IN:   Nothing
1211 04D0              ; OUT:     LONG - pointer to Window Manager's port.
1212 04D0              ;
1213 04D0              GetWMgrPort PROC 
1214 04D0              ;
1215 04D0              ;
1216 04D0              result   equ   9
1217 04D0              ;
1218 04D0 22 64 00 E1           jsl   IncBusyFlg
1219 04D4              ;
1220 04D4 0B                    phd   
1221 04D5 5B                    tcd   
1222 04D6              ;
1223 04D6 20 19 21              jsr   pushport                 Push address of Window Manager port.
1224 04D9 68                    pla                            Return address of Window Manager port.
1225 04DA FA                    plx   
1226 04DB 80 24                 bra   return
1227 04DD              ;
1228 04DD              ;
1229 04DD              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1230 04DD              ;        Return pointer to current active window.
1231 04DD              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = =
1232 04DD              ;
1233 04DD              ;  IN:   Nothing
1234 04DD              ;
1235 04DD              ; OUT:   LONG - pointer to current active window's port.
1236 04DD              ;
1237 04DD                       ENTRY FrontWindow
1238 04DD              FrontWindow                             ; 
1239 04DD              ;
1240 04DD 22 64 00 E1           jsl   IncBusyFlg
1241 04E1              ;
1242 04E1 0B                    phd   
1243 04E2 5B                    tcd   
1244 04E3              ;
1245 04E3 20 96 20              jsr   find_top                 Find the top most visible window.
1246 04E6 20 08 22              jsr   get_portp2               Convert window pointer to port pointer.
1247 04E9 80 16                 bra   return
1248 04EB              ;
1249 04EB              ;
1250 04EB              ; = = = = = = = = = = = = = = = = = = = = = = =
1251 04EB              ;          Return pointer to first
1252 04EB              ;          window in window list.
1253 04EB              ;110= = = = = = = = = = = = = = = = = = = = = =
1254 04EB              ;
1255 04EB              ;  IN:   Nothing
1256 04EB              ;
1257 04EB              ; OUT:   LONG - pointer to first window in window list, zero if none.
1258 04EB              ;
1259 04EB                       ENTRY GetFirstWindow
1260 04EB              GetFirstWindow                          ; 
1261 04EB              ;
1262 04EB              ;
1263 04EB 22 64 00 E1           jsl   IncBusyFlg
1264 04EF
1265 04EF 0B                    phd   
1266 04F0 5B                    tcd   
1267 04F1              ;
1268 04F1 A5 8E                 lda   <topwind                 Return pointer to top window port.
1269 04F3 A6 90                 ldx   <topwind+2
1270 04F5 D0 03                 bne   ok1
1271 04F7 A8                    tay   
1272 04F8 F0 07                 beq   return
1273 04FA 18           ok1      clc   
1274 04FB 69 04 00              adc   #wport
1275 04FE 90 01                 bcc   return
1276 0500 E8                    inx   
1277 0501              ;
1278 0501 83 09        return   sta   result,s                 Return pointer to top window port.
1279 0503 8A                    txa   
1280 0504 83 0B                 sta   result+2,s
1281 0506              ;
1282 0506 8B                    phb   
1283 0507 4C A3 8F              jmp   pop0bytes
1284 050A              ;
1285 050A                       ENDP 
1286 050A              ;
1287 050A              ;
1288 050A              ;===============================================
1289 050A              ;        Swap Window Manager Icon Font.
1290 050A              ;===============================================
1291 050A              ;
1292 050A              ;   IN:    PUSH:LONG - handle of new Window Manager icon font, -1 for none.
1293 050A              ;
1294 050A              ;  OUT:    LONG - current (before swap) icon font.
1295 050A              ;
1296 050A              SetWMgrIcons PROC 
1297 050A              ;
1298 050A              ;
1299 050A              newFont  equ   9
1300 050A              oldFont  equ   newFont+4
1301 050A              ;
1302 050A              ;
1303 050A 22 64 00 E1           jsl   IncBusyFlg
1304 050E 0B                    phd   
1305 050F 5B                    tcd   
1306 0510              ;
1307 0510 A0 0E 00              ldy   #windIconFont            Return old font.
1308 0513 B7 D8                 lda   [<data],y
1309 0515 83 0D                 sta   oldFont,s
1310 0517 C8                    iny   
1311 0518 C8                    iny   
1312 0519 B7 D8                 lda   [<data],y
1313 051B 83 0F                 sta   oldFont+2,s
1314 051D              ;
1315 051D A3 0B                 lda   newFont+2,s              Use new font?
1316 051F 30 08                 bmi   exit
1317 0521              ;
1318 0521 97 D8                 sta   [<data],y                Initialize new icon font.
1319 0523 88                    dey   
1320 0524 88                    dey   
1321 0525 A3 09                 lda   newFont,s
1322 0527 97 D8                 sta   [<data],y
1323 0529              ;
1324 0529 8B           exit     phb   
1325 052A 4C B3 8F              jmp   pop4bytes
1326 052D                       ENDP 
1327 052D              ;
1328 052D              ;
1329 052D              ;===============================================================
1330 052D              ;          Return pointer to Window Manager globals.
1331 052D              ;===============================================================
1332 052D              ;
1333 052D              GetWindowMgrGlobals PROC 
1334 052D              ;
1335 052D              ;
1336 052D              result   equ   9
1337 052D              ;
1338 052D              ;
1339 052D 22 64 00 E1           jsl   IncBusyFlg
1340 0531 0B                    phd   
1341 0532 5B                    tcd   
1342 0533              ;
1343 0533 A5 D8                 lda   <data
1344 0535 83 09                 sta   result,s
1345 0537 A5 DA                 lda   <data+2
1346 0539 83 0B                 sta   result+2,s
1347 053B              ;
1348 053B 8B                    phb   
1349 053C 4C A3 8F              jmp   pop0Bytes
1350 053F                       ENDP 
1351 053F              ;
1352 053F              ;
1353 053F              ;==================================================
1354 053F              ;          Setup to draw window frame.
1355 053F              ;==================================================
1356 053F              ;
1357 053F              ;   IN:    PUSH:LONG - pointer to window RECORD to setup for.
1358 053F              ;
1359 053F                       EXPORT StartFrameDrawing
1360 053F              StartFrameDrawing PROC 
1361 053F              ;
1362 053F                                                      ;using equates
1363 053F              ;
1364 053F              theWindow equ   9
1365 053F              ;
1366 053F              ;
1367 053F 22 64 00 E1           jsl   IncBusyFlg
1368 0543 0B                    phd                            Save caller's direct page pointer.
1369 0544 5B                    tcd                            Switch to Window Manager's direct page.
1370 0545              ;
1371 0545 A3 09                 lda   theWindow,s              Pass pointer to window record.
1372 0547 85 A6                 sta   <wind
1373 0549 A3 0B                 lda   theWindow+2,s
1374 054B 85 A8                 sta   <wind+2
1375 054D              ;
1376 054D 20 87 21              jsr   pushGray                 Pass handle to desktop, source 1.
1377 0550 A0 C0 00              ldy   #wstrucRgn+2             Pass handle window's StructRgn.
1378 0553 20 F9 21              jsr   pushandle
1379 0556 20 9A 21              jsr   pushclip                 Pass handle of region for result.
1380 0559 A2 04 71 22           _SectRgn                       Intersection of strucRgn and desktop.
1381 0560              ;
1382 0560 20 D2 08              jsr   SubStructLoop            Subtract all windows above.
1383 0563 20 A8 1F              jsr   moveWMgrOnWind           Move Window Manager port over window.
1384 0566              ;
1385 0566 8B                    phb   
1386 0567 4C B3 8F              jmp   pop4bytes
1387 056A                       ENDP 
1388 056A              ;
1389 056A              ;
1390 056A              ;==================================================
1391 056A              ;          Undo setup to draw window frame.
1392 056A              ;==================================================
1393 056A              ;
1394 056A              ;   IN:    No inputs.
1395 056A              ;          StartFrameDrawing must have been called.
1396 056A              ;
1397 056A                       EXPORT EndFrameDrawing
1398 056A              EndFrameDrawing PROC 
1399 056A              ;
1400 056A 22 64 00 E1           jsl   IncBusyFlg
1401 056E 0B                    phd                            Save caller's direct page pointer.
1402 056F 5B                    tcd                            Switch to Window Manager's direct page.
1403 0570              ;
1404 0570 20 F8 1F              jsr   moveWMgrBack
1405 0573 20 C4 08              jsr   fullPort
1406 0576              ;
1407 0576 8B                    phb   
1408 0577 4C A3 8F              jmp   pop0bytes
1409 057A
1410 057A
1411 057A                       ENDP 
1412 057A              ;
1413 057A              ;
1414 057A              ;            APPEND	WREGION.ASM
1415 057A                       TITLE 'Apple IIGS Window Manager                   WREGION.ASM' 
1416 057A              ;
1417 057A              ;          Copyright Apple Computer, Inc. 1986,1987,1988
1418 057A              ;          All rights reserved
1419 057A              ;          Written by Dan Oliver
1420 057A              ;
1421 057A              ;
1422 057A              ;======================================================
1423 057A              ;          Subtract region from update region.
1424 057A              ;======================================================
1425 057A              ;
1426 057A              ;   IN:    PUSH:LONG - handle of region to take from window's update region.
1427 057A              ;          Current port is window's.
1428 057A              ;
1429 057A              ;  OUT:    None.
1430 057A              ;
1431 057A              ValidRgn PROC 
1432 057A              ;
1433 057A              ;
1434 057A              ;
1435 057A A2 01 00              ldx   #1                       Subtract region flag.
1436 057D 80 03                 bra   common100
1437 057F              ;
1438 057F              ;
1439 057F              ; = = = = = = = = = = = = = = = = = = = = = = =
1440 057F              ;          Add region to update region.
1441 057F              ;100= = = = = = = = = = = = = = = = = = = = = =
1442 057F              ;
1443 057F              ;   IN:    PUSH:LONG - handle of region to be added to window's update region.
1444 057F              ;          Current port is window's.
1445 057F              ;
1446 057F              ;  OUT:    None.
1447 057F              ;
1448 057F                       ENTRY InvalRgn
1449 057F              InvalRgn                                ; 
1450 057F              ;
1451 057F              badRgn   equ   9
1452 057F              ;
1453 057F              ;
1454 057F A2 00 00              ldx   #0                       Add flag.
1455 0582              ;
1456 0582              common100  
1457 0582 22 64 00 E1           jsl   IncBusyFlg
1458 0586 0B                    phd                            Save caller's zero page.
1459 0587 5B                    tcd                            Switch to my zero page.
1460 0588              ;
1461 0588 20 C8 05              jsr   chg_update               Add the region to the update region.
1462 058B              ;
1463 058B 8B                    phb   
1464 058C 4C B3 8F              jmp   pop4bytes
1465 058F              ;
1466 058F              ;
1467 058F              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1468 058F              ;          Subtract RECT to update region.
1469 058F              ;110= = = = = = = = = = = = = = = = = = = = = = = = =
1470 058F              ;
1471 058F              ;   IN:    PUSH:LONG - pointer to RECT to take from window's update region.
1472 058F              ;          Current port is window's.
1473 058F              ;
1474 058F              ;  OUT:    None.
1475 058F              ;
1476 058F                       ENTRY ValidRect
1477 058F              ValidRect                               ; 
1478 058F              ;
1479 058F              ;
1480 058F A2 01 00              ldx   #1                       Subtract flag.
1481 0592 80 03                 bra   common120
1482 0594              ;
1483 0594              ;
1484 0594              ; = = = = = = = = = = = = = = = = = = = = = = =
1485 0594              ;          Add RECT to update region.
1486 0594              ;120= = = = = = = = = = = = = = = = = = = = = =
1487 0594              ;
1488 0594              ;   IN:    PUSH:LONG - pointer to RECT to be added to window's update region.
1489 0594              ;          Current port is window's.
1490 0594              ;
1491 0594              ;  OUT:    None.
1492 0594              ;
1493 0594                       ENTRY InvalRect
1494 0594              InvalRect                               ; 
1495 0594              ;
1496 0594 A2 00 00              ldx   #0                       Add flag.
1497 0597              ;
1498 0597              common120  
1499 0597 22 64 00 E1           jsl   IncBusyFlg
1500 059B 20 A5 05              jsr   init_rgn                 Allocate and initialize temp region.
1501 059E              ;
1502 059E 20 78 26              jsr   disposeRgnPtr            Free temp region.
1503 05A1              ;
1504 05A1 8B                    phb   
1505 05A2 82 0E 8A              brl   pop4bytes
1506 05A5              ;
1507 05A5              ;
1508 05A5              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1509 05A5              ;       Get window pointer from current port
1510 05A5              ;130= = = = = = = = = = = = = = = = = = = = = = = = =
1511 05A5              ;
1512 05A5 7A           init_rgn ply                            Get return address.
1513 05A6              ;
1514 05A6 0B                    phd                            Save caller's zero page.
1515 05A7 5B                    tcd                            Switch to my zero page.
1516 05A8              ;
1517 05A8 5A                    phy                            Put return address back.
1518 05A9              ;
1519 05A9              ;
1520 05A9              ; --- Allocate and initialize a temp region -------------
1521 05A9              ;
1522 05A9 86 DE                 stx   <work                    Save operation flag.
1523 05AB              ;
1524 05AB 20 AD 21              jsr   alloc_rgn                Get temp region.
1525 05AE              ;
1526 05AE 20 80 21              jsr   pushrgnptr               Set temp = to given RECT.
1527 05B1 A3 11                 lda   17,s                     Pass address of RECT.
1528 05B3 48                    pha   
1529 05B4 A3 11                 lda   17,s
1530 05B6 48                    pha   
1531 05B7 A2 04 6C 22           _RectRgn 
1532 05BE              ;
1533 05BE A5 B8                 lda   <rgnptr                  Replace pointer to RECT with region.
1534 05C0 83 0B                 sta   11,s
1535 05C2 A5 BA                 lda   <rgnptr+2
1536 05C4 83 0D                 sta   13,s
1537 05C6              ;
1538 05C6 A6 DE                 ldx   <work                    Save operation flag.
1539 05C8              ;
1540 05C8              ;
1541 05C8 86 DE        chg_update stx   <work                  Save operation.
1542 05CA              ;
1543 05CA 20 88 20              jsr   get_port
1544 05CD              ;
1545 05CD              ; --- Convert region to global coordinates ------------------
1546 05CD              ;
1547 05CD A3 0D                 lda   13,s                     Region handle.
1548 05CF 48                    pha   
1549 05D0 A3 0D                 lda   13,s
1550 05D2 48                    pha   
1551 05D3 A0 0E 00              ldy   #wport+GP_Bounds+x1      Get window's port offset.
1552 05D6 B7 A6                 lda   [<wind],y
1553 05D8 49 FF FF              eor   #$FFFF
1554 05DB 1A                    inc   a
1555 05DC 48                    pha   
1556 05DD 88                    dey   
1557 05DE 88                    dey   
1558 05DF B7 A6                 lda   [<wind],y
1559 05E1 49 FF FF              eor   #$FFFF
1560 05E4 1A                    inc   a
1561 05E5 48                    pha   
1562 05E6 A2 04 6F 22           _OffsetRgn 
1563 05ED              ;
1564 05ED              ; --- Add/Subtract region to update region ------------------------
1565 05ED              ;
1566 05ED A0 C8 00              ldy   #wupdateRgn+2            Starting region.
1567 05F0 20 F9 21              jsr   pushandle
1568 05F3 A3 11                 lda   17,s                     Region to subtract.
1569 05F5 48                    pha   
1570 05F6 A3 11                 lda   17,s
1571 05F8 48                    pha   
1572 05F9 A0 C8 00              ldy   #wupdateRgn+2            Region to place result.
1573 05FC 20 F9 21              jsr   pushandle
1574 05FF              ;
1575 05FF A5 DE                 lda   <work                    Was that add or subtract?
1576 0601 F0 08                 beq   add2
1577 0603              ;
1578 0603 A2 04 73 22           _DiffRgn                       Subtract region.
1579 060A 60                    rts   
1580 060B              ;
1581 060B A2 04 72 22  add2     _UnionRgn                      Add region
1582 0612 60                    rts   
1583 0613              ;
1584 0613                       ENDP 
1585 0613              ;
1586 0613              ;
1587 0613              ;=======================================================================
1588 0613              ;          Set the window's origin to draw.
1589 0613              ;          The caller should perform SetOrigin(0,0) when done.
1590 0613              ;=======================================================================
1591 0613              ;
1592 0613              ;   IN:    PUSH:LONG - pointer to window's port.
1593 0613              ;
1594 0613              ;  OUT:    None.
1595 0613              ;                Current port equals window's.
1596 0613              ;                Origin set.
1597 0613              ;
1598 0613              StartDrawing PROC 
1599 0613              ;
1600 0613              ;
1601 0613              ;
1602 0613 20 CA 21              jsr   setup
1603 0616              ;
1604 0616 A9 1D 00              lda   #wStartDrawing           Pass command to defProc.
1605 0619 20 D5 11              jsr   callProc2                Call window's defProc.
1606 061C              ;
1607 061C 8B                    phb   
1608 061D 82 93 89              brl   pop4bytes
1609 0620                       ENDP 
1610 0620              ;
1611 0620              ;
1612 0620              ;======================================
1613 0620              ;        Replace visRgn with
1614 0620              ;        visRgn AND wupdateRgn.
1615 0620              ;======================================
1616 0620              ;
1617 0620              ;   IN:  PUSH:LONG - pointer to window's port.
1618 0620              ;
1619 0620              ;  OUT:  Nothing.
1620 0620              ;
1621 0620                       EXPORT BeginUpdate
1622 0620              BeginUpdate PROC 
1623 0620
1624 0620 20 CA 21              jsr   setup
1625 0623
1626 0623 20 36 06              jsr   startupdate
1627 0626
1628 0626 20 04 22              jsr   get_portptr              Get pointer to window's port.
1629 0629 DA                    phx   
1630 062A 48                    pha   
1631 062B A2 04 1B 22           _SetPort 
1632 0632
1633 0632 8B                    phb   
1634 0633 82 7D 89              brl   pop4bytes
1635 0636              ;
1636 0636              ;
1637 0636              ; = = = = = = = = = = = = = = = = = = = = =
1638 0636              ;          Guts of BeginUpdate.
1639 0636              ;100= = = = = = = = = = = = = = = = = = = =
1640 0636              ;
1641 0636              ;   IN:    wind = window pointer.
1642 0636              ;
1643 0636              ;  OUT:    window's visRgn = update region.
1644 0636              ;          port = window's.
1645 0636              ;
1646 0636                       EXPORT startupdate
1647 0636              startupdate                             ;       
1648 0636              ;
1649 0636              ;
1650 0636              ; --- Convert updateRgn to local coordinates ------------------
1651 0636              ;
1652 0636 A0 C8 00              ldy   #wupdateRgn+2
1653 0639 20 F9 21              jsr   pushandle
1654 063C A0 0E 00              ldy   #wport+GP_Bounds+x1      Get window's port offset.
1655 063F 20 F9 21              jsr   pushWlong
1656 0642 A2 04 6F 22           _OffsetRgn                     Make update local to window.
1657 0649              ;
1658 0649              ;
1659 0649              ; --- updateRgn = updateRgn AND visRgn ------------------------
1660 0649              ;
1661 0649 A0 22 00              ldy   #wport+GP_VisRgn+2
1662 064C 20 F9 21              jsr   pushandle                Pass the visRgn handle.
1663 064F A0 C8 00              ldy   #wupdateRgn+2            Pass the update region handle.
1664 0652 20 F9 21              jsr   pushandle
1665 0655 A0 C8 00              ldy   #wupdateRgn+2            Put the intersection of vis and
1666 0658 20 F9 21              jsr   pushandle                update into update.
1667 065B A2 04 71 22           _SectRgn                       Get the intersection.
1668 0662              ;
1669 0662              ;
1670 0662              ; --- Switch the visRgn and updateRgn handles ----------
1671 0662              ;
1672 0662 20 86 06              jsr   swapRgn
1673 0665              ;
1674 0665              ;
1675 0665              ; --- Switch to the window's port ----------------------
1676 0665              ;
1677 0665 20 48 20              jsr   save_port                Save the original port.
1678 0668 60                    rts   
1679 0669              ;
1680 0669              ;
1681 0669              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1682 0669              ;          Replace visRgn with wupdateRgn.
1683 0669              ;110= = = = = = = = = = = = = = = = = = = = = = = = =
1684 0669              ;
1685 0669              ;   IN:    PUSH:LONG - pointer to window's port.
1686 0669              ;
1687 0669              ;  OUT:    Nothing.
1688 0669              ;
1689 0669                       EXPORT EndUpdate
1690 0669              EndUpdate  
1691 0669
1692 0669 20 CA 21              jsr   setup
1693 066C
1694 066C 20 73 06              jsr   finiupdate
1695 066F 8B                    phb   
1696 0670 82 40 89              brl   pop4bytes
1697 0673              ;
1698 0673              ;
1699 0673              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1700 0673              ;          Guts to EndUpdate.
1701 0673              ;120= = = = = = = = = = = = = = = = = = = = = = = = =
1702 0673              ;
1703 0673              ;   IN:    wind = window pointer.
1704 0673              ;
1705 0673                       EXPORT finiupdate
1706 0673              finiupdate  
1707 0673              ;
1708 0673 20 86 06              jsr   swapRgn                  Exchange updateRgn and visRgn handles.
1709 0676              ;
1710 0676 A0 C8 00              ldy   #wupdateRgn+2
1711 0679 20 F9 21              jsr   pushandle                Push updateRgn handle.
1712 067C A2 04 6A 22           _SetEmptyRgn                   Empty the update region.
1713 0683              ;
1714 0683 82 DA 19              brl   restore_port             Restore original port.
1715 0686              ;
1716 0686              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1717 0686              ;        Swap updateRgn and visRgn handles.
1718 0686              ;130= = = = = = = = = = = = = = = = = = = = = = = = =
1719 0686              ;
1720 0686              ;   IN:    <wind = pointer to window.
1721 0686              ;
1722 0686 A0 22 00     swapRgn  ldy   #wport+GP_VisRgn+2
1723 0689 20 F9 21              jsr   pushandle                Save the visRgn handle.
1724 068C              ;
1725 068C A0 C8 00              ldy   #wupdateRgn+2
1726 068F 20 F9 21              jsr   pushandle                Get the handle for updateRgn.
1727 0692 A0 20 00              ldy   #wport+GP_VisRgn         Store wupdateRgn handle in visRgn.
1728 0695 68                    pla   
1729 0696 97 A6                 sta   [<wind],y
1730 0698 C8                    iny   
1731 0699 C8                    iny   
1732 069A 68                    pla   
1733 069B 97 A6                 sta   [<wind],y
1734 069D              ;
1735 069D A0 C6 00              ldy   #wupdateRgn              Store visRgn handle in wupdate.
1736 06A0 68                    pla   
1737 06A1 97 A6                 sta   [<wind],y
1738 06A3 C8                    iny   
1739 06A4 C8                    iny   
1740 06A5 68                    pla   
1741 06A6 97 A6                 sta   [<wind],y
1742 06A8 60                    rts   
1743 06A9              ;
1744 06A9                       ENDP 
1745 06A9              ;
1746 06A9              ;
1747 06A9              ;========================================
1748 06A9              ;        Redraw a clobbered region.
1749 06A9              ;========================================
1750 06A9              ;
1751 06A9              ;   IN:  wind = window to start with, and go down list from there.
1752 06A9              ;        rgnptr = clobbered region.
1753 06A9              ;
1754 06A9              ;  OUT:  wind trashed.
1755 06A9              ;        rgnptr trashed.
1756 06A9              ;
1757 06A9              paintbehind PROC 
1758 06A9              ;
1759 06A9              ; --- Go down list and draw all windows -----------
1760 06A9              ;
1761 06A9 A0 02 00     lop1     ldy   #2                       ;Next window.
1762 06AC B7 A6                 lda   [<wind],y
1763 06AE A8                    tay   
1764 06AF A7 A6                 lda   [<wind]
1765 06B1 85 A6                 sta   <wind
1766 06B3 84 A8                 sty   <wind+2
1767 06B5              ;
1768 06B5              ;
1769 06B5                       ENTRY paintonedown
1770 06B5              paintonedown  
1771 06B5              ;
1772 06B5 20 BF 06              jsr   PaintOne                 ;Paint the window.
1773 06B8              ;
1774 06B8 A5 A6                 lda   <wind
1775 06BA 05 A8                 ora   <wind+2
1776 06BC D0 EB                 bne   lop1
1777 06BE              ;
1778 06BE 60                    rts   
1779 06BF              ;
1780 06BF              ;
1781 06BF              ; = = = = = = = = = = = = = = = = = = = = =
1782 06BF              ;        Draw a single window.
1783 06BF              ;100= = = = = = = = = = = = = = = = = = = =
1784 06BF              ;
1785 06BF              ;   IN:    wind = window to be drawn, zero to draw desktop pattern.
1786 06BF              ;          rgnptr = handle of region to be redrawn (clobbered region).
1787 06BF              ;          Current port = window manager's.
1788 06BF              ;
1789 06BF              ;  OUT:    rgnptr = rgnptr - redrawn area.
1790 06BF              ;
1791 06BF                       ENTRY PaintOne
1792 06BF              PaintOne  
1793 06BF              ;
1794 06BF A5 A6                 lda   <wind                    Is window NIL?
1795 06C1 05 A8                 ora   <wind+2
1796 06C3 D0 1D                 bne   gopaintone
1797 06C5              ;
1798 06C5              ;
1799 06C5              ; --- Draw desktop in clobbered region -----------
1800 06C5              ;
1801 06C5 20 80 21              jsr   pushrgnptr
1802 06C8 20 9A 21              jsr   pushclip
1803 06CB A2 04 69 22           _CopyRgn 
1804 06D2              ;
1805 06D2 20 5B 07              jsr   PaintDesk                Fill the current port with desktop.
1806 06D5              ;
1807 06D5 20 80 21              jsr   pushrgnptr               Clobbered region.
1808 06D8 A2 04 6A 22           _SetEmptyRgn                   Clear clobbered region, all painted.
1809 06DF 82 75 00     toExit100 brl   exit100
1810 06E2              ;
1811 06E2              ;
1812 06E2              ; --- Draw the given window in the given region ------------------
1813 06E2              ;
1814 06E2 20 48 22     gopaintone jsr   testVis                Test the window's F_VIS flag.
1815 06E5 F0 F8                 beq   toExit100                Don't draw invisible windows
1816 06E7              ;
1817 06E7 20 80 21              jsr   pushrgnptr               Pass handle of clobbered region.
1818 06EA A0 C0 00              ldy   #wstrucRgn+2             Pass handle window's StructRgn.
1819 06ED 20 F9 21              jsr   pushandle
1820 06F0 20 9A 21              jsr   pushclip                 Pass clip region handle.
1821 06F3 A2 04 71 22           _SectRgn                       ClipRgn = clobbered and wind StructRgn
1822 06FA              ;
1823 06FA 20 17 09              jsr   testclip                 Is clip region empty?
1824 06FD D0 E0                 bne   toExit100
1825 06FF              ;
1826 06FF              ;
1827 06FF              ; ------- There is something to draw -----------------------
1828 06FF              ;
1829 06FF 20 B1 08              jsr   clipabove                Subtract windows above 'wind' from clip
1830 0702 D0 DB                 bne   toExit100                Anything left in clip region?
1831 0704              ;
1832 0704              ;
1833 0704              ; --- Draw window's frame --------------------------------------
1834 0704              ;
1835 0704 20 82 1F              jsr   drawframe
1836 0707              ;
1837 0707              ;
1838 0707              ; --- Subtract redrawn area from clobbered region ----------
1839 0707              ;
1840 0707 20 80 21              jsr   pushrgnptr               Clobbered region.
1841 070A 20 9A 21              jsr   pushclip                 Subtract redrawn region from clobbered.
1842 070D 20 80 21              jsr   pushrgnptr               Result in clobbered region.
1843 0710 A2 04 73 22           _DiffRgn                       Clobbered = clobbered - redrawn.
1844 0717              ;
1845 0717              ;
1846 0717              ; --- Compute clobbered content region ------------------
1847 0717              ;
1848 0717 A0 C4 00              ldy   #wcontRgn+2              Region 1, content region.
1849 071A 20 F9 21              jsr   pushandle
1850 071D 20 9A 21              jsr   pushclip                 Region 2, clobbered region.
1851 0720 20 9A 21              jsr   pushclip                 Result into clip.
1852 0723 A2 04 71 22           _SectRgn 
1853 072A              ;
1854 072A              ;
1855 072A              ; --- Erase content area to be redrawn -------------------------
1856 072A              ;
1857 072A 20 9A 21              jsr   pushclip                 Content part needing to be redrawn.
1858 072D A6 A8                 ldx   <wind+2                  Pass address of window's background
1859 072F A5 A6                 lda   <wind                    pattern.
1860 0731 18                    clc   
1861 0732 69 24 00              adc   #wport+GP_BkPat
1862 0735 90 01                 bcc   store100
1863 0737 E8                    inx   
1864 0738 DA           store100 phx   
1865 0739 48                    pha   
1866 073A A2 04 7D 22           _FillRgn                       Draw floor of content area.
1867 0741              ;
1868 0741              ;
1869 0741              ; --- Add clobbered content area to window's update region --------------
1870 0741              ;
1871 0741 20 9A 21              jsr   pushclip                 Clobbered part of content region.
1872 0744 A0 C8 00              ldy   #wupdateRgn+2            Current update region for window.
1873 0747 20 F9 21              jsr   pushandle
1874 074A A0 C8 00              ldy   #wupdateRgn+2            Result in window's update region.
1875 074D 20 F9 21              jsr   pushandle
1876 0750 A2 04 72 22           _UnionRgn                      Add the clobbered to the update.
1877 0757              ;
1878 0757 20 C4 08     exit100  jsr   fullport                 Set clip to full desktop.
1879 075A 60                    rts   
1880 075B              ;
1881 075B              ;
1882 075B              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
1883 075B              ;        Fill screen with desktop pattern.
1884 075B              ;110= = = = = = = = = = = = = = = = = = = = = = = = =
1885 075B              ;
1886 075B                       ENTRY PaintDesk
1887 075B              PaintDesk  
1888 075B
1889 075B                       IMPORT pushLocInfo1
1890 075B                       IMPORT pushDataAddr
1891 075B
1892 075B
1893 075B A5 94                 lda   <deskpatt+2              Get format of desktop pattern.
1894 075D 29 00 FF              and   #$FF00
1895 0760 EB                    xba   
1896 0761 C9 80 00              cmp   #$0080
1897 0764 F0 0E                 beq   readyPatt
1898 0766 C9 40 00              cmp   #$0040
1899 0769 F0 18                 beq   makePatt
1900 076B 0A                    asl   a
1901 076C AA                    tax   
1902 076D 7C 70 07              jmp   (@types,x)
1903 0770 99 07        @types   DC W:customType
1904 0772 A2 07                 DC W:messageType
1905 0774
1906 0774
1907 0774              ;
1908 0774              ; --- Pattern pointer in deskpatt.
1909 0774              ;
1910 0774 20 46 21     readyPatt jsr   pushscreen              Pass pointer to screen bounds.
1911 0777 D4 94                 pei   <deskpatt+2              Pass address of fill pattern.
1912 0779 D4 92                 pei   <deskpatt
1913 077B A2 04 57 22           _FillRect                      Draw desktop.
1914 0782 60                    rts   
1915 0783              ;
1916 0783              ;
1917 0783              ; --- Pattern number in deskpatt.
1918 0783              ;
1919 0783 20 46 21     makePatt jsr   pushscreen               Pass pointer to screen bounds.
1920 0786 A4 92                 ldy   <deskpatt                Pass pattern number to generate.
1921 0788 A5 D8                 lda   <data                    Pass pointer to global data area.
1922 078A A6 DA                 ldx   <data+2
1923 078C 20 DF 3F              jsr   makePattern              Generate pattern.
1924 078F DA                    phx                            Pass address of generated pattern
1925 0790 5A                    phy   
1926 0791 A2 04 57 22           _FillRect                      Draw desktop.
1927 0798 60                    rts   
1928 0799              ;
1929 0799              ;
1930 0799              ; --- Call outside routine to draw desktop.
1931 0799              ;
1932 0799 A6 93        customType ldx   <deskpatt+1            Address of routine to draw desktop.
1933 079B A5 92                 lda   <deskpatt
1934 079D 22 67 22 FD           jsl   longCall                 Make long distance call.
1935 07A1 60                    rts   
1936 07A2              ;
1937 07A2              ;
1938 07A2              ; --- deskpatt is a handle deskMessage that defines desktop.
1939 07A2              ;
1940 07A2 A0 04 00     messageType ldy   #4                    Lock message.
1941 07A5 B7 92                 lda   [<deskpatt],y
1942 07A7 48                    pha                            Save attributes.
1943 07A8 09 00 80              ora   #$8000
1944 07AB 97 92                 sta   [<deskpatt],y
1945 07AD              ;
1946 07AD D4 E0                 pei   <work+2                  Save.
1947 07AF D4 DE                 pei   <work
1948 07B1              ;
1949 07B1 A0 02 00              ldy   #2                       Dereference the message.
1950 07B4 B7 92                 lda   [<deskpatt],y
1951 07B6 85 E0                 sta   <work+2
1952 07B8 A7 92                 lda   [<deskpatt]
1953 07BA 85 DE                 sta   <work
1954 07BC              ;
1955 07BC A0 06 00              ldy   #messFormat              Dispatch to message format handler.
1956 07BF B7 DE                 lda   [<work],y
1957 07C1 0A                    asl   a
1958 07C2 AA                    tax   
1959 07C3 FC D3 07              jsr   (@formats,x)
1960 07C6              ;
1961 07C6 68                    pla                            Restore.
1962 07C7 85 DE                 sta   <work
1963 07C9 68                    pla   
1964 07CA 85 E0                 sta   <work+2
1965 07CC              ;
1966 07CC A0 04 00              ldy   #4                       Restore handle's attributes.
1967 07CF 68                    pla   
1968 07D0 97 92                 sta   [<deskpatt],y
1969 07D2 60                    rts   
1970 07D3              ;
1971 07D3 D7 07        @formats DC W:@pattern                  0
1972 07D5 E7 07                 DC W:@picture                  1
1973 07D7              ;
1974 07D7              ;
1975 07D7              ;----------------------------------------------------------
1976 07D7              ;                   Pattern message handler.
1977 07D7              ;----------------------------------------------------------
1978 07D7              ;
1979 07D7 20 46 21     @pattern jsr   pushscreen               Pass pointer to screen bounds.
1980 07DA 20 0B 08              jsr   @getMessInfo             Pass pattern pointer.
1981 07DD DA                    phx   
1982 07DE 48                    pha   
1983 07DF A2 04 57 22           _FillRect                      Draw desktop.
1984 07E6 60                    rts   
1985 07E7              ;
1986 07E7              ;
1987 07E7              ;----------------------------------------------------------
1988 07E7              ;                   Picture message handler.
1989 07E7              ;----------------------------------------------------------
1990 07E7              ;
1991 07E7 20 0B 08     @picture jsr   @getMessInfo             Store address of image in locInfo record.
1992 07EA A0 74 00              ldy   #LocInfo1+PixelImage
1993 07ED 97 D8                 sta   [<data],y
1994 07EF C8                    iny   
1995 07F0 C8                    iny   
1996 07F1 8A                    txa   
1997 07F2 97 D8                 sta   [<data],y
1998 07F4              ;
1999 07F4 20 5A 21              jsr   pushLocInfo1             Pass pointer to LocInfo record.
2000 07F7 A9 7A 00              lda   #LocInfo1+PBounds        Pass pointer to source RECT.
2001 07FA 20 5D 21              jsr   pushDataAddr
2002 07FD A9 00 00              lda   #0                       Common need.
2003 0800 48                    pha                            Pass destination point.
2004 0801 48                    pha   
2005 0802 48                    pha   
2006 0803 A2 04 D6 22           _PPToPort 
2007 080A 60                    rts   
2008 080B              ;
2009 080B              ;
2010 080B              ;------------------------------------------------------------------------------
2011 080B              ;                   Compute pointer to messInfo part of message.
2012 080B              ;------------------------------------------------------------------------------
2013 080B              ;
2014 080B A6 E0        @getMessInfo ldx   <work+2              Compute pointer to info part of message.
2015 080D A5 DE                 lda   <work
2016 080F 18                    clc   
2017 0810 69 08 00              adc   #messInfo
2018 0813 90 01                 bcc   @ok100
2019 0815 E8                    inx   
2020 0816 60           @ok100   rts   
2021 0817              ;
2022 0817                       ENDP 
2023 0817              ;
2024 0817              ;
2025 0817              ;==========================================================
2026 0817              ;        Compute visible region of window's content.
2027 0817              ;==========================================================
2028 0817              ;
2029 0817              ;   IN:    Nothing.
2030 0817              ;
2031 0817              ;  OUT:    Visible content computed for every window.
2032 0817              ;          'wind' preserved.
2033 0817              ;
2034 0817              calc_vis PROC 
2035 0817                       EXPORT calc_vis2
2036 0817              ;
2037 0817 A9 00 00              lda   #0                       Calc to bottom window.
2038 081A AA                    tax   
2039 081B              ;
2040 081B              ;
2041 081B              ;  IN: x/a = window to stop at, this window and below does not have its visRgn computed.
2042 081B              ;
2043 081B              stopWindow equ   1
2044 081B              ;
2045 081B D4 A6        calc_vis2 pei   <wind                   Saves.
2046 081D D4 A8                 pei   <wind+2
2047 081F              ;
2048 081F DA                    phx                            Save window to stop at.
2049 0820 48                    pha   
2050 0821              ;
2051 0821 A5 D5                 lda   <FloorRgn+1              Is there a floor region?
2052 0823 F0 0E                 beq   skip1
2053 0825              ;
2054 0825 20 87 21              jsr   pushGray                 Copy desktop region into FloorRgn.
2055 0828 D4 D6                 pei   <FloorRgn+2
2056 082A D4 D4                 pei   <FloorRgn
2057 082C A2 04 69 22           _CopyRgn 
2058 0833              ;
2059 0833              ;
2060 0833 A5 8E        skip1    lda   <topwind                 Start with the top window.
2061 0835 A4 90                 ldy   <topwind+2
2062 0837 80 59                 bra   enter1
2063 0839              ;
2064 0839 20 48 22     lop1     jsr   testVis                  Test the window's F_VIS flag.
2065 083C F0 4C                 beq   nextwind
2066 083E              ;
2067 083E              ;
2068 083E A0 C4 00              ldy   #wcontRgn+2              Pass handle of window's content.
2069 0841 20 F9 21              jsr   pushandle
2070 0844 20 9A 21              jsr   pushclip                 Pass handle of clip region.
2071 0847 A2 04 69 22           _CopyRgn                       clip = wcontRgn.
2072 084E              ;
2073 084E
2074 084E 20 B1 08              jsr   clipabove                Subtract all windows above.
2075 0851              ;
2076 0851 20 9A 21              jsr   pushclip
2077 0854 A0 0E 00              ldy   #wport+GP_Bounds+x1      Get window's port offset.
2078 0857 20 F9 21              jsr   pushWlong
2079 085A A2 04 6F 22           _OffsetRgn                     Make clip local to window.
2080 0861              ;
2081 0861 20 9A 21              jsr   pushclip                 Put visible content into visRgn.
2082 0864 A0 22 00              ldy   #wport+GP_VisRgn+2
2083 0867 20 F9 21              jsr   pushandle
2084 086A A2 04 69 22           _CopyRgn 
2085 0871              ;
2086 0871              ;
2087 0871 A5 D5                 lda   <FloorRgn+1              Is there a Floor region?
2088 0873 F0 15                 beq   nextwind
2089 0875              ;
2090 0875 D4 D6                 pei   <FloorRgn+2              From the Floor region,
2091 0877 D4 D4                 pei   <FloorRgn
2092 0879 A0 C0 00              ldy   #wstrucRgn+2             subtract the window's entire region,
2093 087C 20 F9 21              jsr   pushandle
2094 087F D4 D6                 pei   <FloorRgn+2              and place the answer back in the Floor.
2095 0881 D4 D4                 pei   <FloorRgn
2096 0883 A2 04 73 22           _DiffRgn 
2097 088A              ;
2098 088A              ;
2099 088A              ;
2100 088A A0 02 00     nextwind ldy   #2                       Next window.
2101 088D B7 A6                 lda   [<wind],y
2102 088F A8                    tay   
2103 0890 A7 A6                 lda   [<wind]
2104 0892              ;
2105 0892 85 A6        enter1   sta   <wind
2106 0894 84 A8                 sty   <wind+2
2107 0896              ;
2108 0896 C3 01                 cmp   stopWindow,s             Stop at this window?
2109 0898 D0 9F                 bne   lop1
2110 089A 98                    tya   
2111 089B C3 03                 cmp   stopWindow+2,s
2112 089D D0 9A                 bne   lop1
2113 089F              ;
2114 089F              ;
2115 089F 20 C4 08              jsr   fullport                 Reset Window Manager's clip.
2116 08A2              ;
2117 08A2 68                    pla                            Get rid of window to stop at.
2118 08A3 68                    pla   
2119 08A4              ;
2120 08A4 68                    pla                            Restores.
2121 08A5 85 A8                 sta   <wind+2
2122 08A7 68                    pla   
2123 08A8 85 A6                 sta   <wind
2124 08AA 60                    rts   
2125 08AB                       ENDP 
2126 08AB              ;
2127 08AB              ;
2128 08AB              ;==================================================
2129 08AB              ;        Remove any thing that doesn't
2130 08AB              ;        belong to 'wind from clip region.
2131 08AB              ;==================================================
2132 08AB              ;
2133 08AB              ;   IN:  wind = window to start with.
2134 08AB              ;
2135 08AB              ;  OUT:  clip = intersection of clip region and desktop,
2136 08AB              ;                      less windows above.
2137 08AB              ;        Equal = FALSE if 'rgnptr' region is NIL.
2138 08AB              ;
2139 08AB              clipgabove PROC 
2140 08AB              ;
2141 08AB                                                      ;using equates
2142 08AB              ;
2143 08AB              ;
2144 08AB 20 C4 08              jsr   fullport                 Set port to GrayRgn.
2145 08AE 82 21 00              brl   SubStructLoop
2146 08B1              ;
2147 08B1                       ENTRY clipabove
2148 08B1              clipabove                               ; 
2149 08B1              ;
2150 08B1 20 87 21              jsr   pushGray                 Pass handle to desktop, source 1.
2151 08B4 20 9A 21              jsr   pushclip                 Pass handle of clip region, source 2.
2152 08B7 20 9A 21              jsr   pushclip                 Pass handle of region for result.
2153 08BA A2 04 71 22           _SectRgn                       Intersection of clip and desktop.
2154 08C1              ;
2155 08C1 82 0E 00              brl   SubStructLoop            Subtract all windows above and exit.
2156 08C4                       ENDP 
2157 08C4              ;
2158 08C4              ;
2159 08C4              ;======================================
2160 08C4              ;        Set current port (wmgr)
2161 08C4              ;        to GrayRgn (desktop).
2162 08C4              ;=======================================
2163 08C4              ;
2164 08C4              fullport PROC 
2165 08C4              ;
2166 08C4 20 87 21              jsr   pushGray                 Clip to whole desktop.
2167 08C7 20 9A 21              jsr   pushclip
2168 08CA A2 04 69 22           _CopyRgn 
2169 08D1 60                    rts   
2170 08D2                       ENDP 
2171 08D2              ;
2172 08D2              ;
2173 08D2              ;================================================
2174 08D2              ;        Subtract all windows above 'wind'
2175 08D2              ;        from clip region.
2176 08D2              ;================================================
2177 08D2              ;
2178 08D2              ;   IN:  wind = window to start with.
2179 08D2              ;        clip = region to subtract from.
2180 08D2              ;
2181 08D2              ;  OUT:  clip = clip region less windows above 'wind'.
2182 08D2              ;        Equal = FALSE if 'rgnptr' is NIL.
2183 08D2              ;
2184 08D2              SubStructLoop PROC 
2185 08D2              ;
2186 08D2                                                      ;using equates
2187 08D2              ;
2188 08D2              ;
2189 08D2 A5 8E                 lda   <topwind                 Start subtracting from top window.
2190 08D4 A6 90                 ldx   <topwind+2
2191 08D6 80 2A                 bra   enter1
2192 08D8              ;
2193 08D8 A0 D2 00     lop1     ldy   #wframe                  Is this window visible.
2194 08DB B7 DE                 lda   [<work],y
2195 08DD 29 20 00              and   #F_VIS
2196 08E0 F0 18                 beq   nextwind                 Don't subtract invisible windows.
2197 08E2              ;
2198 08E2 20 9A 21              jsr   pushclip                 Pass region handle, source 1.
2199 08E5 A0 C0 00              ldy   #wstrucRgn+2
2200 08E8 B7 DE                 lda   [<work],y
2201 08EA 48                    pha   
2202 08EB 88                    dey   
2203 08EC 88                    dey   
2204 08ED B7 DE                 lda   [<work],y
2205 08EF 48                    pha                            Pass window's StructRgn, source 2.
2206 08F0 20 9A 21              jsr   pushclip                 Region handle, destination.
2207 08F3 A2 04 73 22           _DiffRgn                       Find the difference.
2208 08FA              ;
2209 08FA              ;
2210 08FA A0 02 00     nextwind ldy   #2                       Get pointer to next window.
2211 08FD B7 DE                 lda   [<work],y
2212 08FF AA                    tax   
2213 0900 A7 DE                 lda   [<work]
2214 0902 85 DE        enter1   sta   <work
2215 0904 86 E0                 stx   <work+2
2216 0906              ;
2217 0906 C5 A6                 cmp   <wind                    Have we reached the given window?
2218 0908 D0 CE                 bne   lop1
2219 090A E4 A8                 cpx   <wind+2
2220 090C D0 CA                 bne   lop1
2221 090E              ;
2222 090E 82 06 00     exit     brl   testclip                 Set flag to empty or not and return.
2223 0911                       ENDP 
2224 0911              ;
2225 0911              ;
2226 0911              ;==================================================
2227 0911              ;        Test if region in 'rgnptr' is NIL.
2228 0911              ;==================================================
2229 0911              ;
2230 0911              ;   IN:  rgnptr = handle of region to check.
2231 0911              ;
2232 0911              ;  OUT:  Equal is FALSE (a=nonzero) if 'rgnptr' is empty.
2233 0911              ;
2234 0911              testrgnptr PROC 
2235 0911              ;
2236 0911                                                      ;using equates
2237 0911              ;
2238 0911              ;
2239 0911 48                    pha                            Space for returned value.
2240 0912 20 80 21              jsr   pushrgnptr               Pass handle in 'rgnptr'.
2241 0915 80 04                 bra   testrgn
2242 0917              ;
2243 0917              ;
2244 0917              ; = = = = = = = = = = = = = = = = = = = = = = = =
2245 0917              ;        Test if clip region is empty.
2246 0917              ;100= = = = = = = = = = = = = = = = = = = = = = =
2247 0917              ;
2248 0917              ;   IN:  Clip region to check is current port.
2249 0917              ;
2250 0917              ;  OUT:  Equal is FALSE (a=nonzero) if clip region is empty.
2251 0917              ;
2252 0917                       ENTRY testclip
2253 0917              testclip                                ; 
2254 0917              ;
2255 0917 48                    pha                            Space for returned value.
2256 0918 20 9A 21              jsr   pushclip                 Pass handle of clip region.
2257 091B              ;
2258 091B A2 04 78 22  testrgn  _EmptyRgn                      Is the region empty?
2259 0922 68                    pla                            Set return flag.
2260 0923 60                    rts   
2261 0924              ;
2262 0924                       ENDP 
2263 0924              ;
2264 0924              ;
2265 0924              ;============================
2266 0924              ;        Edit Desktop
2267 0924              ;============================
2268 0924              ;
2269 0924              ;   IN:  PUSH:WORD - operation number:
2270 0924              ;                                     0 = subtract region from desktop.
2271 0924              ;                                     1 = add region to desktop.
2272 0924              ;                                     2 = return handle of desktop region.
2273 0924              ;                                     3 = set handle of desktop region.
2274 0924              ;                                     4 = return desktop pattern.
2275 0924              ;                                     5 = set new desktop pattern.
2276 0924              ;                                     6 = return visible desktop.
2277 0924              ;                                     7 = install background region.
2278 0924              ;                                     8 = check for new desktop pattern in message center.
2279 0924              ;        PUSH:LONG - input parameter.
2280 0924              ;
2281 0924              ;  OUT:  LONG - output parameter.
2282 0924              ;
2283 0924              Desktop  PROC 
2284 0924              ;
2285 0924                       IMPORT allocate3
2286 0924              ;
2287 0924              in_param equ   9
2288 0924              operation equ   in_param+4
2289 0924              out_param equ   operation+2
2290 0924              ;
2291 0924              ;
2292 0924 AA                    tax   
2293 0925 D0 05                 bne   @Continue
2294 0927 A9 02 00              lda   #2
2295 092A 38                    sec   
2296 092B 6B                    rtl   
2297 092C              @Continue  
2298 092C              ;
2299 092C 22 64 00 E1           jsl   IncBusyFlg
2300 0930              ;
2301 0930 0B                    phd                            Save orginal zero page.
2302 0931 5B                    tcd                            Switch to my zero page.
2303 0932              ;
2304 0932 A3 0D                 lda   operation,s
2305 0934 0A                    asl   a
2306 0935 AA                    tax   
2307 0936 BF 41 09 FD           lda   >op_table,x
2308 093A 48                    pha   
2309 093B A3 0D                 lda   in_param+4,s
2310 093D AA                    tax   
2311 093E A3 0B                 lda   in_param+2,s
2312 0940 60                    rts                            Go to operation.
2313 0941              ;
2314 0941 94 09        op_table DC W:FromDesk-1                0
2315 0943 94 09                 DC W:ToDesk-1                  1
2316 0945 B8 09                 DC W:GetDesktop-1              2
2317 0947 B1 09                 DC W:SetDesktop-1              3
2318 0949 F6 09                 DC W:GetDeskPat-1              4
2319 094B BE 09                 DC W:SetDeskPat-1              5
2320 094D C4 09                 DC W:VisDesktop-1              6
2321 094F 8E 09                 DC W:BackRegion-1              7
2322 0951 52 09                 DC W:desktopMessage-1          8
2323 0953              ;
2324 0953              ;
2325 0953              ; --- Check for new desktop pattern message.
2326 0953              ;
2327 0953              GetMessage equ   2                      Message command.
2328 0953              DeskMessage equ   2                     Message type.
2329 0953              ;
2330 0953 A9 18 00     desktopMessage lda   #24                Number of bytes to allocate.
2331 0956 A2 00 00              ldx   #0                       Handle attributes.
2332 0959 A4 DC                 ldy   <MyID
2333 095B 20 82 8F              jsr   allocate3
2334 095E 85 DE                 sta   <work                    Save handle.
2335 0960 86 E0                 stx   <work+2
2336 0962              ;
2337 0962 F4 02 00              pea   GetMessage               Pass action value.
2338 0965 F4 02 00              pea   DeskMessage              Pass type of message.
2339 0968 DA                    phx                            Pass handle to MessageCenter.
2340 0969 48                    pha   
2341 096A A2 01 15 22           _MessageCenter                 Parameters on stack.
2342 0971 90 0E                 bcc   @ok1                     Was a pattern message found?
2343 0973              ;
2344 0973 D4 E0                 pei   <work+2
2345 0975 D4 DE                 pei   <work
2346 0977 A2 02 10 22           _DisposeHandle                 Handle not used or needed.
2347 097E 82 7F 00              brl   exit2
2348 0981              ;
2349 0981              @ok1      
2350 0981 A5 DE                 lda   <work                    Set handle of desktop image.
2351 0983 85 92                 sta   <deskpatt
2352 0985 A5 E0                 lda   <work+2
2353 0987 09 00 01              ora   #$0100                   Set flag that tell format of data in deskpatt.
2354 098A 85 94                 sta   <deskpatt+2
2355 098C 82 71 00              brl   exit2
2356 098F              ;
2357 098F              ;
2358 098F              ; --- Install a background region --------------------------------
2359 098F              ;
2360 098F 85 D4        BackRegion sta   <FloorRgn
2361 0991 86 D6                 stx   <FloorRgn+2
2362 0993 80 6B                 bra   exit2
2363 0995              ;
2364 0995              ;
2365 0995              ; --- Add/Subtract region from the desktop ------------------------
2366 0995              ;
2367 0995              ToDesk                                  ; 
2368 0995 D4 C2        FromDesk pei   <GrayRgn+2               Pass handle to current desktop region.
2369 0997 D4 C0                 pei   <GrayRgn
2370 0999 DA                    phx                            Pass handle of given region.
2371 099A 48                    pha   
2372 099B D4 C2                 pei   <GrayRgn+2               Put result in desktop region.
2373 099D D4 C0                 pei   <GrayRgn
2374 099F              ;
2375 099F A2 04 72              ldx   #UnionRgn
2376 09A2 A3 19                 lda   operation+12,s           Union of Diff call?
2377 09A4 D0 03                 bne   ok1
2378 09A6 A2 04 73              ldx   #DiffRgn
2379 09A9 22 00 00 E1  ok1      jsl   $E10000                  Execute _UnionRgn or _DiffRgn.
2380 09AD              ;
2381 09AD 20 17 08              jsr   calc_vis                 Recompute visRgns for every window.
2382 09B0 80 4E                 bra   exit2
2383 09B2              ;
2384 09B2              ;
2385 09B2              ;
2386 09B2              ; --- Set new handle to desktop region ------------------------
2387 09B2              ;
2388 09B2 85 C0        SetDesktop sta   <GrayRgn
2389 09B4 86 C2                 stx   <GrayRgn+2
2390 09B6              ;
2391 09B6 20 17 08              jsr   calc_vis                 Recompute visRgns for every window.
2392 09B9              ;
2393 09B9              ;
2394 09B9              ; --- Return handle of desktop region -------------------------
2395 09B9              ;
2396 09B9 A5 C0        GetDesktop lda   <GrayRgn
2397 09BB A6 C2                 ldx   <GrayRgn+2
2398 09BD 80 3C                 bra   exit
2399 09BF              ;
2400 09BF              ;
2401 09BF              ; --- Install new desktop pattern -----------------------------
2402 09BF              ;
2403 09BF              SetDeskPat  
2404 09BF 85 92                 sta   <deskpatt
2405 09C1 86 94                 stx   <deskpatt+2
2406 09C3 80 04                 bra   skip1                    Paint new desktop.
2407 09C5              ;
2408 09C5              ;
2409 09C5              ; ------ Return visible desktop ----------------------------------
2410 09C5              ;
2411 09C5 85 B8        VisDesktop sta   <rgnptr                Save given region.
2412 09C7 86 BA                 stx   <rgnptr+2
2413 09C9              ;
2414 09C9              ;
2415 09C9              ; ------ Paint new desktop ---------------------------------------
2416 09C9              ;
2417 09C9 20 3A 20     skip1    jsr   setwmgrport              Switch to Window Manager's port.
2418 09CC 20 C4 08              jsr   fullport                 Make sure port's clip is entire desktop.
2419 09CF              ;
2420 09CF 64 A6                 stz   <wind                    Subtract all windows from clip.
2421 09D1 64 A8                 stz   <wind+2
2422 09D3 20 D2 08              jsr   SubStructLoop
2423 09D6              ;
2424 09D6 A3 0D                 lda   operation,s
2425 09D8 C9 06 00              cmp   #6
2426 09DB D0 0F                 bne   skip2
2427 09DD              ;
2428 09DD 20 9A 21              jsr   pushclip                 Copy visible desktop
2429 09E0 20 80 21              jsr   pushrgnptr               into given region.
2430 09E3 A2 04 69 22           _CopyRgn 
2431 09EA 80 03                 bra   skip3
2432 09EC              ;
2433 09EC 20 5B 07     skip2    jsr   PaintDesk                Paint just the desktop.
2434 09EF 20 C4 08     skip3    jsr   fullport                 Leave with Window Manager's port full.
2435 09F2              ;
2436 09F2 20 60 20              jsr   restore_port
2437 09F5 80 09                 bra   exit2
2438 09F7              ;
2439 09F7              ;
2440 09F7              ; --- Return desktop pattern ----------------------------------
2441 09F7              ;
2442 09F7 A5 92        GetDeskPat lda   <deskpatt
2443 09F9 A6 94                 ldx   <deskpatt+2
2444 09FB              ;
2445 09FB 83 0F        exit     sta   out_param,s
2446 09FD 8A                    txa   
2447 09FE 83 11                 sta   out_param+2,s
2448 0A00              ;
2449 0A00 8B           exit2    phb   
2450 0A01 82 B7 85              brl   pop6bytes
2451 0A04                       ENDP 
2452 0A04              ;
2453 0A04
2454 0A04              *******************************************************************************
2455 0A04              *
2456 0A04                       Export FakeReadMouse
2457 0A04              FakeReadMouse PROC 
2458 0A04              *
2459 0A04              * Description:      This routine can be used as a direct replacement for the
2460 0A04              *                   ReadMouse misc tools call.  Its inputs and outputs are
2461 0A04              *                   identical in every way to the real read mouse. The main 
2462 0A04              *                   difference is that this readmouse calls eventavail instead
2463 0A04              *                   of going directly to the mouse. This allows journalling to
2464 0A04              *                   take place.
2465 0A04              *
2466 0A04              *                   NOTE: This call Clears all bits of the mode byte.
2467 0A04              *
2468 0A04              *
2469 0A04              * Inputs:           Space               - Word
2470 0A04              *                   Space               - Word
2471 0A04              *                   Space               - Word
2472 0A04              *                   ReturnAddr
2473 0A04              *
2474 0A04              * Outputs:          CurrentX (Word)     - Y position in global coordinants
2475 0A04              *                   CurrentY (Word)     - X position in global coordinants
2476 0A04              *                   ButtonState (word)  - status of the buttons. (Mode clear)
2477 0A04              *
2478 0A04              * External Refs:
2479 0A04              *
2480 0A04              * Entry Points:
2481 0A04              *
2482 0A04              *******************************************************************************
2483 0A04              *
2484 0A04              * First define a stack frame for our use
2485 0A04              @tempEvent equ   1
2486 0A04              @xevent  equ   @tempEvent+16
2487 0A04              @SaveDPage equ   @xEvent+2
2488 0A04              @ReturnAddr equ   @SaveDPage+2
2489 0A04              @ButtonState equ   @ReturnAddr+3
2490 0A04              @CurrentY equ   @ButtonState+2
2491 0A04              @CurrentX equ   @CurrentY+2
2492 0A04
2493 0A04              ;
2494 0A04 0B                    phd                            Save current direct page.
2495 0A05              ;
2496 0A05 3B                    tsc                            Make room for event record.
2497 0A06 38                    sec                            on the stack
2498 0A07 E9 12 00              sbc   #@xevent+1
2499 0A0A 1B                    tcs   
2500 0A0B 5B                    tcd   
2501 0A0C              ;
2502 0A0C 48                    pha                            Space for returned flag.
2503 0A0D F4 00 00              pea   0                        Looking for NULL event only.
2504 0A10 F4 00 00              pea   0                        Pass pointer to event record.
2505 0A13 1A                    inc   a                        NOTE: <A> still holds the direct
2506 0A14 48                    pha                            page pointer at this point.
2507 0A15 A2 06 0B 22           _EventAvail 
2508 0A1C FA                    plx                            Get returned flag and ignore it.
2509 0A1D
2510 0A1D A5 0B                 lda   <@tempEvent+10           get the mouse coordinants
2511 0A1F 85 1A                 sta   <@CurrentY
2512 0A21 A5 0D                 lda   <@tempEvent+12
2513 0A23 85 1C                 sta   <@CurrentX
2514 0A25
2515 0A25 A5 0F                 lda   <@tempEvent+14           get the button states
2516 0A27 29 C0 00              and   #$00C0                   strip off just the button status
2517 0A2A 49 C0 00              eor   #$00C0
2518 0A2D EB                    xba                            put it in the high byte
2519 0A2E 85 18                 sta   <@ButtonState
2520 0A30
2521 0A30 3B                    tsc                            Remove the bogus event record 
2522 0A31 18                    clc                            on the stack
2523 0A32 69 12 00              adc   #@xevent+1
2524 0A35 1B                    tcs   
2525 0A36 2B                    pld   
2526 0A37 6B                    rtl   
2527 0A38                       EndP 
2528 0A38
2529 0A38
2530 0A38              ;
2531 0A38              ;===============================================
2532 0A38              ;        Drag a Window to a New Position.
2533 0A38              ;===============================================
2534 0A38              ;
2535 0A38              ;   IN:    PUSH:WORD - drag flag:
2536 0A38              ;                         bit 15:    1 = bring window to top after drag.
2537 0A38              ;                         bits 8-14: reserved (zero).
2538 0A38              ;                         bits 0-7:  horizontal movement resolution:
2539 0A38              ;                                          0 = default grid:
2540 0A38              ;                                                    4 pixels in 320 mode.
2541 0A38              ;                                                    8 pixels in 640 mode.
2542 0A38              ;                                          1 = every pixel.
2543 0A38              ;                                          2 = every 2 pixels.
2544 0A38              ;                                          4 = every 4 pixels.
2545 0A38              ;                                          8 = every 8 pixels.
2546 0A38              ;                                         16 = every 16 pixels.
2547 0A38              ;                                         32 = every 32 pixels.
2548 0A38              ;                                         64 = every 64 pixels.
2549 0A38              ;                                        128 = every 128 pixels.
2550 0A38              ;          PUSH:LONG - starting y,x point in global coordinates.
2551 0A38              ;          PUSH:WORD - grace buffer.
2552 0A38              ;          PUSH:LONG - pointer to bounds RECT.
2553 0A38              ;          PUSH:LONG - pointer to window's port.
2554 0A38              ;
2555 0A38              ;  OUT:    None.
2556 0A38              ;
2557 0A38              DragWindow PROC 
2558 0A38              ;
2559 0A38              ;
2560 0A38              theWind  equ   9
2561 0A38              bounds   equ   theWind+4
2562 0A38              grace    equ   bounds+4
2563 0A38              ystart   equ   grace+2
2564 0A38              xstart   equ   ystart+2
2565 0A38              dragFlag equ   xstart+2
2566 0A38              ;
2567 0A38              ;
2568 0A38 20 CA 21              jsr   setup                    Get parameters.
2569 0A3B              ;
2570 0A3B              ;
2571 0A3B              ; --- Set default grid -------------------------------------------
2572 0A3B              ;
2573 0A3B A3 17                 lda   dragFlag,s
2574 0A3D 29 FF 00              and   #$00FF
2575 0A40 D0 12                 bne   skip1
2576 0A42              ;
2577 0A42 A2 08 00              ldx   #8                       640 grid
2578 0A45 A0 61 00              ldy   #scInfo-1
2579 0A48 B7 D8                 lda   [<data],y                Get current mode.
2580 0A4A 30 03                 bmi   ok2
2581 0A4C A2 04 00              ldx   #4                       320 grid.
2582 0A4F 8A           ok2      txa   
2583 0A50 03 17                 ora   dragFlag,s
2584 0A52 83 17                 sta   dragFlag,s
2585 0A54              ;
2586 0A54              ;
2587 0A54              ; --- Set default drag bounds RECT ------------------------------
2588 0A54              ;
2589 0A54 A3 0D        skip1    lda   bounds,s                 Did the caller give a bounds RECT?
2590 0A56 03 0F                 ora   bounds+2,s
2591 0A58 D0 1F                 bne   ok3
2592 0A5A              ;
2593 0A5A 20 15 22              jsr   deskBounds               wrect = GrayRgn bounds.
2594 0A5D              ;
2595 0A5D 20 70 21              jsr   pushwrect                Pass pointer to 'wrect'.
2596 0A60 A3 1B                 lda   dragFlag+4,s
2597 0A62 29 FF 00              and   #$00FF
2598 0A65 48                    pha   
2599 0A66 F4 04 00              pea   4                        Vertical.
2600 0A69 A2 04 4C 22           _InsetRect                     Make bounds smaller than desktop.
2601 0A70              ;
2602 0A70 7B                    tdc                            Set address of default bounds RECT.
2603 0A71 18                    clc   
2604 0A72 69 9E 00              adc   #wrect
2605 0A75 85 AE                 sta   <workptr                 Store pointer to default bounds RECT.
2606 0A77 64 B0                 stz   <workptr+2
2607 0A79              ;
2608 0A79              ;
2609 0A79              ; --- Set drag bounds -----------------------------------
2610 0A79              ;
2611 0A79 A3 13        ok3      lda   ystart,s
2612 0A7B 85 B4                 sta   <yrat
2613 0A7D A3 15                 lda   xstart,s
2614 0A7F 85 B6                 sta   <xrat
2615 0A81              ;
2616 0A81 A0 06 00              ldy   #x2
2617 0A84 B7 AE        lop1     lda   [<workptr],y             Clone bounds RECT.
2618 0A86              ;
2619 0A86 48                    pha                            Save A.
2620 0A87 BB                    tyx                            Save Y.
2621 0A88 8A                    txa                            Compute index into data area.
2622 0A89 18                    clc   
2623 0A8A 69 8A 00              adc   #slop_bound
2624 0A8D A8                    tay   
2625 0A8E 68                    pla   
2626 0A8F 97 D8                 sta   [<data],y
2627 0A91 9B                    txy                            Restore Y.
2628 0A92              ;
2629 0A92 8A                    txa                            Compute min and max deltas.
2630 0A93 29 03 00              and   #3
2631 0A96 AA                    tax   
2632 0A97 B7 AE                 lda   [<workptr],y
2633 0A99 38                    sec   
2634 0A9A F5 B4                 sbc   <yrat,x
2635 0A9C              ;
2636 0A9C 48                    pha                            Save A.
2637 0A9D BB                    tyx                            Save Y.
2638 0A9E 8A                    txa                            Compute index into data area.
2639 0A9F 18                    clc   
2640 0AA0 69 82 00              adc   #drag_bound
2641 0AA3 A8                    tay   
2642 0AA4 68                    pla   
2643 0AA5 97 D8                 sta   [<data],y
2644 0AA7 9B                    txy                            Restore Y.
2645 0AA8              ;
2646 0AA8 88                    dey   
2647 0AA9 88                    dey   
2648 0AAA 10 D8                 bpl   lop1
2649 0AAC              ;
2650 0AAC              ;
2651 0AAC 20 3C 21              jsr   pushslop_bound           Pass address of slop_bound.
2652 0AAF A3 15                 lda   grace+4,s
2653 0AB1 49 FF FF              eor   #$FFFF
2654 0AB4 1A                    inc   a
2655 0AB5 48                    pha   
2656 0AB6 48                    pha   
2657 0AB7 A2 04 4C 22           _InsetRect                     Expand bounds for grace buffer.
2658 0ABE              ;
2659 0ABE              ;
2660 0ABE 20 1B 22              jsr   getwgrect                Get window's global coordinates.
2661 0AC1              ;
2662 0AC1 20 3A 20              jsr   setwmgrport              Switch to Window Manager's port.
2663 0AC4 20 C4 08              jsr   fullport                 Set clip to GrayRgn.
2664 0AC7              ;
2665 0AC7 A3 17                 lda   dragFlag,s               Special case, window will be top.
2666 0AC9 30 03                 bmi   ok4
2667 0ACB 20 D2 08              jsr   SubStructLoop            Can't drag over windows on top.
2668 0ACE              ;
2669 0ACE A3 17        ok4      lda   dragFlag,s               Pass grid resolution.
2670 0AD0 29 FF 00              and   #$00FF
2671 0AD3 EB                    xba   
2672 0AD4 09 10 00              ora   #$0010                   Min and max deltas in limit RECT.
2673 0AD7 85 DE                 sta   <work
2674 0AD9              ;
2675 0AD9 A2 05 00              ldx   #wGetDrag                Get address of outline draw routine.
2676 0ADC 20 19 20              jsr   dispatch
2677 0ADF 85 E0                 sta   <work+2
2678 0AE1 86 E2                 stx   <work+4
2679 0AE3 05 E2                 ora   <work+4                  Is there a custom draw routine?
2680 0AE5 F0 07                 beq   ok5
2681 0AE7              ;
2682 0AE7 A5 DE                 lda   <work                    Set 'custom draw routine' flag.
2683 0AE9 09 08 00              ora   #$0008
2684 0AEC 85 DE                 sta   <work
2685 0AEE              ;
2686 0AEE 20 8E 0B     ok5      jsr   callDrag                 Let user reposition the window.
2687 0AF1              ;
2688 0AF1 83 13                 sta   ystart,s                 Save deltay.
2689 0AF3 8A                    txa   
2690 0AF4 83 15                 sta   xstart,s                 Save deltax.
2691 0AF6              ;
2692 0AF6              ;
2693 0AF6              ; --- Move window to new position --------------------------
2694 0AF6              ;
2695 0AF6 20 04 22              jsr   get_portptr              Get pointer to window's port,
2696 0AF9 DA                    phx                            Pass window to SelectWindow.
2697 0AFA 48                    pha   
2698 0AFB              ;
2699 0AFB A3 15                 lda   xstart,s                 ;added 3/2/89 by DDG to special case
2700 0AFD 03 13                 ora   ystart,s                 ;..moving by zero
2701 0AFF F0 26                 beq   skipMove
2702 0B01
2703 0B01 A0 0E 00              ldy   #wport+GP_Bounds+x1      Compute new content position.
2704 0B04 B7 A6                 lda   [<wind],y
2705 0B06 38                    sec   
2706 0B07 E3 19                 sbc   xstart+4,s
2707 0B09 49 FF FF              eor   #$FFFF
2708 0B0C 1A                    inc   a
2709 0B0D 48                    pha                            Pass new x position.
2710 0B0E 88                    dey   
2711 0B0F 88                    dey   
2712 0B10 B7 A6                 lda   [<wind],y
2713 0B12 38                    sec   
2714 0B13 E3 19                 sbc   ystart+6,s
2715 0B15 49 FF FF              eor   #$FFFF
2716 0B18 1A                    inc   a
2717 0B19 48                    pha                            Pass new y position.
2718 0B1A A3 07                 lda   7,s                      Pass window pointer.
2719 0B1C 48                    pha   
2720 0B1D A3 07                 lda   7,s
2721 0B1F 48                    pha   
2722 0B20 A2 0E 19 22           _MoveWindow 
2723 0B27              skipMove  
2724 0B27 FA                    plx   
2725 0B28 7A                    ply   
2726 0B29 A3 17                 lda   dragFlag,s               Should window be brought foreward?
2727 0B2B 10 09                 bpl   done
2728 0B2D              ;
2729 0B2D 5A                    phy   
2730 0B2E DA                    phx   
2731 0B2F A2 0E 11 22           _SelectWindow 
2732 0B36              ;
2733 0B36 20 60 20     done     jsr   restore_port             Restore original port.
2734 0B39 20 C4 08              jsr   fullport                 !!!!! Set clip to GrayRgn.
2735 0B3C              ;
2736 0B3C 8B                    phb   
2737 0B3D 82 A3 84              brl   pop16bytes
2738 0B40              ;
2739 0B40              ;
2740 0B40              ; = = = = = = = = = = = = = = = = = = = = = = = =
2741 0B40              ;        Check if button is stil down.
2742 0B40              ;150= = = = = = = = = = = = = = = = = = = = = = =
2743 0B40              ;
2744 0B40              ;  OUT:    X = FALSE if button still down, TRUE if up.
2745 0B40              ;          Y = Y position of mouse in local.
2746 0B40              ;          A = X position of mouse in local.
2747 0B40              ;
2748 0B40              tempEvent equ   1
2749 0B40              xevent   equ   tempEvent+16
2750 0B40              ;
2751 0B40                       ENTRY ckbutton
2752 0B40              ckbutton                                ; 
2753 0B40              ;
2754 0B40 0B                    phd                            Save current direct page.
2755 0B41              ;
2756 0B41 3B                    tsc                            Make room for event record.
2757 0B42 38                    sec   
2758 0B43 E9 12 00              sbc   #xevent+1
2759 0B46 1B                    tcs   
2760 0B47 5B                    tcd   
2761 0B48              ;
2762 0B48 48                    pha                            Space for returned flag.
2763 0B49 F4 04 00              pea   4                        Looking for button up event only.
2764 0B4C F4 00 00              pea   0                        Pass pointer to event record.
2765 0B4F 1A                    inc   a
2766 0B50 48                    pha   
2767 0B51 A2 06 0A 22           _GetNextEvent 
2768 0B58 FA                    plx                            Get returned flag.
2769 0B59 D0 06                 bne   exit150                  Was there an up event?
2770 0B5B              ;
2771 0B5B              ;
2772 0B5B              ; --- Button has not come up yet, but double check ----------------------
2773 0B5B              ; --- This makes sure that if mouse was already up when got in here
2774 0B5B              ; --- that we don't stay here for-ever.
2775 0B5B              ;
2776 0B5B              ; Changed by mensch and glass 9 apr 89
2777 0B5B              ;
2778 0B5B A5 0F                 lda   <tempEvent+modif
2779 0B5D 29 80 00              and   #Btn0State
2780 0B60 AA                    tax   
2781 0B61
2782 0B61              ;
2783 0B61              ;
2784 0B61              ; --- Button up event, use position of event -------------------------------
2785 0B61              ;
2786 0B61 DA           exit150  phx                            Save return flag.
2787 0B62              ;
2788 0B62 A9 0B 00              lda   #tempEvent+where+y1
2789 0B65 20 64 8F              jsr   pushDpage
2790 0B68 A2 04 85 22           _GlobalToLocal                 Convert position to local.
2791 0B6F              ;
2792 0B6F FA                    plx                            Restore return flag.
2793 0B70              ;
2794 0B70 A5 0D                 lda   <tempEvent+where+x1
2795 0B72 85 11                 sta   <xevent
2796 0B74 A4 0B                 ldy   <tempEvent+where+y1
2797 0B76              ;
2798 0B76 3B                    tsc   
2799 0B77 18                    clc   
2800 0B78 69 10 00              adc   #xevent-1
2801 0B7B 1B                    tcs   
2802 0B7C 68                    pla                            Get xevent.
2803 0B7D              ;
2804 0B7D 2B                    pld                            Restore original direct page.
2805 0B7E              ;
2806 0B7E DA                    phx   
2807 0B7F FA                    plx                            Return TRUE if button up event.
2808 0B80 60                    rts   
2809 0B81              ;
2810 0B81              ;
2811 0B81              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
2812 0B81              ;          Check two number's delta.
2813 0B81              ;110= = = = = = = = = = = = = = = = = = = = = = = = =
2814 0B81              ;
2815 0B81              ;   IN:    a = one number.
2816 0B81              ;          x = the other number.
2817 0B81              ;
2818 0B81              ;  OUT:    Carry is set if the two number differ by 5 (plus or minus 2).
2819 0B81              ;
2820 0B81 86 DE        ck_move  stx   <work
2821 0B83 E5 DE                 sbc   <work
2822 0B85 10 03                 bpl   ok110
2823 0B87 49 FF FF              eor   #$FFFF
2824 0B8A C9 05 00     ok110    cmp   #5
2825 0B8D 60                    rts   
2826 0B8E              ;
2827 0B8E                       ENDP 
2828 0B8E              ;
2829 0B8E              ;
2830 0B8E              ;=====================================
2831 0B8E              ;        Drag a xor rectangle.
2832 0B8E              ;=====================================
2833 0B8E              ;
2834 0B8E              ;   IN:    wrect = starting position of rectangle, in global.
2835 0B8E              ;          yrat = cursor's starting y position.
2836 0B8E              ;          xrat = cursor's starting x position.
2837 0B8E              ;          work = grid and drag flag.
2838 0B8E              ;          work+2 = action proc or custom draw routine.
2839 0B8E              ;          drag_bound = bounds RECT.
2840 0B8E              ;          slop_bound = grace bounds RECT.
2841 0B8E              ;
2842 0B8E              ;  OUT:    a = deltay.
2843 0B8E              ;          x = deltax.
2844 0B8E              ;
2845 0B8E              callDrag PROC 
2846 0B8E              ;
2847 0B8E                                                      ;using equates
2848 0B8E                                                      ;using staticRAM
2849 0B8E              ;
2850 0B8E              ;
2851 0B8E 48                    pha                            Space for result.
2852 0B8F 48                    pha   
2853 0B90 D4 E2                 pei   <work+4                  Pass address of action proc or draw.
2854 0B92 D4 E0                 pei   <work+2
2855 0B94 F4 FD 00              pea   colorWhite>>16           Drag pattern.
2856 0B97 F4 D6 42              pea   colorWhite
2857 0B9A D4 B6                 pei   <xrat                    Starting position.
2858 0B9C D4 B4                 pei   <yrat
2859 0B9E 20 70 21              jsr   pushwrect                RECT to drag.
2860 0BA1 20 32 21              jsr   pushdrag_bound           Pass pointer to limit RECT.
2861 0BA4 20 3C 21              jsr   pushslop_bound           Pass pointer to slop RECT.
2862 0BA7 D4 DE                 pei   <work                    Drag flag.
2863 0BA9 A2 0E 53 22           _WindDragRect 
2864 0BB0 68                    pla   
2865 0BB1 FA                    plx   
2866 0BB2 60                    rts   
2867 0BB3
2868 0BB3                       ENDP 
2869 0BB3
2870 0BB3
2871 0BB3              ;=============================
2872 0BB3              ;        Move a window.
2873 0BB3              ;=============================
2874 0BB3              ;
2875 0BB3              ;   IN:    PUSH:WORD - new x content origin in global coordinates.
2876 0BB3              ;          PUSH:WORD - new y content origin in global coordinates.
2877 0BB3              ;          PUSH:LONG - pointer to window port.
2878 0BB3              ;
2879 0BB3              ;  OUT:    None.
2880 0BB3              ;
2881 0BB3              MoveWindow PROC 
2882 0BB3              ;
2883 0BB3              ;
2884 0BB3              theWind  equ   10
2885 0BB3              yOrigin  equ   theWind+4
2886 0BB3              xOrigin  equ   yorigin+2
2887 0BB3              ;
2888 0BB3              deltay   equ   work
2889 0BB3              deltax   equ   deltay+2
2890 0BB3              ;
2891 0BB3              ;
2892 0BB3 20 CA 21              jsr   setup
2893 0BB6              ;
2894 0BB6 8B                    phb                            Save current data bank.
2895 0BB7 4B                    phk                            Make program and data banks the same.
2896 0BB8 AB                    plb   
2897 0BB9              ;
2898 0BB9              ;
2899 0BB9              ; --- If window is full, save current position ---------------
2900 0BB9              ;
2901 0BB9 A3 0E                 lda   yOrigin,s
2902 0BBB AA                    tax   
2903 0BBC A3 10                 lda   xOrigin,s
2904 0BBE A8                    tay   
2905 0BBF A9 1E 00              lda   #wStartMove              Tell window defProc move is happening.
2906 0BC2 20 D5 11              jsr   callProc2
2907 0BC5 83 0E                 sta   yOrigin,s
2908 0BC7 8A                    txa   
2909 0BC8 83 10                 sta   xOrigin,s
2910 0BCA              ;
2911 0BCA              ;
2912 0BCA              ; --- Set source and destination RECT bounds -----------------
2913 0BCA              ;
2914 0BCA 20 1B 22              jsr   getwgrect                Get window's starting RECT.
2915 0BCD              ;
2916 0BCD A0 B6 01              ldy   #blitsrc+x2              Copy Window's bounds into blit's.
2917 0BD0 20 D9 0C              jsr   copywrect
2918 0BD3 A0 BE 01              ldy   #blitdes+x2
2919 0BD6 20 D9 0C              jsr   copywrect
2920 0BD9              ;
2921 0BD9              ;
2922 0BD9              ; --- Compute the window's visible structRgn ---------------
2923 0BD9              ;
2924 0BD9 20 3A 20              jsr   setwmgrport              Switch to Window Manager's port.
2925 0BDC              ;
2926 0BDC A0 C0 00              ldy   #wstrucRgn+2             Set wmgr's clip region
2927 0BDF 20 F9 21              jsr   pushandle                to the window's StructRgn.
2928 0BE2 A2 04 24 22           _SetClip 
2929 0BE9              ;
2930 0BE9 20 B1 08              jsr   clipabove                Compute visible area of window.
2931 0BEC              ;                              clip = visible region.
2932 0BEC              ;
2933 0BEC 20 AD 21              jsr   alloc_rgn
2934 0BEF 20 AD 21              jsr   alloc_rgn                Allocate region for destination.
2935 0BF2              ;                              rgnptr2 = rgnptr.
2936 0BF2              ;                              rgnptr = new region.
2937 0BF2 20 9A 21              jsr   pushclip
2938 0BF5 20 80 21              jsr   pushrgnptr
2939 0BF8 A2 04 69 22           _CopyRgn                       rgnptr = clip (visible window).
2940 0BFF              ;
2941 0BFF 20 9A 21              jsr   pushclip
2942 0C02 20 8E 21              jsr   pushrgn2
2943 0C05 A2 04 69 22           _CopyRgn                       rgnptr2 = clip (visible window).
2944 0C0C              ;
2945 0C0C              ;
2946 0C0C              ; --- Move the window by changing its Bounds RECT -------------
2947 0C0C              ;
2948 0C0C A3 0E                 lda   yorigin,s                Pass new position of content.
2949 0C0E AA                    tax   
2950 0C0F A3 10                 lda   xorigin,s
2951 0C11 20 C8 17              jsr   pos_wind                 Reposition the window.
2952 0C14 86 DE                 stx   <deltay                  Save delta y.
2953 0C16 85 E0                 sta   <deltax                  Save delat x.
2954 0C18              ;
2955 0C18 A0 C0 00              ldy   #wstrucRgn+2             Offset window's StructRgn.
2956 0C1B 20 CA 0C              jsr   offsetrgn
2957 0C1E              ;
2958 0C1E A0 C4 00              ldy   #wcontRgn+2              Offset window's content region.
2959 0C21 20 CA 0C              jsr   offsetrgn
2960 0C24              ;
2961 0C24 A0 C8 00              ldy   #wupdateRgn+2            Offset window's update region.
2962 0C27 20 CA 0C              jsr   offsetrgn
2963 0C2A              ;
2964 0C2A 20 48 22              jsr   testVis                  Is the window visible?
2965 0C2D D0 03                 bne   ok1
2966 0C2F 82 7F 00              brl   skip1                    If not, no need to redraw.
2967 0C32              ;
2968 0C32              ;
2969 0C32              ; --- Offset the destination region from the source region ------
2970 0C32              ;
2971 0C32 20 80 21     ok1      jsr   pushrgnptr               Pass destination region handle.
2972 0C35 D4 E0                 pei   <deltax
2973 0C37 D4 DE                 pei   <deltay
2974 0C39 A2 04 6F 22           _OffsetRgn 
2975 0C40              ;
2976 0C40 20 28 21              jsr   pushblitdes              Pass pointer to destination RECT.
2977 0C43 D4 E0                 pei   <deltax
2978 0C45 D4 DE                 pei   <deltay
2979 0C47 A2 04 4B 22           _OffsetRect                    Offset destination RECT.
2980 0C4E              ;
2981 0C4E              ;
2982 0C4E              ; --- Clip blit to not over draw any windows on top of this one -------
2983 0C4E              ;
2984 0C4E 20 80 21              jsr   pushrgnptr               Copy destination region into
2985 0C51 20 9A 21              jsr   pushclip                 the clip region (used by clipabove).
2986 0C54 A2 04 69 22           _CopyRgn 
2987 0C5B              ;
2988 0C5B 20 B1 08              jsr   clipabove                Subtract any windows on top.
2989 0C5E              ;
2990 0C5E 20 9A 21              jsr   pushclip                 Copy clipped region back
2991 0C61 20 80 21              jsr   pushrgnptr               into 'rgnptr'.
2992 0C64 A2 04 69 22           _CopyRgn 
2993 0C6B              ;
2994 0C6B              ;
2995 0C6B              ; --- BLIT the window to its new home ------------------------
2996 0C6B              ;
2997 0C6B A5 BA                 lda   <rgnptr+2                Destination clip region.
2998 0C6D A0 4C 00              ldy   #scrn2scrn+PP_Clip+2
2999 0C70 97 D8                 sta   [<data],y
3000 0C72 A5 B8                 lda   <rgnptr
3001 0C74 88                    dey   
3002 0C75 88                    dey   
3003 0C76 97 D8                 sta   [<data],y
3004 0C78              ;
3005 0C78 20 23 21              jsr   pushscrn2scrn
3006 0C7B A2 04 7F 22           _PaintPixels 
3007 0C82              ;
3008 0C82              ;
3009 0C82              ;
3010 0C82              ; --- Redraw any part of the window newly exposed -----------
3011 0C82              ;
3012 0C82 A0 C0 00              ldy   #wstrucRgn+2
3013 0C85 20 F9 21              jsr   pushandle                Pass window's StructRgn.
3014 0C88 20 80 21              jsr   pushrgnptr               Pass destination region.
3015 0C8B 20 80 21              jsr   pushrgnptr               Result into 'rgnptr'.
3016 0C8E A2 04 73 22           _DiffRgn                       rgnptr = StructRgn - Blitted area.
3017 0C95              ;
3018 0C95 20 C4 08              jsr   fullport                 Set clip to full screen.
3019 0C98 20 BF 06              jsr   PaintOne                 Draw the remainder of the window.
3020 0C9B              ;
3021 0C9B              ;
3022 0C9B              ; --- Redraw whole left by window when moved ----------------
3023 0C9B              ;
3024 0C9B 20 8E 21              jsr   pushrgn2                 Pass where window was.
3025 0C9E A0 C0 00              ldy   #wstrucRgn+2
3026 0CA1 20 F9 21              jsr   pushandle                Pass where window is.
3027 0CA4 20 80 21              jsr   pushrgnptr               Result in 'rgnptr'.
3028 0CA7 A2 04 73 22           _DiffRgn                       rgnptr = clobbered region.
3029 0CAE              ;
3030 0CAE 20 A9 06              jsr   paintbehind              Redraw what's in 'rgnptr'.
3031 0CB1              ;
3032 0CB1              ;
3033 0CB1              ; --- Free temp. regions ---------------------------
3034 0CB1              ;
3035 0CB1 20 78 26     skip1    jsr   disposeRgnPtr
3036 0CB4              ;
3037 0CB4 D4 BE                 pei   <rgnptr2+2
3038 0CB6 D4 BC                 pei   <rgnptr2
3039 0CB8 A2 04 68 22           _DisposeRgn 
3040 0CBF              ;
3041 0CBF              ;
3042 0CBF              ; --- Fix up every window's visRgn ----------------
3043 0CBF              ;
3044 0CBF 20 17 08              jsr   calc_vis
3045 0CC2              ;
3046 0CC2 20 60 20              jsr   restore_port             Restore original port.
3047 0CC5              ;
3048 0CC5 AB                    plb                            Restore original data bank.
3049 0CC6 8B                    phb   
3050 0CC7 82 F9 82              brl   pop8bytes
3051 0CCA              ;
3052 0CCA              ;
3053 0CCA              ; = = = = = = = = = = = = = = = = =
3054 0CCA              ;          Offset region.
3055 0CCA              ;100= = = = = = = = = = = = = = = =
3056 0CCA              ;
3057 0CCA              ;
3058 0CCA              ;   IN:    y = index to region to offset
3059 0CCA              ;
3060 0CCA 20 F9 21     offsetrgn jsr   pushandle
3061 0CCD D4 E0                 pei   <deltax
3062 0CCF D4 DE                 pei   <deltay
3063 0CD1 A2 04 6F 22           _OffsetRgn 
3064 0CD8 60                    rts   
3065 0CD9              ;
3066 0CD9              ;
3067 0CD9              ; = = = = = = = = = = = = = = = = = = = = = = = = =
3068 0CD9              ;          Copy 'wrect' into data area.
3069 0CD9              ;110= = = = = = = = = = = = = = = = = = = = = = = =
3070 0CD9              ;
3071 0CD9              ;   IN:    y = offset to X2 destination in data area.
3072 0CD9              ;          wrect = RECT to copy.
3073 0CD9              ;
3074 0CD9 A2 06 00     copywrect ldx   #x2
3075 0CDC B5 9E        lop110   lda   <wrect,x
3076 0CDE 97 D8                 sta   [<data],y
3077 0CE0 88                    dey   
3078 0CE1 88                    dey   
3079 0CE2 CA                    dex   
3080 0CE3 CA                    dex   
3081 0CE4 10 F6                 bpl   lop110
3082 0CE6 60                    rts   
3083 0CE7              ;
3084 0CE7                       ENDP 
3085 0CE7              ;
3086 0CE7              ;
3087 0CE7              ;===================================================
3088 0CE7              ;          Return the address of DragRect.
3089 0CE7              ;===================================================
3090 0CE7              ;
3091 0CE7              GetDragRect PROC 
3092 0CE7              ;
3093 0CE7              ;
3094 0CE7              result   equ   7
3095 0CE7              ;
3096 0CE7              ;
3097 0CE7 A9 F5 0C              lda   #WindDragRect-1
3098 0CEA 83 07                 sta   result,s
3099 0CEC A9 FD 00              lda   #WindDragRect>>16
3100 0CEF 83 09                 sta   result+2,s
3101 0CF1              ;
3102 0CF1 A9 00 00              lda   #0                       No error.
3103 0CF4 18                    clc   
3104 0CF5 6B                    rtl   
3105 0CF6              ;
3106 0CF6                       ENDP 
3107 0CF6              ;
3108 0CF6              ;
3109 0CF6              ;====================================
3110 0CF6              ;          Drag a rectangle.
3111 0CF6              ;====================================
3112 0CF6              ;
3113 0CF6              ;   IN:    PUSH:LONG - pointer to action procedure routine.
3114 0CF6              ;          PUSH:LONG - address of drag pattern.
3115 0CF6              ;          PUSH:WORD - x starting point of mouse, in local.
3116 0CF6              ;          PUSH:WORD - y starting point of mouse, in local.
3117 0CF6              ;          PUSH:LONG - pointer to RECT to be dragged, in local.
3118 0CF6              ;          PUSH:LONG - pointer to bounds RECT, in local.
3119 0CF6              ;          PUSH:LONG - pointer to slop RECT, in local.
3120 0CF6              ;          PUSH:WORD - constraining axis:
3121 0CF6              ;                       %xxxxxxxxxxxxxx00 - no constraint.
3122 0CF6              ;                       %xxxxxxxxxxxxxx01 - Allow only horizontal movement.
3123 0CF6              ;                       %xxxxxxxxxxxxxx10 - Allow only vertical movement.
3124 0CF6              ;                       %xxxxxxxxxxxxx0xx - Drag RECT.
3125 0CF6              ;                       %xxxxxxxxxxxxx1xx - Rubber-band RECT.
3126 0CF6              ;                       %xxxxxxxxxxxx0xxx - default drag, action=action proc.
3127 0CF6              ;                       %xxxxxxxxxxxx1xxx - Custom RECT, action=draw routine.
3128 0CF6              ;                       %xxxxxxxxxxx0xxxx - limit_rect = bounds RECT.
3129 0CF6              ;                       %xxxxxxxxxxx1xxxx - limit_rect = min and max values.
3130 0CF6              ;                       %xxxxxxxxxx0xxxxx - don't return drag rect in drag_rect.
3131 0CF6              ;                       %xxxxxxxxxx1xxxxx - return drag rect in drag_rect.
3132 0CF6              ;                       %xxxxxxxxx0xxxxxx - don't bind cursor to limit_rect.
3133 0CF6              ;                       %xxxxxxxxx1xxxxxx - bind cursor to limit_rect.
3134 0CF6              ;                       %xxxxxxxx0xxxxxxx - don't pass draw flag to custom draw.
3135 0CF6              ;                       %xxxxxxxx1xxxxxxx - pass draw flag to custom draw.
3136 0CF6              ;                       %00000000xxxxxxxx - grid values, 0, 1, 2, 4, 8, ect...
3137 0CF6              ;
3138 0CF6              ;  OUT:    LONG - low WORD is delta y, high WORD is delta x.
3139 0CF6              ;
3140 0CF6              WindDragRect PROC EXPORT
3141 0CF6              ;
3142 0CF6                                                      ;using equates
3143 0CF6              ;
3144 0CF6              VERTAXIS equ   $0001                    Set to allow only vertical movement.
3145 0CF6              HORAXIS  equ   $0002                    Set to allow only horizontal movement.
3146 0CF6              RUBBERBAND equ   $0004                  Set if rubber band RECT.
3147 0CF6              CUSTOMRECT equ   $0008                  Set if custom RECT draw routine.
3148 0CF6              MMPASSED equ   $0010                    Min and Max passed in limit_rect.
3149 0CF6              RETURNDRAG equ   $0020                  Return drag RECT in drag_rect.
3150 0CF6              BOUNDXY  equ   $0040                    Set to bind cursor to limit_rect.
3151 0CF6              PASSFLAG equ   $0080                    Pass draw flag to custom draw routine.
3152 0CF6              ;
3153 0CF6              grid_val equ   1
3154 0CF6              grid_val2 equ   grid_val+2
3155 0CF6              grid_msk equ   grid_val2+2
3156 0CF6              min_deltay equ   grid_msk+2
3157 0CF6              min_deltax equ   min_deltay+2
3158 0CF6              max_deltay equ   min_deltax+2
3159 0CF6              max_deltax equ   max_deltay+2
3160 0CF6              trect    equ   max_deltax+2
3161 0CF6              drag     equ   trect+RECTSIZE
3162 0CF6              ypt      equ   drag+RECTSIZE
3163 0CF6              xpt      equ   ypt+2
3164 0CF6              moveFlag equ   xpt+2
3165 0CF6              worksize equ   moveFlag+1
3166 0CF6              ;
3167 0CF6              constraint equ   worksize+9             Direction of movement allowed.
3168 0CF6              slop_rect equ   constraint+2            Pointer to RECT that is cursor bounds.
3169 0CF6              limit_rect equ   slop_rect+4            Pointer to RECT that is movement bounds.
3170 0CF6              drag_rect equ   limit_rect+4            Pointer to RECT to drag.
3171 0CF6              starty   equ   drag_rect+4              Starting point.
3172 0CF6              startx   equ   starty+2
3173 0CF6              drag_patt equ   startx+2                Pattern for xor dragging.
3174 0CF6              action   equ   drag_patt+4              Address of routine to call while dragging.
3175 0CF6              deltay   equ   action+4                 Return values.
3176 0CF6              deltax   equ   deltay+2
3177 0CF6              ;
3178 0CF6              ;
3179 0CF6 22 64 00 E1           jsl   IncBusyFlg
3180 0CFA 0B                    phd   
3181 0CFB              ;
3182 0CFB 3B                    tsc   
3183 0CFC 38                    sec   
3184 0CFD E9 24 00              sbc   #worksize
3185 0D00 1B                    tcs   
3186 0D01 5B                    tcd   
3187 0D02              ;
3188 0D02 64 23                 stz   <moveFlag                Set 'draw' flag.
3189 0D04 E6 23                 inc   <moveFlag
3190 0D06              ;
3191 0D06              ;
3192 0D06              ; --- Clone RECTs into my direct page --------------------------
3193 0D06              ;
3194 0D06 A0 06 00              ldy   #x2
3195 0D09 BB           lop1     tyx   
3196 0D0A B7 37                 lda   [<drag_rect],y
3197 0D0C 95 17                 sta   <drag,x
3198 0D0E B7 33                 lda   [<limit_rect],y
3199 0D10 95 07                 sta   <min_deltay,x
3200 0D12 88                    dey   
3201 0D13 88                    dey   
3202 0D14 10 F3                 bpl   lop1
3203 0D16              ;
3204 0D16              ;
3205 0D16              ; --- Set up grid values -------------------------------------
3206 0D16              ;
3207 0D16 A5 2E                 lda   <constraint+1            Get grid value.
3208 0D18 29 FF 00              and   #$00FF
3209 0D1B D0 01                 bne   store1
3210 0D1D 1A                    inc   a                        At least one pixel.
3211 0D1E 85 01        store1   sta   <grid_val                $0001 $0002 $0004 $0008...
3212 0D20 85 03                 sta   <grid_val2
3213 0D22 46 03                 lsr   <grid_val2               $0000 $0001 $0002 $0004...
3214 0D24 3A                    dec   a
3215 0D25 49 FF FF              eor   #$FFFF
3216 0D28 85 05                 sta   <grid_msk                $FFFF $FFFE $FFFC $FFF8...
3217 0D2A              ;
3218 0D2A              ;
3219 0D2A              ; --- Compute min and max deltax -----------------------------
3220 0D2A              ;
3221 0D2A A5 2D                 lda   <constraint              Was the min and max values passed?
3222 0D2C 29 10 00              and   #MMPASSED
3223 0D2F D0 4A                 bne   ok2
3224 0D31              ;
3225 0D31 A2 02 00              ldx   #x1
3226 0D34 A5 2D                 lda   <constraint              Bind the drag RECT or the cursor?
3227 0D36 29 40 00              and   #BOUNDXY
3228 0D39 F0 14                 beq   bindRect
3229 0D3B              ;
3230 0D3B              ;
3231 0D3B              ; ------ Bind the cursor to the limit RECT -------------------
3232 0D3B              ;
3233 0D3B              ; MMPASSED = 0
3234 0D3B              ; BOUNDXY  = 1
3235 0D3B              ;
3236 0D3B B5 07        lop5     lda   <min_deltay,x
3237 0D3D 38                    sec   
3238 0D3E F5 3B                 sbc   <starty,x
3239 0D40 95 07                 sta   <min_deltay,x
3240 0D42              ;
3241 0D42 B5 0B                 lda   <max_deltay,x
3242 0D44 38                    sec   
3243 0D45 F5 3B                 sbc   <starty,x
3244 0D47 95 0B                 sta   <max_deltay,x
3245 0D49              ;
3246 0D49 CA                    dex   
3247 0D4A CA                    dex   
3248 0D4B 10 EE                 bpl   lop5
3249 0D4D 80 12                 bra   skip3
3250 0D4F              ;
3251 0D4F              ;
3252 0D4F              ; ------ Bind the drag RECT to the limit RECT ----------------
3253 0D4F              ;
3254 0D4F              ; MMPASSED = 0
3255 0D4F              ; BOUNDXY  = 0
3256 0D4F              ;
3257 0D4F              bindRect                                ; 
3258 0D4F B5 07        lop3     lda   <min_deltay,x
3259 0D51 38                    sec   
3260 0D52 F5 17                 sbc   <drag+y1,x
3261 0D54 95 07                 sta   <min_deltay,x
3262 0D56              ;
3263 0D56 B5 0B                 lda   <max_deltay,x
3264 0D58 38                    sec   
3265 0D59 F5 1B                 sbc   <drag+y2,x
3266 0D5B 95 0B                 sta   <max_deltay,x
3267 0D5D              ;
3268 0D5D CA                    dex   
3269 0D5E CA                    dex   
3270 0D5F 10 EE                 bpl   lop3
3271 0D61              ;
3272 0D61              ;
3273 0D61              ; --- Place deltas on grid -----------------------------------
3274 0D61              ;
3275 0D61 A5 05        skip3    lda   <grid_msk                Round up minimum up, if needed.
3276 0D63 49 FF FF              eor   #$FFFF
3277 0D66 25 09                 and   <min_deltax
3278 0D68 F0 0B                 beq   skip4                    Already on grid?
3279 0D6A              ;
3280 0D6A A5 09                 lda   <min_deltax              Round up.
3281 0D6C 25 05                 and   <grid_msk
3282 0D6E 18                    clc   
3283 0D6F 65 03                 adc   <grid_val2
3284 0D71 65 03                 adc   <grid_val2
3285 0D73 85 09                 sta   <min_deltax
3286 0D75              ;
3287 0D75 A5 0D        skip4    lda   <max_deltax              Round down.
3288 0D77 25 05                 and   <grid_msk
3289 0D79 85 0D                 sta   <max_deltax
3290 0D7B              ;
3291 0D7B              ;
3292 0D7B              ; --- Constrain movement -------------------------------------
3293 0D7B              ;
3294 0D7B A2 00 00     ok2      ldx   #0
3295 0D7E A5 2D                 lda   <constraint
3296 0D80 29 03 00              and   #VERTAXIS+HORAXIS
3297 0D83 F0 0C                 beq   ok1                      Any constrain on?
3298 0D85 3A                    dec   a                        Constrain horizontally?
3299 0D86 F0 05                 beq   con_hor
3300 0D88 3A                    dec   a
3301 0D89 D0 06                 bne   ok1
3302 0D8B E8                    inx                            Constrain vertically.
3303 0D8C E8                    inx   
3304 0D8D 74 07        con_hor  stz   <min_deltay,x
3305 0D8F 74 0B                 stz   <max_deltay,x
3306 0D91              ;
3307 0D91              ;
3308 0D91              ;
3309 0D91              ; --- More initialization ------------------------------------
3310 0D91              ;
3311 0D91 64 47        ok1      stz   <deltay                  Start with no movement.
3312 0D93 64 49                 stz   <deltax
3313 0D95              ;
3314 0D95              ;
3315 0D95              ; --- Set up pen for outline dragging ------------------------
3316 0D95              ;
3317 0D95 D4 41                 pei   <drag_patt+2             Pass address of xor pattern.
3318 0D97 D4 3F                 pei   <drag_patt
3319 0D99 A2 04 30 22           _SetPenPat                     ;was PenPat 17-Sep-90 DAL
3320 0DA0              ;
3321 0DA0 F4 02 00              pea   2                        XOR mode.
3322 0DA3 A2 04 2E 22           _SetPenMode                    ;was PenMode 17-Sep-90 DAL
3323 0DAA              ;
3324 0DAA F4 02 00              pea   2
3325 0DAD F4 01 00              pea   1
3326 0DB0 A2 04 2C 22           _SetPenSize 
3327 0DB7              ;
3328 0DB7              ;
3329 0DB7              ; --- Drag RECT ----------------------------------------------
3330 0DB7              ;
3331 0DB7 20 AB 0E     lop2     jsr   xorbox                   Draw XOR box.
3332 0DBA              ;
3333 0DBA 20 40 0B     lop4     jsr   ckbutton                 Is button still down?
3334 0DBD 84 1F                 sty   <ypt
3335 0DBF 85 21                 sta   <xpt
3336 0DC1 D0 18                 bne   done2
3337 0DC3              ;
3338 0DC3              ;
3339 0DC3              ; --- Call action routine ------------------------------------
3340 0DC3              ;
3341 0DC3 A5 2D                 lda   <constraint              Is there a custom draw routine?
3342 0DC5 29 08 00              and   #CUSTOMRECT
3343 0DC8 D0 0A                 bne   skip1
3344 0DCA              ;
3345 0DCA A6 44                 ldx   <action+1                Was an action routine passed?
3346 0DCC F0 06                 beq   skip1
3347 0DCE A5 43                 lda   <action
3348 0DD0 22 67 22 FD           jsl   longCall                 Call action routine.
3349 0DD4              ;
3350 0DD4              ;
3351 0DD4 20 F4 0D     skip1    jsr   ckposition
3352 0DD7 90 DE                 bcc   lop2                     Redraw?
3353 0DD9 80 DF                 bra   lop4
3354 0DDB              ;
3355 0DDB              ;
3356 0DDB              ; --- Exit ---------------------------------------------------
3357 0DDB              ;
3358 0DDB 20 F4 0D     done2    jsr   ckposition               Check position one last time.
3359 0DDE 90 03                 bcc   skip2                    Box already erased?
3360 0DE0 20 AB 0E              jsr   xorbox                   Erase xor box.
3361 0DE3              ;
3362 0DE3 A2 04 36 22  skip2    _PenNormal                     Reset pen patteren.
3363 0DEA              ;
3364 0DEA 3B                    tsc   
3365 0DEB 18                    clc   
3366 0DEC 69 24 00              adc   #worksize
3367 0DEF 1B                    tcs   
3368 0DF0              ;
3369 0DF0              ;
3370 0DF0 8B                    phb   
3371 0DF1 82 FF 81              brl   pop26bytes
3372 0DF4
3373 0DF4
3374 0DF4              ;
3375 0DF4              ;
3376 0DF4              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
3377 0DF4              ;        Check cursor, move RECT if needed.
3378 0DF4              ;100= = = = = = = = = = = = = = = = = = = = = = = = =
3379 0DF4              ;
3380 0DF4              ;  OUT:  Carry flag set if no need to redraw.
3381 0DF4              ;
3382 0DF4              ckposition                              ; 
3383 0DF4              ;
3384 0DF4              ;
3385 0DF4              ; --- Check if cursor is inside 'slop_rect' ------------------
3386 0DF4              ;
3387 0DF4 48                    pha                            Space for result.
3388 0DF5 A9 1F 00              lda   #ypt                     Pass pointer to point to check.
3389 0DF8 20 64 8F              jsr   pushDpage
3390 0DFB D4 31                 pei   <slop_rect+2             Pass pointer to RECT to check.
3391 0DFD D4 2F                 pei   <slop_rect
3392 0DFF A2 04 4F 22           _PtInRect                      Is the cursor in slop_rect?
3393 0E06 68                    pla   
3394 0E07 D0 08                 bne   ok100
3395 0E09              ;
3396 0E09              ;
3397 0E09              ; ------ Reset RECT to starting place ------------------------
3398 0E09              ;
3399 0E09 A5 3B                 lda   <starty
3400 0E0B 85 1F                 sta   <ypt
3401 0E0D A5 3D                 lda   <startx
3402 0E0F 85 21                 sta   <xpt
3403 0E11              ;
3404 0E11              ;
3405 0E11              ; --- Check if there has been any movement -------------------
3406 0E11              ;
3407 0E11 20 38 0E     ok100    jsr   getdelta                 Did the mouse move?
3408 0E14 C5 47                 cmp   <deltay
3409 0E16 D0 04                 bne   moveit100
3410 0E18 E4 49                 cpx   <deltax
3411 0E1A F0 0C                 beq   ckCustom
3412 0E1C              ;
3413 0E1C 20 AB 0E     moveit100 jsr   xorbox                  Erase XOR box before move.
3414 0E1F              ;
3415 0E1F 20 38 0E              jsr   getdelta                 Compute and set the new deltas.
3416 0E22 85 47                 sta   <deltay
3417 0E24 86 49                 stx   <deltax
3418 0E26 18                    clc                            Redraw flag.
3419 0E27 60                    rts   
3420 0E28              ;
3421 0E28              ;
3422 0E28 A5 2D        ckCustom lda   <constraint              Should the draw routine be called anyway.
3423 0E2A 29 80 00              and   #PASSFLAG
3424 0E2D F0 07                 beq   exit100
3425 0E2F              ;
3426 0E2F 64 23                 stz   <moveFlag                Clear draw flag.
3427 0E31 20 AB 0E              jsr   xorbox                   Call custom draw routine.
3428 0E34 E6 23                 inc   <moveFlag                Set draw flag back to drawing.
3429 0E36              ;
3430 0E36 38           exit100  sec                            No need to redraw.
3431 0E37 60                    rts                            Carry set, no need to redraw.
3432 0E38              ;
3433 0E38              ;
3434 0E38              ; = = = = = = = = = = = = = = = = = =
3435 0E38              ;        Compute delta
3436 0E38              ;110= = = = = = = = = = = = = = = = =
3437 0E38              ;
3438 0E38              ;   IN:    ypt, xpt = new point.
3439 0E38              ;          starty, startx = original point.
3440 0E38              ;
3441 0E38              ;  OUT:    a = delta y.
3442 0E38              ;          x = delta x.
3443 0E38              ;
3444 0E38 A5 21        getdelta lda   <xpt                     Current position,
3445 0E3A 38                    sec   
3446 0E3B E5 3D                 sbc   <startx                  less starting position,
3447 0E3D AA                    tax                            equals delta x.
3448 0E3E              ;
3449 0E3E 25 05                 and   <grid_msk                Force delta x to grid.
3450 0E40 48                    pha   
3451 0E41              ;
3452 0E41 8A                    txa                            Should delta x be rounded?
3453 0E42 25 03                 and   <grid_val2
3454 0E44 F0 06                 beq   ok110
3455 0E46              ;
3456 0E46 0A                    asl   a                        Round delta x up.
3457 0E47 18                    clc   
3458 0E48 63 01                 adc   1,s
3459 0E4A 83 01                 sta   1,s
3460 0E4C              ;
3461 0E4C 68           ok110    pla                            New delta x.
3462 0E4D A2 02 00              ldx   #x1
3463 0E50 20 70 0E              jsr   bindDelta
3464 0E53 98                    tya   
3465 0E54 25 05                 and   <grid_msk                Force delta x to grid.
3466 0E56 48                    pha   
3467 0E57              ;
3468 0E57 98                    tya                            Should delta x be rounded?
3469 0E58 25 03                 and   <grid_val2
3470 0E5A F0 06                 beq   ok111
3471 0E5C              ;
3472 0E5C 0A                    asl   a                        Round delta x up.
3473 0E5D 18                    clc   
3474 0E5E 63 01                 adc   1,s
3475 0E60 83 01                 sta   1,s
3476 0E62              ;
3477 0E62              ok111                                   ; Delta x on stack.
3478 0E62              ;
3479 0E62              ;
3480 0E62              ; --- Compute the y delta ------------------------------------
3481 0E62              ;
3482 0E62 A5 1F                 lda   <ypt
3483 0E64 38                    sec   
3484 0E65 E5 3B                 sbc   <starty                  New delta y.
3485 0E67 A2 00 00              ldx   #y1
3486 0E6A 20 70 0E              jsr   bindDelta
3487 0E6D 98                    tya   
3488 0E6E FA                    plx   
3489 0E6F 60                    rts   
3490 0E70              ;
3491 0E70              ;
3492 0E70              ; = = = = = = = = = = = = = = = = = = = = = = =
3493 0E70              ;          Bind delta to limit RECT.
3494 0E70              ;120= = = = = = = = = = = = = = = = = = = = = =
3495 0E70              ;
3496 0E70              ;   IN:    a = new delta.
3497 0E70              ;          x = x or y offset.
3498 0E70              ;
3499 0E70 B4 07        bindDelta ldy   <min_deltay,x
3500 0E72 20 95 0E              jsr   find_max                 a = max.
3501 0E75              ;
3502 0E75 B4 07                 ldy   <min_deltay,x            Did the point start outside limit?
3503 0E77 30 08                 bmi   ok120
3504 0E79              ;
3505 0E79 38                    sec   
3506 0E7A F5 07                 sbc   <min_deltay,x
3507 0E7C B0 03                 bcs   ok120
3508 0E7E              ;
3509 0E7E A9 00 00              lda   #0
3510 0E81              ;
3511 0E81 B4 0B        ok120    ldy   <max_deltay,x
3512 0E83 20 95 0E              jsr   find_max                 New delta x bound to min and max.
3513 0E86              ;
3514 0E86 B5 0B                 lda   <max_deltay,x
3515 0E88 10 0A                 bpl   ok121
3516 0E8A              ;
3517 0E8A 98                    tya   
3518 0E8B 38                    sec   
3519 0E8C F5 0B                 sbc   <max_deltay,x
3520 0E8E A8                    tay   
3521 0E8F 30 03                 bmi   ok121
3522 0E91              ;
3523 0E91 A0 00 00              ldy   #0
3524 0E94              ;
3525 0E94 60           ok121    rts   
3526 0E95              ;
3527 0E95              ;
3528 0E95              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
3529 0E95              ;        Find the greater of two signed numbers.
3530 0E95              ;130= = = = = = = = = = = = = = = = = = = = = = = = = =
3531 0E95              ;
3532 0E95              ;   IN:    a = one signed number.
3533 0E95              ;          y = the other signed number.
3534 0E95              ;
3535 0E95              ;  OUT:    a = the greater of a or y.
3536 0E95              ;          y = the lesser of a or y.
3537 0E95              ;          x = same as in.
3538 0E95              ;
3539 0E95              agr_y    equ   1
3540 0E95              ;
3541 0E95 DA           find_max phx                            Save x.
3542 0E96              ;
3543 0E96 5A                    phy                            Save y.
3544 0E97 AA                    tax                            Save a.
3545 0E98 38                    sec   
3546 0E99 E3 01                 sbc   agr_y,s
3547 0E9B 70 04                 bvs   lab130
3548 0E9D 30 04                 bmi   dest130
3549 0E9F 80 06                 bra   exit130
3550 0EA1 30 04        lab130   bmi   exit130
3551 0EA3 9B           dest130  txy                            x = A.
3552 0EA4 68                    pla                            a = X.
3553 0EA5 FA                    plx   
3554 0EA6 60                    rts   
3555 0EA7              ;
3556 0EA7 8A           exit130  txa                            a = A.
3557 0EA8 7A                    ply                            x = X.
3558 0EA9 FA                    plx   
3559 0EAA 60                    rts   
3560 0EAB              ;
3561 0EAB              ;
3562 0EAB              ; = = = = = = = = = = = = = = = = = = =
3563 0EAB              ;        Draw a XOR rectangle.
3564 0EAB              ;140= = = = = = = = = = = = = = = = = =
3565 0EAB              ;
3566 0EAB              ;   IN:    starty = cursor starting y position.
3567 0EAB              ;          startx = cursor starting x position.
3568 0EAB              ;          deltay = cursor y position to draw at.
3569 0EAB              ;          deltax = cursor x position to draw at.
3570 0EAB              ;          drag = starting RECT.
3571 0EAB              ;
3572 0EAB A5 2D        xorbox   lda   <constraint              Rubber-band or drag?
3573 0EAD 29 04 00              and   #RUBBERBAND
3574 0EB0 F0 17                 beq   dragit140
3575 0EB2              ;
3576 0EB2              ;
3577 0EB2              ; --- Set RECT for drag or rubber-band -----------------------
3578 0EB2              ;
3579 0EB2 A2 02 00              ldx   #x1
3580 0EB5 B4 17        lop140   ldy   <drag+y1,x
3581 0EB7 B5 1B                 lda   <drag+y2,x
3582 0EB9 18                    clc   
3583 0EBA 75 47                 adc   <deltay,x
3584 0EBC              ;
3585 0EBC 20 95 0E              jsr   find_max
3586 0EBF              ;
3587 0EBF 94 0F                 sty   <trect+y1,x
3588 0EC1 95 13                 sta   <trect+y2,x
3589 0EC3 CA                    dex   
3590 0EC4 CA                    dex   
3591 0EC5 10 EE                 bpl   lop140
3592 0EC7              ;
3593 0EC7 80 15                 bra   draw140
3594 0EC9              ;
3595 0EC9              ;
3596 0EC9              ; ------ Offset the RECT for dragging ------------------------
3597 0EC9              ;
3598 0EC9 A2 02 00     dragit140 ldx   #x1
3599 0ECC B5 17        lop141   lda   <drag+y1,x
3600 0ECE 18                    clc   
3601 0ECF 75 47                 adc   <deltay,x
3602 0ED1 95 0F                 sta   <trect+y1,x
3603 0ED3              ;
3604 0ED3 B5 1B                 lda   <drag+y2,x
3605 0ED5 18                    clc   
3606 0ED6 75 47                 adc   <deltay,x
3607 0ED8 95 13                 sta   <trect+y2,x
3608 0EDA              ;
3609 0EDA CA                    dex   
3610 0EDB CA                    dex   
3611 0EDC 10 EE                 bpl   lop141
3612 0EDE              ;
3613 0EDE              ;
3614 0EDE              ; --- Draw the shape -----------------------------------------
3615 0EDE              ;
3616 0EDE A5 2D        draw140  lda   <constraint              Return the drag RECT?
3617 0EE0 29 20 00              and   #RETURNDRAG
3618 0EE3 F0 0C                 beq   skip140
3619 0EE5              ;
3620 0EE5 A0 06 00              ldy   #x2                      Return the RECT to the caller.
3621 0EE8 BB           lop142   tyx   
3622 0EE9 B5 0F                 lda   <trect,x
3623 0EEB 97 37                 sta   [<drag_rect],y
3624 0EED 88                    dey   
3625 0EEE 88                    dey   
3626 0EEF 10 F7                 bpl   lop142
3627 0EF1              ;
3628 0EF1              ;
3629 0EF1 A5 2D        skip140  lda   <constraint              Custom draw routine?
3630 0EF3 29 08 00              and   #CUSTOMRECT
3631 0EF6 F0 16                 beq   default140
3632 0EF8              ;
3633 0EF8              ;
3634 0EF8              ; ------ Custom RECT drag ------------------------------------
3635 0EF8              ;
3636 0EF8 A5 2D                 lda   <constraint              Pass draw flag?
3637 0EFA 29 80 00              and   #PASSFLAG
3638 0EFD F0 02                 beq   skip141
3639 0EFF              ;
3640 0EFF D4 23                 pei   <moveFlag                Pass the movement flag.
3641 0F01              ;
3642 0F01 D4 49        skip141  pei   <deltax                  Pass deltas.
3643 0F03 D4 47                 pei   <deltay
3644 0F05              ;
3645 0F05 A6 44                 ldx   <action+1
3646 0F07 A5 43                 lda   <action
3647 0F09 22 67 22 FD           jsl   longCall                 Call draw routine.
3648 0F0D 60                    rts   
3649 0F0E              ;
3650 0F0E              ;
3651 0F0E              ; ------ Default draw ----------------------------------------
3652 0F0E              ;
3653 0F0E D4 11        default140 pei   <trect+x1              ; get into place
3654 0F10 D4 0F                 pei   <trect+y1
3655 0F12 A2 04 3A 22           _MoveTo 
3656 0F19              ;
3657 0F19 A5 15                 lda   <trect+x2                ; draw top
3658 0F1B 3A                    dec   a
3659 0F1C 3A                    dec   a
3660 0F1D 48                    pha   
3661 0F1E D4 0F                 pei   <trect+y1
3662 0F20 A2 04 3C 22           _LineTo 
3663 0F27
3664 0F27 F4 00 00              pea   0                        ; move down one
3665 0F2A F4 01 00              pea   1
3666 0F2D A2 04 3B 22           _Move 
3667 0F34              ;
3668 0F34 A5 15                 lda   <trect+x2                ; draw right
3669 0F36 3A                    dec   a
3670 0F37 3A                    dec   a
3671 0F38 48                    pha   
3672 0F39 A5 13                 lda   <trect+y2
3673 0F3B 3A                    dec   a
3674 0F3C 48                    pha   
3675 0F3D A2 04 3C 22           _LineTo 
3676 0F44
3677 0F44 F4 FE FF              pea   -2                       ; move left two
3678 0F47 F4 00 00              pea   0
3679 0F4A A2 04 3B 22           _move 
3680 0F51              ;
3681 0F51 D4 11                 pei   <trect+x1                ; draw bottom
3682 0F53 A5 13                 lda   <trect+y2
3683 0F55 3A                    dec   a
3684 0F56 48                    pha   
3685 0F57 A2 04 3C 22           _LineTo 
3686 0F5E              ;
3687 0F5E F4 00 00              pea   0                        ; move up one
3688 0F61 F4 FF FF              pea   -1
3689 0F64 A2 04 3B 22           _Move 
3690 0F6B              ;
3691 0F6B D4 11                 pei   <trect+x1                ; draw left
3692 0F6D A5 0F                 lda   <trect+y1
3693 0F6F 1A                    inc   a
3694 0F70 48                    pha   
3695 0F71 A2 04 3C 22           _LineTo 
3696 0F78 60                    rts   
3697 0F79              ;
3698 0F79                       ENDP 
3699 0F79              ;
3700 0F79              ;
3701 0F79              ;==========================================
3702 0F79              ;        Get current mouse position.
3703 0F79              ;==========================================
3704 0F79              ;
3705 0F79              ;  OUT:  yrat = mouse y position.
3706 0F79              ;        xrat = mouse x position.
3707 0F79              ;
3708 0F79              getratpos PROC 
3709 0F79              ;
3710 0F79                                                      ;using equates
3711 0F79              ;
3712 0F79              ;
3713 0F79 A9 B4 00              lda   #yrat
3714 0F7C              ;
3715 0F7C                       ENTRY getratpos2
3716 0F7C              getratpos2                              ; 
3717 0F7C              ;
3718 0F7C 20 64 8F              jsr   pushDpage
3719 0F7F A2 06 0C 22           _GetMouse 
3720 0F86 60                    rts   
3721 0F87                       ENDP 
3722 0F87              ;
3723 0F87              ;
3724 0F87              ;            APPEND	WACCESS.ASM
3725 0F87                       TITLE 'Apple IIGS Window Manager                   WACCESS.ASM' 
3726 0F87              ;
3727 0F87              ;          Copyright Apple Computer, Inc. 1986,1987,1988
3728 0F87              ;          All rights reserved
3729 0F87              ;          Written by Dan Oliver
3730 0F87              ;
3731 0F87              ;
3732 0F87              ;==========================================
3733 0F87              ;          Get/Set global flag.
3734 0F87              ;==========================================
3735 0F87              ;
3736 0F87              ;   IN:    WORD - negative to clear bits, positive to set bits,
3737 0F87              ;                 zero to just return current global flag.
3738 0F87              ;
3739 0F87              ;  OUT:    WORD - global flag after change.
3740 0F87              ;
3741 0F87              WindowGlobal PROC 
3742 0F87              ;
3743 0F87              ;
3744 0F87              newState equ   9
3745 0F87              newFlag  equ   newState+2
3746 0F87              ;
3747 0F87              ;
3748 0F87 22 64 00 E1           jsl   IncBusyFlg
3749 0F8B 0B                    phd                            Save caller's zero page.
3750 0F8C 5B                    tcd   
3751 0F8D              ;
3752 0F8D A0 AA 01              ldy   #WindGlobal
3753 0F90              ;
3754 0F90 A3 09                 lda   newState,s               Set or reset bits?
3755 0F92 10 04                 bpl   setBits
3756 0F94              ;
3757 0F94 37 D8                 and   [<data],y
3758 0F96 80 02                 bra   exit3
3759 0F98              ;
3760 0F98 17 D8        setBits  ora   [<data],y
3761 0F9A 97 D8        exit3    sta   [<data],y
3762 0F9C 83 0B                 sta   newFlag,s
3763 0F9E              ;
3764 0F9E 8B                    phb   
3765 0F9F 82 09 80              brl   pop2bytes
3766 0FA2                       ENDP 
3767 0FA2              ;
3768 0FA2              ;
3769 0FA2              ;=========================================
3770 0FA2              ;          Set the system window flag
3771 0FA2              ;          in the window record.
3772 0FA2              ;=========================================
3773 0FA2              ;
3774 0FA2              ;   IN:    PUSH:LONG - pointer to window's port.
3775 0FA2              ;
3776 0FA2              ;  OUT:    None.
3777 0FA2              ;
3778 0FA2              SetSysWindow PROC 
3779 0FA2              ;
3780 0FA2              ;
3781 0FA2              ;
3782 0FA2 20 CA 21              jsr   setup
3783 0FA5              ;
3784 0FA5 A0 08 00              ldy   #wport+4
3785 0FA8 B7 A6                 lda   [<wind],y
3786 0FAA 09 00 80              ora   #$8000                   Set system window flag.
3787 0FAD 97 A6                 sta   [<wind],y
3788 0FAF              ;
3789 0FAF 8B                    phb   
3790 0FB0 82 00 80              brl   pop4bytes
3791 0FB3                       ENDP 
3792 0FB3              ;
3793 0FB3              ;
3794 0FB3              ;=========================================
3795 0FB3              ;          Set updateDraw
3796 0FB3              ;=========================================
3797 0FB3              ;
3798 0FB3              ;   IN:    PUSH:LONG - address of routine to draw window's content region.
3799 0FB3              ;          PUSH:LONG - pointer to window's port.
3800 0FB3              ;
3801 0FB3              ;  OUT:    None.
3802 0FB3              ;
3803 0FB3              SetCDraw PROC 
3804 0FB3              ;
3805 0FB3              ;
3806 0FB3              theWind  equ   9
3807 0FB3              newContDraw equ   theWind+4
3808 0FB3              ;
3809 0FB3              ;
3810 0FB3 20 CA 21              jsr   setup
3811 0FB6              ;
3812 0FB6 A0 B6 00              ldy   #wContDraw
3813 0FB9              ;
3814 0FB9              ;
3815 0FB9                       ENTRY setWindLong
3816 0FB9              setWindLong                             ; 
3817 0FB9              ;
3818 0FB9 A3 0D                 lda   newContDraw,s
3819 0FBB 97 A6                 sta   [<wind],y
3820 0FBD C8                    iny   
3821 0FBE C8                    iny   
3822 0FBF A3 0F                 lda   newContDraw+2,s
3823 0FC1 97 A6                 sta   [<wind],y
3824 0FC3              ;
3825 0FC3 8B                    phb   
3826 0FC4 82 FC 7F              brl   pop8bytes
3827 0FC7                       ENDP 
3828 0FC7              ;
3829 0FC7              ;
3830 0FC7              ;==================================================
3831 0FC7              ;          Set application's reserved
3832 0FC7              ;          LONG in window record.
3833 0FC7              ;==================================================
3834 0FC7              ;
3835 0FC7              ;   IN:    PUSH:LONG - value to set.
3836 0FC7              ;          PUSH:LONG - pointer to window's port.
3837 0FC7              ;
3838 0FC7              ;  OUT:    None.
3839 0FC7              ;
3840 0FC7              SetWRefCon PROC 
3841 0FC7              ;
3842 0FC7              ;
3843 0FC7              ;
3844 0FC7 20 CA 21              jsr   setup
3845 0FCA              ;
3846 0FCA A0 B2 00              ldy   #wRefCon
3847 0FCD 80 EA                 bra   setWindLong
3848 0FCF                       ENDP 
3849 0FCF              ;
3850 0FCF              ;
3851 0FCF              ;=============================================
3852 0FCF              ;          Set wdefProc in window record.
3853 0FCF              ;=============================================
3854 0FCF              ;
3855 0FCF              ;   IN:    PUSH:LONG - address of new window definition procedure.
3856 0FCF              ;          PUSH:LONG - pointer to window's port.
3857 0FCF              ;
3858 0FCF              ;  OUT:    None.
3859 0FCF              ;
3860 0FCF              SetDefProc PROC 
3861 0FCF              ;
3862 0FCF              ;
3863 0FCF              ;
3864 0FCF              theWind  equ   9
3865 0FCF              newDefProc equ   theWind+4
3866 0FCF              ;
3867 0FCF              ;
3868 0FCF 20 CA 21              jsr   setup
3869 0FD2              ;
3870 0FD2 A0 AE 00              ldy   #wDefProc
3871 0FD5 80 E2                 bra   setWindLong
3872 0FD7                       ENDP 
3873 0FD7              ;
3874 0FD7              ;
3875 0FD7              ;=====================================================
3876 0FD7              ;          Return wdefProc from window record.
3877 0FD7              ;=====================================================
3878 0FD7              ;
3879 0FD7              ;   IN:    PUSH:LONG - pointer to window's port.
3880 0FD7              ;
3881 0FD7              ;  OUT:    LONG - wdefProc from window's record.
3882 0FD7              ;
3883 0FD7              GetDefProc PROC 
3884 0FD7              ;
3885 0FD7              ;
3886 0FD7              theWindow equ   9
3887 0FD7              result   equ   theWindow+4
3888 0FD7              ;
3889 0FD7              ;
3890 0FD7 20 CA 21              jsr   setup
3891 0FDA              ;
3892 0FDA A0 AE 00              ldy   #wDefProc
3893 0FDD 80 0E                 bra   get_long
3894 0FDF                       ENDP 
3895 0FDF              ;
3896 0FDF              ;
3897 0FDF              ;======================================================
3898 0FDF              ;          Return wcontrol from window record.
3899 0FDF              ;======================================================
3900 0FDF              ;
3901 0FDF              ;   IN:    PUSH:LONG - pointer to window's port.
3902 0FDF              ;
3903 0FDF              ;  OUT:    LONG - wcontrol from window's record.
3904 0FDF              ;
3905 0FDF              GetWControls PROC 
3906 0FDF              ;
3907 0FDF              ;
3908 0FDF              theWindow equ   9
3909 0FDF              result   equ   theWindow+4
3910 0FDF              ;
3911 0FDF              ;
3912 0FDF 20 CA 21              jsr   setup
3913 0FE2              ;
3914 0FE2 A0 CA 00              ldy   #wControls
3915 0FE5 80 06                 bra   get_long
3916 0FE7                       ENDP 
3917 0FE7              ;
3918 0FE7              ;
3919 0FE7              ;==================================================
3920 0FE7              ;          Read application's reserved
3921 0FE7              ;          LONG in window record.
3922 0FE7              ;==================================================
3923 0FE7              ;
3924 0FE7              ;   IN:    PUSH:LONG - pointer to window's port.
3925 0FE7              ;
3926 0FE7              ;  OUT:    LONG - application's reserved LONG,
3927 0FE7              ;                 set only by NewWindow and SetWRefCon.
3928 0FE7              ;
3929 0FE7              GetWRefCon PROC Export 
3930 0FE7              ; The listplus application calls GetWRefCon in its custom control procedure.
3931 0FE7              ; Since the control happens to be in the frame of the window, this is causing many
3932 0FE7              ; window manager temps to be destroyed that were not supposed to be destroyed in
3933 0FE7              ; select window.
3934 0FE7              ; Future versions of the window manager should change selectwindow to save and
3935 0FE7              ; restore needed vars around the call to drawentireframe.
3936 0FE7
3937 0FE7 20 CA 21              jsr   setup
3938 0FEA A0 B2 00              ldy   #wRefCon
3939 0FED
3940 0FED                       EndP 
3941 0FED              ;;
3942 0FED              ;
3943 0FED              ; Change getlong to be an internal proc now...
3944 0FED              ; 5/11/89 mensch
3945 0FED              get_long proc                           ;       
3946 0FED              theWind  equ   9
3947 0FED              result   equ   theWind+4
3948 0FED              ;
3949 0FED              ;
3950 0FED B7 A6                 lda   [<wind],y
3951 0FEF 83 0D                 sta   result,s
3952 0FF1 C8                    iny   
3953 0FF2 C8                    iny   
3954 0FF3 B7 A6                 lda   [<wind],y
3955 0FF5 83 0F                 sta   result+2,s
3956 0FF7              ;
3957 0FF7 8B                    phb   
3958 0FF8 82 B8 7F              brl   pop4bytes
3959 0FFB                       ENDP 
3960 0FFB              ;
3961 0FFB              ;
3962 0FFB              ;=========================================
3963 0FFB              ;          Get uContDraw
3964 0FFB              ;=========================================
3965 0FFB              ;
3966 0FFB              ;   IN:    PUSH:LONG - pointer to window's port.
3967 0FFB              ;
3968 0FFB              ;  OUT:    LONG - address of routine to draw window's content region.
3969 0FFB              ;
3970 0FFB              GetCDraw PROC 
3971 0FFB              ;
3972 0FFB              ;
3973 0FFB              ;
3974 0FFB 20 CA 21              jsr   setup
3975 0FFE              ;
3976 0FFE A0 B6 00              ldy   #wContDraw
3977 1001 80 EA                 bra   get_long
3978 1003                       ENDP 
3979 1003              ;
3980 1003              ;
3981 1003              ;====================================================
3982 1003              ;          Return wframe from window record.
3983 1003              ;====================================================
3984 1003              ;
3985 1003              ;   IN:    PUSH:LONG - pointer to window's port.
3986 1003              ;
3987 1003              ;  OUT:    WORD - wframe from window's record.
3988 1003              ;
3989 1003              GetWFrame PROC 
3990 1003              ;
3991 1003              ;
3992 1003              theWindow equ   9
3993 1003              result   equ   theWindow+4
3994 1003              ;
3995 1003              ;
3996 1003 20 CA 21              jsr   setup
3997 1006              ;
3998 1006 A0 D2 00              ldy   #wframe
3999 1009 B7 A6                 lda   [<wind],y
4000 100B 83 0D                 sta   result,s
4001 100D              ;
4002 100D 8B                    phb   
4003 100E 82 A2 7F              brl   pop4bytes
4004 1011                       ENDP 
4005 1011              ;
4006 1011              ;
4007 1011              ;========================================================
4008 1011              ;          Return wstrucRgn from window record.
4009 1011              ;========================================================
4010 1011              ;
4011 1011              ;   IN:    PUSH:LONG - pointer to window's port.
4012 1011              ;
4013 1011              ;  OUT:    LONG - wstrucRgn from window's record.
4014 1011              ;
4015 1011              GetStructRgn PROC 
4016 1011              ;
4017 1011              ;
4018 1011              ;
4019 1011 20 CA 21              jsr   setup
4020 1014              ;
4021 1014 A0 BE 00              ldy   #wStrucRgn
4022 1017 80 D4                 bra   get_long
4023 1019                       ENDP 
4024 1019              ;
4025 1019              ;
4026 1019              ;========================================================
4027 1019              ;          Return wcontRgn from window record.
4028 1019              ;========================================================
4029 1019              ;
4030 1019              ;   IN:    PUSH:LONG - pointer to window's port.
4031 1019              ;
4032 1019              ;  OUT:    LONG - wcontRgn from window's record.
4033 1019              ;
4034 1019              GetContRgn PROC 
4035 1019              ;
4036 1019              ;
4037 1019              ;
4038 1019 20 CA 21              jsr   setup
4039 101C              ;
4040 101C A0 C2 00              ldy   #wContRgn
4041 101F 80 CC                 bra   get_long
4042 1021                       ENDP 
4043 1021              ;
4044 1021              ;
4045 1021              ;========================================================
4046 1021              ;          Return wupdateRgn from window record.
4047 1021              ;========================================================
4048 1021              ;
4049 1021              ;   IN:    PUSH:LONG - pointer to window's port.
4050 1021              ;
4051 1021              ;  OUT:    LONG - wupdateRgn from window's record.
4052 1021              ;
4053 1021              GetUpdateRgn PROC 
4054 1021              ;
4055 1021              ;
4056 1021              ;
4057 1021 20 CA 21              jsr   setup
4058 1024              ;
4059 1024 A0 C6 00              ldy   #wUpdateRgn
4060 1027 80 C4                 bra   get_long
4061 1029                       ENDP 
4062 1029              ;
4063 1029              ;
4064 1029              ;=================================================
4065 1029              ;          Return wnext from window record.
4066 1029              ;=================================================
4067 1029              ;
4068 1029              ;   IN:    PUSH:LONG - pointer to window's port.
4069 1029              ;
4070 1029              ;  OUT:    LONG - pointer to next window's record.
4071 1029              ;
4072 1029              GetNextWindow PROC 
4073 1029              ;
4074 1029              ;
4075 1029              theWind  equ   9
4076 1029              result   equ   theWind+4
4077 1029              ;
4078 1029              ;
4079 1029 20 CA 21              jsr   setup
4080 102C              ;
4081 102C A0 02 00              ldy   #wnext+2                 Get pointer to next window,
4082 102F B7 A6                 lda   [<wind],y
4083 1031 AA                    tax   
4084 1032 88                    dey   
4085 1033 88                    dey   
4086 1034 B7 A6                 lda   [<wind],y
4087 1036 20 08 22              jsr   get_portp2               convert it to a port pointer,
4088 1039 83 0D                 sta   result,s                 and return it.
4089 103B 8A                    txa   
4090 103C 83 0F                 sta   result+2,s
4091 103E              ;
4092 103E 8B                    phb   
4093 103F 82 71 7F              brl   pop4bytes
4094 1042                       ENDP 
4095 1042              ;
4096 1042              ;
4097 1042              ;=========================================
4098 1042              ;          Return the window type.
4099 1042              ;=========================================
4100 1042              ;
4101 1042              ;   IN:    PUSH:LONG - pointer to window's port.
4102 1042              ;
4103 1042              ;  OUT:    WORD - not zero if a system window, zero if application window.
4104 1042              ;
4105 1042              GetSysWFlag PROC 
4106 1042              ;
4107 1042                                                      ;using equates
4108 1042              ;
4109 1042              theWindow equ   9
4110 1042              result   equ   theWindow+4
4111 1042              ;
4112 1042              ;
4113 1042              ;   OUT:   WORD - negative if a system window, positive if an application's.
4114 1042              ;
4115 1042                       ENTRY GetWKind
4116 1042              GetWKind  
4117 1042 20 CA 21              jsr   setup
4118 1045              ;
4119 1045 A0 08 00              ldy   #wport+4
4120 1048 B7 A6                 lda   [<wind],y
4121 104A 29 00 80              and   #$8000                   Get system window flag.
4122 104D 83 0D                 sta   result,s                 Return state to caller.
4123 104F
4124 104F 8B                    phb   
4125 1050 82 60 7F              brl   pop4bytes
4126 1053                       ENDP 
4127 1053              ;
4128 1053              ;
4129 1053              ;
4130 1053              ;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
4131 1053              ;%%%                                                                     %%%
4132 1053              ;%%%   The following Window Manager calls are specific to the window     %%%
4133 1053              ;%%%   defProc.  The Window Manager hands the call off to the defProc.   %%%
4134 1053              ;%%%                                                                     %%%
4135 1053              ;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
4136 1053              ;
4137 1053              ;
4138 1053              ;==================================================
4139 1053              ;          Set application's horizontal
4140 1053              ;          origin mask.
4141 1053              ;==================================================
4142 1053              ;
4143 1053              ;   IN:    PUSH:WORD - value to set.
4144 1053              ;          PUSH:LONG - pointer to window's port.
4145 1053              ;
4146 1053              ;  OUT:    None.
4147 1053              ;
4148 1053              SetOrgnMask PROC 
4149 1053              ;
4150 1053              ;
4151 1053              ;
4152 1053 20 CA 21              jsr   setup
4153 1056              ;
4154 1056 A9 00 00              lda   #wSetOrgMask             Request number.
4155 1059 20 C9 11              jsr   callProc
4156 105C              ;
4157 105C 8B                    phb   
4158 105D 82 5B 7F              brl   pop6bytes
4159 1060                       ENDP 
4160 1060              ;
4161 1060              ;
4162 1060              ;=========================================
4163 1060              ;          Set wmaxheight & wmaxwidth.
4164 1060              ;=========================================
4165 1060              ;
4166 1060              ;   IN:    PUSH:WORD - maximum width of content allowed when sizing the window.
4167 1060              ;          PUSH:WORD - maximum height of content allowed when sizing the window.
4168 1060              ;          PUSH:LONG - pointer to window's port.
4169 1060              ;
4170 1060              ;  OUT:    None.
4171 1060              ;
4172 1060              SetMaxGrow PROC 
4173 1060              ;
4174 1060              ;
4175 1060              ;
4176 1060 20 CA 21              jsr   setup
4177 1063              ;
4178 1063 A9 01 00              lda   #wSetMaxGrow             Request number.
4179 1066 80 69                 bra   setCallProc
4180 1068                       ENDP 
4181 1068              ;
4182 1068              ;
4183 1068              ;=========================================
4184 1068              ;          Set vscroll & hscroll
4185 1068              ;=========================================
4186 1068              ;
4187 1068              ;   IN:    PUSH:WORD - number of pixels to scroll when arrowed in right scroll.
4188 1068              ;          PUSH:WORD - number of pixels to scroll when arrowed in bottom scroll.
4189 1068              ;          PUSH:LONG - pointer to window's port.
4190 1068              ;
4191 1068              ;  OUT:    None.
4192 1068              ;
4193 1068              SetScroll PROC 
4194 1068              ;
4195 1068              ;
4196 1068 20 CA 21              jsr   setup
4197 106B              ;
4198 106B A9 02 00              lda   #wSetScroll              Request number.
4199 106E 80 61                 bra   setCallProc
4200 1070                       ENDP 
4201 1070              ;             
4202 1070              ;
4203 1070              ;=========================================
4204 1070              ;          Set vpage & hpage.
4205 1070              ;=========================================
4206 1070              ;
4207 1070              ;   IN:    PUSH:WORD - number of pixels to scroll when paged in right scroll.
4208 1070              ;          PUSH:WORD - number of pixels to scroll when paged in bottom scroll.
4209 1070              ;          PUSH:LONG - pointer to window's port.
4210 1070              ;
4211 1070              ;  OUT:    None.
4212 1070              ;
4213 1070              SetPage  PROC 
4214 1070              ;
4215 1070              ;
4216 1070              ;
4217 1070 20 CA 21              jsr   setup
4218 1073              ;
4219 1073 A9 03 00              lda   #wSetPage                Request number.
4220 1076 80 59                 bra   setCallProc
4221 1078                       ENDP 
4222 1078              ;
4223 1078              ;
4224 1078              ;=============================================
4225 1078              ;          Set wInfoRef  in window record.
4226 1078              ;=============================================
4227 1078              ;
4228 1078              ;   IN:    PUSH:LONG - pointer to text string to appear in information bar.
4229 1078              ;          PUSH:LONG - pointer to window's port.
4230 1078              ;
4231 1078              ;  OUT:    None.
4232 1078              ;
4233 1078              SetInfoRefCon PROC 
4234 1078              ;
4235 1078              ;
4236 1078              ;
4237 1078 20 CA 21              jsr   setup
4238 107B              ;
4239 107B A9 04 00              lda   #wSetInfoRefCon          Request number.
4240 107E 80 51                 bra   setCallProc
4241 1080                       ENDP 
4242 1080              ;
4243 1080              ;
4244 1080              ;=============================================
4245 1080              ;          Set wInfoDraw in window record.
4246 1080              ;=============================================
4247 1080              ;
4248 1080              ;   IN:    PUSH:LONG - address of routine to draw in information bar.
4249 1080              ;          PUSH:LONG - pointer to window's port.
4250 1080              ;
4251 1080              ;  OUT:    None.
4252 1080              ;
4253 1080              SetInfoDraw PROC 
4254 1080              ;
4255 1080              ;
4256 1080              ;
4257 1080 20 CA 21              jsr   setup
4258 1083              ;
4259 1083 A9 05 00              lda   #wSetInfoDraw            Request number.
4260 1086 80 49                 bra   setCallProc
4261 1088                       ENDP 
4262 1088              ;
4263 1088              ;
4264 1088              ;=========================================
4265 1088              ;          Set y_origin & x_origin.
4266 1088              ;=========================================
4267 1088              ;
4268 1088              ;   IN:    PUSH:WORD - flag, TRUE to scroll content.
4269 1088              ;          PUSH:WORD - x origin of content.
4270 1088              ;          PUSH:WORD - y origin of content.
4271 1088              ;          PUSH:LONG - pointer to window's port.
4272 1088              ;
4273 1088              ;  OUT:    None.
4274 1088              ;
4275 1088              SetCOrigin2 PROC 
4276 1088              ;
4277 1088              ;
4278 1088              ;
4279 1088 20 CA 21              jsr   setup
4280 108B              ;
4281 108B A3 01                 lda   1,s                      Save caller's direct page.
4282 108D A0 34 00              ldy   #callerDpage
4283 1090 97 D8                 sta   [<data],y
4284 1092 8B                    phb   
4285 1093 8B                    phb   
4286 1094 68                    pla   
4287 1095 A0 36 00              ldy   #callerDataB
4288 1098 97 D8                 sta   [<data],y
4289 109A              ;
4290 109A A9 06 00              lda   #wSetOrigin              Request number.
4291 109D 20 C9 11              jsr   callProc                 Call window's defProc.
4292 10A0              ;
4293 10A0              ;
4294 10A0 8B                    phb   
4295 10A1 82 27 7F              brl   pop10bytes
4296 10A4                       ENDP 
4297 10A4              ; 
4298 10A4              ;
4299 10A4              ;=========================================
4300 10A4              ;          Set y_origin & x_origin.
4301 10A4              ;=========================================
4302 10A4              ;
4303 10A4              ;   IN:    PUSH:WORD - x origin of content.
4304 10A4              ;          PUSH:WORD - y origin of content.
4305 10A4              ;          PUSH:LONG - pointer to window's port.
4306 10A4              ;
4307 10A4              ;  OUT:    None.
4308 10A4              ;
4309 10A4              SetCOrigin PROC 
4310 10A4              ;
4311 10A4              ;
4312 10A4              theWindow equ   9
4313 10A4              newYorigin equ   theWindow+4
4314 10A4              newXorigin equ   newYorigin+2
4315 10A4              ;
4316 10A4              ;
4317 10A4 22 64 00 E1           jsl   IncBusyFlg
4318 10A8 0B                    phd                            Save direct page for pop.
4319 10A9              ;
4320 10A9 F4 01 00              pea   1                        Scroll content.
4321 10AC A3 11                 lda   newXorigin+2,s
4322 10AE 48                    pha   
4323 10AF A3 11                 lda   newYorigin+4,s
4324 10B1 48                    pha   
4325 10B2 A3 11                 lda   theWindow+8,s
4326 10B4 48                    pha   
4327 10B5 A3 11                 lda   theWindow+8,s
4328 10B7 48                    pha   
4329 10B8 A2 0E 57 22           _SetContentOrigin2 
4330 10BF              ;
4331 10BF 8B                    phb   
4332 10C0 82 00 7F              brl   pop8bytes
4333 10C3                       ENDP 
4334 10C3              ;
4335 10C3              ;
4336 10C3              ;=========================================
4337 10C3              ;          Set data_h & data_w.
4338 10C3              ;=========================================
4339 10C3              ;
4340 10C3              ;   IN:    PUSH:WORD - width of data size.
4341 10C3              ;          PUSH:WORD - height of data size.
4342 10C3              ;          PUSH:LONG - pointer to window's port.
4343 10C3              ;
4344 10C3              ;  OUT:    None.
4345 10C3              ;
4346 10C3              SetDataSize PROC 
4347 10C3              ;
4348 10C3              ;
4349 10C3              ;
4350 10C3 20 CA 21              jsr   setup
4351 10C6              ;
4352 10C6 A9 07 00              lda   #wSetDataSize            Request number.
4353 10C9 80 06                 bra   setCallProc
4354 10CB                       ENDP 
4355 10CB              ;
4356 10CB              ;
4357 10CB              ;=============================================
4358 10CB              ;          Set new window full size.
4359 10CB              ;=============================================
4360 10CB              ;
4361 10CB              ;   IN:    PUSH:LONG - pointer to RECT to be replace wFull.
4362 10CB              ;          PUSH:LONG - pointer to window's port.
4363 10CB              ;
4364 10CB              ;  OUT:    None.
4365 10CB              ;
4366 10CB              SetZoomRect PROC 
4367 10CB              ;
4368 10CB              ;
4369 10CB              ;
4370 10CB 20 CA 21              jsr   setup
4371 10CE              ;
4372 10CE A9 08 00              lda   #wSetZoomRect            Request number.
4373 10D1              ;
4374 10D1                       ENTRY setCallProc
4375 10D1              setCallProc                             ; 
4376 10D1              ;
4377 10D1 20 C9 11              jsr   callProc                 Call window's defProc.
4378 10D4              ;
4379 10D4 8B                    phb   
4380 10D5 82 EB 7E              brl   pop8bytes
4381 10D8
4382 10D8                       ENDP 
4383 10D8
4384 10D8              ;
4385 10D8              ;
4386 10D8              ;====================================
4387 10D8              ;        Change a window's title
4388 10D8              ;====================================
4389 10D8              ;
4390 10D8              ;  IN:   LONG - pointer to new title.
4391 10D8              ;        LONG - pointer to window port.
4392 10D8              ;
4393 10D8              SetWTitle PROC 
4394 10D8              ;
4395 10D8              ;
4396 10D8              ;
4397 10D8 20 CA 21              jsr   setup
4398 10DB              ;
4399 10DB A9 09 00              lda   #wSetTitle               Request number.
4400 10DE 80 F1                 bra   setCallProc
4401 10E0                       ENDP 
4402 10E0              ;
4403 10E0              ;
4404 10E0              ;==========================================
4405 10E0              ;        Change frame pattern/colors.
4406 10E0              ;==========================================
4407 10E0              ;
4408 10E0              ;  IN:   LONG - pointer to new color table.
4409 10E0              ;        LONG - pointer to window port.
4410 10E0              ;
4411 10E0              ; OUT:   Nothing.
4412 10E0              ;
4413 10E0              SetFrameColor PROC 
4414 10E0              ;
4415 10E0              ;
4416 10E0              theWind  equ   9
4417 10E0              colorTable equ   theWind+4
4418 10E0              ;
4419 10E0              ;
4420 10E0 20 CA 21              jsr   setup                    Put input parameters in zero page.
4421 10E3              ;
4422 10E3 A3 09                 lda   theWind,s                Set window's color table or system
4423 10E5 D0 04                 bne   ok1                      default color table?
4424 10E7 A3 0A                 lda   theWind+1,s
4425 10E9 F0 05                 beq   skip1
4426 10EB              ;
4427 10EB A9 0A 00     ok1      lda   #wSetColorTable          Request number.
4428 10EE 80 E1                 bra   setCallProc
4429 10F0              ;
4430 10F0              ;
4431 10F0 A3 0D        skip1    lda   colorTable,s             Use default table?
4432 10F2 D0 0E                 bne   ok2
4433 10F4 A3 0F                 lda   colorTable+2,s
4434 10F6 D0 0A                 bne   ok2
4435 10F8              ;
4436 10F8 A9 7C 22              lda   #def_color               Use default color table.
4437 10FB 83 0D                 sta   colorTable,s
4438 10FD A9 FD 00              lda   #def_color>>16
4439 1100 83 0F                 sta   colorTable+2,s
4440 1102              ;
4441 1102 A0 0A 00     ok2      ldy   #defWindClr              New default color table.
4442 1105 A3 0D                 lda   colorTable,s
4443 1107 97 D8                 sta   [<data],y
4444 1109 C8                    iny   
4445 110A C8                    iny   
4446 110B A3 0F                 lda   colorTable+2,s
4447 110D 97 D8                 sta   [<data],y
4448 110F 8B                    phb   
4449 1110 82 B0 7E              brl   pop8bytes
4450 1113              ;
4451 1113                       ENDP 
4452 1113              ;
4453 1113              ;
4454 1113              ;=============================================
4455 1113              ;          Set wframe in window record.
4456 1113              ;=============================================
4457 1113              ;
4458 1113              ;   IN:    PUSH:WORD - new wframe for window's record.
4459 1113              ;          PUSH:LONG - pointer to window's port.
4460 1113              ;
4461 1113              ;  OUT:    None.
4462 1113              ;
4463 1113              SetWFrame PROC 
4464 1113              ;
4465 1113              ;
4466 1113              ;
4467 1113 20 CA 21              jsr   setup
4468 1116              ;
4469 1116 A9 0B 00              lda   #wSetFrameFlag
4470 1119 20 C9 11              jsr   callProc                 Call window's defProc.
4471 111C              ;
4472 111C 8B                    phb   
4473 111D 82 9B 7E              brl   pop6bytes
4474 1120                       ENDP 
4475 1120              ;             
4476 1120              ;
4477 1120              ;=========================================
4478 1120              ;          Get wmaxheight & wmaxwidth.
4479 1120              ;=========================================
4480 1120              ;
4481 1120              ;   IN:    PUSH:LONG - pointer to window's port.
4482 1120              ;              
4483 1120              ;  OUT:    LONG - high word = max width, low word = max height.
4484 1120              ;
4485 1120              GetMaxGrow PROC 
4486 1120              ;
4487 1120              ;
4488 1120              theWindow equ   9
4489 1120              result   equ   theWindow+4
4490 1120              ;
4491 1120              ;
4492 1120 20 CA 21              jsr   setup
4493 1123              ;
4494 1123 A9 0D 00              lda   #wGetMaxGrow
4495 1126              ;
4496 1126                       ENTRY getProcLong
4497 1126              getProcLong                             ; 
4498 1126              ;
4499 1126 20 C9 11              jsr   callProc                 Call window's defProc.
4500 1129 83 0D                 sta   result,s
4501 112B 8A                    txa   
4502 112C 83 0F                 sta   result+2,s
4503 112E              ;
4504 112E 8B                    phb   
4505 112F 82 81 7E              brl   pop4bytes
4506 1132                       ENDP 
4507 1132              ;             
4508 1132              ;
4509 1132              ;=========================================
4510 1132              ;          Set vscroll & hscroll
4511 1132              ;=========================================
4512 1132              ;
4513 1132              ;   IN:    PUSH:LONG - pointer to window's port.
4514 1132              ;              
4515 1132              ;  OUT:    LONG - high word = number of pixels scrolled horizontally,
4516 1132              ;                 low word = number of pixels scrolled vertically.
4517 1132              ;
4518 1132              GetScroll PROC 
4519 1132              ;
4520 1132              ;
4521 1132              ;
4522 1132 20 CA 21              jsr   setup
4523 1135              ;
4524 1135 A9 0E 00              lda   #wGetScroll
4525 1138 80 EC                 bra   getProcLong
4526 113A                       ENDP 
4527 113A              ;             
4528 113A              ;
4529 113A              ;=========================================
4530 113A              ;          Get vpage & hpage.
4531 113A              ;=========================================
4532 113A              ;
4533 113A              ;   IN:    PUSH:LONG - pointer to window's port.
4534 113A              ;              
4535 113A              ;  OUT:    LONG - high word = number of pixels paged horizontally,
4536 113A              ;                 low word = number of pixels paged vertically.
4537 113A              ;
4538 113A              GetPage  PROC 
4539 113A              ;
4540 113A              ;
4541 113A 20 CA 21              jsr   setup
4542 113D              ;
4543 113D A9 0F 00              lda   #wGetPage
4544 1140 80 E4                 bra   getProcLong
4545 1142                       ENDP 
4546 1142              ;
4547 1142              ;
4548 1142              ;=======================================================
4549 1142              ;          Return wInfoRef from window record.
4550 1142              ;=======================================================
4551 1142              ;
4552 1142              ;   IN:    PUSH:LONG - pointer to window's port.
4553 1142              ;
4554 1142              ;  OUT:    LONG - wInfoRef field in window record.
4555 1142              ;
4556 1142              GetInfoRefCon PROC 
4557 1142              ;
4558 1142              ;
4559 1142              ;
4560 1142 20 CA 21              jsr   setup
4561 1145              ;
4562 1145 A9 10 00              lda   #wGetInfoRefCon
4563 1148 80 DC                 bra   getProcLong
4564 114A                       ENDP 
4565 114A              ;
4566 114A              ;
4567 114A              ;=======================================================
4568 114A              ;          Return wInfoDraw from window record.
4569 114A              ;=======================================================
4570 114A              ;
4571 114A              ;   IN:    PUSH:LONG - pointer to window's port.
4572 114A              ;
4573 114A              ;  OUT:    LONG - wInfoDraw from window's record.
4574 114A              ;
4575 114A              GetInfoDraw PROC 
4576 114A              ;
4577 114A              ;
4578 114A 20 CA 21              jsr   setup
4579 114D              ;
4580 114D A9 11 00              lda   #wGetInfoDraw
4581 1150 80 D4                 bra   getProcLong
4582 1152                       ENDP 
4583 1152              ;
4584 1152              ;
4585 1152              ;=========================================
4586 1152              ;          Get y_origin & x_origin.
4587 1152              ;=========================================
4588 1152              ;
4589 1152              ;   IN:    PUSH:LONG - pointer to window's port.
4590 1152              ;
4591 1152              ;  OUT:    LONG - high word = x origin, low word = y origin.
4592 1152              ;
4593 1152              GetCOrigin PROC 
4594 1152              ;
4595 1152              ;
4596 1152              ;
4597 1152 20 CA 21              jsr   setup
4598 1155              ;
4599 1155 A9 12 00              lda   #wGetOrigin
4600 1158 80 CC                 bra   getProcLong
4601 115A                       ENDP 
4602 115A              ;
4603 115A              ;
4604 115A              ;=========================================
4605 115A              ;          Get data_h & data_w.
4606 115A              ;=========================================
4607 115A              ;
4608 115A              ;   IN:    PUSH:LONG - pointer to window's port.
4609 115A              ;           
4610 115A              ;  OUT:    LONG - high word = width of data, low word = height of data area.
4611 115A              ;
4612 115A              GetDataSize PROC 
4613 115A              ;
4614 115A              ;
4615 115A              ;
4616 115A 20 CA 21              jsr   setup
4617 115D              ;
4618 115D A9 13 00              lda   #wGetDataSize
4619 1160 80 C4                 bra   getProcLong
4620 1162                       ENDP 
4621 1162              ;
4622 1162              ;
4623 1162              ;=============================================
4624 1162              ;          Return pointer to zoom RECT.
4625 1162              ;=============================================
4626 1162              ;
4627 1162              ;   IN:    PUSH:LONG - pointer to window's port.
4628 1162              ;
4629 1162              ;  OUT:    LONG - pointer to wFull in window's record.
4630 1162              ;
4631 1162              GetZoomRect PROC 
4632 1162              ;
4633 1162              ;
4634 1162              ;
4635 1162 20 CA 21              jsr   setup
4636 1165              ;
4637 1165 A9 14 00              lda   #wGetZoomRect
4638 1168 80 BC                 bra   getProcLong
4639 116A                       ENDP 
4640 116A              ;
4641 116A              ;
4642 116A              ;================================================
4643 116A              ;        Return address of window's title.
4644 116A              ;================================================
4645 116A              ;
4646 116A              ;  IN:   LONG - pointer to window port.
4647 116A              ;
4648 116A              ; OUT:   LONG - pointer to title.
4649 116A              ;
4650 116A              GetWTitle PROC 
4651 116A              ;
4652 116A 20 CA 21              jsr   setup
4653 116D              ;
4654 116D A9 15 00              lda   #wGetTitle
4655 1170 80 B4                 bra   getProcLong
4656 1172                       ENDP 
4657 1172              ;
4658 1172              ;
4659 1172              ;==========================================
4660 1172              ;        Return frame pattern/colors.
4661 1172              ;==========================================
4662 1172              ;
4663 1172              ;  IN:     PUSH:LONG - pointer to place to store color table.
4664 1172              ;          PUSH:LONG - pointer to window port.
4665 1172              ;
4666 1172              ; OUT:     Nothing.
4667 1172              ;
4668 1172              GetFrameColor PROC 
4669 1172              ;
4670 1172                                                      ;using equates
4671 1172              ;
4672 1172              theWind  equ   9
4673 1172              desTable equ   theWind+4
4674 1172              ;
4675 1172              ;
4676 1172 20 CA 21              jsr   setup
4677 1175              ;
4678 1175 A9 16 00              lda   #wGetColorTable          Ask defProc for color table pointer
4679 1178 20 C9 11              jsr   callProc
4680 117B 85 DE                 sta   <work                    Store pointer to color table.
4681 117D 86 E0                 stx   <work+2
4682 117F              ;
4683 117F              @WorkOK   
4684 117F A3 0D                 lda   desTable,s               Get pointer to destination table.
4685 1181 85 E2                 sta   <work+4
4686 1183 A3 0F                 lda   desTable+2,s
4687 1185 85 E4                 sta   <work+6
4688 1187              ;
4689 1187 A0 08 00              ldy   #8                       Clone color table into given table.
4690 118A B7 DE        lop1     lda   [<work],y
4691 118C 97 E2                 sta   [<work+4],y
4692 118E 88                    dey   
4693 118F 88                    dey   
4694 1190 10 F8                 bpl   lop1
4695 1192              ;
4696 1192 8B                    phb   
4697 1193 82 2D 7E              brl   pop8bytes
4698 1196                       ENDP 
4699 1196              ;
4700 1196              ;
4701 1196              ;=============================================
4702 1196              ;          Return the RECT of a
4703 1196              ;          window's information bar.
4704 1196              ;=============================================
4705 1196              ;
4706 1196              ;   IN:    PUSH:LONG - pointer to destination RECT for information bar RECT.
4707 1196              ;          PUSH:LONG - pointer to window's port.
4708 1196              ;
4709 1196              ;  OUT:    None.
4710 1196              ;
4711 1196              GetRectInfo PROC 
4712 1196              ;
4713 1196              ;
4714 1196              ;
4715 1196 20 CA 21              jsr   setup
4716 1199              ;
4717 1199 A9 18 00              lda   #wGetInfoRect
4718 119C 20 C9 11              jsr   callProc
4719 119F              ;
4720 119F 8B                    phb   
4721 11A0 82 20 7E              brl   pop8bytes
4722 11A3                       ENDP 
4723 11A3              ;
4724 11A3              ;
4725 11A3              ;=======================================================
4726 11A3              ;          Draw the interior of the info bar.
4727 11A3              ;========================================================
4728 11A3              ;
4729 11A3              ;   IN:    PUSH:LONG - pointer to window port.
4730 11A3              ;
4731 11A3              ;  OUT:    None.
4732 11A3              ;
4733 11A3              DrawInfoBar PROC 
4734 11A3              ;
4735 11A3              ;
4736 11A3              ;
4737 11A3 20 CA 21              jsr   setup
4738 11A6              ;
4739 11A6 A9 19 00              lda   #wDrawInfo
4740 11A9 20 C9 11              jsr   callProc                 Call window's defProc.
4741 11AC              ;
4742 11AC 8B           exit     phb   
4743 11AD 82 03 7E              brl   pop4bytes
4744 11B0                       ENDP 
4745 11B0              ;
4746 11B0              ;
4747 11B0              ;=======================================================
4748 11B0              ;          Set up to draw in information bar.
4749 11B0              ;========================================================
4750 11B0              ;
4751 11B0              ;   IN:    PUSH:LONG - pointer to destination RECT for information bar RECT.
4752 11B0              ;          PUSH:LONG - pointer to window's port.
4753 11B0              ;
4754 11B0              ;  OUT:    None.
4755 11B0              ;
4756 11B0              StartInfoDraw PROC 
4757 11B0              ;
4758 11B0              ;
4759 11B0 20 CA 21              jsr   setup
4760 11B3              ;
4761 11B3 A9 1A 00              lda   #wStartInfoDraw
4762 11B6 82 18 FF              brl   setCallProc              Call window's defProc.
4763 11B9                       ENDP 
4764 11B9              ;
4765 11B9              ;
4766 11B9              ;=======================================================
4767 11B9              ;          Reste Window Manager's port
4768 11B9              ;          after StartInfoDrawing call.
4769 11B9              ;========================================================
4770 11B9              ;
4771 11B9              ;   IN:    None.
4772 11B9              ;
4773 11B9              ;  OUT:    None.
4774 11B9              ;
4775 11B9              EndInfoDrawing PROC 
4776 11B9              ;
4777 11B9              ;
4778 11B9 22 64 00 E1           jsl   IncBusyFlg
4779 11BD 0B                    phd                            Save original zero page.
4780 11BE 5B                    tcd                            Switch to my zero page.
4781 11BF              ;
4782 11BF A9 1B 00              lda   #wEndInfoDraw
4783 11C2 20 C9 11              jsr   callProc
4784 11C5              ;
4785 11C5 8B                    phb   
4786 11C6 82 DA 7D              brl   pop0bytes
4787 11C9                       ENDP 
4788 11C9              ;
4789 11C9              ;
4790 11C9              ;==============================================================
4791 11C9              ;          Call window defProc through generic entry.
4792 11C9              ;==============================================================
4793 11C9              ;
4794 11C9              ;   IN:    a = request number.
4795 11C9              ;
4796 11C9                       EXPORT callProc
4797 11C9              callProc PROC 
4798 11C9              ;
4799 11C9                                                      ;using equates
4800 11C9              ;
4801 11C9              theWind  equ   11
4802 11C9              newParam equ   theWind+4
4803 11C9              ;
4804 11C9              ;
4805 11C9 48                    pha   
4806 11CA              ;
4807 11CA A3 15                 lda   newParam+6,s
4808 11CC 85 DE                 sta   <work
4809 11CE A3 13                 lda   newParam+4,s
4810 11D0 A8                    tay   
4811 11D1 A3 11                 lda   newParam+2,s
4812 11D3 AA                    tax   
4813 11D4              ;
4814 11D4 68                    pla   
4815 11D5              ;
4816 11D5              ;
4817 11D5              ; = = = = = = = = = = = = = = = = = = = = = =
4818 11D5              ;          Call window defProc.
4819 11D5              ; = = = = = = = = = = = = = = = = = = = = = =
4820 11D5              ;
4821 11D5              ;   IN:    a = request number.
4822 11D5              ;          x = newParam.
4823 11D5              ;          y = newParam+2
4824 11D5              ;          work = newParam+4
4825 11D5              ;
4826 11D5              ;  OUT:    x/a = returned value from defProc.
4827 11D5              ;
4828 11D5                       EXPORT callProc2
4829 11D5              callProc2                               ; 
4830 11D5              ;
4831 11D5 5A                    phy   
4832 11D6              ;
4833 11D6              ;
4834 11D6              ; --- Initialize call procedure list -------------------------
4835 11D6              ;
4836 11D6 A0 C2 01              ldy   #callProcList            Set request number.
4837 11D9 97 D8                 sta   [<data],y
4838 11DB C8                    iny   
4839 11DC C8                    iny   
4840 11DD A9 00 00              lda   #0                       Set defProc ID.
4841 11E0 97 D8                 sta   [<data],y
4842 11E2 C8                    iny   
4843 11E3 C8                    iny   
4844 11E4 8A                    txa   
4845 11E5 97 D8                 sta   [<data],y                Set new parameter.
4846 11E7 C8                    iny   
4847 11E8 C8                    iny   
4848 11E9 68                    pla   
4849 11EA 97 D8                 sta   [<data],y
4850 11EC C8                    iny   
4851 11ED C8                    iny   
4852 11EE A5 DE                 lda   <work
4853 11F0 97 D8                 sta   [<data],y
4854 11F2              ;
4855 11F2 20 50 21              jsr   pushcallProcList
4856 11F5 68                    pla                            Pass proc list pointer to defProc.
4857 11F6 85 C4                 sta   <param
4858 11F8 68                    pla   
4859 11F9 85 C6                 sta   <param+2
4860 11FB              ;
4861 11FB A2 0A 00              ldx   #wCallDefProc            Have window defProc perform operation.
4862 11FE 82 18 0E              brl   dispatch
4863 1201                       ENDP 
4864 1201              ;
4865 1201              ;            APPEND	WNEW.ASM
4866 1201                       TITLE 'Apple IIGS Window Manager                   WNEW.ASM' 
4867 1201              ;
4868 1201              ;          Copyright Apple Computer, Inc. 1986,1987,1988
4869 1201              ;          All rights reserved
4870 1201              ;          Written by Dan Oliver
4871 1201              ;
4872 1201              ;
4873 1201              ;
4874 1201              ;==================================
4875 1201              ;        Create a New Window.
4876 1201              ;==================================
4877 1201              ;
4878 1201              ;   IN:    PUSH:LONG - space for result.
4879 1201              ;          PUSH:LONG - pointer to window parameter list.
4880 1201              ;
4881 1201              ; OUT:     LONG - pointer to window's port if OK, zero if error.
4882 1201              ;
4883 1201              NewWindow PROC 
4884 1201              ;
4885 1201                                                      ;using equates
4886 1201              ;
4887 1201              param_list equ   9
4888 1201              ret_wind equ   param_list+4
4889 1201              ;
4890 1201              ;
4891 1201              ; --- New parameter list offsets -----------------------------
4892 1201              ;
4893 1201              paramID  equ   0                        ID of parameter list.
4894 1201              newDefProc equ   paramID+2              DefProc of window.
4895 1201              newData  equ   newDefProc+4             Additional data for new window.
4896 1201              ;
4897 1201              ;
4898 1201 22 64 00 E1           jsl   IncBusyFlg
4899 1205
4900 1205 0B                    phd                            Save caller's direct page pointer.
4901 1206 5B                    tcd                            Switch to my direct page.
4902 1207              ;
4903 1207 A3 09                 lda   param_list,s             Get pointer to parameter list.
4904 1209 85 C4                 sta   <param
4905 120B A3 0B                 lda   param_list+2,s
4906 120D 85 C6                 sta   <param+2
4907 120F              ;
4908 120F A9 00 00              lda   #0                       No window, just in case.
4909 1212 83 0D                 sta   ret_wind,s
4910 1214 83 0F                 sta   ret_wind+2,s
4911 1216              ;
4912 1216              ;
4913 1216              ; --- Ask defProc for record size ----------------------------
4914 1216              ;
4915 1216 A7 C4                 lda   [<param]                 What kind of parameter list do I have?
4916 1218 F0 1A                 beq   ok1
4917 121A              ;
4918 121A              ;
4919 121A              ; ------ Old parameter list ----------------------------------
4920 121A              ;
4921 121A A0 02 00              ldy   #2                       Document or Alert window?
4922 121D B7 C4                 lda   [<param],y
4923 121F 29 00 20              and   #F_ALERT
4924 1222 D0 08                 bne   alertProc
4925 1224              ;
4926 1224 A9 52 43              lda   #docDefProc              Address of document defProc.
4927 1227 A0 43 FD              ldy   #docDefProc>>8
4928 122A 80 12                 bra   enter1
4929 122C              ;
4930 122C A9 11 52     alertProc lda   #alertDefProc           Address of alert defProc.
4931 122F A0 52 FD              ldy   #alertDefProc>>8
4932 1232 80 0A                 bra   enter1
4933 1234              ;
4934 1234              ;
4935 1234              ; ------ New parameter list ----------------------------------
4936 1234              ;
4937 1234 A0 03 00     ok1      ldy   #newDefProc+1            Pass address of custom defProc.
4938 1237 B7 C4                 lda   [<param],y
4939 1239 48                    pha   
4940 123A 88                    dey   
4941 123B B7 C4                 lda   [<param],y
4942 123D 7A                    ply   
4943 123E              ;
4944 123E 85 AE        enter1   sta   <workptr                 Remember the defProc address.
4945 1240 84 AF                 sty   <workptr+1
4946 1242 A2 07 00              ldx   #wRecSize                Pass operation number.
4947 1245 64 A6                 stz   <wind                    Pass invalid window pointer.
4948 1247 64 A8                 stz   <wind+2
4949 1249 20 23 20              jsr   dispatch2                Ask defProc for extra window record size.
4950 124C 85 A6                 sta   <wind                    Save possible window record.
4951 124E 86 A8                 stx   <wind+2
4952 1250 B0 15                 bcs   errorExit1
4953 1252 9B                    txy                            Should the record even be allocated?
4954 1253 30 3B                 bmi   skip1
4955 1255              ;
4956 1255              ;
4957 1255              ; --- Allocate a window record -------------------------------
4958 1255              ;
4959 1255 18                    clc                            Add window record header size
4960 1256 69 D4 00              adc   #WHEADERSIZE             to addtional size needed by defProc.
4961 1259 85 DE                 sta   <work                    Remember size.
4962 125B 20 C5 21              jsr   allocate                 Allocate a window record.
4963 125E 85 A6                 sta   <wind                    Store handle of window record.
4964 1260 86 A8                 stx   <wind+2
4965 1262 90 07                 bcc   ok4                      Error allocating window?
4966 1264              ;
4967 1264 A0 02 0E              ldy   #allocateErr             Return error code.
4968 1267 8B           errorExit1 phb   
4969 1268 82 4B 7D              brl   Epop4bytes               Pop 4 bytes and pass error code.
4970 126B              ;
4971 126B A0 02 00     ok4      ldy   #2                       Deference handle.
4972 126E B7 A6                 lda   [<wind],y
4973 1270 A8                    tay   
4974 1271 A7 A6                 lda   [<wind]
4975 1273 85 A6                 sta   <wind                    Pointer to window record.
4976 1275 84 A8                 sty   <wind+2
4977 1277              ;
4978 1277              ;
4979 1277              ; --- Zero the window record -----------------------
4980 1277              ;
4981 1277 A5 DE                 lda   <work                    Get size of record.
4982 1279 29 FE FF              and   #$FFFE                   Make sure it's even.
4983 127C A8                    tay   
4984 127D A9 00 00              lda   #0
4985 1280 80 02                 bra   enter3
4986 1282 97 A6        lop3     sta   [<wind],y
4987 1284 88           enter3   dey   
4988 1285 88                    dey   
4989 1286 10 FA                 bpl   lop3
4990 1288              ;
4991 1288 A0 D2 00              ldy   #wframe                  Set flag to show record was allocated.
4992 128B A9 04 00              lda   #F_ALLOCATE
4993 128E 97 A6                 sta   [<wind],y
4994 1290              skip1     
4995 1290              ;
4996 1290              ;
4997 1290              ; --- Open graf port for window ------------------------------
4998 1290              ;
4999 1290 A5 A8                 lda   <wind+2
5000 1292 29 FF 7F              and   #$7FFF
5001 1295 85 A8                 sta   <wind+2
5002 1297              ;
5003 1297 20 48 20              jsr   save_port                Save current port.
5004 129A              ;
5005 129A 20 04 22              jsr   get_portptr              Compute where in record port goes.
5006 129D DA                    phx   
5007 129E 48                    pha   
5008 129F A2 04 18 22           _OpenPort 
5009 12A6 90 0A                 bcc   ok5                      Error opening port?
5010 12A8              ;
5011 12A8 A8                    tay                            Place error code in y.
5012 12A9 5A           errorExit2 phy                          Save error code.
5013 12AA 20 60 20              jsr   restore_port             Restore original port.
5014 12AD 7A                    ply                            Return error code in Y.
5015 12AE 8B                    phb   
5016 12AF 82 04 7D              brl   Epop4bytes               Pop 4 bytes and pass error code.
5017 12B2              ;
5018 12B2              ;
5019 12B2              ; --- Set window's defProc -----------------------------------
5020 12B2              ;
5021 12B2 A0 AE 00     ok5      ldy   #wDefProc
5022 12B5 A5 AE                 lda   <workptr
5023 12B7 97 A6                 sta   [<wind],y
5024 12B9 C8                    iny   
5025 12BA A5 AF                 lda   <workptr+1
5026 12BC 97 A6                 sta   [<wind],y
5027 12BE              ;
5028 12BE              ;
5029 12BE              ; --- Ask the defProc for the window port size and position --
5030 12BE              ;
5031 12BE A2 08 00              ldx   #wPosition               Pass operation number.
5032 12C1 20 19 20              jsr   dispatch
5033 12C4 B0 E3                 bcs   errorExit2
5034 12C6              ;
5035 12C6 85 AE                 sta   <workptr                 Store pointer to position RECT.
5036 12C8 86 B0                 stx   <workptr+2
5037 12CA A0 06 00              ldy   #x2                      Move position RECT into 'wrect'.
5038 12CD B7 AE        lop2     lda   [<workptr],y
5039 12CF BB                    tyx   
5040 12D0 95 9E                 sta   <wrect,x
5041 12D2 88                    dey   
5042 12D3 88                    dey   
5043 12D4 10 F7                 bpl   lop2
5044 12D6              ;
5045 12D6              ;
5046 12D6              ; --- Set the width and height of the window (and put content RECT into wrect).
5047 12D6              ;
5048 12D6 A5 A4                 lda   <wrect+x2                Compute window's width.
5049 12D8 38                    sec   
5050 12D9 E5 A0                 sbc   <wrect+x1
5051 12DB 48                    pha                            Pass width.
5052 12DC A5 A2                 lda   <wrect+y2                Compute window's height.
5053 12DE 38                    sec   
5054 12DF E5 9E                 sbc   <wrect+y1
5055 12E1 48                    pha                            Pass height.
5056 12E2 A2 04 21 22           _SetPortSize                   Set size of window's port.
5057 12E9              ;
5058 12E9              ;
5059 12E9              ; --- Position Bounds RECT so window will be in the correct position ----
5060 12E9              ;
5061 12E9 D4 A0                 pei   <wrect+x1
5062 12EB D4 9E                 pei   <wrect+y1
5063 12ED A2 04 22 22           _MovePortTo 
5064 12F4              ;
5065 12F4 20 6E 22              jsr   zeroOrigin               SetOrigin( 0,0,).
5066 12F7              ;
5067 12F7              ;
5068 12F7              ; --- Allocate regions for window -----------------------
5069 12F7              ;
5070 12F7 A0 BE 00              ldy   #wstrucRgn               First region in record.
5071 12FA 5A           lop5     phy                            Save.
5072 12FB              ;
5073 12FB 48                    pha                            Return space for region handle.
5074 12FC 48                    pha   
5075 12FD A2 04 67 22           _NewRgn                        Allocate an empty region.
5076 1304              ;
5077 1304 68                    pla   
5078 1305 FA                    plx   
5079 1306 7A                    ply   
5080 1307 97 A6                 sta   [<wind],y                Store the region handle in the window.
5081 1309 C8                    iny   
5082 130A C8                    iny   
5083 130B 8A                    txa   
5084 130C 97 A6                 sta   [<wind],y
5085 130E C8                    iny   
5086 130F C8                    iny   
5087 1310 C0 CA 00              cpy   #wstrucRgn+12            All 3 regions allocated?
5088 1313 D0 E5                 bne   lop5
5089 1315              ;
5090 1315              ;
5091 1315              ; --- Let window initialize anything else -----------
5092 1315              ;
5093 1315 20 A8 1F              jsr   moveWMgrOnWind           Move Window Manager's port on window.
5094 1318              ;
5095 1318 A2 03 00              ldx   #wNew                    Initialize flag.
5096 131B 20 19 20              jsr   dispatch                 Pass message to window.
5097 131E              ;
5098 131E 20 E8 13              jsr   getWMgrCtls              Move control list into window and
5099 1321              ;                                     call moveWmgrBack.
5100 1321              ;
5101 1321              ;
5102 1321              ; --- Draw new Window ---------------------
5103 1321              ;
5104 1321              ; ------- Will new window cause the current top window to go under? ----
5105 1321              ;
5106 1321 A0 D2 00              ldy   #wframe                  Start as unhilited.
5107 1324 B7 A6                 lda   [<wind],y
5108 1326 29 FE FF              and   #_F_HILITED
5109 1329 97 A6                 sta   [<wind],y
5110 132B              ;
5111 132B A2 09 00              ldx   #wBehind
5112 132E 20 19 20              jsr   dispatch
5113 1331 85 AE                 sta   <workptr                 workptr = where to send new window.
5114 1333 86 B0                 stx   <workptr+2
5115 1335              ;
5116 1335 20 48 22              jsr   testVis                  Test the window's F_VIS flag.
5117 1338 D0 0F                 bne   ok3                      Is the new window visible?
5118 133A              ;
5119 133A A0 22 00              ldy   #wport+GP_VisRgn+2       Set window's VisRgn to empty.
5120 133D 20 F9 21              jsr   pushandle
5121 1340 A2 04 6A 22           _SetEmptyRgn 
5122 1347 80 4B                 bra   skip2
5123 1349              ;
5124 1349 A9 FF FF     ok3      lda   #$FFFF
5125 134C C5 AE                 cmp   <workptr
5126 134E D0 44                 bne   skip2
5127 1350 C5 B0                 cmp   <workptr+2
5128 1352 D0 40                 bne   skip2
5129 1354              ;
5130 1354 20 96 20              jsr   find_top                 Find the top most visible window.
5131 1357 F0 3B                 beq   skip2                    Is there a top?
5132 1359              ;
5133 1359              ;
5134 1359              ; ----------- Unhilite top most window -----------------------------------
5135 1359              ;
5136 1359 D4 B0                 pei   <workptr+2               Save behind parameter.
5137 135B D4 AE                 pei   <workptr
5138 135D D4 A8                 pei   <wind+2                  Save window pointer.
5139 135F D4 A6                 pei   <wind
5140 1361              ;
5141 1361 85 A6                 sta   <wind                    Put pointer to top most visible window
5142 1363 86 A8                 stx   <wind+2                  into 'wind'.
5143 1365              ;
5144 1365 A0 AA 01              ldy   #WindGlobal              Is unhiliting turned off?
5145 1368 B7 D8                 lda   [<data],y
5146 136A D0 1C                 bne   skip3
5147 136C              ;
5148 136C A0 C0 00              ldy   #wstrucRgn+2             Pass handle window's StructRgn.
5149 136F 20 F9 21              jsr   pushandle
5150 1372 20 87 21              jsr   pushGray                 Pass handle of desktop.
5151 1375 20 9A 21              jsr   pushclip                 Pass clip region handle.
5152 1378 A2 04 71 22           _SectRgn                       Set clip to window and desktop.
5153 137F              ;
5154 137F 20 F3 1E              jsr   unhilite                 Inactivate top window.
5155 1382 20 D8 1E              jsr   deactivate               Send deactivate message to window.
5156 1385 20 82 1F              jsr   drawframe                Draw inactivated window.
5157 1388              ;
5158 1388 68           skip3    pla                            Restore new window pointer.
5159 1389 85 A6                 sta   <wind
5160 138B 68                    pla   
5161 138C 85 A8                 sta   <wind+2
5162 138E 68                    pla   
5163 138F 85 AE                 sta   <workptr
5164 1391 68                    pla   
5165 1392 85 B0                 sta   <workptr+2
5166 1394              ;
5167 1394              ;
5168 1394 20 C4 08     skip2    jsr   fullport                 Set clip to full desktop.
5169 1397              ;
5170 1397 A5 AE                 lda   <workPtr
5171 1399 05 B0                 ora   <workPtr+2
5172 139B D0 06                 bne   ok2
5173 139D              ;
5174 139D C6 B0                 dec   <workPtr+2               Make $FFFF
5175 139F C6 AE                 dec   <workPtr
5176 13A1 C6 AE                 dec   <workPtr                 Make $FFFE to send behind all others.
5177 13A3              ;
5178 13A3 20 89 1C     ok2      jsr   fixworkptr               Make workptr a window pointer if plus.
5179 13A6 20 13 1F              jsr   intolist                 Put window into list.
5180 13A9              ;
5181 13A9 20 96 20              jsr   find_top                 Find the top most visible window.
5182 13AC C5 A6                 cmp   <wind                    Is the new window top?
5183 13AE D0 0A                 bne   skip4
5184 13B0 E4 A8                 cpx   <wind+2
5185 13B2 D0 06                 bne   skip4
5186 13B4              ;
5187 13B4 20 E9 1E              jsr   hilite                   Hilite new window.
5188 13B7 20 C7 1E              jsr   activate                 Send activate message to window.
5189 13BA              ;
5190 13BA              ;
5191 13BA              ; --- Compute visible content regions for every window --------
5192 13BA              ;
5193 13BA 20 17 08     skip4    jsr   calc_vis
5194 13BD              ;
5195 13BD              ;
5196 13BD              ; --- Draw new window -----------------------------------------
5197 13BD              ;
5198 13BD 20 AD 21              jsr   alloc_rgn                Allocate a work region.
5199 13C0              ;
5200 13C0 A0 C0 00              ldy   #wstrucRgn+2
5201 13C3 20 F9 21              jsr   pushandle
5202 13C6 20 80 21              jsr   pushrgnptr
5203 13C9 A2 04 69 22           _CopyRgn                       Draw the whole window.
5204 13D0              ;
5205 13D0 20 BF 06              jsr   PaintOne                 Draw the window.
5206 13D3              ;
5207 13D3 20 78 26              jsr   disposeRgnPtr            Free work region.
5208 13D6              ;
5209 13D6              ;
5210 13D6              ; --- Return pointer to window ------------
5211 13D6              ;
5212 13D6 20 04 22              jsr   get_portptr              Get pointer to window's port.
5213 13D9 83 0D                 sta   ret_wind,s
5214 13DB 8A                    txa   
5215 13DC 83 0F                 sta   ret_wind+2,s
5216 13DE              ;
5217 13DE 20 60 20              jsr   restore_port             Restore original port.
5218 13E1 20 60 20              jsr   restore_port             Restore original port.
5219 13E4              ;
5220 13E4 8B                    phb   
5221 13E5 82 CB 7B              brl   pop4bytes
5222 13E8                       ENDP 
5223 13E8              ;
5224 13E8              ;
5225 13E8              ;=======================================================================
5226 13E8              ;          Move control list into window and call moveWMgrBack.
5227 13E8              ;=======================================================================
5228 13E8              ;
5229 13E8              getWMgrCtls PROC 
5230 13E8              ;
5231 13E8              ;
5232 13E8              ;
5233 13E8 A0 5C 01              ldy   #wmgr_wind+wControls     Move any created controls into
5234 13EB B7 D8                 lda   [<data],y                the window's wFrameCtls field.
5235 13ED AA                    tax   
5236 13EE C8                    iny   
5237 13EF C8                    iny   
5238 13F0 B7 D8                 lda   [<data],y
5239 13F2 A0 D0 00              ldy   #wFrameCtls+2
5240 13F5 97 A6                 sta   [<wind],y
5241 13F7 88                    dey   
5242 13F8 88                    dey   
5243 13F9 8A                    txa   
5244 13FA 97 A6                 sta   [<wind],y
5245 13FC              ;
5246 13FC 82 F9 0B              brl   moveWMgrBack             Back Window Manager port back to global.
5247 13FF                       ENDP 
5248 13FF              ;
5249 13FF              ;
5250 13FF              ;==============================
5251 13FF              ;        Close a Window
5252 13FF              ;==============================
5253 13FF              ;
5254 13FF              ; IN:    LONG - pointer to window port to close.
5255 13FF              ;OUT:    x = 0 if error, else 1.
5256 13FF              ;
5257 13FF              CloseWindow PROC 
5258 13FF                       import KillAuxInfoRecord
5259 13FF
5260 13FF                                                      ;using equates
5261 13FF
5262 13FF 20 CA 21              jsr   setup                    Get address of theWind.
5263 1402              ;
5264 1402 64 C4                 stz   <param                   No additional parameter send to defProc.
5265 1404 64 C6                 stz   <param+2
5266 1406 A2 04 00              ldx   #wDispose                Tell defProc to do additional disposal.
5267 1409 20 19 20              jsr   dispatch
5268 140C AA                    tax                            Does defProc want to abort close?
5269 140D F0 04                 beq   @1
5270 140F 8B                    phb   
5271 1410 82 A0 7B              brl   pop4bytes
5272 1413              @1        
5273 1413              ;
5274 1413              ;
5275 1413 20 3A 20              jsr   setwmgrport              Switch to Window Manager's port.
5276 1416              ;
5277 1416 20 93 14              jsr   erasewind                Take window out of list.
5278 1419              ;
5279 1419 20 DA 21              jsr   pullparam                Get window pointer again.
5280 141C              ;
5281 141C              ;
5282 141C              ; --- Deallocate any controls in the window ---------------
5283 141C              ;
5284 141C 20 04 22              jsr   get_portptr              Get window's port pointer.
5285 141F DA                    phx                            Pass pointer to window's port.
5286 1420 48                    pha   
5287 1421 A2 10 0B 22           _KillControls                  Deallocate all controls in window.
5288 1428 90 04                 bcc   ok1                      Is the Control Manager installed?
5289 142A 68                    pla   
5290 142B 68                    pla   
5291 142C 80 20                 bra   skip1
5292 142E              ;
5293 142E A0 D0 00     ok1      ldy   #wFrameCtls+2            wControls = wFrameCtls.
5294 1431 B7 A6                 lda   [<wind],y
5295 1433 AA                    tax   
5296 1434 88                    dey   
5297 1435 88                    dey   
5298 1436 B7 A6                 lda   [<wind],y
5299 1438              ;
5300 1438 A0 CA 00              ldy   #wControls
5301 143B 97 A6                 sta   [<wind],y
5302 143D C8                    iny   
5303 143E C8                    iny   
5304 143F 8A                    txa   
5305 1440 97 A6                 sta   [<wind],y
5306 1442              ;
5307 1442 20 04 22              jsr   get_portptr              Get window's port pointer.
5308 1445 DA                    phx                            Pass pointer to window's port.
5309 1446 48                    pha   
5310 1447 A2 10 0B 22           _KillControls                  Deallocate all frame controls in window.
5311 144E              ;
5312 144E              ;
5313 144E              ; --- Remove any activate or deactivate events for the window being closed ---
5314 144E              ;
5315 144E 20 04 22     skip1    jsr   get_portptr              Get window's port pointer.
5316 1451 C5 84                 cmp   <CurActive               Does the window have an activate waiting?
5317 1453 D0 06                 bne   checkDeact
5318 1455 E4 86                 cpx   <CurActive+2
5319 1457 D0 02                 bne   checkDeact
5320 1459              ;
5321 1459 64 80                 stz   <FlgActive               Remove the activate flag.
5322 145B              ;
5323 145B C5 88        checkDeact cmp   <CurDeActive           Does the window have a deactivate waiting?
5324 145D D0 06                 bne   skip2
5325 145F E4 8A                 cpx   <CurDeActive+2
5326 1461 D0 02                 bne   skip2
5327 1463              ;
5328 1463 64 82                 stz   <FlgDeActive             Remove the deactivate flag.
5329 1465              ;
5330 1465              ;
5331 1465              ; --- Deallocate memory used by the window's record. ------
5332 1465              ;
5333 1465 DA           skip2    phx                            Pass to port pointer.
5334 1466 48                    pha   
5335 1467 A2 04 1A 22           _ClosePort                     Close window's port.
5336 146E              ;
5337 146E A0 D2 00              ldy   #wframe                  Was the window allocated by me?
5338 1471 B7 A6                 lda   [<wind],y
5339 1473 29 04 00              and   #F_ALLOCATE
5340 1476
5341 1476 F0 14                 beq   JoinTheExitCode
5342 1478
5343 1478              ;	bne	@2
5344 1478              ;	phb
5345 1478              ;	brl	pop4bytes	Done if not allocated.
5346 1478              ;@2
5347 1478              ;
5348 1478 48                    pha                            Space for returned handle.
5349 1479 48                    pha   
5350 147A D4 A8                 pei   <wind+2                  Convert pointer to handle.
5351 147C D4 A6                 pei   <wind
5352 147E A2 02 1A 22           _FindHandle 
5353 1485 A2 02 10 22           _DisposeHandle                 Free block allocated for window record.
5354 148C              ;
5355 148C              JoinTheExitCode  
5356 148C 20 60 20              jsr   restore_port             Restore original port.
5357 148F              ;
5358 148F 8B                    phb   
5359 1490 82 20 7B              brl   pop4bytes
5360 1493
5361 1493                       ENDP 
5362 1493              ;
5363 1493              ;===============================================
5364 1493              ;        Erase a window from the screen.
5365 1493              ;===============================================
5366 1493              ;
5367 1493              ;   IN:    wind = window to be erased and taken out of the list.
5368 1493              ;
5369 1493              *
5370 1493              *
5371 1493              * 26 Apr 89         David Good
5372 1493              *
5373 1493              * If the windGlobal flag said to NOT change the hilighting on windows,
5374 1493              * CloseWindow used to skip drawing. Now it just skips the hilighting,
5375 1493              * but it still draws the frame.
5376 1493              *
5377 1493              ****************************************************************
5378 1493
5379 1493              erasewind PROC 
5380 1493
5381 1493              ;---------------------------------------------------------------
5382 1493 20 48 22              jsr   testVis                  ;if the window we are closing is invisible
5383 1496 D0 06                 bne   doVis                    ;..then do it the slow way
5384 1498
5385 1498 20 23 16              jsr   killAllPortRgns          ;dispose of all the regions in the window
5386 149B 82 60 0A              brl   outoflist                ;..we are killing and take the window out
5387 149E              ;---------------------------------------------------------------
5388 149E 20 AD 21     doVis    jsr   alloc_rgn                ;allocate a temporary region
5389 14A1
5390 14A1 A0 C0 00              ldy   #wstrucRgn+2             ;combine the structure region of the
5391 14A4 20 F9 21              jsr   pushandle                ;..window we are closing with the desktop
5392 14A7 20 87 21              jsr   pushGray                 ;..and leave it in our temporary region
5393 14AA D4 BA                 pei   <rgnptr+2
5394 14AC D4 B8                 pei   <rgnptr
5395 14AE A2 04 71 22           _SectRgn 
5396 14B5
5397 14B5 A5 8E                 lda   <topwind                 ;subtract the structure regions of all
5398 14B7 A6 90                 ldx   <topwind+2               ;..the windows above the current one
5399 14B9 80 2C                 bra   @enterLoop               ;..from the temporary region
5400 14BB
5401 14BB A0 D2 00     @loop    ldy   #wframe                  ;if the window is invisible, then don't
5402 14BE B7 DE                 lda   [<work],y                ;..subtract it.
5403 14C0 29 20 00              and   #F_VIS
5404 14C3 F0 1A                 beq   @nextWindow
5405 14C5
5406 14C5 D4 BA                 pei   <rgnptr+2                ;do the subtract
5407 14C7 D4 B8                 pei   <rgnptr
5408 14C9 A0 C0 00              ldy   #wstrucRgn+2
5409 14CC B7 DE                 lda   [<work],y
5410 14CE 48                    pha   
5411 14CF 88                    dey   
5412 14D0 88                    dey   
5413 14D1 B7 DE                 lda   [<work],y
5414 14D3 48                    pha   
5415 14D4 D4 BA                 pei   <rgnptr+2
5416 14D6 D4 B8                 pei   <rgnptr
5417 14D8 A2 04 73 22           _DiffRgn 
5418 14DF
5419 14DF A0 02 00     @nextWindow ldy   #2                    ;move to the next window
5420 14E2 B7 DE                 lda   [<work],y
5421 14E4 AA                    tax   
5422 14E5 A7 DE                 lda   [<work]
5423 14E7 85 DE 86 E0  @enterLoop stax <work
5424 14EB C5 A6                 cmp   <wind                    ;are we at the topmost window ? If so,
5425 14ED D0 CC                 bne   @loop                    ;..then we are done
5426 14EF E4 A8                 cpx   <wind+2
5427 14F1 D0 C8                 bne   @loop
5428 14F3
5429 14F3 20 C4 08              jsr   fullport                 ;set the clip region to the full desktop
5430 14F6              ;---------------------------------------------------------------
5431 14F6 20 23 16     findNewTop jsr   killAllPortRgns        ;dispose of all the regions in the window
5432 14F9
5433 14F9 A0 02 00              ldy   #2                       ;index for the high word of wNext
5434 14FC B7 A6                 lda   [<wind],y                ;save the pointer to the next window on
5435 14FE 48                    pha                            ;..the stack
5436 14FF A7 A6                 lda   [<wind]
5437 1501 48                    pha   
5438 1502
5439 1502 20 FE 1E              jsr   outoflist                ;take the window out of the list
5440 1505
5441 1505 20 96 20              jsr   find_top                 ;find the topmost visible window. If
5442 1508 F0 22                 beq   @skipDraw                ;..there aren't any then skip the hilite
5443 150A 85 A6 86 A8           stax <wind
5444 150E
5445 150E A0 AA 01              ldy   #WindGlobal              ;hiliting off?
5446 1511 B7 D8                 lda   [<data],y
5447 1513 D0 14                 bne   @skipHilite
5448 1515
5449 1515 A0 D2 00              ldy   #wframe                  ;if the window is already hilited then
5450 1518 B7 A6                 lda   [<wind],y                ;..skip the hilite
5451 151A 29 01 00              and   #F_HILITED
5452 151D D0 0A                 bne   @skipHilite
5453 151F B7 A6                 lda   [<wind],y
5454 1521 09 01 00              ora   #F_HILITED
5455 1524 97 A6                 sta   [<wind],y
5456 1526
5457 1526 20 C7 1E              jsr   activate                 ;send a activate message to the window
5458 1529 20 68 1C     @skipHilite jsr   drawEntireFrame       ;otherwise draw the entire frame
5459 152C              @skipDraw  
5460 152C              ;---------------------------------------------------------------
5461 152C 68           drawAllWindows pla   
5462 152D 85 A6                 sta   <wind
5463 152F 68                    pla   
5464 1530 85 A8                 sta   <wind+2
5465 1532
5466 1532 A5 A6        @loop    lda   <wind
5467 1534 05 A8                 ora   <wind+2
5468 1536 D0 03 82 BA           beql addToDeskRgn
5469 153B
5470 153B 20 48 22              jsr   testVis                  ;if the window is invisible, then skip
5471 153E D0 03 82 A3           beql @nextWindow               ;..it
5472 1543
5473 1543 D4 BA                 pei   <rgnptr+2                ;see if this window should be drawn by
5474 1545 D4 B8                 pei   <rgnptr                  ;..finding the intersection of the clip
5475 1547 A0 C0 00              ldy   #wstrucRgn+2             ;..and the structure region
5476 154A 20 F9 21              jsr   pushandle
5477 154D 20 9A 21              jsr   pushclip
5478 1550 A2 04 71 22           _SectRgn 
5479 1557 20 17 09              jsr   testclip                 ;is the clip region NOT empty ? if yes,
5480 155A F0 03 82 87           bnel @nextWindow               ;..then skip drawing
5481 155F
5482 155F A5 A6                 lda   <wind                    ;is this window the new topmost window ?
5483 1561 C5 C8                 cmp   <top_vis                 ;..If so, then we have already drawn it
5484 1563 D0 06                 bne   @notTheTop               ;..so skip just the draw step
5485 1565 A5 A8                 lda   <wind+2
5486 1567 C5 CA                 cmp   <top_vis+2
5487 1569 F0 03                 beq   @skipDraw
5488 156B 20 68 1C     @notTheTop jsr   drawEntireFrame        ;draw the new window clipped to our region
5489 156E              @skipDraw  
5490 156E A0 C4 00              ldy   #wContRgn+2              ;the new area to update is the intersection
5491 1571 20 F9 21              jsr   pushandle                ;..of the content region and our clip
5492 1574 20 9A 21              jsr   pushclip                 ;..region. Put it back into the clip
5493 1577 20 9A 21              jsr   pushclip                 ;..region for now.
5494 157A A2 04 71 22           _SectRgn 
5495 1581 20 9A 21              jsr   pushclip                 ;erase the new update area
5496 1584 A5 A6 A6 A8           ldax <wind
5497 1588 18                    clc   
5498 1589 69 24 00              adc   #wport+GP_BkPat
5499 158C 90 01                 bcc   @1
5500 158E E8                    inx   
5501 158F DA           @1       phx   
5502 1590 48                    pha   
5503 1591 A2 04 7D 22           _FillRgn 
5504 1598 20 9A 21              jsr   pushclip                 ;add the new update area to the update
5505 159B A0 C8 00              ldy   #wUpdateRgn+2            ;..region
5506 159E 20 F9 21              jsr   pushandle
5507 15A1 A0 C8 00              ldy   #wUpdateRgn+2
5508 15A4 20 F9 21              jsr   pushandle
5509 15A7 A2 04 72 22           _UnionRgn 
5510 15AE
5511 15AE A0 B0 00              ldy   #port+GP_ClipRgn+2       ;offset the new update area to local
5512 15B1 B7 D8                 lda   [<data],y                ;..coordinates, so we can add it to the
5513 15B3 AA                    tax                            ;..visible region
5514 15B4 88                    dey   
5515 15B5 88                    dey   
5516 15B6 B7 D8                 lda   [<data],y
5517 15B8 20 41 1C              jsr   offsetToLocal
5518 15BB 20 9A 21              jsr   pushclip                 ;add the new update area to the visible
5519 15BE A0 22 00              ldy   #wport+GP_VisRgn+2       ;..region also
5520 15C1 20 F9 21              jsr   pushandle
5521 15C4 A0 22 00              ldy   #wport+GP_VisRgn+2
5522 15C7 20 F9 21              jsr   pushandle
5523 15CA A2 04 72 22           _UnionRgn 
5524 15D1
5525 15D1 D4 BA                 pei   <rgnptr+2                ;subtract the struct region from our temp
5526 15D3 D4 B8                 pei   <rgnptr                  ;..so the next window will be clipped
5527 15D5 A0 C0 00              ldy   #wStrucRgn+2             ;..properly.
5528 15D8 20 F9 21              jsr   pushandle
5529 15DB D4 BA                 pei   <rgnptr+2
5530 15DD D4 B8                 pei   <rgnptr
5531 15DF A2 04 73 22           _DiffRgn 
5532 15E6              @nextWindow  
5533 15E6 A0 02 00              ldy   #2                       ;move to the next window
5534 15E9 B7 A6                 lda   [<wind],y
5535 15EB AA                    tax   
5536 15EC A7 A6                 lda   [<wind]
5537 15EE 85 A6 86 A8           stax <wind
5538 15F2
5539 15F2 82 3D FF              brl   @loop
5540 15F5              ;---------------------------------------------------------------
5541 15F5 A5 D5        addToDeskRgn lda   <FloorRgn+1          ;if there isn't a floor region then don't
5542 15F7 F0 12                 beq   @skipFloor               ;..change it !
5543 15F9
5544 15F9 D4 D6                 pei   <FloorRgn+2              ;add whatever is left to the floor region
5545 15FB D4 D4                 pei   <FloorRgn
5546 15FD 20 80 21              jsr   pushrgnptr
5547 1600 D4 D6                 pei   <FloorRgn+2
5548 1602 D4 D4                 pei   <FloorRgn
5549 1604 A2 04 72 22           _UnionRgn 
5550 160B              @skipFloor  
5551 160B D4 BA                 pei   <rgnptr+2                ;clip to our remaining region
5552 160D D4 B8                 pei   <rgnptr
5553 160F 20 9A 21              jsr   pushclip
5554 1612 A2 04 69 22           _CopyRgn 
5555 1619
5556 1619 20 78 26              jsr   disposeRgnPtr            ;free the temporary work region
5557 161C
5558 161C 20 5B 07              jsr   PaintDesk                ;paint the desktop using cliprgn
5559 161F
5560 161F 20 C4 08              jsr   fullport                 ;set the clip back to a full port
5561 1622 60                    rts   
5562 1623              ;---------------------------------------------------------------
5563 1623
5564 1623
5565 1623
5566 1623              ;---------------------------------------------------------------
5567 1623 A0 22 00     killAllPortRgns ldy   #wport+GP_VisRgn+2 ;clear the vis rgn of the killed window
5568 1626 20 F9 21              jsr   pushandle
5569 1629 A2 04 6A 22           _SetEmptyRgn 
5570 1630
5571 1630 A0 C8 00              ldy   #wUpdateRgn+2            ;dispose of all the regions in the window
5572 1633 20 3F 16              jsr   @killTheRgn              ;..we are killing
5573 1636 A0 C4 00              ldy   #wContRgn+2
5574 1639 20 3F 16              jsr   @killTheRgn
5575 163C A0 C0 00              ldy   #wStrucRgn+2
5576 163F
5577 163F 20 F9 21     @killTheRgn jsr   pushandle
5578 1642 A2 04 68 22           _DisposeRgn 
5579 1649 60                    rts   
5580 164A              ;---------------------------------------------------------------
5581 164A
5582 164A                       ENDP 
5583 164A
5584 164A              ****************************************************************
5585 164A              ;
5586 164A              ;
5587 164A              ;==========================================
5588 164A              ;          Change a window's size.
5589 164A              ;==========================================
5590 164A              ;
5591 164A              ;   IN:    PUSH:WORD - new content region width.
5592 164A              ;          PUSH:WORD - new content region height, if both zero, just exit.
5593 164A              ;          PUSH:LONG - pointer to window's port.
5594 164A              ;
5595 164A              ;  OUT:    None.
5596 164A              ;
5597 164A              SizeWindow PROC 
5598 164A
5599 164A              theWindow equ   9
5600 164A              newHeight equ   theWindow+4
5601 164A              newWidth equ   newHeight+2
5602 164A              updateFlag equ   newWidth+2
5603 164A              ;
5604 164A              ;
5605 164A 20 CA 21              jsr   setup
5606 164D              ;
5607 164D A3 0F                 lda   newWidth,s
5608 164F 03 0D                 ora   newHeight,s              Are both width and height zero?
5609 1651 F0 43                 beq   exit                     If yes, just exit.
5610 1653              ;
5611 1653              ;
5612 1653              ; --- Force height and width to be at least one --------------------------
5613 1653              ;
5614 1653 A3 0F                 lda   newWidth,s
5615 1655 D0 03                 bne   ok4
5616 1657 1A                    inc   a
5617 1658 83 0F                 sta   newWidth,s
5618 165A              ;
5619 165A A3 0D        ok4      lda   newHeight,s
5620 165C D0 03                 bne   ok5
5621 165E 1A                    inc   a
5622 165F 83 0D                 sta   newHeight,s
5623 1661              ;
5624 1661              ;
5625 1661              ; --- Check if there is no change ----------------------------------------
5626 1661              ;
5627 1661 20 51 22     ok5      jsr   getcontwh                Compute width/height of content region.
5628 1664              ;
5629 1664 A5 A2                 lda   <wrect+y2
5630 1666 C3 0D                 cmp   newHeight,s              Change in height?
5631 1668 D0 06                 bne   ok1
5632 166A A5 A4                 lda   <wrect+x2                Change in width?
5633 166C C3 0F                 cmp   newWidth,s
5634 166E F0 26                 beq   exit                     If no change, I'm done (nothing to do).
5635 1670              ;
5636 1670              ;
5637 1670              ; --- Tell window's defProc about new size -------------------
5638 1670              ;
5639 1670 A0 00 00     ok1      ldy   #0                       Pass address of newHeight and newWidth.
5640 1673 3B                    tsc   
5641 1674 18                    clc   
5642 1675 69 0D 00              adc   #newHeight
5643 1678 AA                    tax   
5644 1679 A9 20 00              lda   #wNewSize                Pass command.
5645 167C 20 D5 11              jsr   callProc2                Call window's defProc.
5646 167F 85 B2                 sta   <uncovered
5647 1681              ;
5648 1681              ;
5649 1681              ; --- Compute new content size -------------------------------
5650 1681              ;
5651 1681 A5 9E                 lda   <wrect+y1
5652 1683 85 96                 sta   <rect+y1
5653 1685 18                    clc   
5654 1686 63 0D                 adc   newHeight,s
5655 1688 85 9A                 sta   <rect+y2
5656 168A              ;
5657 168A A5 A0                 lda   <wrect+x1
5658 168C 85 98                 sta   <rect+x1
5659 168E 18                    clc   
5660 168F 63 0F                 adc   newWidth,s
5661 1691 85 9C                 sta   <rect+x2
5662 1693              ;
5663 1693              ;
5664 1693              ; --- Resize window ------------------------------------------
5665 1693              ;
5666 1693 20 BC 16              jsr   sizeguts                 Resize window, makes content = rect.
5667 1696              ;
5668 1696 8B           exit     phb   
5669 1697 82 29 79              brl   pop8bytes
5670 169A                       ENDP 
5671 169A              ;
5672 169A              ;
5673 169A              ;===============================================
5674 169A              ;          Resize and position a window.
5675 169A              ;===============================================
5676 169A              ;
5677 169A              ;   IN:    PUSH:WORD - TRUE to only draw what's uncovered,
5678 169A              ;                      FALSE to redraw entire content region.
5679 169A              ;          PUSH:LONG - pointer to new content RECT in global.
5680 169A              ;          PUSH:LONG - pointer to window's port.
5681 169A              ;
5682 169A              ;  OUT:    None.
5683 169A              ;
5684 169A              ResizeWindow PROC 
5685 169A              ;
5686 169A              ;
5687 169A              theWindow equ   9
5688 169A              newRect  equ   theWindow+4
5689 169A              redrawFlag equ   newRect+4
5690 169A              ;
5691 169A              srcRect  equ   work
5692 169A              ;
5693 169A              ;
5694 169A 20 CA 21              jsr   setup
5695 169D              ;
5696 169D              ;
5697 169D A3 0D                 lda   newRect,s                Get pointer to new RECT.
5698 169F 85 DE                 sta   <srcRect
5699 16A1 A3 0F                 lda   newRect+2,s
5700 16A3 85 E0                 sta   <srcRect+2
5701 16A5              ;
5702 16A5 A0 06 00              ldy   #x2                      Clone new RECT.
5703 16A8 B7 DE        lop1     lda   [<srcRect],y
5704 16AA BB                    tyx   
5705 16AB 95 96                 sta   <rect,x
5706 16AD 88                    dey   
5707 16AE 88                    dey   
5708 16AF 10 F7                 bpl   lop1
5709 16B1              ;
5710 16B1 A3 11                 lda   redrawFlag,s             Pass redraw flag.
5711 16B3 85 B2                 sta   <uncovered
5712 16B5              ;
5713 16B5 20 BC 16              jsr   sizeguts                 Resize window, makes content = rect.
5714 16B8              ;
5715 16B8 8B                    phb   
5716 16B9 82 0F 79              brl   pop10bytes
5717 16BC                       ENDP 
5718 16BC              ;
5719 16BC              ;
5720 16BC              ;============================================
5721 16BC              ;          Change a window's size.
5722 16BC              ;============================================
5723 16BC              ;
5724 16BC              ;   IN:    <wind = pointer to window to be sized.
5725 16BC              ;          <rect = new size and position of content region.
5726 16BC              ;          <uncovered = FALSE if whole content should be redrawn,
5727 16BC              ;                       TRUE if original content should not be redrawn.
5728 16BC              ;
5729 16BC              ;  OUT:    <rect = trashed.
5730 16BC              ;          <wrect = trashed.
5731 16BC              ;
5732 16BC              ;
5733 16BC              ; Change History
5734 16BC              ;
5735 16BC              ; 04 Nov 88         Steven Glass
5736 16BC              ;
5737 16BC              ; Notifies controls of size change.
5738 16BC              ;
5739 16BC              sizeguts PROC 
5740 16BC              ;
5741 16BC                                                      ;using equates
5742 16BC              ;
5743 16BC              ;
5744 16BC              ; --- Remember window's current strucRgn ----------------
5745 16BC              ;
5746 16BC 20 AD 21              jsr   alloc_rgn                Get a temp region.
5747 16BF              ;
5748 16BF A5 B2                 lda   <uncovered               Just whats uncovered?
5749 16C1 F0 13                 beq   skip1
5750 16C3              ;
5751 16C3 A0 C4 00              ldy   #wcontRgn+2              Save the original content region.
5752 16C6 20 F9 21              jsr   pushandle
5753 16C9 20 80 21              jsr   pushrgnptr
5754 16CC A2 04 69 22           _CopyRgn                       rgnptr = content region before resize.
5755 16D3 20 AD 21              jsr   alloc_rgn                rgnptr2 = rgnptr.
5756 16D6              ;
5757 16D6              ;
5758 16D6 A0 C0 00     skip1    ldy   #wstrucRgn+2
5759 16D9 20 F9 21              jsr   pushandle
5760 16DC 20 80 21              jsr   pushrgnptr
5761 16DF A2 04 69 22           _CopyRgn                       rgnptr = wstrucRgn.
5762 16E6              ;
5763 16E6 20 9C 17              jsr   new_size                 content is set to 'rect'.
5764 16E9              ;
5765 16E9              ;
5766 16E9              ; --- Compute new wsturcRgn and wcontRgn ---------------------
5767 16E9              ;
5768 16E9 20 A8 1F              jsr   moveWMgrOnWind           Move Window Manager's port on window.
5769 16EC A2 02 00              ldx   #wCalcRgns
5770 16EF 20 19 20              jsr   dispatch                 Trash 'rect' and 'wrect'.
5771 16F2 20 E8 13              jsr   getWMgrCtls              Move control list into window and
5772 16F5              ;                                     call moveWmgrBack.
5773 16F5              ;
5774 16F5              ; --- Draw anything uncovered by size change ------------------
5775 16F5              ;
5776 16F5 20 3A 20              jsr   setwmgrport              Current port = Window Manager's,
5777 16F8              ;
5778 16F8 20 48 22              jsr   testVis                  Is the window visible?
5779 16FB F0 71                 beq   skip4                    If not, no need to draw anything.
5780 16FD              ;
5781 16FD 20 17 08              jsr   calc_vis
5782 1700              ;          
5783 1700 20 80 21              jsr   pushrgnptr               From the hole,
5784 1703 A0 C0 00              ldy   #wstrucRgn+2             add the new window,
5785 1706 20 F9 21              jsr   pushandle
5786 1709 20 80 21              jsr   pushrgnptr               and that's the clobbered region.
5787 170C A2 04 72 22           _UnionRgn 
5788 1713              ;
5789 1713              ;
5790 1713              ; --- Subtract any windows above ----------------------------------
5791 1713              ;
5792 1713 20 9A 21              jsr   pushclip                 Save current clip handle.
5793 1716              ;
5794 1716 A5 B8                 lda   <rgnptr                  Replace clip handle with
5795 1718 A0 AE 00              ldy   #port+GP_ClipRgn         region to subtract from.
5796 171B 97 D8                 sta   [<data],y
5797 171D A5 BA                 lda   <rgnptr+2
5798 171F C8                    iny   
5799 1720 C8                    iny   
5800 1721 97 D8                 sta   [<data],y
5801 1723              ;
5802 1723 20 D2 08              jsr   SubStructLoop            Subtract windows above.
5803 1726              ;
5804 1726 68                    pla                            Restore clip handle.
5805 1727 A0 AE 00              ldy   #port+GP_ClipRgn
5806 172A 97 D8                 sta   [<data],y
5807 172C 68                    pla   
5808 172D C8                    iny   
5809 172E C8                    iny   
5810 172F 97 D8                 sta   [<data],y
5811 1731              ;
5812 1731              ;
5813 1731 A5 B2                 lda   <uncovered               Just whats uncovered?
5814 1733 F0 23                 beq   skip2
5815 1735              ;
5816 1735 20 8E 21              jsr   pushrgn2                 Intersect old content,
5817 1738 A0 C4 00              ldy   #wcontRgn+2              and new content region.
5818 173B 20 F9 21              jsr   pushandle
5819 173E 20 8E 21              jsr   pushrgn2
5820 1741 A2 04 71 22           _SectRgn 
5821 1748              ;
5822 1748 20 80 21              jsr   pushrgnptr               Clobbered region,
5823 174B 20 8E 21              jsr   pushrgn2                 less common area of old and new content,
5824 174E 20 80 21              jsr   pushrgnptr               equals new clobbered region.
5825 1751 A2 04 73 22           _DiffRgn                       rgnptr = rgnptr - rgnptr2
5826 1758              ;
5827 1758              ;
5828 1758 A2 C0 00     skip2    ldx   #GrayRgn
5829 175B 20 91 21              jsr   pushptr
5830 175E 20 80 21              jsr   pushrgnptr
5831 1761 20 80 21              jsr   pushrgnptr
5832 1764 A2 04 71 22           _SectRgn                       Clip clobbered region to desktop.
5833 176B              ;
5834 176B              ;
5835 176B 20 B5 06              jsr   paintonedown             Redraw clobbered area.
5836 176E              ;
5837 176E 20 78 26     skip4    jsr   disposeRgnPtr            Free temp region
5838 1771              ;
5839 1771              ;
5840 1771 A5 B2                 lda   <uncovered               Just whats uncovered?
5841 1773 F0 0C                 beq   skip3
5842 1775              ;
5843 1775 20 8E 21              jsr   pushrgn2                 Free copy of original content region.
5844 1778 A2 04 68 22           _DisposeRgn 
5845 177F              ;
5846 177F 64 B2                 stz   <uncovered               Reset default redraw global flag.
5847 1781              ;
5848 1781              ;
5849 1781              skip3     
5850 1781              ;
5851 1781              ; Notify the controls in this window about the change in size.
5852 1781              ; (added 04 Nov 88 SEG)
5853 1781              ;
5854 1781 F4 00 08              PushWord #FctlTellAboutSize 
5855 1784 F4 10 00              PushWord #ctlWindChangeSize 
5856 1787 F4 00 00 F4           PushLong #0 
5857 178D 20 04 22              jsr   get_PortPtr
5858 1790 DA                    phx   
5859 1791 48                    pha   
5860 1792 A2 10 2D 22           _NotifyCtls 
5861 1799
5862 1799
5863 1799 82 C4 08              brl   restore_port             Restore original port.
5864 179C                       ENDP 
5865 179C              ;
5866 179C              ;
5867 179C              ;=====================================================
5868 179C              ;          Set a window's size and position.
5869 179C              ;=====================================================
5870 179C              ;
5871 179C              ;   IN:    rect = new size and position.
5872 179C              ;          wind = window pointer.
5873 179C              ;
5874 179C              ;  OUT:    window's port changed.
5875 179C              ;
5876 179C              new_size PROC 
5877 179C              ;
5878 179C                                                      ;using equates
5879 179C              ;
5880 179C              ;
5881 179C 20 48 20              jsr   save_port                Save original port.
5882 179F              ;
5883 179F 20 04 22              jsr   get_portptr
5884 17A2 DA                    phx   
5885 17A3 48                    pha   
5886 17A4 A2 04 1B 22           _SetPort                       Switch to window's port.
5887 17AB              ;
5888 17AB A5 9C                 lda   <rect+x2
5889 17AD 38                    sec   
5890 17AE E5 98                 sbc   <rect+x1
5891 17B0 48                    pha                            Pass new width.
5892 17B1 A5 9A                 lda   <rect+y2
5893 17B3 38                    sec   
5894 17B4 E5 96                 sbc   <rect+y1
5895 17B6 48                    pha                            Pass new height.
5896 17B7 A2 04 21 22           _SetPortSize 
5897 17BE              ;
5898 17BE A6 96                 ldx   <rect+y1                 Global Y position.
5899 17C0 A5 98                 lda   <rect+x1                 Global X position.
5900 17C2 20 C8 17              jsr   pos_wind                 Position the window.
5901 17C5              ;
5902 17C5 82 98 08              brl   restore_port
5903 17C8                       ENDP 
5904 17C8              ;
5905 17C8              ;
5906 17C8              ;===============================================
5907 17C8              ;        Offset a window's Bounds RECT.
5908 17C8              ;        Used to position a window.
5909 17C8              ;===============================================
5910 17C8              ;
5911 17C8              ;   IN:  x = global y position of content.
5912 17C8              ;        a = global x position of content.
5913 17C8              ;        wind = window to reposition.
5914 17C8              ;
5915 17C8              ;  OUT:  x = deltay.
5916 17C8              ;        a = deltax.
5917 17C8              ;
5918 17C8              pos_wind PROC 
5919 17C8              ;
5920 17C8                                                      ;using equates
5921 17C8              ;
5922 17C8              deltay   equ   1
5923 17C8              deltax   equ   deltay+2
5924 17C8              ;
5925 17C8              ;
5926 17C8 49 FF FF              eor   #$FFFF                   Negate x position.
5927 17CB 1A                    inc   a
5928 17CC 48                    pha                            Save.
5929 17CD              ;
5930 17CD 8A                    txa   
5931 17CE 49 FF FF              eor   #$FFFF                   Negate y position.
5932 17D1 1A                    inc   a
5933 17D2 48                    pha                            Save.
5934 17D3              ;
5935 17D3              ;
5936 17D3 A0 0E 00              ldy   #wport+GP_Bounds+x1      Compute delta x.
5937 17D6 B7 A6                 lda   [<wind],y
5938 17D8 38                    sec   
5939 17D9 E3 03                 sbc   deltax,s
5940 17DB 83 03                 sta   deltax,s
5941 17DD              ;
5942 17DD 88                    dey                            Compute delta y.
5943 17DE 88                    dey   
5944 17DF B7 A6                 lda   [<wind],y
5945 17E1 38                    sec   
5946 17E2 E3 01                 sbc   deltay,s
5947 17E4 83 01                 sta   deltay,s
5948 17E6              ;
5949 17E6              ;
5950 17E6 B7 A6        lop1     lda   [<wind],y                Offset bounds RECT.
5951 17E8 38                    sec   
5952 17E9 E3 01                 sbc   deltay,s
5953 17EB 97 A6                 sta   [<wind],y
5954 17ED              ;
5955 17ED C8                    iny   
5956 17EE C8                    iny   
5957 17EF B7 A6                 lda   [<wind],y
5958 17F1 38                    sec   
5959 17F2 E3 03                 sbc   deltax,s
5960 17F4 97 A6                 sta   [<wind],y
5961 17F6              ;
5962 17F6 C8                    iny   
5963 17F7 C8                    iny   
5964 17F8 C0 12 00              cpy   #wport+GP_Bounds+x2      Done?
5965 17FB 90 E9                 bcc   lop1
5966 17FD              ;
5967 17FD              ;
5968 17FD FA                    plx                            Return deltay.
5969 17FE 68                    pla                            Return deltax.
5970 17FF 60                    rts   
5971 1800                       ENDP 
5972 1800
5973 1800
5974 1800              ;=====================================
5975 1800              ;          Track grow region.
5976 1800              ;=====================================
5977 1800              ;
5978 1800              ;   IN:    PUSH:WORD - minimum horizontal position.
5979 1800              ;          PUSH:WORD - minimum vertical position.
5980 1800              ;          PUSH:WORD - x starting position.
5981 1800              ;          PUSH:WORD - y starting position.
5982 1800              ;          PUSH:LONG - pointer to window's port.
5983 1800              ;
5984 1800              ;  OUT:    LONG - low word is content's new height,
5985 1800              ;                 high word is content's new width.
5986 1800              ;
5987 1800              GrowWindow PROC 
5988 1800
5989 1800              theWindow equ   9
5990 1800              ystart   equ   theWindow+4
5991 1800              xstart   equ   ystart+2
5992 1800              min_h    equ   xstart+2
5993 1800              min_w    equ   min_h+2
5994 1800              new_h    equ   min_w+2
5995 1800              new_w    equ   new_h+2
5996 1800              ;
5997 1800              content_h equ   work+8
5998 1800              content_w equ   content_h+2
5999 1800              ;
6000 1800              ;
6001 1800 20 CA 21              jsr   setup
6002 1803
6003 1803 A9 1F 00              lda   #wStartGrow              Tell window's defProc starting to grow.
6004 1806 20 D5 11              jsr   callProc2
6005 1809              ;
6006 1809 20 3A 20              jsr   setwmgrport              Switch to Window Manager's port.
6007 180C 20 C4 08              jsr   fullport
6008 180F              ;
6009 180F A0 C2 00              ldy   #wcontRgn                Get global coordinates of content.
6010 1812 20 1E 22              jsr   getbounds                wrect = content bounds.
6011 1815 20 9C 1F              jsr   wrect2rect               rect = wrect.
6012 1818              ;
6013 1818 A0 BE 00              ldy   #wstrucRgn               Get global coordinates of content.
6014 181B 20 1E 22              jsr   getbounds                wrect = wwStructRgn bounds.
6015 181E              ;
6016 181E              ;
6017 181E              ; --- Compute min and max deltas -------------------------------------------
6018 181E              ;
6019 181E A5 9A                 lda   <rect+y2                 Compute the height of the content area.
6020 1820 38                    sec   
6021 1821 E5 96                 sbc   <rect+y1
6022 1823 1A                    inc   a
6023 1824 85 E6                 sta   <content_h
6024 1826              ;
6025 1826 A5 9C                 lda   <rect+x2                 Compute the width of the content area.
6026 1828 38                    sec   
6027 1829 E5 98                 sbc   <rect+x1
6028 182B 1A                    inc   a
6029 182C 85 E8                 sta   <content_w
6030 182E              ;
6031 182E A3 11                 lda   min_h,s
6032 1830 38                    sec   
6033 1831 E5 E6                 sbc   <content_h
6034 1833 A0 82 00              ldy   #drag_bound+y1           Min y delta.
6035 1836 97 D8                 sta   [<data],y
6036 1838              ;
6037 1838 A3 13                 lda   min_w,s
6038 183A 38                    sec   
6039 183B E5 E8                 sbc   <content_w
6040 183D A0 84 00              ldy   #drag_bound+x1           Min x delta.
6041 1840 97 D8                 sta   [<data],y
6042 1842              ;
6043 1842 A9 0D 00              lda   #wGetMaxGrow             Pass request number.
6044 1845 20 D5 11              jsr   callProc2                a = max height.
6045 1848              ;                                     x = max width.
6046 1848              ;
6047 1848 38                    sec   
6048 1849 E5 E6                 sbc   <content_h
6049 184B A0 86 00              ldy   #drag_bound+y2           Max y delta.
6050 184E 97 D8                 sta   [<data],y
6051 1850              ;
6052 1850 8A                    txa   
6053 1851 38                    sec   
6054 1852 E5 E8                 sbc   <content_w
6055 1854 A0 88 00              ldy   #drag_bound+x2           Max x delta.
6056 1857 97 D8                 sta   [<data],y
6057 1859              ;
6058 1859              ;
6059 1859              ; --- Set slop bounds ------------------------------------------------
6060 1859              ;
6061 1859 A0 70 00              ldy   #scInfo+8+x2
6062 185C A2 90 00              ldx   #slop_bound+x2
6063 185F B7 D8        lop1     lda   [<data],y
6064 1861 5A                    phy   
6065 1862 9B                    txy   
6066 1863 97 D8                 sta   [<data],y
6067 1865 7A                    ply   
6068 1866 88                    dey   
6069 1867 88                    dey   
6070 1868 CA                    dex   
6071 1869 CA                    dex   
6072 186A E0 8A 00              cpx   #slop_bound
6073 186D B0 F0                 bcs   lop1
6074 186F              ;
6075 186F              ;
6076 186F              ; --- Call DragRect ---------------------------------------------------
6077 186F              ;
6078 186F A3 0F                 lda   xstart,s                 Pass cursor's starting position.
6079 1871 85 B6                 sta   <xrat
6080 1873 A3 0D                 lda   ystart,s
6081 1875 85 B4                 sta   <yrat
6082 1877              ;
6083 1877 A9 3C 01              lda   #$013C                   Custom draw, on one pixel grid.
6084 187A 85 DE                 sta   <work
6085 187C              ;
6086 187C A9 FD 00              lda   #draw_grow>>16           Address of custom draw routine.
6087 187F 85 E2                 sta   <work+4
6088 1881 A9 A9 18              lda   #draw_grow
6089 1884 85 E0                 sta   <work+2
6090 1886              ;
6091 1886 20 8E 0B              jsr   callDrag                 Drag the grow box.
6092 1889              ;                                     a = delta y.
6093 1889              ;                                     x = delta x.
6094 1889              ;
6095 1889              ;
6096 1889              ; --- Compute new width and height ---------------------------------
6097 1889              ;
6098 1889 A8                    tay                            Any change?
6099 188A D0 03                 bne   ok3
6100 188C 9B                    txy   
6101 188D F0 0A                 beq   store3                   Return zero if no change.
6102 188F              ;
6103 188F 18           ok3      clc                            Compute new content height.
6104 1890 65 E6                 adc   <content_h
6105 1892 3A                    dec   a
6106 1893 A8                    tay   
6107 1894              ;
6108 1894 8A                    txa                            Compute new content width.
6109 1895 18                    clc   
6110 1896 65 E8                 adc   <content_w
6111 1898 3A                    dec   a
6112 1899              ;
6113 1899 83 17        store3   sta   new_w,s                  Return new content size to caller.
6114 189B 98                    tya   
6115 189C 83 15                 sta   new_h,s
6116 189E              ;
6117 189E              ;
6118 189E              ; --- Clean-up and exit -----------------------------------------
6119 189E              ;
6120 189E 20 60 20              jsr   restore_port             Restore original port.
6121 18A1              ;
6122 18A1              ;
6123 18A1 64 B2                 stz   <uncovered               Global flag.
6124 18A3 E6 B2                 inc   <uncovered               Don't redraw original content region.
6125 18A5
6126 18A5 8B                    phb   
6127 18A6 82 2A 77              brl   pop12bytes
6128 18A9
6129 18A9              ;
6130 18A9              ; = = = = = = = = = = = = = = = = = = = = = =
6131 18A9              ;          Custom DragRect outline
6132 18A9              ;          draw routine.
6133 18A9              ; = = = = = = = = = = = = = = = = = = = = = =
6134 18A9              ;
6135 18A9              draw_grow  
6136 18A9              ;
6137 18A9              deltay   equ   6
6138 18A9              deltax   equ   deltay+2
6139 18A9              ;
6140 18A9              ;
6141 18A9 0B                    phd                            Save caller's direct page.
6142 18AA              ;
6143 18AA 48                    pha                            Space for result.
6144 18AB 48                    pha   
6145 18AC F4 00 00              pea   0                        Pass system tool flag.
6146 18AF F4 0E 00              pea   WindToolNum              Pass Window Manager tool number.
6147 18B2 A2 01 0C 22           _GetWAP 
6148 18B9 2B                    pld                            Window Manager's direct page pointer.
6149 18BA 68                    pla                            Don't need high word.
6150 18BB              ;
6151 18BB 64 C4                 stz   <param                   Pass address of window frame RECT.
6152 18BD 7B                    tdc   
6153 18BE 18                    clc   
6154 18BF 69 9E 00              adc   #wrect
6155 18C2 85 C6                 sta   <param+2
6156 18C4              ;
6157 18C4 A2 06 00              ldx   #wGrowFrame              Ask defProc to draw outline.
6158 18C7 20 19 20              jsr   dispatch                 Pass message to window's defProc.
6159 18CA AA                    tax                            Did defProc complete task?
6160 18CB D0 2A                 bne   exit10
6161 18CD              ;
6162 18CD              ;
6163 18CD              ; --- Draw default grow outline ----------------------------------------
6164 18CD              ;
6165 18CD              ;   IN:    wrect = window frame RECT.
6166 18CD              ;          rect = content RECT.
6167 18CD              ;
6168 18CD 20 70 21              jsr   pushwrect                Push the address of 'wrect'.
6169 18D0 A2 04 53 22           _FrameRect 
6170 18D7              ;
6171 18D7 A5 96                 lda   <rect+y1
6172 18D9 85 DE                 sta   <work+y1
6173 18DB A5 98                 lda   <rect+x1
6174 18DD 85 E0                 sta   <work+x1
6175 18DF              ;
6176 18DF A5 9A                 lda   <rect+y2
6177 18E1 18                    clc   
6178 18E2 63 06                 adc   deltay,s
6179 18E4 85 E2                 sta   <work+y2
6180 18E6              ;
6181 18E6 A5 9C                 lda   <rect+x2
6182 18E8 18                    clc   
6183 18E9 63 08                 adc   deltax,s
6184 18EB 85 E4                 sta   <work+x2
6185 18ED              ;
6186 18ED 20 6B 21              jsr   pushwork
6187 18F0 A2 04 53 22           _FrameRect 
6188 18F7              ;
6189 18F7              ;
6190 18F7 2B           exit10   pld                            Restore caller's direct page.
6191 18F8              ;
6192 18F8 A3 00                 lda   0,s                      Move return address down stack.
6193 18FA 83 04                 sta   4,s
6194 18FC A3 02                 lda   2,s
6195 18FE 83 06                 sta   6,s
6196 1900 68                    pla                            Remove input parameters.
6197 1901 68                    pla   
6198 1902 6B                    rtl   
6199 1903              ;
6200 1903                       ENDP 
6201 1903              ;
6202 1903              ;
6203 1903              ;============================================
6204 1903              ;          Pin a point in a RECT.
6205 1903              ;============================================
6206 1903              ;
6207 1903              ;   IN:    PUSH:WORD - x coordinate of point to pin.
6208 1903              ;          PUSH:WORD - y coordinate of point to pin.
6209 1903              ;          PUSH:LONG - pointer to RECT in which to pin point.
6210 1903              ;
6211 1903              ;  OUT:    LONG - high word is pinned y coordinate,
6212 1903              ;                 low word is pinned x coordinate.
6213 1903              ;
6214 1903              PinRect  PROC 
6215 1903              ;
6216 1903                                                      ;using equates
6217 1903              ;
6218 1903              bindRect equ   9
6219 1903              ypoint   equ   bindRect+4
6220 1903              xpoint   equ   ypoint+2
6221 1903              ypinned  equ   xpoint+2
6222 1903              xpinned  equ   ypinned+2
6223 1903              ;
6224 1903              ;
6225 1903 22 64 00 E1           jsl   IncBusyFlg
6226 1907 0B                    phd                            Save orginal zero page.
6227 1908              ;
6228 1908 3B                    tsc                            Switch zero page into stack.
6229 1909 5B                    tcd   
6230 190A              ;
6231 190A              ; Zero out the result
6232 190A A5 0D                 lda   <yPoint
6233 190C 85 11                 sta   <yPinned
6234 190E A5 0F                 lda   <xPoint
6235 1910 85 13                 sta   <xPinned
6236 1912
6237 1912              ; now test to see the Y value first...
6238 1912 A5 0D                 lda   <yPoint                  ; test to see if this is greaterthan or equal to
6239 1914 C7 09                 cmp   [<bindRect]
6240 1916 10 06                 bpl   @1                       ; if this test is ok, then <yPoint is greater than bind.y1
6241 1918 A7 09                 lda   [<bindRect]
6242 191A 85 11                 sta   <yPinned
6243 191C 80 0C                 bra   @testX                   ; now tets the <X> value
6244 191E              @1        
6245 191E A0 04 00              ldy   #4
6246 1921 D7 09                 cmp   [<bindRect],y
6247 1923 30 05                 bmi   @testX                   ; <Y> value is fine...
6248 1925 B7 09                 lda   [<bindRect],y
6249 1927 3A                    dec   a
6250 1928 85 11                 sta   <yPinned
6251 192A              ; and test the X value
6252 192A              @testX    
6253 192A A0 02 00              ldy   #2
6254 192D A5 0F                 lda   <xPoint                  ; test to see if this is greaterthan or equal to
6255 192F D7 09                 cmp   [<bindRect],y
6256 1931 10 06                 bpl   @2                       ; if this test is ok, then <yPoint is greater than bind.y1
6257 1933 B7 09                 lda   [<bindRect],y
6258 1935 85 13                 sta   <xPinned
6259 1937 80 0C                 bra   @TestDone                ; now tets the <X> value
6260 1939              @2        
6261 1939 A0 06 00              ldy   #6
6262 193C D7 09                 cmp   [<bindRect],y
6263 193E 30 05                 bmi   @testDone                ; <Y> value is fine...
6264 1940 B7 09                 lda   [<bindRect],y
6265 1942 3A                    dec   a
6266 1943 85 13                 sta   <xPinned
6267 1945 8B           @TestDone phb   
6268 1946 82 7A 76              brl   pop8bytes
6269 1949
6270 1949                       ENDP 
6271 1949
6272 1949              ;
6273 1949              ; Was:
6274 1949              ;
6275 1949              ;
6276 1949              ; --- Force negative top and left to zero ------------
6277 1949              ;
6278 1949              ;	lda	[<bindRect]
6279 1949              ;	bpl	ok1
6280 1949              ;	lda	#0
6281 1949              ;ok1	sta	<ypinned
6282 1949              ;;
6283 1949              ;	ldy	#x1
6284 1949              ;	lda	[<bindRect],y
6285 1949              ;	bpl	ok2
6286 1949              ;	lda	#0
6287 1949              ;ok2	sta	<xpinned
6288 1949              ;;
6289 1949              ;;
6290 1949              ;; --- Pin the point --------------------------------------------
6291 1949              ;;
6292 1949              ;	lda	<ypoint
6293 1949              ;	cmp	<ypinned
6294 1949              ;	bcs	skip1
6295 1949              ;	lda	<ypinned	Pin to top side.
6296 1949              ;;
6297 1949              ;skip1	iny
6298 1949              ;	iny
6299 1949              ;	cmp	[<bindRect],y
6300 1949              ;	bcc	store1
6301 1949              ;	lda	[<bindRect],y	Pin to bottom side,
6302 1949              ;	dec	a	less one.
6303 1949              ;store1	sta	<ypinned
6304 1949              ;;
6305 1949              ;;
6306 1949              ;	lda	<xpoint
6307 1949              ;	cmp	<xpinned
6308 1949              ;	bcs	skip2
6309 1949              ;	lda	<xpinned	Pin to left side.
6310 1949              ;;
6311 1949              ;skip2	iny
6312 1949              ;	iny
6313 1949              ;	cmp	[<bindRect],y
6314 1949              ;	bcc	store2
6315 1949              ;	lda	[<bindRect],y	Pin to right side,
6316 1949              ;	dec	a	less one.
6317 1949              ;store2	sta	<xpinned
6318 1949              ;;
6319 1949              ;;
6320 1949              ;	phb
6321 1949              ;	brl	pop8bytes
6322 1949              ;	ENDP
6323 1949              ;
6324 1949              ;=================================================
6325 1949              ;          Flip a window's zoom position.
6326 1949              ;=================================================
6327 1949              ;
6328 1949              ;   IN:    PUSH:LONG - pointer of window's port.
6329 1949              ;
6330 1949              ;  OUT:    None.
6331 1949              ;
6332 1949              ZoomWindow PROC 
6333 1949              ;
6334 1949              ;
6335 1949              ;
6336 1949 20 CA 21              jsr   setup
6337 194C              ;
6338 194C A9 1C 00              lda   #wZoomWindow             Request number.
6339 194F 20 D5 11              jsr   callProc2                Tell defProc to Zoom Window.
6340 1952              ;
6341 1952 8B                    phb   
6342 1953 82 5D 76              brl   pop4bytes
6343 1956                       ENDP 
6344 1956              ;
6345 1956              ;
6346 1956              ;            APPEND	WFIND.ASM
6347 1956                       TITLE 'Apple IIGS Window Manager               WFIND.ASM' 
6348 1956              ;
6349 1956              ;          Copyright Apple Computer, Inc. 1986,1987,1988
6350 1956              ;          All rights reserved
6351 1956              ;          Written by Dan Oliver
6352 1956              ;
6353 1956              ;
6354 1956              ;=====================================
6355 1956              ;        Find Window Function.
6356 1956              ;=====================================
6357 1956              ;
6358 1956              ;  IN:   PUSH - LONG - address of where to store window pointer.
6359 1956              ;        PUSH - LONG - point on screen of where to check.
6360 1956              ;
6361 1956              ; OUT:   WORD - function at given point, window also set at given address.
6362 1956              ;
6363 1956              ;               wInDesk         On Desktop.
6364 1956              ;               wInMenuBar      On System Menu Bar.
6365 1956              ;               wInSysWindow    On System window.
6366 1956              ;               wInContent      In content region.
6367 1956              ;               wInDrag         In drag region.
6368 1956              ;               wInGrow         In grow region, active window only.
6369 1956              ;               wInGoAway       In go-away region, active window only.
6370 1956              ;               wInZoom         In zoom region, active window only.
6371 1956              ;               wInInfo         In information bar.
6372 1956              ;               wInVScroll      In right scroll bar.
6373 1956              ;               wInHScroll      In bottom scroll bar.
6374 1956              ;               wInFrame        In frame, but not on anything else.
6375 1956              ;
6376 1956              ;
6377 1956              FindWindow PROC 
6378 1956              ;
6379 1956                                                      ;using equates
6380 1956              ;
6381 1956              point    equ   9                        Point to check.
6382 1956              retWind  equ   point+4                  Address of where to store window.
6383 1956              retLoc   equ   retWind+4                Location on stack of return parameter.
6384 1956              ;
6385 1956              ;
6386 1956 22 64 00 E1           jsl   IncBusyFlg
6387 195A
6388 195A 0B                    phd   
6389 195B 5B                    tcd   
6390 195C              ;
6391 195C 20 C4 08              jsr   fullport                 Set clip to GrayRgn.
6392 195F              ;
6393 195F              ;
6394 195F              ; --- Check if point is on the desktop ----------------------------
6395 195F              ;
6396 195F 48                    pha                            Space for return value.
6397 1960 F4 00 00              pea   0                        Pass pointer to point to check.
6398 1963 3B                    tsc   
6399 1964 18                    clc   
6400 1965 69 0D 00              adc   #point+4
6401 1968 48                    pha   
6402 1969 D4 C2                 pei   <GrayRgn+2               Region to check, desktop.
6403 196B D4 C0                 pei   <GrayRgn
6404 196D A2 04 75 22           _PtInRgn                       Check if the point is on the desktop.
6405 1974 A9 11 00              lda   #wInMenuBar              Not on the desktop flag, just in case.
6406 1977 FA                    plx   
6407 1978 F0 39                 beq   exit1
6408 197A              ;
6409 197A              ;
6410 197A              ; ------ We're on the desktop.  Are we on a window? ------------------------
6411 197A              ;
6412 197A A6 8E        ck_wind  ldx   <topwind                 Start at top and check every window.
6413 197C A5 90                 lda   <topwind+2
6414 197E 80 28                 bra   enter1
6415 1980              ;
6416 1980 20 48 22     lop1     jsr   testVis                  Test the window's F_VIS flag.
6417 1983 F0 19                 beq   next1                    Check only visible windows.
6418 1985              ;
6419 1985 A3 0B                 lda   point+x1,s               Past point to check.
6420 1987 AA                    tax   
6421 1988 A3 09                 lda   point+y1,s
6422 198A 20 CC 19              jsr   findloc                  Check if on a window part.
6423 198D AA                    tax   
6424 198E F0 0E                 beq   next1                    On any part of window?
6425 1990              ;
6426 1990 83 11                 sta   retLoc,s                 Save part found.
6427 1992 A0 08 00              ldy   #wport+4                 Set the system/nonsystem window
6428 1995 B7 A6                 lda   [<wind],y                flag in the part code.
6429 1997 29 00 80              and   #$8000
6430 199A 03 11                 ora   retLoc,s
6431 199C 80 15                 bra   exit1
6432 199E              ;
6433 199E A0 00 00     next1    ldy   #wnext                   Check the next window.
6434 19A1 B7 A6                 lda   [<wind],y
6435 19A3 AA                    tax   
6436 19A4 C8                    iny   
6437 19A5 C8                    iny   
6438 19A6 B7 A6                 lda   [<wind],y
6439 19A8 85 A8        enter1   sta   <wind+2
6440 19AA 86 A6                 stx   <wind
6441 19AC              ;
6442 19AC 05 A6                 ora   <wind
6443 19AE D0 D0                 bne   lop1                     Any more windows to check?
6444 19B0              ;
6445 19B0              ;    On desktop, but not on any window, flag is zero.
6446 19B0              ;
6447 19B0 A9 10 00              lda   #wInDesk
6448 19B3              ;
6449 19B3 83 11        exit1    sta   retLoc,s                 Return location to caller.
6450 19B5              ;
6451 19B5 A3 0D                 lda   retWind,s                Return window pointer.
6452 19B7 85 AE                 sta   <workptr
6453 19B9 A3 0F                 lda   retWind+2,s
6454 19BB 85 B0                 sta   <workptr+2
6455 19BD              ;
6456 19BD 20 04 22              jsr   get_portptr              Convert 'wind' to port pointer.
6457 19C0 87 AE                 sta   [<workptr]
6458 19C2 A0 02 00              ldy   #2
6459 19C5 8A                    txa   
6460 19C6 97 AE                 sta   [<workptr],y
6461 19C8              ;
6462 19C8 8B                    phb   
6463 19C9 82 F7 75              brl   pop8bytes
6464 19CC                       ENDP 
6465 19CC              ;
6466 19CC              ;
6467 19CC              ;=======================================
6468 19CC              ;        Find point on window.
6469 19CC              ;=======================================
6470 19CC              ;
6471 19CC              ;  IN:   a = y point in global.
6472 19CC              ;        x = x point in global.
6473 19CC              ;        wind = window to check.
6474 19CC              ;
6475 19CC              ; OUT:     a =   Zero if not on anything.
6476 19CC              ;                wInContent if in content region.
6477 19CC              ;                wInDrag if in drag region.
6478 19CC              ;                wInGrow if in grow region.
6479 19CC              ;                wInGoAway if in go-away region.
6480 19CC              ;                wInZoom if in zoom region.
6481 19CC              ;                wInInfo
6482 19CC              ;                wInVScroll
6483 19CC              ;                wInHScroll
6484 19CC              ;                wInFrame
6485 19CC              ;
6486 19CC              findloc  PROC 
6487 19CC              ;
6488 19CC                                                      ;using equates
6489 19CC              ;
6490 19CC              ;
6491 19CC 85 B4                 sta   <yrat                    Save point.
6492 19CE 86 B6                 stx   <xrat
6493 19D0              ;
6494 19D0              ;
6495 19D0              ; --- Check for hit on window --------------------------------
6496 19D0              ;
6497 19D0 A0 C0 00              ldy   #wstrucRgn+2
6498 19D3 20 08 1A              jsr   test_pt                  Is the point on the window?
6499 19D6 D0 04                 bne   next1
6500 19D8              ;
6501 19D8 A9 00 00              lda   #0                       Not on window flag.
6502 19DB 60                    rts   
6503 19DC              ;
6504 19DC              ;
6505 19DC              ; --- Point is on the window, now find out where -------------
6506 19DC              ;
6507 19DC A0 C4 00     next1    ldy   #wcontRgn+2              Is the point on the content region?
6508 19DF 20 08 1A              jsr   test_pt
6509 19E2 F0 04                 beq   next2
6510 19E4              ;
6511 19E4 A9 13 00              lda   #wInContent              On content.
6512 19E7 60                    rts   
6513 19E8              ;
6514 19E8              ;
6515 19E8              ; --- Check other regions on window --------------------------
6516 19E8              ;
6517 19E8 20 1B 22     next2    jsr   getwgrect                wrect = window's strucRgn bounds (global).
6518 19EB              ;
6519 19EB A5 B4                 lda   <yrat                    Convert point to check to window's local.
6520 19ED 38                    sec   
6521 19EE E5 9E                 sbc   <wrect+y1
6522 19F0 85 C4                 sta   <param
6523 19F2              ;
6524 19F2 A5 B6                 lda   <xrat
6525 19F4 38                    sec   
6526 19F5 E5 A0                 sbc   <wrect+x1
6527 19F7 85 C6                 sta   <param+2
6528 19F9              ;
6529 19F9 20 A8 1F              jsr   moveWMgrOnWind           Move Window Manager over window.
6530 19FC              ;
6531 19FC A2 01 00              ldx   #wHit                    Check hit message.
6532 19FF 20 19 20              jsr   dispatch                 Call window definition procedure.
6533 1A02 48                    pha   
6534 1A03              ;
6535 1A03 20 F8 1F              jsr   moveWMgrBack             Put Window Manager's port back.
6536 1A06              ;
6537 1A06 68                    pla   
6538 1A07 60                    rts   
6539 1A08                       ENDP 
6540 1A08              ;
6541 1A08              ;
6542 1A08              ;===============================================
6543 1A08              ;        Check if a point is in a region.
6544 1A08              ;===============================================
6545 1A08              ;
6546 1A08              ;   IN:  yrat = y point.
6547 1A08              ;        xrat = x point.
6548 1A08              ;        wind = window to check.
6549 1A08              ;        y = offset into window record where region handle is.
6550 1A08              ;
6551 1A08              ;  OUT:  Equal = FALSE if point is in region.
6552 1A08              ;
6553 1A08              test_pt  PROC 
6554 1A08              ;
6555 1A08 48                    pha                            Space for returned value.
6556 1A09 20 66 21              jsr   pushyrat                 Pass pointer to point to check.
6557 1A0C 20 F9 21              jsr   pushandle                Pass handle of region to check.
6558 1A0F A2 04 75 22           _PtInRgn 
6559 1A16 68                    pla                            Get result which sets return flag.
6560 1A17 60                    rts   
6561 1A18                       ENDP 
6562 1A18              ;
6563 1A18              ;
6564 1A18              ;=====================================
6565 1A18              ;        Check point inside rect.
6566 1A18              ;=====================================
6567 1A18              ;
6568 1A18              ;   IN:  a = y position.
6569 1A18              ;        x = x position.
6570 1A18              ;        rect = rectangle to check.
6571 1A18              ;
6572 1A18              ;  OUT:  if inside equal = FALSE, 'A' and 'Y' = 1.
6573 1A18              ;        if not inside equal = TRUE, 'A' and 'Y' = 0.
6574 1A18              ;
6575 1A18              inside   PROC 
6576 1A18              ;
6577 1A18                                                      ;using equates
6578 1A18              ;
6579 1A18              ;
6580 1A18 A0 00 00              ldy   #0                       Not inside flag.
6581 1A1B              ;
6582 1A1B 24 96                 bit   <rect+y1                 Is top side off top of screen?
6583 1A1D 30 04                 bmi   ok1
6584 1A1F C5 96                 cmp   <rect+y1                 Below top side?
6585 1A21 90 19                 bcc   exit1
6586 1A23 24 9A        ok1      bit   <rect+y2                 Is bottom off top?
6587 1A25 30 15                 bmi   exit1
6588 1A27 C5 9A                 cmp   <rect+y2                 Above bottom side?
6589 1A29 B0 11                 bcs   exit1
6590 1A2B              ;
6591 1A2B 24 98                 bit   <rect+x1
6592 1A2D 30 04                 bmi   ok2
6593 1A2F E4 98                 cpx   <rect+x1                 To right of left side?
6594 1A31 90 09                 bcc   exit1
6595 1A33 24 9C        ok2      bit   <rect+x2                 Is right side off left side of screen?
6596 1A35 30 05                 bmi   exit1
6597 1A37 E4 9C                 cpx   <rect+x2                 To left of right side?
6598 1A39 B0 01                 bcs   exit1
6599 1A3B              ;
6600 1A3B C8                    iny                            Set inside flag.
6601 1A3C              ;
6602 1A3C 98           exit1    tya                            Set return equal flag.
6603 1A3D 60                    rts   
6604 1A3E                       ENDP 
6605 1A3E              ;
6606 1A3E              ;
6607 1A3E              ;===================================
6608 1A3E              ;        Watch Zoom Box.
6609 1A3E              ;===================================
6610 1A3E              ;
6611 1A3E              ;   IN:    PUSH:LONG - y,x starting point of cursor in global coordinates.
6612 1A3E              ;          PUSH:LONG - pointer to window port.
6613 1A3E              ;
6614 1A3E              ;  OUT:    WORD - TRUE if button released inside zoom box, else FALSE.
6615 1A3E              ;
6616 1A3E              TrackZoom PROC 
6617 1A3E              ;
6618 1A3E              ;
6619 1A3E              theWind  equ   9
6620 1A3E              point    equ   theWind+4
6621 1A3E              retFlag  equ   point+4
6622 1A3E              ;
6623 1A3E              ;
6624 1A3E 20 CA 21              jsr   setup
6625 1A41              ;
6626 1A41 A9 17 00              lda   #wInZoom                 Zoom box flag.
6627 1A44 80 06                 bra   trackbox
6628 1A46              ;
6629 1A46              ;
6630 1A46              ; = = = = = = = = = = = = = = = = = =
6631 1A46              ;        Watch Box.
6632 1A46              ; = = = = = = = = = = = = = = = = = =
6633 1A46              ;
6634 1A46              ;   IN:    PUSH:LONG - y,x starting point of cursor in global coordinates.
6635 1A46              ;          PUSH:LONG - pointer to window port.
6636 1A46              ;
6637 1A46              ;  OUT:    WORD - TRUE if button released inside close box, else FALSE.
6638 1A46              ;
6639 1A46                       ENTRY TrackGoAway
6640 1A46              TrackGoAway                             ;       
6641 1A46              ;
6642 1A46              ;
6643 1A46 20 CA 21              jsr   setup
6644 1A49              ;
6645 1A49 A9 16 00              lda   #wInGoAway               Close box flag.
6646 1A4C              ;
6647 1A4C                       ENTRY trackbox
6648 1A4C              trackbox                                ; 
6649 1A4C              ;
6650 1A4C 85 CC                 sta   <boxflag                 wInGoAway or wInZoom.
6651 1A4E              ;
6652 1A4E A9 00 00              lda   #0                       Starts out as normal.
6653 1A51 83 11                 sta   retFlag,s
6654 1A53              ;
6655 1A53 20 B1 08              jsr   clipabove
6656 1A56 20 A8 1F              jsr   moveWMgrOnWind           Move Window Manager over window.
6657 1A59              ;
6658 1A59 A3 0D                 lda   point,s                  Pass local coordinates to defProc.
6659 1A5B 85 C4                 sta   <param
6660 1A5D A3 0F                 lda   point+2,s
6661 1A5F 85 C6                 sta   <param+2
6662 1A61              ;
6663 1A61 20 75 21              jsr   pushparam
6664 1A64 A2 04 85 22           _GlobalToLocal 
6665 1A6B              ;
6666 1A6B              ;
6667 1A6B 20 90 1A              jsr   ck_inbox                 Check if rat in box.
6668 1A6E A3 11                 lda   retFlag,s                Must start out in box.
6669 1A70 F0 17                 beq   exit
6670 1A72              ;
6671 1A72              ;
6672 1A72 20 40 0B     lop1     jsr   ckbutton                 Check for a button up event.
6673 1A75 84 C4                 sty   <param
6674 1A77 85 C6                 sta   <param+2
6675 1A79 D0 05                 bne   released                 Done if button up.
6676 1A7B              ;
6677 1A7B 20 90 1A              jsr   ck_inbox                 Check if rat in box.
6678 1A7E 80 F2                 bra   lop1
6679 1A80              ;
6680 1A80              ;
6681 1A80              ; --- Button has been released ------------------------------------
6682 1A80              ;
6683 1A80 20 90 1A     released jsr   ck_inbox                 Check if still in box.
6684 1A83              ;
6685 1A83 A9 00 00              lda   #0                       Always exit with box as normal.
6686 1A86 20 A7 1A              jsr   drawbox
6687 1A89              ;
6688 1A89              ;
6689 1A89 20 F8 1F     exit     jsr   moveWMgrBack             Put Window Manager's port back.
6690 1A8C 8B                    phb   
6691 1A8D 82 33 75              brl   pop8bytes
6692 1A90              ;
6693 1A90              ;
6694 1A90              ; = = = = = = = = = = = = = = = = = = = =
6695 1A90              ;          Check if rat in box.
6696 1A90              ; = = = = = = = = = = = = = = = = = = = =
6697 1A90              ;
6698 1A90              ;   IN:    <param = position to check, in local.
6699 1A90              ;          <boxFlag = wInGoAway or wInZoom.
6700 1A90              ;
6701 1A90              ;  OUT:    retFlag = TRUE if in box, FALSE if outside box.
6702 1A90              ;
6703 1A90 A2 01 00     ck_inbox ldx   #wHit                    Pass hit test window command.
6704 1A93 20 19 20              jsr   dispatch                 Call defProc.
6705 1A96              ;
6706 1A96 A2 00 00              ldx   #0                       Not in box flag, just in case.
6707 1A99 C5 CC                 cmp   <boxFlag                 In proper part?
6708 1A9B D0 03                 bne   store100
6709 1A9D A2 FF FF              ldx   #TRUE                    In box flag.
6710 1AA0 8A           store100 txa   
6711 1AA1 C3 13                 cmp   retFlag+2,s              Has state changed?
6712 1AA3 F0 2A                 beq   exit100
6713 1AA5              ;
6714 1AA5 83 13                 sta   retFlag+2,s              New state.
6715 1AA7              ;
6716 1AA7              ;
6717 1AA7              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
6718 1AA7              ;          Ask window defProc to draw close or zoom box.
6719 1AA7              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
6720 1AA7              ;
6721 1AA7              ;   IN:    a = 0 to unhilite box, $8000 to hilite.
6722 1AA7              ;          <boxFlag = wInGoAway to draw close box, wInZoom to draw zoom box.
6723 1AA7              ;
6724 1AA7 D4 C6        drawBox  pei   <param+2                 Save.
6725 1AA9 D4 C4                 pei   <param
6726 1AAB              ;
6727 1AAB 85 C6                 sta   <param+2                 Pass hilite flag.
6728 1AAD A5 CC                 lda   <boxFlag
6729 1AAF 38                    sec   
6730 1AB0 E9 15 00              sbc   #wInGrow                 Convert wInGoAway to 1, wInZoom to 2.
6731 1AB3 85 C4                 sta   <param                   Pass part to draw.
6732 1AB5              ;
6733 1AB5 D4 A2                 pei   <wrect+y2                Save.
6734 1AB7 D4 A4                 pei   <wrect+x2
6735 1AB9              ;
6736 1AB9 A2 00 00              ldx   #wDraw                   Pass draw command to defProc.
6737 1ABC 20 19 20              jsr   dispatch
6738 1ABF              ;
6739 1ABF 68                    pla                            Restore.
6740 1AC0 85 A4                 sta   <wrect+x2
6741 1AC2 68                    pla   
6742 1AC3 85 A2                 sta   <wrect+y2
6743 1AC5 64 9E                 stz   <wrect+y1
6744 1AC7 64 A0                 stz   <wrect+x1
6745 1AC9              ;
6746 1AC9 68                    pla                            Restore.
6747 1ACA 85 C4                 sta   <param
6748 1ACC 68                    pla   
6749 1ACD 85 C6                 sta   <param+2
6750 1ACF              ;
6751 1ACF 60           exit100  rts   
6752 1AD0              ;
6753 1AD0                       ENDP 
6754 1AD0              ;
6755 1AD0              ;
6756 1AD0              ;=============================================
6757 1AD0              ;        Bring a window to the front.
6758 1AD0              ;=============================================
6759 1AD0              ;
6760 1AD0              ;   IN:  PUSH:LONG - window port to bring to front.
6761 1AD0              ;
6762 1AD0              ;  OUT:  Nothing.
6763 1AD0              ;
6764 1AD0              BringToFront PROC 
6765 1AD0              ;
6766 1AD0 20 CA 21              jsr   setup
6767 1AD3              ;
6768 1AD3 A9 00 00              lda   #0                       Don't do any highlighting flag.
6769 1AD6 80 66                 bra   tofront                  Execute common code.
6770 1AD8                       ENDP 
6771 1AD8              ;
6772 1AD8              ;
6773 1AD8              ;========================================
6774 1AD8              ;        Make Window the top window.
6775 1AD8              ;========================================
6776 1AD8              ;
6777 1AD8              ;   IN:  PUSH:LONG - pointer to the window port to become top.
6778 1AD8              ;
6779 1AD8              ;  OUT:  None.
6780 1AD8              ;
6781 1AD8              ;
6782 1AD8              ; Change History
6783 1AD8              *
6784 1AD8              * Feb 89            David Good
6785 1AD8              *
6786 1AD8              * Changed a bunch of stuff to make it go faster.
6787 1AD8              *
6788 1AD8              * 19 Apr 89         David Good
6789 1AD8              *
6790 1AD8              * Made vis region equal to the intersection of Gray and
6791 1AD8              * content regions instead of just content.  Fixed a number 
6792 1AD8              * fun and hard to track bugs.
6793 1AD8              *
6794 1AD8              ****************************************************************
6795 1AD8
6796 1AD8              SelectWindow PROC 
6797 1AD8
6798 1AD8              ;---------------------------------------------------------------
6799 1AD8                       DefineStack 
6800 1AD8              origD    word 
6801 1AD8              RTL1     block 3 
6802 1AD8              RTL2     block 3 
6803 1AD8              theWindow long 
6804 1AD8              ;---------------------------------------------------------------
6805 1AD8
6806 1AD8              ;---------------------------------------------------------------
6807 1AD8
6808 1AD8 22 64 00 E1           jsl   IncBusyFlg
6809 1ADC
6810 1ADC 0B                    phd                            ;save the user's direct page pointer
6811 1ADD 5B                    tcd                            ;switch to our direct page
6812 1ADE
6813 1ADE A3 09                 lda   theWindow,s              ;make the window we are selecting a window
6814 1AE0 38                    sec                            ;..pointer and put in in <workptr
6815 1AE1 E9 04 00              sbc   #4
6816 1AE4 85 AE                 sta   <workptr
6817 1AE6 A3 0B                 lda   theWindow+2,s
6818 1AE8 E9 00 00              sbc   #0
6819 1AEB 85 B0                 sta   <workptr+2
6820 1AED              ;---------------------------------------------------------------
6821 1AED A5 8E A6 90  checkList ldax <topwind                 ;check to make sure the window we are
6822 1AF1 80 14                 bra   @enter                   ;..selecting is in the list
6823 1AF3 A5 A6        @loop    lda   <wind
6824 1AF5 C5 AE                 cmp   <workptr
6825 1AF7 D0 06                 bne   @1
6826 1AF9 A5 A8                 lda   <wind+2
6827 1AFB C5 B0                 cmp   <workptr+2
6828 1AFD F0 13                 beq   @foundIt
6829 1AFF A0 02 00     @1       ldy   #2                       ;move to the next window
6830 1B02 B7 A6                 lda   [<wind],y
6831 1B04 AA                    tax   
6832 1B05 A7 A6                 lda   [<wind]
6833 1B07 85 A6 86 A8  @enter   stax <wind
6834 1B0B 05 A8                 ora   <wind+2                  ;check to see if there are more windows
6835 1B0D D0 E4                 bne   @loop                    ;..in the list. If not, then exit
6836 1B0F 82 2B 01              brl   exit
6837 1B12
6838 1B12 20 48 22     @foundIt jsr   testVis                  ;if the window is invisible, then call the
6839 1B15 F0 1C                 beq   gotoAirport              ;..airport
6840 1B17
6841 1B17 A5 8E A6 90           ldax <topwind                  ;are we selecting the topmost window ?
6842 1B1B C5 A6                 cmp   <wind                    ;..if so, then call the airport
6843 1B1D D0 04                 bne   @notTheTop
6844 1B1F E4 A8                 cpx   <wind+2
6845 1B21 F0 10                 beq   gotoAirport
6846 1B23 85 A6 86 A8  @notTheTop stax <wind
6847 1B27 20 48 22              jsr   testVis                  ;is the topmost window invisible ? If so,
6848 1B2A F0 07                 beq   gotoAirport              ;..then call the airport
6849 1B2C B7 A6                 lda   [<wind],y                ;is the topmost window hilighted ? If so,
6850 1B2E 29 01 00              and   #F_HILITED               ;..then we can do things the fast way
6851 1B31 D0 15                 bne   doFast
6852 1B33              ;---------------------------------------------------------------
6853 1B33 A5 AE A6 B0  gotoAirport ldax <workptr               ;copy <workptr to <wind
6854 1B37 85 A6 86 A8           stax <wind
6855 1B3B A9 01 00              lda   #1                       ;do highlighting flag.
6856 1B3E
6857 1B3E                       ENTRY tofront
6858 1B3E A2 FF FF     tofront  ldx   #$FFFF                   ;move window to top flag.
6859 1B41 9B                    txy   
6860 1B42 20 9B 1C              jsr   airport                  ;change window's plane.
6861 1B45
6862 1B45 82 F5 00              brl   exit
6863 1B48              ;---------------------------------------------------------------
6864 1B48 20 3A 20     doFast   jsr   setwmgrport              ;switch to the window manager's port
6865 1B4B 20 C4 08              jsr   fullport                 ;set the clip region to a full port
6866 1B4E
6867 1B4E 20 F3 1E              jsr   unhilite                 ;clear the hilight bit on the topmost window
6868 1B51 20 D8 1E              jsr   deactivate               ;send deactivate message to 'wind'.
6869 1B54
6870 1B54 20 68 1C              jsr   drawEntireFrame          ;draw the frame as unhilighted
6871 1B57
6872 1B57 A0 C0 00              ldy   #wStrucRgn+2             ;get the structure region into work
6873 1B5A B7 AE                 lda   [<workptr],y
6874 1B5C 85 E0                 sta   <work+2
6875 1B5E 88                    dey   
6876 1B5F 88                    dey   
6877 1B60 B7 AE                 lda   [<workptr],y
6878 1B62 85 DE                 sta   <work
6879 1B64
6880 1B64 A5 8E                 lda   <topwind                 ;start with the topmost window
6881 1B66 A6 90                 ldx   <topwind+2
6882 1B68              ;---------------------------------------------------------------
6883 1B68
6884 1B68 85 A6 86 A8  mainLoop stax <wind                     ;the window we are working with goes in
6885 1B6C C5 AE                 cmp   <workptr                 ;..<wind. Is it the same as the window
6886 1B6E D0 04                 bne   @1                       ;..we are moving to the top ? If it is
6887 1B70 E4 B0                 cpx   <workptr+2               ;..then stop changing visible regions
6888 1B72 F0 34                 beq   @done
6889 1B74              @1        
6890 1B74 20 48 22              jsr   testVis                  ;is this window invisible ? If so, then
6891 1B77 F0 25                 beq   @skip                    ;..skip it
6892 1B79
6893 1B79 A5 DE A6 E0           ldax <work                     ;make the structure region local to the
6894 1B7D 20 41 1C              jsr   offsetToLocal            ;..window
6895 1B80
6896 1B80 A0 22 00              ldy   #wport+GP_VisRgn+2       ;the visible region is the old visible
6897 1B83 20 F9 21              jsr   pushandle                ;..region minus the entire struct region
6898 1B86 D4 E0                 pei   <work+2                  ;..of the window that moved up
6899 1B88 D4 DE                 pei   <work
6900 1B8A A0 22 00              ldy   #wport+GP_VisRgn+2
6901 1B8D 20 F9 21              jsr   pushandle
6902 1B90 A2 04 73 22           _DiffRgn 
6903 1B97
6904 1B97 A5 DE A6 E0           ldax <work                     ;make the structure region global again
6905 1B9B 20 4B 1C              jsr   offsetToGlobal
6906 1B9E              @skip     
6907 1B9E A0 02 00              ldy   #2                       ;get the next window ptr into A and X
6908 1BA1 B7 A6                 lda   [<wind],y                ;..wNext is zero, so take advantage of
6909 1BA3 AA                    tax                            ;..this
6910 1BA4 A7 A6                 lda   [<wind]
6911 1BA6 80 C0                 bra   mainLoop
6912 1BA8
6913 1BA8 20 FE 1E     @done    jsr   outoflist                ;take the new topmost window out of the
6914 1BAB A9 FF FF              lda   #$FFFF                   ;..list and put it back on top
6915 1BAE 85 AE                 sta   <workptr
6916 1BB0 85 B0                 sta   <workptr+2
6917 1BB2 20 13 1F              jsr   intolist
6918 1BB5
6919 1BB5              ;---------------------------------------------------------------
6920 1BB5 20 AD 21     calcUpdateRgn jsr   alloc_rgn           ;allocate a temp work region in <rgnptr
6921 1BB8
6922 1BB8 A0 22 00              ldy   #wport+GP_VisRgn+2       ;offset the visible region to global
6923 1BBB B7 A6                 lda   [<wind],y                ;..coordinates
6924 1BBD AA                    tax   
6925 1BBE 88                    dey   
6926 1BBF 88                    dey   
6927 1BC0 B7 A6                 lda   [<wind],y
6928 1BC2 20 4B 1C              jsr   offsetToGlobal
6929 1BC5
6930 1BC5 A0 C4 00              ldy   #wContRgn+2              ;the new update region is the difference
6931 1BC8 20 F9 21              jsr   pushandle                ;..between the content region and the
6932 1BCB A0 22 00              ldy   #wport+GP_VisRgn+2       ;..old visible region
6933 1BCE 20 F9 21              jsr   pushandle
6934 1BD1 D4 BA                 pei   <rgnptr+2
6935 1BD3 D4 B8                 pei   <rgnptr
6936 1BD5 A2 04 73 22           _DiffRgn 
6937 1BDC
6938 1BDC D4 BA                 pei   <rgnptr+2                ;add the new update area to the old
6939 1BDE D4 B8                 pei   <rgnptr                  ;..update region
6940 1BE0 A0 C8 00              ldy   #wUpdateRgn+2
6941 1BE3 20 F9 21              jsr   pushandle
6942 1BE6 A0 C8 00              ldy   #wUpdateRgn+2
6943 1BE9 20 F9 21              jsr   pushandle
6944 1BEC A2 04 72 22           _UnionRgn 
6945 1BF3
6946 1BF3 A0 C4 00              ldy   #wContRgn+2              ;set the new visible region to the
6947 1BF6 20 F9 21              jsr   pushandle                ;..intersection of the content region
6948 1BF9 20 87 21              jsr   pushGray                 ;..and the desktop
6949 1BFC A0 22 00              ldy   #wport+GP_VisRgn+2
6950 1BFF 20 F9 21              jsr   pushandle
6951 1C02 A2 04 71 22           _SectRgn 
6952 1C09
6953 1C09 A0 22 00              ldy   #wport+GP_VisRgn+2       ;offset the visible region back to local
6954 1C0C B7 A6                 lda   [<wind],y                ;..coordinates
6955 1C0E AA                    tax   
6956 1C0F 88                    dey   
6957 1C10 88                    dey   
6958 1C11 B7 A6                 lda   [<wind],y
6959 1C13 20 41 1C              jsr   offsetToLocal
6960 1C16
6961 1C16 20 E9 1E              jsr   hilite                   ;hilight the new topmost window
6962 1C19 20 C7 1E              jsr   activate                 ;send activate message to 'wind'.
6963 1C1C 20 68 1C              jsr   drawEntireFrame          ;draw the new window frame
6964 1C1F
6965 1C1F D4 BA                 pei   <rgnptr+2                ;erase the new update area
6966 1C21 D4 B8                 pei   <rgnptr
6967 1C23 A5 A6 A6 A8           ldax <wind
6968 1C27 18                    clc   
6969 1C28 69 24 00              adc   #wport+GP_BkPat
6970 1C2B 90 01                 bcc   @1
6971 1C2D E8                    inx   
6972 1C2E DA           @1       phx   
6973 1C2F 48                    pha   
6974 1C30 A2 04 7D 22           _FillRgn 
6975 1C37
6976 1C37 20 78 26              jsr   disposeRgnPtr            ;dispose of the temporary region
6977 1C3A
6978 1C3A 20 60 20              jsr   restore_port             ;restore original port.
6979 1C3D              ;---------------------------------------------------------------
6980 1C3D 8B           exit     phb   
6981 1C3E
6982 1C3E 82 72 73              brl   pop4bytes                ;pop input parameters and return.
6983 1C41              ;---------------------------------------------------------------
6984 1C41
6985 1C41                       ENDP 
6986 1C41
6987 1C41              ****************************************************************
6988 1C41
6989 1C41              WindXXXProc PROC  ENTRY 
6990 1C41
6991 1C41              ;---------------------------------------------------------------
6992 1C41                       ENTRY  offsetToLocal
6993 1C41                       ENTRY  offsetToGlobal
6994 1C41              ;---------------------------------------------------------------
6995 1C41
6996 1C41              ;---------------------------------------------------------------
6997 1C41 DA 48        offsetToLocal PushAX 
6998 1C43 A0 0E 00              ldy   #wport+GP_Bounds+x1
6999 1C46 20 F9 21              jsr   pushWlong
7000 1C49 80 15                 bra   offsetIt
7001 1C4B              ;---------------------------------------------------------------
7002 1C4B DA 48        offsetToGlobal PushAX 
7003 1C4D A0 0E 00              ldy   #wport+GP_Bounds+x1
7004 1C50 B7 A6                 lda   [<wind],y
7005 1C52 49 FF FF              eor   #$FFFF
7006 1C55 1A                    inc   a
7007 1C56 48                    pha   
7008 1C57 88                    dey   
7009 1C58 88                    dey   
7010 1C59 B7 A6                 lda   [<wind],y
7011 1C5B 49 FF FF              eor   #$FFFF
7012 1C5E 1A                    inc   a
7013 1C5F 48                    pha   
7014 1C60 A2 04 6F 22  offsetIt _OffsetRgn 
7015 1C67 60                    rts   
7016 1C68              ;---------------------------------------------------------------
7017 1C68
7018 1C68                       ENDP 
7019 1C68
7020 1C68              ****************************************************************
7021 1C68
7022 1C68              drawEntireFrame PROC  ENTRY 
7023 1C68
7024 1C68              ;---------------------------------------------------------------
7025 1C68 20 A8 1F              jsr   moveWMgrOnWind           ;setup for drawing the frame
7026 1C6B
7027 1C6B 64 C4                 stz   <param                   ;pass 'draw entire frame' flag.
7028 1C6D 64 C6                 stz   <param+2                 ;pass 'unhilited' flag.
7029 1C6F A2 00 00              ldx   #wDraw
7030 1C72 20 19 20              jsr   dispatch
7031 1C75
7032 1C75 82 80 03              brl   moveWMgrBack             ;restore the clip region
7033 1C78              ;---------------------------------------------------------------
7034 1C78
7035 1C78                       ENDP 
7036 1C78
7037 1C78              ****************************************************************
7038 1C78              ;
7039 1C78              ;==============================================
7040 1C78              ;        Send a window behind another one.
7041 1C78              ;==============================================
7042 1C78              ;
7043 1C78              ;   IN:  PUSH:LONG - pointer to window in front of first given window,
7044 1C78              ;                      or -2 to put it on the bottom.
7045 1C78              ;        PUSH:LONG - pointer to the window's port.
7046 1C78              ;  OUT:  None.
7047 1C78              ;
7048 1C78              SendBehind PROC 
7049 1C78              ;
7050 1C78              ;
7051 1C78              ;
7052 1C78 20 CA 21              jsr   setup                    Get 2 pointers of input.
7053 1C7B              ;
7054 1C7B 20 89 1C              jsr   fixworkptr
7055 1C7E A8                    tay                            Pass which window wind goes behind.
7056 1C7F A9 01 00              lda   #1                       Perform hiliting flag.
7057 1C82 20 9B 1C              jsr   airport
7058 1C85              ;
7059 1C85 8B                    phb   
7060 1C86 82 3A 73              brl   pop8bytes
7061 1C89              ;
7062 1C89              ;
7063 1C89              ; = = = = = = = = = = = = = = = = = = = = = = = =
7064 1C89              ;          Make workptr a window pointer.
7065 1C89              ;100= = = = = = = = = = = = = = = = = = = = = = =
7066 1C89              ;
7067 1C89              ;   IN:    workptr = window port pointer.
7068 1C89              ;
7069 1C89              ;  OUT:    workptr = window pointer.
7070 1C89              ;          a = workptr.
7071 1C89              ;          x = workptr+2.
7072 1C89              ;
7073 1C89                       ENTRY fixworkptr
7074 1C89              fixworkptr                              ; 
7075 1C89              ;
7076 1C89 A5 AE                 lda   <workptr
7077 1C8B A6 B0                 ldx   <workptr+2               Was a window pointer passed?
7078 1C8D 30 0B                 bmi   exit100
7079 1C8F              ;
7080 1C8F 38                    sec                            Make window pointer a record pointer.
7081 1C90 E9 04 00              sbc   #wport
7082 1C93 B0 01                 bcs   store100
7083 1C95 CA                    dex   
7084 1C96              ;
7085 1C96 85 AE        store100 sta   <workptr
7086 1C98 86 B0                 stx   <workptr+2
7087 1C9A 60           exit100  rts   
7088 1C9B              ;
7089 1C9B                       ENDP 
7090 1C9B              ;
7091 1C9B              ;
7092 1C9B              ;==================================================
7093 1C9B              ;          Change window plane and redraw.
7094 1C9B              ;===================================================
7095 1C9B              ;
7096 1C9B              ;   IN:    a = $xxx1 to doing hiliting/unhiliting, $xxx0 to not.
7097 1C9B              ;              $8xxx if window was invisible, $0xxx if window was visible.
7098 1C9B              ;          x/y = window to put <wind behind.
7099 1C9B              ;                $FFFFFFFF to move <wind to top.
7100 1C9B              ;                $FFFFFFFE to move <wind to bottom.
7101 1C9B              ;          <wind = window to send behind, if invisible no drawing done.
7102 1C9B              ;
7103 1C9B              ;  OUT:  None.
7104 1C9B              ;
7105 1C9B              airport  PROC 
7106 1C9B              ;
7107 1C9B              nextWindow equ   1
7108 1C9B              behind   equ   nextWindow+4
7109 1C9B              dohilite equ   behind+4
7110 1C9B              ;
7111 1C9B              ;
7112 1C9B 48                    pha                            1=hilite, 0=don't do hiliting.
7113 1C9C              ;
7114 1C9C 84 AE                 sty   <workptr                 Save behind parameter.
7115 1C9E 86 B0                 stx   <workptr+2
7116 1CA0 DA                    phx   
7117 1CA1 5A                    phy   
7118 1CA2              ;
7119 1CA2 A0 02 00              ldy   #wNext+2                 Save window under one being changed.
7120 1CA5 B7 A6                 lda   [<wind],y
7121 1CA7 48                    pha   
7122 1CA8 A7 A6                 lda   [<wind]
7123 1CAA 48                    pha   
7124 1CAB              ;
7125 1CAB              ;
7126 1CAB              ; --- Get copy of visible window that I beginnin with --------------------
7127 1CAB              ;
7128 1CAB 20 3A 20              jsr   setwmgrport              Swicth to Window Manager's port.
7129 1CAE              ;
7130 1CAE 20 AD 21              jsr   alloc_rgn                Allocate a temp work region.
7131 1CB1              ;
7132 1CB1 A3 09                 lda   dohilite,s               Did the window start as invisible?
7133 1CB3 30 25                 bmi   skip1
7134 1CB5              ;
7135 1CB5 20 48 22              jsr   testVis                  If window is invisible don't do drawing.
7136 1CB8 F0 20                 beq   skip1
7137 1CBA              ;
7138 1CBA A0 C0 00              ldy   #wstrucRgn+2             Clone window's region.
7139 1CBD 20 F9 21              jsr   pushandle
7140 1CC0 20 9A 21              jsr   pushclip
7141 1CC3 A2 04 69 22           _CopyRgn 
7142 1CCA              ;
7143 1CCA 20 B1 08              jsr   clipabove                Subtract all windows above 'wind'.
7144 1CCD              ;
7145 1CCD 20 9A 21              jsr   pushclip                 Clone beginning visible window part.
7146 1CD0 20 80 21              jsr   pushrgnptr               rgnptr = beginning visible window.
7147 1CD3 A2 04 69 22           _CopyRgn 
7148 1CDA              ;
7149 1CDA              ;
7150 1CDA              ; --- Reorder window list ---------------------------------------------
7151 1CDA              ;
7152 1CDA 20 FE 1E     skip1    jsr   outoflist                Remove 'wind' from window list.
7153 1CDD 10 03                 bpl   ok1                      Was 'wind' in the list?
7154 1CDF 82 9E 00              brl   exit
7155 1CE2              ;
7156 1CE2 A3 05        ok1      lda   behind,s                 Pass window to send 'wind' behind.
7157 1CE4 85 AE                 sta   <workptr
7158 1CE6 A3 07                 lda   behind+2,s
7159 1CE8 85 B0                 sta   <workptr+2
7160 1CEA 20 13 1F              jsr   intolist                 Put 'wind' into proper plane.
7161 1CED              ;
7162 1CED              ;
7163 1CED              ; --- Compute the area of the screen that changed -----------------------
7164 1CED              ;
7165 1CED 20 48 22              jsr   testVis                  If window is invisible don't do drawing.
7166 1CF0 D0 03                 bne   @ok2
7167 1CF2 82 8B 00              brl   exit
7168 1CF5              @ok2      
7169 1CF5              ;
7170 1CF5 A9 FF FF              lda   #$FFFF
7171 1CF8 C3 05                 cmp   behind,s
7172 1CFA D0 0B                 bne   @toBottom
7173 1CFC C3 07                 cmp   behind+2,s
7174 1CFE D0 07                 bne   @toBottom
7175 1D00              ;
7176 1D00 A3 03                 lda   nextWindow+2,s           Compute visRgns to where new top window came from.
7177 1D02 AA                    tax   
7178 1D03 A3 01                 lda   nextWindow,s
7179 1D05 80 02                 bra   @ok1
7180 1D07              ;
7181 1D07 1A           @toBottom inc   a                       Compute visRgns for every window.
7182 1D08 AA                    tax   
7183 1D09 20 17 08     @ok1     jsr   calc_vis                 Compute visRgns.
7184 1D0C              ;
7185 1D0C              ;
7186 1D0C A0 C0 00              ldy   #wstrucRgn+2             Clone window's region.
7187 1D0F 20 F9 21              jsr   pushandle
7188 1D12 20 9A 21              jsr   pushclip
7189 1D15 A2 04 69 22           _CopyRgn 
7190 1D1C              ;
7191 1D1C 20 B1 08              jsr   clipabove                Subtract all windows above 'wind'.
7192 1D1F              ;
7193 1D1F 20 80 21              jsr   pushrgnptr               Beginning visible window.
7194 1D22 20 9A 21              jsr   pushclip                 Visible window after plane change.
7195 1D25 20 80 21              jsr   pushrgnptr               Result in clobbered region.
7196 1D28 A2 04 74 22           _XorRgn                        Compute the part that changed.
7197 1D2F              ;
7198 1D2F              ;
7199 1D2F              ; --- Unhilite/Hilite as needed, and add frames to clobbered region --------
7200 1D2F              ;
7201 1D2F A3 09        skip2    lda   dohilite,s               Did caller want hiliting changes?
7202 1D31 29 01 00              and   #$0001
7203 1D34 F0 3F                 beq   exit1
7204 1D36              ;
7205 1D36 64 DE                 stz   <work                    Set top window not found flag.
7206 1D38              ;
7207 1D38 A5 8E                 lda   <topwind
7208 1D3A A6 90                 ldx   <topwind+2
7209 1D3C 80 2F                 bra   enter1
7210 1D3E              ;
7211 1D3E 20 48 22     lop1     jsr   testVis                  Test the window's F_VIS flag.
7212 1D41 F0 22                 beq   nextwind                 If not, skip it.
7213 1D43              ;
7214 1D43 B7 A6                 lda   [<wind],y
7215 1D45 29 01 00              and   #F_HILITED               Get hilite bit.
7216 1D48 A6 DE                 ldx   <work                    Has the first visible window been found?
7217 1D4A D0 0D                 bne   ck_unlite                If yes, this window should be unhilited.
7218 1D4C              ;
7219 1D4C AA                    tax                            Is the window hilited?
7220 1D4D D0 26                 bne   exit1                    If yes, top still top, clobbered ready.
7221 1D4F              ;
7222 1D4F E6 DE                 inc   <work                    Set 'top window found' flag.
7223 1D51              ;
7224 1D51 20 E9 1E              jsr   hilite                   Hilite the new top window.
7225 1D54 20 C7 1E              jsr   activate                 Send activate message to 'wind'.
7226 1D57 80 09                 bra   plusFrame                Add window's frame to clobbered area.
7227 1D59              ;
7228 1D59 AA           ck_unlite tax                           Is inactive window unhilited?
7229 1D5A F0 09                 beq   nextwind                 If yes, it hasn't changed states.
7230 1D5C              ;
7231 1D5C 20 F3 1E              jsr   unhilite                 Clear hilite bit.
7232 1D5F 20 D8 1E              jsr   deactivate               Send deactivate message to 'wind'.
7233 1D62              ;
7234 1D62 20 8F 1D     plusFrame jsr   addframe                Add window's frame to clobbered region.
7235 1D65              ;
7236 1D65 A0 02 00     nextwind ldy   #2
7237 1D68 B7 A6                 lda   [<wind],y
7238 1D6A AA                    tax   
7239 1D6B A7 A6                 lda   [<wind]
7240 1D6D              ;
7241 1D6D 85 A6        enter1   sta   <wind
7242 1D6F 86 A8                 stx   <wind+2
7243 1D71 05 A8                 ora   <wind+2                  Any more windows?
7244 1D73 D0 C9                 bne   lop1
7245 1D75              ;
7246 1D75              ;          
7247 1D75 A5 8E        exit1    lda   <topwind                 Start with first window in list.
7248 1D77 85 A6                 sta   <wind
7249 1D79 A5 90                 lda   <topwind+2
7250 1D7B 85 A8                 sta   <wind+2
7251 1D7D              ;
7252 1D7D 20 B5 06              jsr   paintonedown             Draw all windows in clobbered region.
7253 1D80              ;
7254 1D80 20 78 26     exit     jsr   disposeRgnPtr            Free temp work region.
7255 1D83              ;
7256 1D83 20 6E 22              jsr   zeroOrigin               SetOrigin( 0,0,).
7257 1D86 20 60 20              jsr   restore_port             Restore original port.
7258 1D89              ;
7259 1D89 68                    pla   
7260 1D8A 68                    pla   
7261 1D8B 68                    pla   
7262 1D8C 68                    pla   
7263 1D8D 68                    pla   
7264 1D8E 60                    rts   
7265 1D8F                       ENDP 
7266 1D8F              ;
7267 1D8F              ;
7268 1D8F              ;===========================================================
7269 1D8F              ;        Add window's frame region to rgnptr region.
7270 1D8F              ;===========================================================
7271 1D8F              ;
7272 1D8F              ;   IN:    wind = window frame to add.
7273 1D8F              ;
7274 1D8F              ;  OUT:    rgnptr = rgnptr + wind's visible frame.
7275 1D8F              ;          Window Manager's clip region is trashed.
7276 1D8F              ;
7277 1D8F              addframe PROC 
7278 1D8F              ;
7279 1D8F                                                      ;using equates
7280 1D8F              ;
7281 1D8F              ;
7282 1D8F              ; --- Compute area of frame to draw -----------------------------------------
7283 1D8F              ;
7284 1D8F A0 C0 00              ldy   #wstrucRgn+2
7285 1D92 20 F9 21              jsr   pushandle
7286 1D95 A0 C4 00              ldy   #wcontRgn+2
7287 1D98 20 F9 21              jsr   pushandle
7288 1D9B 20 9A 21              jsr   pushclip
7289 1D9E A2 04 73 22           _DiffRgn                       clip = wstrucRgn - wcontRgn.
7290 1DA5              ;
7291 1DA5 20 B1 08              jsr   clipabove                Remove any windows above.
7292 1DA8              ;
7293 1DA8 20 80 21              jsr   pushrgnptr
7294 1DAB 20 9A 21              jsr   pushclip
7295 1DAE 20 80 21              jsr   pushrgnptr
7296 1DB1 A2 04 73 22           _DiffRgn                       clobbered = clobbered - visible frame.
7297 1DB8              ;
7298 1DB8              ;
7299 1DB8              ; --- Redraw frame ----------------------------------------------------------
7300 1DB8              ;
7301 1DB8 82 C7 01              brl   drawframe
7302 1DBB                       ENDP 
7303 1DBB              ;
7304 1DBB              ;
7305 1DBB              ;========================================
7306 1DBB              ;        Make a window visible.
7307 1DBB              ;========================================
7308 1DBB              ;
7309 1DBB              ;   IN:  PUSH - LONG - pointer to the window port.
7310 1DBB              ;  OUT:  None.
7311 1DBB              ;
7312 1DBB              ;        If the window isn't going to be the top visible window
7313 1DBB              ;              then just call ShowHide.
7314 1DBB              ;        Else
7315 1DBB              ;              call SelectWindow:
7316 1DBB              ;                                       Unhighlight current top window.
7317 1DBB              ;                                       Moves the window to the top of list.
7318 1DBB              ;              call ShowHide to make the window visible.
7319 1DBB              ;
7320 1DBB              ShowWindow PROC 
7321 1DBB              ;
7322 1DBB              ;
7323 1DBB 20 CA 21              jsr   setup
7324 1DBE              ;
7325 1DBE 20 48 22              jsr   testVis                  Test the window's F_VIS flag.
7326 1DC1 D0 4D                 bne   exit100                  Is the window already visible?
7327 1DC3              ;
7328 1DC3              ;
7329 1DC3              ; --- Is the window going to be the active window? ----
7330 1DC3              ;
7331 1DC3 A5 90                 lda   <topwind+2
7332 1DC5 A6 8E                 ldx   <topwind
7333 1DC7 C5 A8        lop100   cmp   <wind+2                  Are we at the window?
7334 1DC9 D0 04                 bne   next100
7335 1DCB E4 A6                 cpx   <wind
7336 1DCD F0 1C                 beq   newtop                   The window is in front of the
7337 1DCF              ;                                     current active window.
7338 1DCF 86 AE        next100  stx   <workptr
7339 1DD1 85 B0                 sta   <workptr+2
7340 1DD3              ;
7341 1DD3 A0 D2 00              ldy   #wframe                  Is this window visible?
7342 1DD6 B7 AE                 lda   [<workptr],y
7343 1DD8 29 20 00              and   #F_VIS
7344 1DDB D0 24                 bne   justshowit               The window is not in front of
7345 1DDD              ;                                     current active window.
7346 1DDD              ;
7347 1DDD A7 AE                 lda   [<workptr]
7348 1DDF AA                    tax   
7349 1DE0 A0 02 00              ldy   #wnext+2
7350 1DE3 17 AE                 ora   [<workptr],y             Is the window event in the list?
7351 1DE5 F0 29                 beq   exit100
7352 1DE7              ;
7353 1DE7 B7 AE                 lda   [<workptr],y
7354 1DE9 80 DC                 bra   lop100
7355 1DEB              ;
7356 1DEB              ;
7357 1DEB              ; --- Window is going to be the new active window. ----
7358 1DEB              ;
7359 1DEB A0 D2 00     newtop   ldy   #wframe
7360 1DEE B7 A6                 lda   [<wind],y
7361 1DF0 09 20 00              ora   #F_VIS                   Set visible flag.
7362 1DF3 97 A6                 sta   [<wind],y
7363 1DF5              ;
7364 1DF5              ;                                     VisRgn must be empty.
7365 1DF5              ;
7366 1DF5 A9 01 80              lda   #$8001                   Window was invisible, do hiliting.
7367 1DF8 A2 FF FF              ldx   #$FFFF                   Make the window top.
7368 1DFB 9B                    txy   
7369 1DFC 20 9B 1C              jsr   airport
7370 1DFF 80 0F                 bra   exit100
7371 1E01              ;
7372 1E01              ;
7373 1E01              ; --- Show the window. -----------------
7374 1E01              ;
7375 1E01 F4 20 00     justshowit pea   F_VIS                  Make window visible.
7376 1E04 20 04 22              jsr   get_portptr
7377 1E07 DA                    phx   
7378 1E08 48                    pha   
7379 1E09 A2 0E 23 22           _ShowHide 
7380 1E10              ;
7381 1E10              ;
7382 1E10 8B           exit100  phb   
7383 1E11 82 9F 71              brl   pop4bytes                Pop input parameters and return.
7384 1E14                       ENDP 
7385 1E14              ;
7386 1E14              ;
7387 1E14              ;============================
7388 1E14              ;        Hide a window.
7389 1E14              ;============================
7390 1E14              ;
7391 1E14              ;   IN:    PUSH:LONG - pointer to window's port.
7392 1E14              ;
7393 1E14              ;  OUT:    None.
7394 1E14              ;
7395 1E14              ;          Hide the window.
7396 1E14              ;          Select a new active window if the hidden window was active.
7397 1E14              ;
7398 1E14              HideWindow PROC 
7399 1E14              ;
7400 1E14                                                      ;using equates
7401 1E14              ;
7402 1E14              theWind  equ   9
7403 1E14              ;
7404 1E14              ;
7405 1E14 20 CA 21              jsr   setup
7406 1E17              ;
7407 1E17 20 48 22              jsr   testVis                  Test the window's F_VIS flag.
7408 1E1A F0 34                 beq   exit100
7409 1E1C              ;
7410 1E1C 20 96 20              jsr   find_top                 Find top most visible window.
7411 1E1F              ;                                     and make it the new top window.
7412 1E1F              ;
7413 1E1F 20 08 22              jsr   get_portp2               Get pointer to window's port.
7414 1E22 DA                    phx                            Save.
7415 1E23 48                    pha   
7416 1E24              ;
7417 1E24 F4 00 00              pea   0                        Hide window.
7418 1E27 A3 11                 lda   theWind+8,s              Pass window pointer.
7419 1E29 48                    pha   
7420 1E2A A3 11                 lda   theWind+8,s
7421 1E2C 48                    pha   
7422 1E2D A2 0E 23 22           _ShowHide 
7423 1E34              ;
7424 1E34              ;
7425 1E34              ; --- Was the window the active window? ----
7426 1E34              ;
7427 1E34 68                    pla                            Get saved prior top window.
7428 1E35 FA                    plx   
7429 1E36 C3 09                 cmp   theWind,s                Did I just hide the top window?
7430 1E38 D0 16                 bne   exit100
7431 1E3A 8A                    txa   
7432 1E3B C3 0B                 cmp   theWind+2,s
7433 1E3D D0 11                 bne   exit100                  Don't worry, I didn't hide the top window.
7434 1E3F              ;
7435 1E3F 20 96 20              jsr   find_top                 Find the next visible window,
7436 1E42              ;                                     and make it the new top window.
7437 1E42 F0 0C                 beq   exit100                  Are there any windows left?
7438 1E44              ;
7439 1E44 20 08 22              jsr   get_portp2               Pass pointer to window's port.
7440 1E47 DA                    phx   
7441 1E48 48                    pha   
7442 1E49 A2 0E 11 22           _SelectWindow 
7443 1E50              ;
7444 1E50 8B           exit100  phb   
7445 1E51 82 5F 71              brl   pop4bytes
7446 1E54                       ENDP 
7447 1E54              ;
7448 1E54              ;
7449 1E54              ;===================================
7450 1E54              ;        ShowHide a window.
7451 1E54              ;===================================
7452 1E54              ;
7453 1E54              ;   IN:  PUSH - WORD - FALSE to hide, TRUE to show.
7454 1E54              ;        PUSH - LONG - pointer to window port.
7455 1E54              ;
7456 1E54              ;        If flag is already in the requested state then just exit.
7457 1E54              ;        Else
7458 1E54              ;              Put visible flag into desired state.
7459 1E54              ;              Redraw affected screen area.
7460 1E54              ;
7461 1E54              ;
7462 1E54              ShowHide PROC 
7463 1E54              ;
7464 1E54              ;
7465 1E54              theWindow equ   9
7466 1E54              vis_flag equ   theWindow+4
7467 1E54              ;
7468 1E54              ;
7469 1E54 20 CA 21              jsr   setup
7470 1E57              ;
7471 1E57              ;
7472 1E57              ; --- Is the caller requesting the visible state change? ---
7473 1E57              ;
7474 1E57 A3 0D                 lda   vis_flag,s
7475 1E59 F0 03                 beq   store1
7476 1E5B A9 20 00              lda   #F_VIS
7477 1E5E 85 AE        store1   sta   <workptr
7478 1E60 AA                    tax   
7479 1E61              ;
7480 1E61 20 48 22              jsr   testVis                  Get the window's F_VIS flag.
7481 1E64 45 AE                 eor   <workptr
7482 1E66 F0 5B                 beq   exit100                  No change if zero.
7483 1E68              ;
7484 1E68              ; --- Change visible flag ------
7485 1E68              ;
7486 1E68 B7 A6                 lda   [<wind],y
7487 1E6A 49 20 00              eor   #F_VIS                   Flip visible flag.
7488 1E6D              ;
7489 1E6D E0 00 00              cpx   #0                       Hiding window?
7490 1E70 D0 03                 bne   store2
7491 1E72              ;
7492 1E72 29 FE FF              and   #_F_HILITED              Unhilite window to be hidden.
7493 1E75              ;
7494 1E75 97 A6        store2   sta   [<wind],y
7495 1E77              ;
7496 1E77 8A                    txa                            Hiding window?
7497 1E78 D0 0D                 bne   skip2
7498 1E7A              ;
7499 1E7A A0 22 00              ldy   #wport+GP_VisRgn+2       Set window's VisRgn to empty.
7500 1E7D 20 F9 21              jsr   pushandle
7501 1E80 A2 04 6A 22           _SetEmptyRgn 
7502 1E87              ;
7503 1E87              ;    
7504 1E87              ; --- Redraw affected screen area -----
7505 1E87              ;
7506 1E87 20 3A 20     skip2    jsr   setwmgrport              Swicth to Window Manager's port.
7507 1E8A              ;
7508 1E8A A0 C0 00              ldy   #wstrucRgn+2             Pass window's region.
7509 1E8D 20 F9 21              jsr   pushandle
7510 1E90 20 9A 21              jsr   pushclip                 Pass handle of wmgr clip region.
7511 1E93 A2 04 69 22           _CopyRgn                       Clip = window region.
7512 1E9A              ;
7513 1E9A 20 B1 08              jsr   clipabove                Subtract windows above 'wind' from clip.
7514 1E9D D0 1E                 bne   skip1
7515 1E9F              ;
7516 1E9F 20 AD 21              jsr   alloc_rgn                Get temp. region, for clobbered region.
7517 1EA2              ;
7518 1EA2 20 9A 21              jsr   pushclip                 Pass handle of clip (clobbered) region.
7519 1EA5 20 80 21              jsr   pushrgnptr               Pass handle of real clobbered region.
7520 1EA8 A2 04 69 22           _CopyRgn                       Clone clobbered region.
7521 1EAF              ;
7522 1EAF A5 8E                 lda   <topwind                 Redraw all windows
7523 1EB1 85 A6                 sta   <wind
7524 1EB3 A5 90                 lda   <topwind+2
7525 1EB5 85 A8                 sta   <wind+2
7526 1EB7 20 B5 06              jsr   paintonedown             in clobbered region.
7527 1EBA              ;
7528 1EBA 20 78 26              jsr   disposeRgnPtr            Free temp. clobbered region.
7529 1EBD              ;
7530 1EBD 20 17 08     skip1    jsr   calc_vis                 Compute visible regions for every window.
7531 1EC0              ;
7532 1EC0 20 60 20              jsr   restore_port             Restore original port.
7533 1EC3              ;
7534 1EC3 8B           exit100  phb   
7535 1EC4 82 F4 70              brl   pop6bytes
7536 1EC7                       ENDP 
7537 1EC7
7538 1EC7
7539 1EC7
7540 1EC7
7541 1EC7              ;====================================================
7542 1EC7              ;          Send a activate message to window.
7543 1EC7              ;====================================================
7544 1EC7              ;
7545 1EC7              ;   IN:    wind = window to activate.
7546 1EC7              ;
7547 1EC7
7548 1EC7                       import ToolboxPatcher
7549 1EC7              activate PROC 
7550 1EC7
7551 1EC7 A2 02 00              ldx   #oWMActivate
7552 1ECA 5C BC 01 E1           jml   ToolboxPatcher
7553 1ECE
7554 1ECE
7555 1ECE                       EXPORT RealWMActivate
7556 1ECE              RealWMActivate  
7557 1ECE
7558 1ECE E6 80                 inc   <FlgActive               Set activate event flag.
7559 1ED0
7560 1ED0 20 04 22              jsr   get_portptr              Get port pointer of 'wind'.
7561 1ED3 85 84                 sta   <CurActive               Set window that's activated.
7562 1ED5 86 86                 stx   <CurActive+2
7563 1ED7 60                    rts   
7564 1ED8
7565 1ED8
7566 1ED8                       ENDP 
7567 1ED8
7568 1ED8
7569 1ED8
7570 1ED8              ;====================================================
7571 1ED8              ;          Send a deactivate message to window.
7572 1ED8              ;====================================================
7573 1ED8              ;
7574 1ED8              ;   IN:    wind = window to deactivate.
7575 1ED8              ;
7576 1ED8                       import ToolboxPatcher
7577 1ED8
7578 1ED8              deactivate PROC 
7579 1ED8
7580 1ED8 A2 04 00              ldx   #oWMDeActivate
7581 1EDB 5C BC 01 E1           jml   ToolboxPatcher
7582 1EDF
7583 1EDF
7584 1EDF                       EXPORT RealWMDeActivate
7585 1EDF              RealWMDeActivate  
7586 1EDF
7587 1EDF
7588 1EDF
7589 1EDF E6 82                 inc   <FlgDeActive             Set deactivate event flag.
7590 1EE1              ;
7591 1EE1 20 04 22              jsr   get_portptr              Get port pointer of 'wind'.
7592 1EE4 85 88                 sta   <CurDeActive             Set window that's deactivated.
7593 1EE6 86 8A                 stx   <CurDeActive+2
7594 1EE8 60                    rts   
7595 1EE9
7596 1EE9
7597 1EE9                       ENDP 
7598 1EE9
7599 1EE9
7600 1EE9              ;====================================================
7601 1EE9              ;        Set/Clear Highlight bit in top
7602 1EE9              ;        window frame and redraw frame.
7603 1EE9              ;====================================================
7604 1EE9              ;
7605 1EE9              ;   IN:    wind = window to hilite or unhilite.
7606 1EE9              ;
7607 1EE9              hilite   PROC 
7608 1EE9              ;
7609 1EE9                                                      ;using equates
7610 1EE9              ;
7611 1EE9              ;
7612 1EE9 A0 D2 00              ldy   #wframe
7613 1EEC B7 A6                 lda   [<wind],y
7614 1EEE 09 01 00              ora   #F_HILITED               Set highlight bit.
7615 1EF1 80 08                 bra   common
7616 1EF3              ;
7617 1EF3                       ENTRY unhilite
7618 1EF3              unhilite                                ; 
7619 1EF3              ;
7620 1EF3 A0 D2 00              ldy   #wframe
7621 1EF6 B7 A6                 lda   [<wind],y
7622 1EF8 29 FE FF              and   #$FFFE                   Clear highlight bit.
7623 1EFB              ;
7624 1EFB 97 A6        common   sta   [<wind],y
7625 1EFD              ;
7626 1EFD 60                    rts   
7627 1EFE                       ENDP 
7628 1EFE              ;
7629 1EFE              ;
7630 1EFE              ;===================================================
7631 1EFE              ;        Take a window out of the list.
7632 1EFE              ;===================================================
7633 1EFE              ;
7634 1EFE              ;   IN:    wind = window to take out of list.
7635 1EFE              ;
7636 1EFE              ;  OUT:    Neg = TRUE if window not in list.
7637 1EFE              ;
7638 1EFE              ;
7639 1EFE              outoflist PROC 
7640 1EFE              ;
7641 1EFE                                                      ;using equates
7642 1EFE              ;
7643 1EFE              ;
7644 1EFE 20 BD 20              jsr   getpre
7645 1F01 30 0F                 bmi   exit100                  Window not in list?
7646 1F03 08                    php                            Save status.
7647 1F04              ;
7648 1F04              ;   wind = window to take out of list.
7649 1F04              ;   workptr = window in front of wind (might be address of 'topwind').
7650 1F04              ;
7651 1F04 A0 00 00              ldy   #wnext
7652 1F07 B7 A6                 lda   [<wind],y
7653 1F09 97 AE                 sta   [<workptr],y
7654 1F0B C8                    iny   
7655 1F0C C8                    iny   
7656 1F0D B7 A6                 lda   [<wind],y
7657 1F0F 97 AE                 sta   [<workptr],y
7658 1F11              ;
7659 1F11 28                    plp                            Return status of 'getpre'.
7660 1F12              ;
7661 1F12 60           exit100  rts   
7662 1F13                       ENDP 
7663 1F13              ;
7664 1F13              ;
7665 1F13              ;=============================================
7666 1F13              ;        Insert a window into the list.
7667 1F13              ;=============================================
7668 1F13              ;
7669 1F13              ;   IN:    wind = window to be inseted, must not be currently in list.
7670 1F13              ;          workptr = window where wind will be inserted behind.
7671 1F13              ;                    $FFFFFFFF to insert as top most.
7672 1F13              ;                    $FFFFFFFE to insert as bottom most.
7673 1F13              intolist PROC 
7674 1F13              ;
7675 1F13                                                      ;using equates
7676 1F13              ;
7677 1F13              ;
7678 1F13 A5 B0                 lda   <workptr+2               Window pointer or specical command?
7679 1F15 10 28                 bpl   insertit                 Must be a window pointer.
7680 1F17              ;
7681 1F17 A5 AE                 lda   <workptr                 Should window go to the bottom?
7682 1F19 C9 FE FF              cmp   #$FFFE
7683 1F1C F0 0B                 beq   tobottom                 If negative and not -2, must be -1.
7684 1F1E              ;
7685 1F1E              ;
7686 1F1E              ; ------ Insert as top window ---------------------------
7687 1F1E              ;
7688 1F1E                       ENTRY wind2top
7689 1F1E              wind2top                                ; 
7690 1F1E              ;
7691 1F1E 64 B0                 stz   <workptr+2               Set to address of 'topwind'.
7692 1F20 7B                    tdc   
7693 1F21 18                    clc   
7694 1F22 69 8E 00              adc   #topwind
7695 1F25 85 AE                 sta   <workptr
7696 1F27 80 16                 bra   insertit
7697 1F29              ;
7698 1F29              ; ------ Insert under bottom window ---------------------
7699 1F29              ;
7700 1F29 64 B0        tobottom stz   <workptr+2
7701 1F2B              ;
7702 1F2B A6 8E                 ldx   <topwind                 Start at top and work down.
7703 1F2D A5 8F                 lda   <topwind+1
7704 1F2F F0 ED                 beq   wind2top
7705 1F31              ;
7706 1F31 A0 01 00              ldy   #wnext+1
7707 1F34 86 AE        lop100   stx   <workptr
7708 1F36 85 AF                 sta   <workptr+1
7709 1F38              ;
7710 1F38 A7 AE                 lda   [<workptr]               Next window.
7711 1F3A AA                    tax   
7712 1F3B B7 AE                 lda   [<workptr],y
7713 1F3D D0 F5                 bne   lop100
7714 1F3F              ;
7715 1F3F              ;
7716 1F3F              ; --- Insert the window ---------------------------------
7717 1F3F              ;
7718 1F3F              ;  wind = window to be put under.
7719 1F3F              ;  workptr = window to be in front of 'wind'.
7720 1F3F              ;
7721 1F3F A0 02 00     insertit ldy   #wnext+2                 Insert window back in list.
7722 1F42 B7 AE                 lda   [<workptr],y
7723 1F44 97 A6                 sta   [<wind],y
7724 1F46 A5 A8                 lda   <wind+2
7725 1F48 97 AE                 sta   [<workptr],y
7726 1F4A              ;
7727 1F4A A7 AE                 lda   [<workptr]
7728 1F4C 87 A6                 sta   [<wind]
7729 1F4E A5 A6                 lda   <wind
7730 1F50 87 AE                 sta   [<workptr]
7731 1F52              ;
7732 1F52 60                    rts   
7733 1F53                       ENDP 
7734 1F53              ;
7735 1F53              ;
7736 1F53              ;====================================================
7737 1F53              ;        Highlight or Unhighlight a window.
7738 1F53              ;====================================================
7739 1F53              ;
7740 1F53              ;  IN:   PUSH - WORD - TRUE = highlight the window.
7741 1F53              ;                      FALSE = unhighlight the window.
7742 1F53              ;        PUSH - LONG - pointer to the window's port.
7743 1F53              ;
7744 1F53              HiliteWindow PROC 
7745 1F53              ;
7746 1F53              ;
7747 1F53              ;
7748 1F53 20 CA 21              jsr   setup
7749 1F56              ;
7750 1F56 20 3A 20              jsr   setwmgrport              Switch to Window Manager's port.
7751 1F59              ;
7752 1F59 A5 AE                 lda   <workptr                 Highlight or Unhighlight?
7753 1F5B D0 05                 bne   liteit
7754 1F5D              ;
7755 1F5D 20 F3 1E              jsr   unhilite                 Clear highlight bit in frame.
7756 1F60 80 03                 bra   skip
7757 1F62              ;
7758 1F62 20 E9 1E     liteit   jsr   hilite                   Set highlight bit in frame.
7759 1F65              ;
7760 1F65 A0 C0 00     skip     ldy   #wstrucRgn+2             Pass handle window's StructRgn.
7761 1F68 20 F9 21              jsr   pushandle
7762 1F6B 20 9A 21              jsr   pushclip                 Pass clip region handle.
7763 1F6E A2 04 69 22           _CopyRgn                       Set clip to window.
7764 1F75              ;
7765 1F75 20 B1 08              jsr   clipabove                Clip to above windows.
7766 1F78              ;
7767 1F78 20 82 1F              jsr   drawframe                Draw window's frame.
7768 1F7B              ;
7769 1F7B 20 60 20              jsr   restore_port             Restore original port.
7770 1F7E              ;
7771 1F7E 8B                    phb   
7772 1F7F 82 39 70              brl   pop6bytes
7773 1F82
7774 1F82                       ENDP 
7775 1F82
7776 1F82
7777 1F82              ;
7778 1F82              ;
7779 1F82              ;====================================
7780 1F82              ;        Draw window's frame
7781 1F82              ;        and do setup.
7782 1F82              ;====================================
7783 1F82              ;
7784 1F82              ;   IN:    current port = Window Manager's.
7785 1F82              ;          wind = window to draw.
7786 1F82              ;
7787 1F82              drawframe PROC 
7788 1F82              ;
7789 1F82                                                      ;using equates
7790 1F82              ;
7791 1F82              ;
7792 1F82 20 A8 1F              jsr   moveWMgrOnWind           Move Window Manager over window.
7793 1F85              ;
7794 1F85 A0 50 00              ldy   #justInfo
7795 1F88 B7 D8                 lda   [<data],y
7796 1F8A F0 03                 beq   store1
7797 1F8C A9 03 00              lda   #3                       Draw just the info bar.
7798 1F8F 85 C4        store1   sta   <param                   Pass 'draw entire frame' flag.
7799 1F91 64 C6                 stz   <param+2                 Pass 'unhilited' flag.
7800 1F93 A2 00 00              ldx   #wDraw
7801 1F96 20 19 20              jsr   dispatch
7802 1F99              ;
7803 1F99 82 5C 00              brl   moveWMgrBack             Put Window Manager's port back.
7804 1F9C                       ENDP 
7805 1F9C              ;
7806 1F9C              ;
7807 1F9C              ;========================================
7808 1F9C              ;        Move 'wrect' into 'rect'
7809 1F9C              ;========================================
7810 1F9C              ;
7811 1F9C              wrect2rect PROC 
7812 1F9C              ;
7813 1F9C                                                      ;using equates
7814 1F9C              ;
7815 1F9C A2 06 00              ldx   #x2
7816 1F9F B5 9E        lop      lda   <wrect,x
7817 1FA1 95 96                 sta   <rect,x
7818 1FA3 CA                    dex   
7819 1FA4 CA                    dex   
7820 1FA5 10 F8                 bpl   lop
7821 1FA7 60                    rts   
7822 1FA8                       ENDP 
7823 1FA8              ;
7824 1FA8              ;
7825 1FA8              ;          APPEND WUTIL.ASM
7826 1FA8                       TITLE 'Apple IIGS Window Manager                   WUTIL.ASM' 
7827 1FA8              ;
7828 1FA8              ;          Copyright Apple Computer, Inc. 1986,1987,1988
7829 1FA8              ;          All rights reserved
7830 1FA8              ;          Written by Dan Oliver
7831 1FA8              ;
7832 1FA8              ;
7833 1FA8              ;==========================================================
7834 1FA8              ;          Move Window Manager's port on window.
7835 1FA8              ;==========================================================
7836 1FA8              ;
7837 1FA8              ;   IN:    <wind = pointer to window record.
7838 1FA8              ;
7839 1FA8              moveWMgrOnWind PROC 
7840 1FA8              ;
7841 1FA8              ;
7842 1FA8              ;
7843 1FA8 20 3A 20              jsr   setwmgrport              Switch to Window Manager's port.
7844 1FAB              ;
7845 1FAB              ;
7846 1FAB              ; --- Set up Window Manager port over window -----------------
7847 1FAB              ;
7848 1FAB 20 1B 22              jsr   getwgrect                wrect = window's strucRgn bounds (global).
7849 1FAE              ;
7850 1FAE              ;
7851 1FAE              ; --- Make Window Manager's origin the same as window's screen origin ----
7852 1FAE              ;
7853 1FAE A5 A0                 lda   <wrect+x1
7854 1FB0 49 FF FF              eor   #$FFFF
7855 1FB3 1A                    inc   a
7856 1FB4 AA                    tax   
7857 1FB5 A5 9E                 lda   <wrect+y1
7858 1FB7 49 FF FF              eor   #$FFFF
7859 1FBA 1A                    inc   a
7860 1FBB 20 72 22              jsr   setTheOrigin
7861 1FBE              ;
7862 1FBE 20 9A 21              jsr   pushclip                 Offset clipping region.
7863 1FC1 A5 A0                 lda   <wrect+x1
7864 1FC3 49 FF FF              eor   #$FFFF
7865 1FC6 1A                    inc   a
7866 1FC7 48                    pha   
7867 1FC8 A5 9E                 lda   <wrect+y1
7868 1FCA 49 FF FF              eor   #$FFFF
7869 1FCD 1A                    inc   a
7870 1FCE 48                    pha   
7871 1FCF A2 04 6F 22           _OffsetRgn 
7872 1FD6              ;
7873 1FD6              ;
7874 1FD6              ; --- Put window's frame controls in Window Mgr window record -----------
7875 1FD6              ;
7876 1FD6 A0 CE 00              ldy   #wFrameCtls
7877 1FD9 B7 A6                 lda   [<wind],y
7878 1FDB AA                    tax   
7879 1FDC C8                    iny   
7880 1FDD C8                    iny   
7881 1FDE B7 A6                 lda   [<wind],y
7882 1FE0 A0 5E 01              ldy   #wmgr_wind+wControls+2
7883 1FE3 97 D8                 sta   [<data],y
7884 1FE5 88                    dey   
7885 1FE6 88                    dey   
7886 1FE7 8A                    txa   
7887 1FE8 97 D8                 sta   [<data],y
7888 1FEA              ;
7889 1FEA A0 D2 00              ldy   #wFrame
7890 1FED B7 A6                 lda   [<wind],y
7891 1FEF 29 F7 FF              and   #_F_CTL_TIE              Force state of controls to be window's.
7892 1FF2 A0 64 01              ldy   #wmgr_wind+wFrame
7893 1FF5 97 D8                 sta   [<data],y
7894 1FF7              ;
7895 1FF7 60                    rts   
7896 1FF8                       ENDP 
7897 1FF8              ;
7898 1FF8              ;
7899 1FF8              ;===========================================================
7900 1FF8              ;          Back Window Manager port back to global.
7901 1FF8              ;===========================================================
7902 1FF8              ;
7903 1FF8              moveWMgrBack PROC 
7904 1FF8              ;
7905 1FF8              ;
7906 1FF8              ;
7907 1FF8 20 9A 21              jsr   pushclip                 Offset clipping region back.
7908 1FFB A0 A0 00              ldy   #port+GP_Bounds+x1
7909 1FFE B7 D8        lop1     lda   [<data],y
7910 2000 49 FF FF              eor   #$FFFF
7911 2003 1A                    inc   a
7912 2004 48                    pha   
7913 2005 88                    dey   
7914 2006 88                    dey   
7915 2007 C0 9E 00              cpy   #port+GP_Bounds+y1
7916 200A F0 F2                 beq   lop1
7917 200C A2 04 6F 22           _OffsetRgn 
7918 2013              ;
7919 2013 20 6E 22              jsr   zeroOrigin               SetOrigin( 0,0,).
7920 2016 82 47 00              brl   restore_port
7921 2019                       ENDP 
7922 2019              ;
7923 2019              ;
7924 2019              ;======================================================
7925 2019              ;          Call window's definition procedure.
7926 2019              ;======================================================
7927 2019              ;
7928 2019              ;   IN:    x = operation number.
7929 2019              ;          wind = window affected.
7930 2019              ;          param = additional parameter.
7931 2019              ;
7932 2019              ;  OUT:    x/a = returned value from defProc.
7933 2019              ;
7934 2019              dispatch PROC 
7935 2019              ;
7936 2019                                                      ;using equates
7937 2019              ;
7938 2019              ;
7939 2019 A0 AF 00              ldy   #wdefProc+1              Pass address of defProc.
7940 201C B7 A6                 lda   [<wind],y
7941 201E 48                    pha   
7942 201F 88                    dey   
7943 2020 B7 A6                 lda   [<wind],y
7944 2022 7A                    ply   
7945 2023              ;
7946 2023              ;
7947 2023              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
7948 2023              ;          Call a defProc at a given address.
7949 2023              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
7950 2023              ;
7951 2023              ;   IN:    x = operation number.
7952 2023              ;          a = low word of address.
7953 2023              ;          y = middle word of address.
7954 2023              ;          wind = window affected.
7955 2023              ;          param = additional parameter.
7956 2023              ;
7957 2023              ;  OUT:    x/a = returned value from defProc.
7958 2023              ;
7959 2023                       ENTRY dispatch2
7960 2023              dispatch2                               ;       
7961 2023              ;
7962 2023 48                    pha                            Space for return.
7963 2024 48                    pha   
7964 2025 D4 DA                 pei   <data+2                  Pass pointer to Window globals.
7965 2027 D4 D8                 pei   <data
7966 2029 DA                    phx                            Operation number to perform.
7967 202A D4 A8                 pei   <wind+2
7968 202C D4 A6                 pei   <wind
7969 202E D4 C6                 pei   <param+2                 Pass parameter.
7970 2030 D4 C4                 pei   <param
7971 2032              ;                                       a = low word of address.
7972 2032 BB                    tyx                            x = mid word of address.
7973 2033 22 67 22 FD           jsl   longCall                 Call defProc.
7974 2037 68                    pla                            Return result.
7975 2038 FA                    plx   
7976 2039 60                    rts   
7977 203A                       ENDP 
7978 203A              ;
7979 203A              ;
7980 203A              ;================================================
7981 203A              ;        Switch to window manager's port.
7982 203A              ;================================================
7983 203A              ;
7984 203A              setwmgrport PROC 
7985 203A              ;
7986 203A              ;
7987 203A 20 48 20              jsr   save_port                Save current port.
7988 203D              ;
7989 203D                       ENTRY wmgrport2
7990 203D              wmgrport2                               ;       
7991 203D              ;
7992 203D 20 19 21              jsr   pushport                 Switch to window manager's graf port.
7993 2040 A2 04 1B 22           _SetPort 
7994 2047 60                    rts   
7995 2048                       ENDP 
7996 2048              ;
7997 2048              ;
7998 2048              ;======================================
7999 2048              ;          Save current port.
8000 2048              ;======================================
8001 2048              ;
8002 2048              ;  OUT:    old_port = current port, if old_port = zero on entry.
8003 2048              ;
8004 2048              save_port PROC 
8005 2048              ;
8006 2048                                                      ;using equates
8007 2048              ;
8008 2048              ;
8009 2048              ;	lda	<Save_Cnt
8010 2048              ;	sta	>$Fd1236
8011 2048
8012 2048 E6 D2                 inc   <save_cnt
8013 204A              ;
8014 204A A5 CE                 lda   <old_port
8015 204C 05 D0                 ora   <old_port+2
8016 204E D0 0F                 bne   exit
8017 2050              ;
8018 2050 48                    pha   
8019 2051 48                    pha   
8020 2052 A2 04 1C 22           _GetPort 
8021 2059 68                    pla   
8022 205A 85 CE                 sta   <old_port
8023 205C 68                    pla   
8024 205D 85 D0                 sta   <old_port+2
8025 205F              ;
8026 205F 60           exit     rts   
8027 2060                       ENDP 
8028 2060              ;          
8029 2060              ;
8030 2060              ;=========================================
8031 2060              ;          Restore original port.
8032 2060              ;=========================================
8033 2060              ;
8034 2060              ;   IN:    old_port = original port, zero if no need for restore.
8035 2060              ;
8036 2060              ;  OUT:    current port = old_port.
8037 2060              ;
8038 2060                       EXPORT restore_port
8039 2060              restore_port PROC 
8040 2060              ;
8041 2060                                                      ;using equates
8042 2060              ;
8043 2060              ;
8044 2060 A5 CE                 lda   <old_port
8045 2062 A8                    tay   
8046 2063 A6 D0                 ldx   <old_port+2
8047 2065 05 D0                 ora   <old_port+2
8048 2067 F0 11                 beq   exit                     No port to restore.
8049 2069              ;
8050 2069              ;	lda	<Save_Cnt
8051 2069              ;	sta	>$Fd1234
8052 2069
8053 2069 C6 D2                 dec   <save_cnt
8054 206B D0 0D                 bne   exit
8055 206D              ;
8056 206D DA                    phx   
8057 206E 5A                    phy   
8058 206F A2 04 1B 22           _SetPort 
8059 2076              ;
8060 2076 64 CE                 stz   <old_port
8061 2078 64 D0                 stz   <old_port+2
8062 207A              ;
8063 207A 60           exit     rts   
8064 207B                       ENDP 
8065 207B              ;
8066 207B              ;
8067 207B              ;============================================
8068 207B              ;          Dereference a handle.
8069 207B              ;============================================
8070 207B              ;
8071 207B              dereference PROC 
8072 207B              ;
8073 207B                                                      ;using equates
8074 207B              ;
8075 207B              ;
8076 207B A0 02 00              ldy   #2                       Dereference the control's handle.
8077 207E B7 AE                 lda   [<workptr],y
8078 2080 A8                    tay   
8079 2081 A7 AE                 lda   [<workptr]
8080 2083 85 AE                 sta   <workptr
8081 2085 84 B0                 sty   <workptr+2
8082 2087 60                    rts   
8083 2088                       ENDP 
8084 2088              ;
8085 2088              ;
8086 2088              ;======================================================
8087 2088              ;       Get window pointer from current port
8088 2088              ;======================================================
8089 2088              ;
8090 2088              get_port PROC 
8091 2088              ;
8092 2088 48                    pha   
8093 2089 48                    pha   
8094 208A A2 04 1C 22           _GetPort 
8095 2091 68                    pla   
8096 2092 FA                    plx   
8097 2093 82 4C 01              brl   get_wptr                 Convert port pointer to window pointer.
8098 2096                       ENDP 
8099 2096              ;
8100 2096              ;
8101 2096              ;===============================================
8102 2096              ;          Find front most visible window.
8103 2096              ;===============================================
8104 2096              ;
8105 2096              ;   IN:    topwind = first window in window list.
8106 2096              ;
8107 2096              ;  OUT:    top_vis = top visible window.
8108 2096              ;          a = top_vis.
8109 2096              ;          x = top_vis+2.
8110 2096              ;          BEQ if no visible window found.
8111 2096              ;          BNE if visible window found.
8112 2096              ;
8113 2096                       EXPORT find_top
8114 2096              find_top PROC 
8115 2096              ;
8116 2096                                                      ;using equates
8117 2096              ;
8118 2096              ;
8119 2096 A6 90                 ldx   <topwind+2
8120 2098 A5 8E                 lda   <topwind
8121 209A 80 08                 bra   enter1
8122 209C              ;
8123 209C A0 02 00     lop1     ldy   #2
8124 209F B7 C8                 lda   [<top_vis],y
8125 20A1 AA                    tax   
8126 20A2 A7 C8                 lda   [<top_vis]
8127 20A4              ;
8128 20A4 85 C8        enter1   sta   <top_vis
8129 20A6 86 CA                 stx   <top_vis+2
8130 20A8 05 CA                 ora   <top_vis+2               Last window?
8131 20AA F0 10                 beq   exit
8132 20AC              ;
8133 20AC A0 D2 00              ldy   #wframe                  Is this window visible?
8134 20AF B7 C8                 lda   [<top_vis],y
8135 20B1 29 20 00              and   #F_VIS
8136 20B4 F0 E6                 beq   lop1                     Stop when first visible window found.
8137 20B6              ;
8138 20B6 08                    php   
8139 20B7 A5 C8                 lda   <top_vis
8140 20B9 A6 CA                 ldx   <top_vis+2
8141 20BB 28                    plp   
8142 20BC              ;
8143 20BC 60           exit     rts   
8144 20BD                       ENDP 
8145 20BD              ;
8146 20BD              ;
8147 20BD              ;===============================================
8148 20BD              ;        Find window in front of this one.
8149 20BD              ;===============================================
8150 20BD              ;
8151 20BD              ;   IN:    wind = window to find window in front of.
8152 20BD              ;  OUT:    equal = TRUE  if found.
8153 20BD              ;                a = low word of window's address.
8154 20BD              ;                x = high word.
8155 20BD              ;                workptr = window in front of the one in wind.
8156 20BD              ;                wind = unchanged.
8157 20BD              ;          equal = FALSE
8158 20BD              ;                minus = TRUE if window not in list.
8159 20BD              ;                minus = FALSE if window is top window.
8160 20BD              ;
8161 20BD              getpre   PROC 
8162 20BD              ;
8163 20BD                                                      ;using equates
8164 20BD              ;
8165 20BD A5 8E                 lda   <topwind
8166 20BF A6 90                 ldx   <topwind+2
8167 20C1              ;
8168 20C1 C5 A6                 cmp   <wind
8169 20C3 D0 13                 bne   lop110
8170 20C5 E4 A8                 cpx   <wind+2
8171 20C7 D0 0F                 bne   lop110
8172 20C9              ;
8173 20C9 A9 00 00              lda   #0                       Previous window is the
8174 20CC 85 B0                 sta   <workptr+2               address of 'topwind'.
8175 20CE 7B                    tdc   
8176 20CF 09 8E 00              ora   #topwind
8177 20D2 85 AE                 sta   <workptr
8178 20D4              ;
8179 20D4 A0 01 00              ldy   #1                       It's the top window flag.
8180 20D7 60                    rts   
8181 20D8              ;
8182 20D8 85 AE        lop110   sta   <workptr
8183 20DA 86 B0                 stx   <workptr+2
8184 20DC              ;
8185 20DC 05 B0                 ora   <workptr+2
8186 20DE D0 04                 bne   ok100
8187 20E0              ;
8188 20E0 A0 FF FF              ldy   #$FFFF                   Window not in list flag.
8189 20E3 60                    rts   
8190 20E4              ;
8191 20E4 A0 00 00     ok100    ldy   #wnext
8192 20E7 A5 A6                 lda   <wind
8193 20E9 D7 AE                 cmp   [<workptr],y
8194 20EB D0 08                 bne   next100
8195 20ED C8                    iny   
8196 20EE C8                    iny   
8197 20EF A5 A8                 lda   <wind+2
8198 20F1 D7 AE                 cmp   [<workptr],y
8199 20F3 F0 0C                 beq   gotit
8200 20F5              ;
8201 20F5 A0 02 00     next100  ldy   #wnext+2
8202 20F8 B7 AE                 lda   [<workptr],y
8203 20FA AA                    tax   
8204 20FB 88                    dey   
8205 20FC 88                    dey   
8206 20FD B7 AE                 lda   [<workptr],y
8207 20FF 80 D7                 bra   lop110
8208 2101              ;
8209 2101 A5 AE        gotit    lda   <workptr
8210 2103 A6 B0                 ldx   <workptr+2
8211 2105 A0 00 00              ldy   #0                       Ok flag.
8212 2108 60           errout   rts   
8213 2109              ;
8214 2109                       ENDP 
8215 2109              ;
8216 2109              ;
8217 2109              ;========================================================
8218 2109              ;          Open/Close the Window Manager's port.
8219 2109              ;========================================================
8220 2109              ;
8221 2109              openWMgrport PROC 
8222 2109              ;
8223 2109                                                      ;using equates
8224 2109              ;
8225 2109              OpenPort equ   $1804                    Function number for OpenPort call.
8226 2109              ClosePort equ   $1A04                   Function number for ClosePort call.
8227 2109              ;
8228 2109              ;
8229 2109 A2 04 18              ldx   #OpenPort
8230 210C 80 03                 bra   enter
8231 210E              ;
8232 210E              ;
8233 210E                       ENTRY closeWMgrport
8234 210E              closeWMgrport                           ; 
8235 210E              ;
8236 210E A2 04 1A              ldx   #ClosePort
8237 2111              ;
8238 2111 20 19 21     enter    jsr   pushport                 Pass pointer to Window Mgr's port.
8239 2114 22 00 00 E1           jsl   $E10000
8240 2118 60                    rts   
8241 2119                       ENDP 
8242 2119              ;
8243 2119              ;
8244 2119              ;=================================================
8245 2119              ;          Push address in data area.
8246 2119              ;=================================================
8247 2119              ;
8248 2119              ;  OUT:    x = same as in.
8249 2119              ;
8250 2119              pushport PROC 
8251 2119              ;
8252 2119                                                      ;using equates
8253 2119              ;
8254 2119              ;
8255 2119 A9 96 00              lda   #port
8256 211C 80 3F                 bra   enter
8257 211E              ;
8258 211E                       ENTRY pushmyeventpos
8259 211E              pushmyeventpos                          ; 
8260 211E A9 5C 00              lda   #myevent+where
8261 2121 80 3A                 bra   enter
8262 2123              ;
8263 2123                       ENTRY pushscrn2scrn
8264 2123              pushscrn2scrn                           ; 
8265 2123 A9 38 00              lda   #scrn2scrn
8266 2126 80 35                 bra   enter
8267 2128              ;
8268 2128                       ENTRY pushblitdes
8269 2128              pushblitdes                             ; 
8270 2128 A9 B8 01              lda   #blitdes
8271 212B 80 30                 bra   enter
8272 212D              ;
8273 212D                       ENTRY pushblitsrc
8274 212D              pushblitsrc                             ; 
8275 212D A9 B0 01              lda   #blitsrc
8276 2130 80 2B                 bra   enter
8277 2132              ;
8278 2132                       ENTRY pushdrag_bound
8279 2132              pushdrag_bound                          ; 
8280 2132 A9 82 00              lda   #drag_bound
8281 2135 80 26                 bra   enter
8282 2137              ;
8283 2137                       ENTRY pushmyevent
8284 2137              pushmyevent                             ; 
8285 2137 A9 52 00              lda   #myevent
8286 213A 80 21                 bra   enter
8287 213C              ;
8288 213C                       ENTRY pushslop_bound
8289 213C              pushslop_bound                          ; 
8290 213C A9 8A 00              lda   #slop_bound
8291 213F 80 1C                 bra   enter
8292 2141              ;
8293 2141                       ENTRY pushGP_Bounds
8294 2141              pushGP_Bounds                           ; 
8295 2141 A9 9E 00              lda   #port+GP_Bounds
8296 2144 80 17                 bra   enter
8297 2146              ;
8298 2146                       ENTRY pushscreen
8299 2146              pushscreen                              ; 
8300 2146 A9 6A 00              lda   #screen
8301 2149 80 12                 bra   enter
8302 214B              ;
8303 214B                       ENTRY pushfontHandle
8304 214B              pushfontHandle                          ; 
8305 214B A9 A4 01              lda   #fontHandle
8306 214E 80 0D                 bra   enter
8307 2150              ;
8308 2150                       ENTRY pushCallProcList
8309 2150              pushCallProcList                        ; 
8310 2150 A9 C2 01              lda   #callProcList
8311 2153 80 08                 bra   enter
8312 2155              ;
8313 2155                       ENTRY pushscInfo
8314 2155              pushscInfo                              ; 
8315 2155 A9 62 00              lda   #scInfo
8316 2158 80 03                 bra   enter
8317 215A              ;
8318 215A                       ENTRY pushLocInfo1
8319 215A A9 72 00     pushLocInfo1 lda   #locInfo1
8320 215D              ;
8321 215D                       ENTRY pushDataAddr
8322 215D              pushDataAddr  
8323 215D 7A           enter    ply                            Get return address.
8324 215E D4 DA                 pei   <data+2                  Pass high word (doesn't cross bank).
8325 2160 18                    clc   
8326 2161 65 D8                 adc   <data
8327 2163 48                    pha                            Pass low word address.
8328 2164 5A                    phy                            Put return address back.
8329 2165 60                    rts   
8330 2166                       ENDP 
8331 2166              ;
8332 2166              ;
8333 2166              ;===================================================
8334 2166              ;        Push address of zero page variables.
8335 2166              ;===================================================
8336 2166              ;
8337 2166              pushyrat PROC 
8338 2166              ;
8339 2166                                                      ;using equates
8340 2166              ;
8341 2166              ;
8342 2166 A9 B4 00              lda   #yrat
8343 2169 80 12                 bra   ok1
8344 216B              ;
8345 216B                       ENTRY pushwork
8346 216B              pushwork                                ; 
8347 216B A9 DE 00              lda   #work
8348 216E 80 0D                 bra   ok1
8349 2170              ;
8350 2170                       ENTRY pushwrect
8351 2170              pushwrect                               ; 
8352 2170 A9 9E 00              lda   #wrect
8353 2173 80 08                 bra   ok1
8354 2175              ;
8355 2175                       ENTRY pushparam
8356 2175              pushparam                               ; 
8357 2175 A9 C4 00              lda   #param
8358 2178 80 03                 bra   ok1
8359 217A              ;
8360 217A                       ENTRY pushrect
8361 217A              pushrect                                ; 
8362 217A A9 96 00              lda   #rect                    Most used.
8363 217D 82 E4 6D     ok1      brl   pushDpage
8364 2180                       ENDP 
8365 2180
8366 2180              ****************************************************************
8367 2180
8368 2180              pushrgnptr PROC 
8369 2180
8370 2180 7A                    ply   
8371 2181 D4 BA                 pei   rgnptr+2
8372 2183 D4 B8                 pei   rgnptr
8373 2185 5A                    phy   
8374 2186 60                    rts   
8375 2187
8376 2187                       ENDP 
8377 2187
8378 2187              ****************************************************************
8379 2187
8380 2187              pushGray PROC 
8381 2187
8382 2187 7A                    ply   
8383 2188 D4 C2                 pei   GrayRgn+2
8384 218A D4 C0                 pei   GrayRgn
8385 218C 5A                    phy   
8386 218D 60                    rts   
8387 218E
8388 218E                       ENDP 
8389 218E
8390 218E              ****************************************************************
8391 218E              ;
8392 218E              ;
8393 218E              ;=================================================
8394 218E              ;        Push long value in direct page.
8395 218E              ;=================================================
8396 218E              ;
8397 218E              pushrgn2 PROC 
8398 218E              ;
8399 218E                                                      ;using equates
8400 218E              ;
8401 218E              ;
8402 218E A2 BC 00              ldx   #rgnptr2
8403 2191              ;
8404 2191              ;
8405 2191              ;
8406 2191              ;   IN:  x = offset into zero page.
8407 2191              ;
8408 2191                       ENTRY pushptr
8409 2191              pushptr                                 ; 
8410 2191              ;
8411 2191 7A                    ply                            Grab return address.
8412 2192              ;
8413 2192 B5 02                 lda   <2,x
8414 2194 48                    pha   
8415 2195 B5 00                 lda   <0,x
8416 2197 48                    pha   
8417 2198              ;
8418 2198 5A                    phy                            Put back return address and return.
8419 2199 60                    rts   
8420 219A                       ENDP 
8421 219A              ;
8422 219A              ;
8423 219A              ;====================================================
8424 219A              ;          Push long value from data area.
8425 219A              ;====================================================
8426 219A              ;
8427 219A              ;   IN:    None.
8428 219A              ;
8429 219A              ;  OUT:    handle to Window Manager's clip region on stack.
8430 219A              ;
8431 219A              pushclip PROC 
8432 219A              ;
8433 219A                                                      ;using equates
8434 219A              ;
8435 219A              ;
8436 219A A0 B0 00              ldy   #port+GP_ClipRgn+2
8437 219D 80 03                 bra   enter
8438 219F              ;
8439 219F              ;
8440 219F                       ENTRY pushvis
8441 219F              pushvis                                 ; 
8442 219F A0 B4 00              ldy   #port+GP_VisRgn+2
8443 21A2              ;
8444 21A2              ;
8445 21A2 FA           enter    plx                            Save return address.
8446 21A3              ;
8447 21A3 B7 D8                 lda   [<data],y                Push long from data area.
8448 21A5 48                    pha   
8449 21A6 88                    dey   
8450 21A7 88                    dey   
8451 21A8 B7 D8                 lda   [<data],y
8452 21AA 48                    pha   
8453 21AB              ;
8454 21AB DA                    phx                            Put return address back.
8455 21AC 60                    rts   
8456 21AD                       ENDP 
8457 21AD              ;
8458 21AD              ;
8459 21AD              ;==================================
8460 21AD              ;        Allocate a region.
8461 21AD              ;==================================
8462 21AD              ;
8463 21AD              ;  IN:   None.
8464 21AD              ;
8465 21AD              ; OUT:   rgnptr2 = what rgnptr was when entered.
8466 21AD              ;        rgnptr = handle of allocated region.
8467 21AD              ;        a = low address of region handle.
8468 21AD              ;        x = high address of region handle.
8469 21AD              ;
8470 21AD              alloc_rgn PROC 
8471 21AD              ;
8472 21AD                                                      ;using equates
8473 21AD              ;
8474 21AD              ;
8475 21AD A5 B8                 lda   <rgnptr                  Move rgnptr into rgnptr2.
8476 21AF 85 BC                 sta   <rgnptr2
8477 21B1 A5 BA                 lda   <rgnptr+2
8478 21B3 85 BE                 sta   <rgnptr2+2
8479 21B5              ;
8480 21B5 48                    pha                            Space for returned handle.
8481 21B6 48                    pha   
8482 21B7 A2 04 67 22           _NewRgn                        Allocate a region.
8483 21BE 68                    pla   
8484 21BF 85 B8                 sta   <rgnptr                  Store handle of allocated region,
8485 21C1 FA                    plx   
8486 21C2 86 BA                 stx   <rgnptr+2                in 'rgnptr'.
8487 21C4 60                    rts   
8488 21C5                       ENDP 
8489 21C5              ;
8490 21C5              ;
8491 21C5              ;================================================
8492 21C5              ;          Allocate a block of memory.
8493 21C5              ;================================================
8494 21C5              ;
8495 21C5              ;   IN:    a = number of bytes to allocate.
8496 21C5              ;          MyID = ID to use.
8497 21C5              ;
8498 21C5              ;  OUT:    x/a = handle.
8499 21C5              ;
8500 21C5              allocate PROC 
8501 21C5                       IMPORT allocate2
8502 21C5              ;
8503 21C5              ;
8504 21C5 A4 DC                 ldy   <MyID
8505 21C7 82 B5 6D              brl   allocate2
8506 21CA                       ENDP 
8507 21CA              ;
8508 21CA              ;
8509 21CA              ;=======================================================
8510 21CA              ;        Swicth to Window Manager's zero page,
8511 21CA              ;        and put input parameters into zero page.
8512 21CA              ;=======================================================
8513 21CA              ;
8514 21CA              ;  IN:   a = zero page to switch to.
8515 21CA              ;
8516 21CA              setup    PROC 
8517 21CA              ;
8518 21CA              ;
8519 21CA              ; REMOVE ME!
8520 21CA              ;	pha
8521 21CA              ;	txa
8522 21CA              ;	sta	>$FD2345
8523 21CA              ;	pla
8524 21CA              ; END OF REMOVAL
8525 21CA
8526 21CA 22 64 00 E1           jsl   IncBusyFlg
8527 21CE              ;
8528 21CE FA                    plx                            Get return address.
8529 21CF 0B                    phd                            Save current zero page pointer.
8530 21D0 DA                    phx                            Put return address back on stack.
8531 21D1              ;
8532 21D1 5B                    tcd                            Switch to Window Manager's zero page.
8533 21D2              ;
8534 21D2              ;
8535 21D2                       ENTRY pullparams
8536 21D2              pullparams                              ; 
8537 21D2              ;
8538 21D2 A3 0F                 lda   15,s                     Pull second to last input parameter.
8539 21D4 85 AE                 sta   <workptr
8540 21D6 A3 11                 lda   17,s
8541 21D8 85 B0                 sta   <workptr+2
8542 21DA              ;
8543 21DA                       ENTRY pullparam
8544 21DA              pullparam                               ; 
8545 21DA              ;
8546 21DA A3 0D                 lda   13,s                     Pull last input parameter.
8547 21DC AA                    tax   
8548 21DD A3 0B                 lda   11,s
8549 21DF 82 00 00              brl   get_wptr
8550 21E2                       ENDP 
8551 21E2              ;
8552 21E2              ;
8553 21E2              ;============================================
8554 21E2              ;          Compute window pointer
8555 21E2              ;          from port pointer.
8556 21E2              ;============================================
8557 21E2              ;
8558 21E2              ;   IN:    a = low word of port pointer.
8559 21E2              ;          x = high word of port pointer.
8560 21E2              ;
8561 21E2              ;  OUT:    wind = window pointer.
8562 21E2              ;          a = low word of window pointer.
8563 21E2              ;          x = high word of window pointer.
8564 21E2              ;          y = trashed.
8565 21E2              ;
8566 21E2                       EXPORT get_wptr
8567 21E2              get_wptr PROC 
8568 21E2              ;
8569 21E2                                                      ;using equates
8570 21E2
8571 21E2 A8                    tay   
8572 21E3 D0 03                 bne   ok1                      Null pointer?
8573 21E5 9B                    txy   
8574 21E6 F0 07                 beq   store1
8575 21E8
8576 21E8 38           ok1      sec   
8577 21E9 E9 04 00              sbc   #wport                   Compute pointer to window record
8578 21EC B0 01                 bcs   store1                   from pointer to window's port.
8579 21EE CA                    dex   
8580 21EF 85 A6        store1   sta   <wind
8581 21F1 86 A8                 stx   <wind+2
8582 21F3
8583 21F3 60                    rts   
8584 21F4                       ENDP 
8585 21F4
8586 21F4
8587 21F4              WMInit   PROC 
8588 21F4              ;
8589 21F4
8590 21F4                       ENTRY WindBootInit
8591 21F4              WindBootInit  
8592 21F4                       ENTRY Reserved
8593 21F4              Reserved  
8594 21F4
8595 21F4                       ENTRY RealFastExit
8596 21F4              RealFastExit         
8597 21F4 A9 00 00              lda   #0
8598 21F7 18                    clc   
8599 21F8 6B                    rtl   
8600 21F9
8601 21F9
8602 21F9                       ENDP 
8603 21F9              ;
8604 21F9              ;
8605 21F9              ;==============================================
8606 21F9              ;        Push a long from window record.
8607 21F9              ;==============================================
8608 21F9              ;
8609 21F9              ;   IN:    y = offset into window record.
8610 21F9              ;          wind = pointer to window record.
8611 21F9              ;
8612 21F9              pushandle PROC 
8613 21F9              ;
8614 21F9              ;
8615 21F9                       ENTRY pushWlong
8616 21F9              pushWlong                               ; 
8617 21F9              ;
8618 21F9 FA                    plx                            Get return address.
8619 21FA              ;
8620 21FA B7 A6                 lda   [<wind],y                Put long on stack.
8621 21FC 48                    pha   
8622 21FD 88                    dey   
8623 21FE 88                    dey   
8624 21FF B7 A6                 lda   [<wind],y
8625 2201 48                    pha   
8626 2202              ;
8627 2202 DA                    phx                            Put return address back on stack.
8628 2203 60                    rts   
8629 2204                       ENDP 
8630 2204              ;
8631 2204              ;
8632 2204              ;===============================================
8633 2204              ;          Compute pointer to window's
8634 2204              ;          port in window's record.
8635 2204              ;===============================================
8636 2204              ;
8637 2204              ;   IN:    wind = window's pointer.
8638 2204              ;
8639 2204              ;  OUT:    a = low word port pointer.
8640 2204              ;          x = high word of port pointer.
8641 2204              ;
8642 2204                       EXPORT get_portptr
8643 2204              get_portptr PROC 
8644 2204              ;
8645 2204                                                      ;using equates
8646 2204              ;
8647 2204              ;
8648 2204 A6 A8                 ldx   <wind+2
8649 2206 A5 A6                 lda   <wind
8650 2208              ;
8651 2208                       EXPORT get_portp2
8652 2208              get_portp2                              ; 
8653 2208              ;
8654 2208 D0 03                 bne   ok1                      Is it a null pointer?
8655 220A 9B                    txy   
8656 220B F0 07                 beq   exit
8657 220D              ;
8658 220D 18           ok1      clc   
8659 220E 69 04 00              adc   #wport
8660 2211 90 01                 bcc   exit
8661 2213 E8                    inx   
8662 2214 60           exit     rts   
8663 2215                       ENDP 
8664 2215              ;
8665 2215              ;
8666 2215              ;=============================================================
8667 2215              ;           Set 'wrect' to bounds of desktop.
8668 2215              ;=============================================================
8669 2215              ;
8670 2215              ;   IN:  None.
8671 2215              ;
8672 2215              ;  OUT:  wrect = screen coordinates of GrayRgn.
8673 2215              ;
8674 2215              deskBounds PROC 
8675 2215              ;
8676 2215              ;
8677 2215 A6 C0                 ldx   <GrayRgn
8678 2217 A5 C1                 lda   <GrayRgn+1
8679 2219 80 09                 bra   getbounds1               Put GrayRgn bounds into 'wrect'.
8680 221B              ;
8681 221B              ;
8682 221B              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
8683 221B              ;        Put window's global coordinates into 'wrect'.
8684 221B              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
8685 221B              ;
8686 221B              ;   IN:    wind = pointer to window.
8687 221B              ;
8688 221B              ;  OUT:    wrect = screen coordinates of window.
8689 221B              ;
8690 221B                       ENTRY getwgrect
8691 221B              getwgrect                               ; 
8692 221B              ;
8693 221B A0 BE 00              ldy   #wstrucRgn               Get pointer to window's StructRgn.
8694 221E              ;
8695 221E              ;
8696 221E              ; = = = = = = = = = = = = = = = = = =
8697 221E              ;        Get a region's bounds.
8698 221E              ; = = = = = = = = = = = = = = = = = =
8699 221E              ;
8700 221E              ;   IN:    wind = window record that contain region handle.
8701 221E              ;          y = index into window for region handle.
8702 221E              ;
8703 221E              ;  OUT:    wrect = bounds of region.
8704 221E              ;
8705 221E                       ENTRY getbounds
8706 221E              getbounds                               ; 
8707 221E              ;
8708 221E B7 A6                 lda   [<wind],y
8709 2220 AA                    tax   
8710 2221 C8                    iny   
8711 2222 B7 A6                 lda   [<wind],y
8712 2224              ;
8713 2224              ;
8714 2224              ; = = = = = = = = = = = = = = = = = =
8715 2224              ;        Get a region's bounds.
8716 2224              ; = = = = = = = = = = = = = = = = = =
8717 2224              ;
8718 2224              ;   IN:    x = low word of region handle.
8719 2224              ;          a = middle word of region handle (bits 8-23).
8720 2224              ;
8721 2224              ;  OUT:    wrect = bounds of region.
8722 2224              ;
8723 2224                       ENTRY getbounds1
8724 2224              getbounds1                              ; 
8725 2224              ;
8726 2224 86 DE                 stx   <work
8727 2226 85 DF                 sta   <work+1                  That's the handle.
8728 2228              ;
8729 2228                       ENTRY getbounds2
8730 2228              getbounds2                              ; 
8731 2228              ;
8732 2228 A0 02 00              ldy   #2
8733 222B B7 DE                 lda   [<work],y
8734 222D A8                    tay   
8735 222E A7 DE                 lda   [<work]
8736 2230 18                    clc   
8737 2231 69 02 00              adc   #Rgn_Bounds              I'm after the region's bounds.
8738 2234 90 01                 bcc   getbounds3               &&
8739 2236 C8                    iny                            &&
8740 2237              ;
8741 2237                       ENTRY getbounds3
8742 2237              getbounds3                              ; 
8743 2237              ;
8744 2237 85 DE                 sta   <work
8745 2239 84 E0                 sty   <work+2                  That's the pointer to bounds.
8746 223B              ;
8747 223B A0 06 00              ldy   #x2                      Put bounds into 'wrect'.
8748 223E BB           lop1     tyx   
8749 223F B7 DE                 lda   [<work],y
8750 2241 95 9E                 sta   <wrect,x
8751 2243 88                    dey   
8752 2244 88                    dey   
8753 2245 10 F7                 bpl   lop1
8754 2247              ;
8755 2247 60                    rts   
8756 2248                       ENDP 
8757 2248              ;
8758 2248              ;
8759 2248              ;================================================
8760 2248              ;          Test a window's visible flag.
8761 2248              ;================================================
8762 2248              ;
8763 2248              ;  OUT:    Equal set to F_VIS state.
8764 2248              ;
8765 2248              testVis  PROC 
8766 2248              ;
8767 2248                                                      ;using equates
8768 2248              ;
8769 2248              ;
8770 2248 A0 D2 00              ldy   #wframe
8771 224B B7 A6                 lda   [<wind],y
8772 224D 29 20 00              and   #F_VIS                   Is this window visible?
8773 2250 60                    rts   
8774 2251                       ENDP 
8775 2251              ;
8776 2251              ;
8777 2251              ;======================================================
8778 2251              ;          Get width/height of content region.
8779 2251              ;======================================================
8780 2251              ;
8781 2251              ;   IN:    wind = window pointer.
8782 2251              ;
8783 2251              ;  OUT:    wrect+y2 = wrect's height.
8784 2251              ;          wrect+x2 = wrect's width.
8785 2251              ;          a = height
8786 2251              ;
8787 2251              getcontwh PROC 
8788 2251              ;
8789 2251                                                      ;using equates
8790 2251              ;
8791 2251              ;
8792 2251 A0 C2 00              ldy   #wcontRgn
8793 2254 20 1E 22              jsr   getbounds                wrect = coordinates of content region.
8794 2257              ;
8795 2257              ;
8796 2257              ;   IN:    wrect = RECT.
8797 2257              ;
8798 2257              ;  OUT:    wrect+y2 = wrect's height.
8799 2257              ;          wrect+x2 = wrect's width.
8800 2257              ;          a = height
8801 2257              ;
8802 2257              ;
8803 2257                       ENTRY getwrectwh
8804 2257              getwrectwh                              ; 
8805 2257              ;
8806 2257 A2 02 00              ldx   #x1
8807 225A B5 A2        lop1     lda   <wrect+y2,x
8808 225C 38                    sec   
8809 225D F5 9E                 sbc   <wrect+y1,x
8810 225F 1A                    inc   a
8811 2260 95 A2                 sta   <wrect+y2,x              Get current height/width of content.
8812 2262 CA                    dex   
8813 2263 CA                    dex   
8814 2264 10 F4                 bpl   lop1
8815 2266 60                    rts   
8816 2267                       ENDP 
8817 2267              ;
8818 2267              ;
8819 2267              ;            APPEND	WCOMMON.ASM
8820 2267                       TITLE 'Apple IIGS Window Manager                   WCOMMON.ASM' 
8821 2267              ;
8822 2267              ;          Copyright Apple Computer, Inc. 1986,1987,1988
8823 2267              ;          All rights reserved
8824 2267              ;          Written by Dan Oliver
8825 2267              ;
8826 2267              ;  This file contains procedures that can be called from anywhere
8827 2267              ;  without depending on a direct page.
8828 2267              ;
8829 2267              ;
8830 2267              ;
8831 2267              ;
8832 2267              ;============================
8833 2267              ;          Long call.
8834 2267              ;============================
8835 2267              ;
8836 2267              ;   IN:    x = middle WORD (bits 8-23) of address of destination routine.
8837 2267              ;          a = low WORD of address of destination routine.
8838 2267              ;
8839 2267              ;  OUT:    Calling this routine is the same as:
8840 2267              ;
8841 2267              ;                jsl   (ax)
8842 2267              ;
8843 2267              ;          where the low byte in 'a' is the low byte of the destination
8844 2267              ;          address, and x = the next 2 bytes of the destination address.
8845 2267              ;
8846 2267                       EXPORT longCall
8847 2267              longCall PROC 
8848 2267              ;
8849 2267 3A                    dec   a                        Make low word look like a return address.
8850 2268              ;                                 !!! High byte of address is not decremented
8851 2268              ;                                     because the program counter doesn't wrap
8852 2268              ;                                     to the next bank!!!!
8853 2268              ;
8854 2268 DA                    phx                            Push the high byte.
8855 2269 BA                    tsx                            Leave only the high byte of the address.
8856 226A E8                    inx   
8857 226B 9A                    txs   
8858 226C              ;
8859 226C 48                    pha                            Push the low word of the address.
8860 226D              ;
8861 226D 6B                    rtl                            Go to the address.
8862 226E              ;
8863 226E              ;  When the routine called returns, it
8864 226E              ;  will return to the routine that called 'longCall', not here.
8865 226E              ;
8866 226E                       ENDP 
8867 226E              ;
8868 226E              ;
8869 226E              ;=======================================================
8870 226E              ;          Set origin of current port to 0,0.
8871 226E              ;=======================================================
8872 226E              ;
8873 226E                       EXPORT zeroOrigin
8874 226E              zeroOrigin PROC 
8875 226E              ;
8876 226E A9 00 00              lda   #0
8877 2271 AA                    tax   
8878 2272              ;
8879 2272              ;
8880 2272              ; = = = = = = = = = = = = = = = = = =
8881 2272              ;          Call SetOrigin.
8882 2272              ; = = = = = = = = = = = = = = = = = =
8883 2272              ;
8884 2272              ;   IN:    a = new y origin.
8885 2272              ;          x = new x origin.
8886 2272              ;
8887 2272                       EXPORT setTheOrigin
8888 2272              setTheOrigin                            ; 
8889 2272              ;
8890 2272 DA                    phx   
8891 2273 48                    pha   
8892 2274 A2 04 23 22           _SetOrigin 
8893 227B 60                    rts   
8894 227C                       ENDP 
8895 227C              ;
8896 227C              ;
8897 227C              ;            APPEND	WSTATIC.ASM
8898 227C                       TITLE 'Apple IIGS Window Manager                   WSTATIC.ASM' 
8899 227C              ;
8900 227C              ;          Copyright Apple Computer, Inc. 1986,1987,1988
8901 227C              ;          All rights reserved
8902 227C              ;          Written by Dan Oliver
8903 227C              ;
8904 227C              ;
8905 227C              ;=====================================
8906 227C              ;          Static data area.
8907 227C              ;=====================================
8908 227C              ;
8909 227C                       EXPORT staticRAM
8910 227C              staticRAM PROC 
8911 227C              ;
8912 227C              ;
8913 227C              ; --- Default pattern/color table for windows ------------------
8914 227C              ;
8915 227C                       EXPORT def_color
8916 227C 00 00        def_color DC W:$0000                    Frame outline.
8917 227E 0F 0F                 DC W:$0F0F                     Unused/Inactive Bar/Inactive Title/Title.
8918 2280 00 00                 DC W:$0000                     Title bar.
8919 2282 F0 F0                 DC W:$F0F0                     Inside grow box.
8920 2284 F0 00                 DC W:$00F0                     Inside info bar.
8921 2286              ;
8922 2286              ;
8923 2286              ; --- Default zoom window size ---------------------------------
8924 2286              ;
8925 2286                       EXPORT def_zoom
8926 2286 19 00 1E 00  def_zoom DC W:25,30,199,639
8927 228E              ;
8928 228E              ;
8929 228E              ; = = = = = = = = = = = = = = = = = = = = = = = =
8930 228E              ;           Window Manager icon font.
8931 228E              ; = = = = = = = = = = = = = = = = = = = = = = = =
8932 228E              ;
8933 228E                       EXPORT wind640
8934 228E              wind640                                 ; 
8935 228E              ;
8936 228E 06 00                 DC W:$0006                     ; {offset word}
8937 2290 CE 00                 DC W:$00CE                     ; {FontID}
8938 2292 00 00                 DC W:$0000                     ; {style}
8939 2294 0A 00                 DC W:$000A                     ; {size}
8940 2296 01 01                 DC W:$0101                     ; {version}
8941 2298 E6 01                 DC W:$01E6                     ; {FBRextent}
8942 229A              ;
8943 229A 01 90                 DC W:$9001                     ; {FontType}
8944 229C 00 00                 DC W:$0000                     ; {FirstChar}
8945 229E 02 00                 DC W:$0002                     ; {LastChar}
8946 22A0 13 00                 DC W:$0013                     ; {WidMax}
8947 22A2 00 00                 DC W:$0000                     ; {KernMax}
8948 22A4 F7 FF                 DC W:$FFF7                     ; {nDescent}
8949 22A6 0F 00                 DC W:$000F                     ; {fRectWidth}
8950 22A8 09 00                 DC W:$0009                     ; {FrectHeight}
8951 22AA 25 00                 DC W:$0025                     ; {owTLoc}
8952 22AC 00 00                 DC W:$0000                     ; {ascent}
8953 22AE 09 00                 DC W:$0009                     ; {descent}
8954 22B0 00 00                 DC W:$0000                     ; {leading}
8955 22B2 03 00                 DC W:$0003                     ; {RowWords}
8956 22B4              ;
8957 22B4              ; BitImage:
8958 22B4 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$FF,$F8,$C0,$07,$9F,$CF
8959 22C4 06 18 C0 07           DC B:$06,$18,$C0,$07,$E7,$3F,$06,$18,$C0,$07,$B8,$EF,$FE,$18,$C0,$07
8960 22D4 E7 3F 00 18           DC B:$E7,$3F,$00,$18,$C0,$07,$9F,$CF,$00,$18,$FF,$FF,$FF,$FF,$FF,$F8
8961 22E4 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00
8962 22EA              ;
8963 22EA              ; LocTable:
8964 22EA 00 00                 DC W:$0000                     Close box.
8965 22EC 0F 00                 DC W:$000F                     Hilited close/zoom boxes.
8966 22EE 1E 00                 DC W:$001E                     Zoom box.
8967 22F0 2D 00                 DC W:$002D                     Total width of bit image in pixels.
8968 22F2 2D 00                 DC W:$002D                     ; Total Width in Pixels
8969 22F4              ;
8970 22F4              ; OWTable:
8971 22F4 13 02                 DC W:$0213                     ; Char (00)
8972 22F6 13 02                 DC W:$0213                     ; Char (01)
8973 22F8 13 02                 DC W:$0213                     ; Char (02)
8974 22FA 01 04                 DC W:$0401                     ; Missing Symbol
8975 22FC 00 00                 DC W:$0000                     ; End of Table - (often -1)
8976 22FE              ;
8977 22FE              ;
8978 22FE                       EXPORT wind320
8979 22FE              wind320                                 ; 
8980 22FE              ;
8981 22FE 06 00                 DC W:$0006                     ; {offset word}
8982 2300 CF 00                 DC W:$00CF                     ; {FontID}
8983 2302 00 00                 DC W:$0000                     ; {style}
8984 2304 0A 00                 DC W:$000A                     ; {size}
8985 2306 01 01                 DC W:$0101                     ; {version}
8986 2308 F2 01                 DC W:$01F2                     ; {FBRextent}
8987 230A              ;
8988 230A 01 90                 DC W:$9001                     ; {FontType}
8989 230C 00 00                 DC W:$0000                     ; {FirstChar}
8990 230E 02 00                 DC W:$0002                     ; {LastChar}
8991 2310 0D 00                 DC W:$000D                     ; {WidMax}
8992 2312 00 00                 DC W:$0000                     ; {KernMax}
8993 2314 F7 FF                 DC W:$FFF7                     ; {nDescent}
8994 2316 09 00                 DC W:$0009                     ; {fRectWidth}
8995 2318 09 00                 DC W:$0009                     ; {FrectHeight}
8996 231A 1C 00                 DC W:$001C                     ; {owTLoc}
8997 231C 00 00                 DC W:$0000                     ; {ascent}
8998 231E 09 00                 DC W:$0009                     ; {descent}
8999 2320 00 00                 DC W:$0000                     ; {leading}
9000 2322 02 00                 DC W:$0002                     ; {RowWords}
9001 2324              ;
9002 2324              ; BitImage:
9003 2324 00 00 00 00           DC B:$00,$00,$00,$00,$FF,$FF,$FF,$E0,$80,$DF,$62,$20,$80,$FB,$E2,$20
9004 2334 80 F5 FE 20           DC B:$80,$F5,$FE,$20,$80,$FB,$E0,$20,$80,$DF,$60,$20,$FF,$FF,$FF,$E0
9005 2344 00 00 00 00           DC B:$00,$00,$00,$00
9006 2348              ;
9007 2348              ; LocTable:
9008 2348 00 00                 DC W:$0000                     ; Char (00)
9009 234A 09 00                 DC W:$0009                     ; Char (01)
9010 234C 12 00                 DC W:$0012                     ; Char (02)
9011 234E 1B 00                 DC W:$001B                     ; Missing Symbol
9012 2350 1B 00                 DC W:$001B                     ; Total Width in Pixels
9013 2352              ;
9014 2352              ; OWTable:
9015 2352 0D 02                 DC W:$020D                     ; Char (00)
9016 2354 0D 02                 DC W:$020D                     ; Char (01)
9017 2356 0D 02                 DC W:$020D                     ; Char (02)
9018 2358 01 04                 DC W:$0401                     ; Missing Symbol
9019 235A 00 00                 DC W:$0000                     ; End of Table - (often -1)
9020 235C              ;
9021 235C                       ENDP 
9022 235C              ;
9023 235C              ;
9024 235C                       Blanks off 
9025 235C                       String asis 
9026 235C              ;
9027 235C              ;
9028 235C              ;==================================================================
9029 235C              ;                   Create window from new template.
9030 235C              ;                   it can be fetched from a resource or be passed
9031 235C              ;                   by pointer or handle.
9032 235C              ;
9033 235C              ; Modified 12-dec-88 Mensch
9034 235C              ;    Added support for input verbs so that NewWindow2 can use ptrs
9035 235C              ;      and handles. Added Input verb to passed parms and template
9036 235C              ;==================================================================
9037 235C              ;
9038 235C              ;   IN:  PUSH:LONG - space for result.
9039 235C              ;        PUSH:LONG - window title.
9040 235C              ;        PUSH:LONG - refCon.
9041 235C              ;        PUSH:LONG - address of content draw routine, NIL if none.
9042 235C              ;        PUSH:LONG - address of window defProc, NIL for standard.
9043 235C              ;        PUSH:WORD - input verb defines what next long word is.
9044 235C              ;        PUSH:LONG - ID of resource that is window parameter table template.
9045 235C              ;        PUSH:WORD - type of resource that is window parameter table template.
9046 235C              ;
9047 235C              ;  OUT:  LONG - pointer to window graphPort, NIL if window not created.
9048 235C              ;
9049 235C              NewWindow2 PROC EXPORT
9050 235C              ;
9051 235C                       IMPORT shutdown
9052 235C                       IMPORT allocate1
9053 235C                       IMPORT allocate3
9054 235C              ;
9055 235C              ;
9056 235C              ; --- New window parameter list offsets.
9057 235C              ;
9058 235C              p_length equ   0                        Number of bytes in parameter list.
9059 235C              p_wframe equ   p_length+2               Type of window, frame flags.
9060 235C              p_wtitle equ   p_wframe+2               Pointer to window's title.
9061 235C              p_wrefCon equ   p_wtitle+4              Reserved for application.
9062 235C              p_wfull  equ   p_wrefCon+4              Size of window, used with ZoomWindow.
9063 235C              p_wcolor equ   p_wfull+8                Pointer to window's color table.
9064 235C              p_y_origin equ   p_wcolor+4             Content's vertical offset.
9065 235C              p_x_origin equ   p_y_origin+2           Content's horizontal offset.
9066 235C              p_data_h equ   p_x_origin+2             Height of total data area.
9067 235C              p_data_w equ   p_data_h+2               Width of total data area.
9068 235C              p_wmaxheight equ   p_data_w+2
9069 235C              p_wmaxwidth equ   p_wmaxheight+2
9070 235C              p_vscroll equ   p_wmaxwidth+2           Amount to scroll vertically (arrows).
9071 235C              p_hscroll equ   p_vscroll+2             Amount to scroll horizonally (arrows).
9072 235C              p_vpage  equ   p_hscroll+2              Amount to page vertically (page region).
9073 235C              p_hpage  equ   p_vpage+2                Amount to page horizontally (page rgn).
9074 235C              p_wInfoText equ   p_hpage+2
9075 235C              p_wInfoH equ   p_wInfoText+4            Height of infomation bar.
9076 235C              p_wdefProc equ   p_wInfoH+2             NOT USED.
9077 235C              p_wInfoDraw equ   p_wdefProc+4          Address of routine to draw Info Bar.
9078 235C              p_updateDraw equ   p_wInfoDraw+4        Address of routine to draw content region.
9079 235C              p_position equ   p_updateDraw+4
9080 235C              p_behind equ   p_position+8
9081 235C              p_windrec equ   p_behind+4              control template 
9082 235C              p_wInVerbs equ   p_windrec+4            Input verbs describing title,color tbl, and ctl template
9083 235C              p_size   equ   p_wInVerbs+2
9084 235C              ;
9085 235C              ;
9086 235C              ; --- Resource types.
9087 235C              ;
9088 235C              rPString equ   $8006
9089 235C              rWindParam1 equ   $800E
9090 235C              rWindParam2 equ   $800F
9091 235C              rWindColor equ   $8010
9092 235C              ;
9093 235C              ;
9094 235C              ; --- Input verbEquates
9095 235C              resIDVAsPtr equ   0
9096 235C              resIDVAsHandle equ   1
9097 235C              resIDVAsResource equ   2
9098 235C              ;
9099 235C              ; --- parmameter template verb word equates
9100 235C              ; the first byte is the same as the verb for NewControl2 call
9101 235C              titleAsPtr equ   $0000
9102 235C              titleAsHandle equ   $0100
9103 235C              titleAsResource equ   $0200
9104 235C              colorAsPtr equ   $0000
9105 235C              colorAsHandle equ   $0400
9106 235C              colorAsResource equ   $0800
9107 235C              ;
9108 235C              ;
9109 235C              ; --- Direct page offsets.
9110 235C              ;
9111 235C              @ID      equ   1
9112 235C              @hand    equ   @ID+4
9113 235C              @ptr     equ   @hand+4
9114 235C              @paramPtr equ   @ptr+4
9115 235C              @memoryID equ   @paramPtr+4
9116 235C              ;
9117 235C              @saveDbank equ   @memoryID+2
9118 235C              @saveDpage equ   @saveDbank+1
9119 235C              @retAddrs equ   @saveDpage+2
9120 235C              @resType equ   @retAddrs+6
9121 235C              @resID   equ   @resType+2
9122 235C              @resIDVerb equ   @resID+4               ; added 12/12/88 Mensch
9123 235C              @defProc equ   @resIDVerb+2
9124 235C              @contentDraw equ   @defProc+4
9125 235C              @refCon  equ   @contentDraw+4
9126 235C              @title   equ   @refCon+4
9127 235C              @result  equ   @title+4
9128 235C              ;
9129 235C 22 64 00 E1           jsl   IncBusyFlg
9130 2360 0B                    phd                            Save caller's direct page pointer.
9131 2361 8B                    phb                            Save caller's data bank pointer.
9132 2362              ;
9133 2362 4B                    phk                            Switch data bank to program bank.
9134 2363 AB                    plb   
9135 2364              ;
9136 2364 5B                    tcd                            Switch to Window Manager's direct page.
9137 2365              ;
9138 2365 3B                    tsc   
9139 2366 D4 DC                 pei   <MyID                    Put memory ID on my page.
9140 2368              ;
9141 2368 38                    sec                            Switch direct page into stack.
9142 2369 E9 12 00              sbc   #@saveDbank-1
9143 236C 1B                    tcs   
9144 236D 5B                    tcd   
9145 236E              ;
9146 236E 64 34                 stz   <@result                 Start with no window, just in case.
9147 2370 64 36                 stz   <@result+2
9148 2372              ;
9149 2372              ;
9150 2372              ; --- Test InputVerb to determine the method of parm passing
9151 2372              ;
9152 2372 A5 22                 lda   <@resIDVerb              get the passed verb
9153 2374 C9 02 00              cmp   #resIDVAsResource
9154 2377 F0 4E                 beq   @ResIDIsRes              If passed as resource, go load it 
9155 2379              ; if neither of these, then passed by handle or pointer, first allocate temp storage
9156 2379              ; to copy the users template into
9157 2379 A9 50 00              lda   #p_size                  template size.
9158 237C A4 11                 ldy   <@memoryID
9159 237E A2 00 80              ldx   #$8000                   pass attributes in <X> (Locked)
9160 2381 20 82 8F              jsr   allocate3                Allocate memory for template.
9161 2384 85 05                 sta   <@hand
9162 2386 86 07                 stx   <@hand+2
9163 2388 A7 05                 lda   [<@hand]                 deref the handle now...
9164 238A AA                    tax   
9165 238B A0 02 00              ldy   #2
9166 238E B7 05                 lda   [<@hand],y
9167 2390 85 0F                 sta   <@ParamPtr+2
9168 2392 86 0D                 stx   <@ParamPtr
9169 2394
9170 2394 A5 22                 lda   <@resIDVerb              get the res ID verb again
9171 2396 F0 18                 beq   @ResIDIsPtr              if pointer, then pass it...
9172 2398
9173 2398              ; if it gets here the user passed us a handle, so copy the data now...
9174 2398 D4 20                 pei   <@resID+2                Pass handle to copy from
9175 239A D4 1E                 pei   <@resID
9176 239C D4 0F                 pei   <@ParamPtr+2             pass the handle to copy to
9177 239E D4 0D                 pei   <@ParamPtr
9178 23A0 F4 00 00              pea   $0000                    now pass the size
9179 23A3 F4 50 00              pea   p_size                   to copy
9180 23A6 A2 02 29 22           _handToPtr 
9181 23AD 82 47 00              brl   @TD0010
9182 23B0              ;
9183 23B0              ; --- New template ref was passed by pointer, so just copy the pointer
9184 23B0              ;
9185 23B0              @ResIDIsPtr  
9186 23B0 D4 20                 pei   <@ResID+2                pointer to the source parm block
9187 23B2 D4 1E                 pei   <@ResID
9188 23B4 D4 0F                 pei   <@paramPtr+2             pointer to destination
9189 23B6 D4 0D                 pei   <@paramPtr
9190 23B8 F4 00 00              pea   $0000
9191 23BB F4 50 00              pea   p_size
9192 23BE A2 02 2B 22           _BlockMove                     copy the data
9193 23C5 80 30                 bra   @TD0010                  and continue
9194 23C7
9195 23C7              ; 
9196 23C7              ; --- Load new window parameter table resource.
9197 23C7              ;
9198 23C7              @ResIDIsRes  
9199 23C7 48                    pha                            Space for result.
9200 23C8 48                    pha   
9201 23C9 D4 1C                 pei   <@resType                Pass type.
9202 23CB D4 20                 pei   <@resID+2                Pass ID.
9203 23CD D4 1E                 pei   <@resID
9204 23CF A2 1E 0E 22           _LoadResource 
9205 23D6 A8                    tay                            Possible error code in y.
9206 23D7 FA                    plx   
9207 23D8 86 0D                 stx   <@paramPtr
9208 23DA FA                    plx   
9209 23DB 86 0F                 stx   <@paramPtr+2
9210 23DD 90 03                 bcc   @ok2                     Error?
9211 23DF 82 B2 00     @toExit2 brl   @exit2                   Error.
9212 23E2              @ok2      
9213 23E2              ;
9214 23E2              ; Now, take the handle from resource mgr or passed by app and dereference it.
9215 23E2              @TemplateDeref  
9216 23E2 A0 04 00              ldy   #4                       Lock parameter table.
9217 23E5 B7 0D                 lda   [<@paramPtr],y
9218 23E7 09 00 80              ora   #$8000
9219 23EA 97 0D                 sta   [<@paramPtr],y
9220 23EC 88                    dey                            Dereference the table.
9221 23ED 88                    dey   
9222 23EE B7 0D                 lda   [<@paramPtr],y
9223 23F0 A8                    tay   
9224 23F1 A7 0D                 lda   [<@paramPtr]
9225 23F3 85 0D                 sta   <@paramPtr
9226 23F5 84 0F                 sty   <@paramPtr+2
9227 23F7              @TD0010   
9228 23F7              ;
9229 23F7              ;
9230 23F7              ; --- Fix up parameter table.
9231 23F7              ;
9232 23F7 A5 1C                 lda   <@resType                Which kind of parameter table?
9233 23F9 C9 0E 80              cmp   #rWindParam1
9234 23FC F0 05                 beq   @doParam1
9235 23FE              ;
9236 23FE 20 65 26              jsr   @fixParam2
9237 2401 80 03                 bra   @done1
9238 2403              ;
9239 2403 20 C1 24     @doParam1 jsr   @fixParam1
9240 2406 98           @done1   tya                            Place possible error code in A.
9241 2407 B0 1B                 bcs   @errOut                  Error?
9242 2409              ;
9243 2409              ;
9244 2409              ; --- Have NewWindow create the window.
9245 2409              ;
9246 2409              ; First adjust parameter list count back to new window size...
9247 2409 A7 0D                 lda   [<@paramPtr]             remove the input verb from the parm count
9248 240B 3A                    dec   a
9249 240C 3A                    dec   a
9250 240D 87 0D                 sta   [<@paramPtr]
9251 240F
9252 240F 48                    pha                            Save for result.
9253 2410 48                    pha   
9254 2411 D4 0F                 pei   <@paramPtr+2             Pass pointer to parameter table.
9255 2413 D4 0D                 pei   <@paramPtr
9256 2415 A2 0E 09 22           _NewWindow 
9257 241C 7A                    ply                            Return window pointer.
9258 241D 84 34                 sty   <@result
9259 241F 7A                    ply   
9260 2420 84 36                 sty   <@result+2
9261 2422 90 15                 bcc   @skip1                   Erorr? y = error code if any.
9262 2424              ;
9263 2424 48           @errOut  pha                            Save error code.
9264 2425              ;
9265 2425 A5 1C                 lda   <@resType                Free items allocated by me.
9266 2427 C9 0E 80              cmp   #rWindParam1
9267 242A D0 0C                 bne   @skip3                   Only for parameter table type 1.
9268 242C              ;
9269 242C A0 06 00              ldy   #p_wtitle+2              Free title if there is one.
9270 242F 20 AC 24              jsr   @freeField
9271 2432              ;
9272 2432 A0 16 00              ldy   #p_wcolor+2              Free the color table if there is one.
9273 2435 20 AC 24              jsr   @freeField
9274 2438              ;
9275 2438 68           @skip3   pla                            Restore error code.
9276 2439              ;
9277 2439              ;
9278 2439              ; --- Free parameter table.
9279 2439              ;
9280 2439 48           @skip1   pha                            Save error code.
9281 243A              ;
9282 243A A5 22                 lda   <@resIDVerb              get the passed verb
9283 243C C9 02 00              cmp   #resIDVAsResource
9284 243F F0 16                 beq   @DumpRes                 If passed as resource, release it...
9285 2441              ; If not a resource, then I made a copy of the passed param block and I should 
9286 2441              ; dispose of it right now...
9287 2441 48                    pha                            room for result
9288 2442 48                    pha   
9289 2443 D4 0F                 pei   <@paramPtr+2             first get the handle back for the temp parm block
9290 2445 D4 0D                 pei   <@paramPtr
9291 2447 A2 02 1A 22           _FindHandle                    get the handle back
9292 244E A2 02 10 22           _DisposeHandle                 and get rid of it.
9293 2455 80 10                 bra   @MkCtrls
9294 2457              ;
9295 2457              @DumpRes  
9296 2457 F4 FF FF              pea   $FFFF                    Pass 'dispose' flag.
9297 245A D4 1C                 pei   <@resType                Pass type.
9298 245C D4 20                 pei   <@resID+2                Pass ID.
9299 245E D4 1E                 pei   <@resID
9300 2460 A2 1E 17 22           _ReleaseResource 
9301 2467              ;
9302 2467              ;
9303 2467              ; --- Create controls in window. Use the low order byte of the wInVerb as the
9304 2467              ;     input verb for this call.
9305 2467              ;
9306 2467              @MkCtrls  
9307 2467 A5 01                 lda   <@ID                     Is there a control list?
9308 2469 05 03                 ora   <@ID+2
9309 246B F0 26                 beq   @skip2
9310 246D              ;
9311 246D A5 34                 lda   <@result                 Was a window created?
9312 246F 05 36                 ora   <@result+2
9313 2471 F0 20                 beq   @skip2
9314 2473              ;
9315 2473 48                    pha                            Space for result.
9316 2474 48                    pha   
9317 2475 D4 36                 pei   <@result+2               Pass window owner.
9318 2477 D4 34                 pei   <@result
9319 2479 A0 4E 00              ldy   #p_wInVerbs              load the offset to the template verbs
9320 247C B7 0D                 lda   [<@paramPtr],y           load in the input verb
9321 247E 29 FF 00              and   #$00FF                   strip off the high byte, low byte for this call
9322 2481 48                    pha                            and pass it as inputverb for NewControl2
9323 2482 D4 03                 pei   <@ID+2                   Pass ID of item list.
9324 2484 D4 01                 pei   <@ID
9325 2486 A2 10 31 22           _NewControl2 
9326 248D FA                    plx                            Don't need result.
9327 248E FA                    plx   
9328 248F 90 02                 bcc   @skip2                   Error?
9329 2491 83 01                 sta   1,s                      Replace saved error code with error from NewControl2.
9330 2493              ;
9331 2493 7A           @skip2   ply                            Restore error code from NewWindow.
9332 2494              ;
9333 2494              ;
9334 2494              ; --- Clean up stack and exit.
9335 2494              ;      mod 12/12/88 pull off 24 bytes parameter. Mensch
9336 2494              ;
9337 2494 3B           @exit2   tsc                            Free allocated direct page.
9338 2495 18                    clc   
9339 2496 69 12 00              adc   #@saveDbank-1
9340 2499 1B                    tcs   
9341 249A A2 18 00              ldx   #24                      Number of bytes to pop.
9342 249D 82 61 6B              brl   shutDown
9343 24A0              ;
9344 24A0 08 00 32 00  @desIndex DC W:p_wrefCon,p_wdefProc,p_updateDraw
9345 24A6 2C 00 24 00  @srcIndex DC W:@refCon,@defProc,@contentDraw
9346 24AC              ;
9347 24AC              ;
9348 24AC              ;-----------------------------------------------
9349 24AC              ;        Free handle in parameter table.
9350 24AC              ;-----------------------------------------------
9351 24AC              ;
9352 24AC              ;   IN: y = index to high word of field.  If highest bit set it is a handle to free.
9353 24AC              ;
9354 24AC B7 0D        @freeField lda   [<@paramPtr],y
9355 24AE 10 10                 bpl   @exit100
9356 24B0              ;
9357 24B0 29 FF 00              and   #$00FF
9358 24B3 48                    pha   
9359 24B4 88                    dey   
9360 24B5 88                    dey   
9361 24B6 B7 0D                 lda   [<@paramPtr],y
9362 24B8 48                    pha   
9363 24B9 A2 02 10 22           _DisposeHandle 
9364 24C0 60           @exit100 rts   
9365 24C1              ;
9366 24C1              ;
9367 24C1              ;---------------------------------------------------------------------
9368 24C1              ;                   Fix up parameter table type 1.
9369 24C1              ;-200-----------------------------------------------------------------
9370 24C1              ;
9371 24C1              ;  OUT:  Carry set if error, y = error code.
9372 24C1              ;        <@ID = ID of control list, NIL if none.
9373 24C1              ;
9374 24C1 64 01        @fixParam1 stz   <@ID                   Start with no controls.
9375 24C3 64 03                 stz   <@ID+2
9376 24C5              ;
9377 24C5              ;
9378 24C5              ; --- Set window title in table.
9379 24C5              ;
9380 24C5 A5 30                 lda   <@title                  Was a title passed?
9381 24C7 05 32                 ora   <@title+2
9382 24C9 F0 35                 beq   @loadTitle               Use the passed title if there is one.
9383 24CB              ;
9384 24CB              ;
9385 24CB              ; ------ Clone the given title.
9386 24CB              ;
9387 24CB              @Clonetitle  
9388 24CB A7 30                 lda   [<@title]                Compute size of string,
9389 24CD 29 FF 00              and   #$00FF
9390 24D0 1A                    inc   a                        including length byte.
9391 24D1 48                    pha                            Save size.
9392 24D2 A4 11                 ldy   <@memoryID
9393 24D4 20 7A 8F              jsr   allocate1                Allocate fixed memory for title.
9394 24D7 85 05                 sta   <@hand
9395 24D9 86 07                 stx   <@hand+2
9396 24DB              ;
9397 24DB 7A                    ply                            Restore size of string.
9398 24DC              ;
9399 24DC D4 32                 pei   <@title+2                Pass source pointer.
9400 24DE D4 30                 pei   <@title
9401 24E0 DA                    phx                            Pass destination handle.
9402 24E1 48                    pha   
9403 24E2 F4 00 00              pea   0                        Pass number of bytes to move.
9404 24E5 5A                    phy   
9405 24E6 A2 02 28 22           _PtrToHand                     Clone title.
9406 24ED              ;
9407 24ED A0 04 00              ldy   #p_wtitle                Store handle of title.
9408 24F0 A5 05                 lda   <@hand
9409 24F2 97 0D                 sta   [<@paramPtr],y
9410 24F4 C8                    iny   
9411 24F5 C8                    iny   
9412 24F6 A5 07                 lda   <@hand+2
9413 24F8 09 00 80              ora   #$8000                   Set bit that states this is a handle.
9414 24FB 97 0D                 sta   [<@paramPtr],y
9415 24FD 82 81 00              brl   @noTitle
9416 2500              ;
9417 2500              ;
9418 2500              ; ------ Load title from wherever.
9419 2500              ;
9420 2500 A0 06 00     @loadTitle ldy   #p_wtitle+2            Is there a title in the template?
9421 2503 B7 0D                 lda   [<@paramPtr],y
9422 2505 AA                    tax   
9423 2506 88                    dey   
9424 2507 88                    dey   
9425 2508 17 0D                 ora   [<@paramPtr],y
9426 250A F0 75                 beq   @noTitle
9427 250C              ;
9428 250C A0 4E 00              ldy   #p_wInVerbs              get the input verbs
9429 250F B7 0D                 lda   [<@paramPtr],y
9430 2511 A8                    tay                            and save em for a second
9431 2512 29 00 02              and   #titleAsResource
9432 2515 D0 32                 bne   @LoadTByRes              if by resource load it
9433 2517 98                    tya   
9434 2518 29 00 01              and   #titleAsHandle
9435 251B D0 10                 bne   @LoadTByHandle
9436 251D A0 06 00              ldy   #p_wtitle+2
9437 2520 B7 0D                 lda   [<@paramPtr],y           load the pointer
9438 2522 85 32                 sta   <@title+2                save it in the string pointer field
9439 2524 88                    dey   
9440 2525 88                    dey   
9441 2526 B7 0D                 lda   [<@paramPtr],y
9442 2528 85 30                 sta   <@title
9443 252A 82 9E FF              brl   @Clonetitle              now create a buffer and copy the title
9444 252D              @LoadTByHandle  
9445 252D A0 06 00              ldy   #p_wtitle+2
9446 2530 B7 0D                 lda   [<@paramPtr],y           load the pointer
9447 2532 85 32                 sta   <@title+2                save it in the string pointer field
9448 2534 88                    dey   
9449 2535 88                    dey   
9450 2536 B7 0D                 lda   [<@paramPtr],y
9451 2538 85 30                 sta   <@title
9452 253A A0 02 00              ldy   #2
9453 253D B7 30                 lda   [<@title],y
9454 253F A8                    tay   
9455 2540 A7 30                 lda   [<@title]
9456 2542 85 30                 sta   <@title
9457 2544 84 32                 sty   <@title+2
9458 2546 82 82 FF              brl   @Clonetitle
9459 2549              @LoadTByRes  
9460 2549 A0 04 00              ldy   #p_wtitle
9461 254C 48                    pha                            Space for result.
9462 254D 48                    pha   
9463 254E F4 06 80              pea   rPString                 Pass type.
9464 2551 DA                    phx                            Pass ID.
9465 2552 B7 0D                 lda   [<@paramPtr],y
9466 2554 48                    pha   
9467 2555 85 01                 sta   <@ID                     Remember ID.
9468 2557 86 03                 stx   <@ID+2
9469 2559 A2 1E 0E 22           _LoadResource 
9470 2560 A8                    tay                            Posible error code.
9471 2561 68                    pla   
9472 2562 FA                    plx   
9473 2563 90 01                 bcc   @ok200                   Error?
9474 2565 60           @errOut200 rts                          Error.
9475 2566              @ok200    
9476 2566              ;
9477 2566 A0 04 00              ldy   #p_wtitle                Store handle of title.
9478 2569 97 0D                 sta   [<@paramPtr],y
9479 256B C8                    iny   
9480 256C C8                    iny   
9481 256D 8A                    txa   
9482 256E 09 00 80              ora   #$8000                   Set bit that states this is a handle.
9483 2571 97 0D                 sta   [<@paramPtr],y
9484 2573              ;
9485 2573 F4 06 80              pea   rPString                 Pass type.
9486 2576 D4 03                 pei   <@ID+2                   Pass ID.
9487 2578 D4 01                 pei   <@ID
9488 257A A2 1E 18 22           _DetachResource                Unlink the title handle from resource.
9489 2581              ;
9490 2581              @noTitle  
9491 2581              ;
9492 2581              ;
9493 2581              ; --- Set window color table pointer in table.
9494 2581              ;
9495 2581 A0 16 00              ldy   #p_wcolor+2              Is there a color table resource?
9496 2584 B7 0D                 lda   [<@paramPtr],y
9497 2586 AA                    tax   
9498 2587 88                    dey   
9499 2588 88                    dey   
9500 2589 17 0D                 ora   [<@paramPtr],y
9501 258B D0 03                 bne   @LCT0005
9502 258D 82 A3 00              brl   @noColor
9503 2590              ;
9504 2590              @LCT0005  
9505 2590 A0 4E 00              ldy   #p_wInVerbs              get the input verbs
9506 2593 B7 0D                 lda   [<@paramPtr],y
9507 2595 29 00 08              and   #colorAsResource
9508 2598 D0 5F                 bne   @LoadCByRes              if by resource load it
9509 259A              ;
9510 259A              ; If not passed by resource ID we will have to make a copy of the color table
9511 259A              ; so first create a handle
9512 259A A9 00 00              lda   #$0000
9513 259D 48                    pha                            room for result
9514 259E 48                    pha   
9515 259F 48                    pha                            zero for high word of size
9516 25A0 F4 0A 00              pea   $000A                    room for a color table
9517 25A3 D4 11                 pei   <@memoryID
9518 25A5 48                    pha                            zero for attributes
9519 25A6 48                    pha                            no specific location
9520 25A7 48                    pha   
9521 25A8 A2 02 09 22           _NewHandle                     allocate the space 
9522 25AF A8                    tay                            Possible error code.
9523 25B0 68                    pla   
9524 25B1 85 01                 sta   <@ID                     save the handle for a sec...
9525 25B3 68                    pla   
9526 25B4 85 03                 sta   <@ID+2
9527 25B6 B0 AD                 bcs   @errOut200               Error?
9528 25B8
9529 25B8 A0 16 00              ldy   #p_wcolor+2              push ref of the color table.
9530 25BB B7 0D                 lda   [<@paramPtr],y
9531 25BD 48                    pha   
9532 25BE 88                    dey   
9533 25BF 88                    dey   
9534 25C0 B7 0D                 lda   [<@paramPtr],y
9535 25C2 48                    pha   
9536 25C3 D4 03                 pei   <@ID+2                   address to copy to
9537 25C5 D4 01                 pei   <@ID
9538 25C7 F4 00 00              pea   $0000                    size to copy
9539 25CA F4 0A 00              pea   $000A
9540 25CD              ;
9541 25CD              ; Now that the parms are set up properly, lets copy the right way depending on
9542 25CD              ; the input verb
9543 25CD A0 4E 00              ldy   #p_wInVerbs              get the input verbs
9544 25D0 B7 0D                 lda   [<@paramPtr],y
9545 25D2 29 00 04              and   #colorAsHandle
9546 25D5 D0 09                 bne   @LoadCByHandle
9547 25D7 A2 02 28 22           _PtrToHand                     copy the data from ptr to our handle
9548 25DE 80 07                 bra   @LCT0020
9549 25E0              ;
9550 25E0              @LoadCByHandle  
9551 25E0 A2 02 2A 22           _HandToHand                    copy the data from handle to handle
9552 25E7              @LCT0020  
9553 25E7 A0 16 00              ldy   #p_wcolor+2              offset to high word of color table
9554 25EA A5 03                 lda   <@ID+2                   high byte of our handle
9555 25EC 09 00 80              ora   #$8000                   set high bit to indicate by handle
9556 25EF 97 0D                 sta   [<@paramPtr],y
9557 25F1 88                    dey   
9558 25F2 88                    dey   
9559 25F3 A5 01                 lda   <@ID
9560 25F5 97 0D                 sta   [<@paramPtr],y
9561 25F7 80 3A                 bra   @noColor
9562 25F9              @LoadCByRes  
9563 25F9 A0 14 00              ldy   #p_wcolor
9564 25FC 48                    pha                            Space for result.
9565 25FD 48                    pha   
9566 25FE F4 10 80              pea   rWindColor               Pass type.
9567 2601 DA                    phx                            Pass ID.
9568 2602 B7 0D                 lda   [<@paramPtr],y
9569 2604 48                    pha   
9570 2605 85 01                 sta   <@ID                     Remember ID.
9571 2607 86 03                 stx   <@ID+2
9572 2609 A2 1E 0E 22           _LoadResource 
9573 2610 A8                    tay                            Possible error code.
9574 2611 68                    pla   
9575 2612 FA                    plx   
9576 2613 90 03                 bcc   @LCT0030
9577 2615 82 4D FF              brl   @errOut200               Error?
9578 2618              ;
9579 2618              @LCT0030  
9580 2618 A0 14 00              ldy   #p_wcolor                Store handle of the colot table.
9581 261B 97 0D                 sta   [<@paramPtr],y
9582 261D C8                    iny   
9583 261E C8                    iny   
9584 261F 8A                    txa   
9585 2620 09 00 80              ora   #$8000                   Set bit that states this is a handle.
9586 2623 97 0D                 sta   [<@paramPtr],y
9587 2625              ;
9588 2625 F4 10 80              pea   rWindColor               Pass type.
9589 2628 D4 03                 pei   <@ID+2                   Pass ID.
9590 262A D4 01                 pei   <@ID
9591 262C A2 1E 18 22           _DetachResource                Unlink color table handle from resource.
9592 2633              ;
9593 2633              @noColor  
9594 2633              ;
9595 2633              ;
9596 2633              ; --- Store passed values in parameter table.
9597 2633              ;
9598 2633 A2 04 00              ldx   #4
9599 2636 DA           @lop200  phx   
9600 2637              ;
9601 2637 BC A0 24              ldy   |@desIndex,x
9602 263A BD A6 24              lda   |@srcIndex,x
9603 263D AA                    tax   
9604 263E              ;
9605 263E B5 00                 lda   <0,x
9606 2640 97 0D                 sta   [<@paramPtr],y
9607 2642 C8                    iny   
9608 2643 C8                    iny   
9609 2644 B5 02                 lda   <2,x
9610 2646 97 0D                 sta   [<@paramPtr],y
9611 2648              ;
9612 2648 FA                    plx   
9613 2649 CA                    dex   
9614 264A CA                    dex   
9615 264B 10 E9                 bpl   @lop200
9616 264D              ;
9617 264D              ;
9618 264D              ; --- Get ID of control list.
9619 264D              ;
9620 264D A2 00 00              ldx   #0
9621 2650 A0 4A 00              ldy   #p_windrec
9622 2653 B7 0D                 lda   [<@paramPtr],y           Get the ID of the window's control list.
9623 2655 85 01                 sta   <@ID
9624 2657 8A                    txa   
9625 2658 97 0D                 sta   [<@paramPtr],y           Clear the windRec field also, window record to be 
9626 265A C8                    iny                            allocated.
9627 265B C8                    iny   
9628 265C B7 0D                 lda   [<@paramPtr],y
9629 265E 85 03                 sta   <@ID+2
9630 2660 8A                    txa   
9631 2661 97 0D                 sta   [<@paramPtr],y
9632 2663 18                    clc                            No error.
9633 2664 60                    rts   
9634 2665              ;
9635 2665              ;
9636 2665              ;---------------------------------------------------------------------
9637 2665              ;                   Fix up parameter table type 2.
9638 2665              ;-300-----------------------------------------------------------------
9639 2665              ;
9640 2665              ;  OUT:  Carry set if error, y = error code.
9641 2665              ;        <@ID = ID of control list, NIL if none.
9642 2665              ;
9643 2665              @fixParam2  
9644 2665              ;
9645 2665              ; --- New parameter list offsets -----------------------------
9646 2665              ;
9647 2665              @paramID equ   0                        ID of parameter list.
9648 2665              @newDefProc equ   @paramID+2            DefProc of window.
9649 2665              @newData equ   @newDefProc+4            Additional data for new window.
9650 2665              ;
9651 2665              ;
9652 2665 64 01                 stz   <@ID                     No control list.
9653 2667 64 03                 stz   <@ID+2
9654 2669              ;
9655 2669 A0 02 00              ldy   #@newDefProc             Store address of defProc.
9656 266C A5 24                 lda   <@defProc
9657 266E 97 0D                 sta   [<@paramPtr],y
9658 2670 C8                    iny   
9659 2671 C8                    iny   
9660 2672 A5 26                 lda   <@defProc+2
9661 2674 97 0D                 sta   [<@paramPtr],y
9662 2676              ;
9663 2676 18                    clc                            No error.
9664 2677 60                    rts   
9665 2678              ;
9666 2678                       ENDP 
9667 2678              ;
9668 2678              ;
9669 2678              ;========================================================
9670 2678              ;          Dispose the temporary region
9671 2678              ;========================================================
9672 2678              ;
9673 2678              disposeRgnPtr PROC 
9674 2678
9675 2678 D4 BA                 pei   rgnptr+2
9676 267A D4 B8                 pei   rgnptr
9677 267C A2 04 68 22           _DisposeRgn 
9678 2683 60                    rts   
9679 2684
9680 2684                       ENDP 
9681 2684              ;
9682 2684              ;
9683 2684                       END   
